/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.editextras;

import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.plugins.editextras.Utilities;

class ConvertToStringBufferCommand
implements ICommand {
    private final ISQLPanelAPI _api;

    ConvertToStringBufferCommand(ISQLPanelAPI api) {
        this._api = api;
    }

    public void execute() throws BaseException {
        int[] bounds = this._api.getSQLEntryPanel().getBoundsOfSQLToBeExecuted();
        if (bounds[0] == bounds[1]) {
            return;
        }
        String textToQuote = this._api.getSQLEntryPanel().getSQLToBeExecuted();
        if (null == textToQuote) {
            return;
        }
        String quotedText = Utilities.quoteText(textToQuote, true);
        this._api.getSQLEntryPanel().setSelectionStart(bounds[0]);
        this._api.getSQLEntryPanel().setSelectionEnd(bounds[1]);
        this._api.getSQLEntryPanel().replaceSelection(quotedText);
    }
}

