/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro.tool;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.bluecow.spectro.Clip;
import net.bluecow.spectro.ClipPanel;
import net.bluecow.spectro.Frame;
import net.bluecow.spectro.SpectroEditSession;
import net.bluecow.spectro.tool.Tool;

public class PaintbrushTool
implements Tool {
    private ClipPanel clipPanel;
    private Clip clip;
    private final PaintbrushMouseHandler mouseHandler = new PaintbrushMouseHandler();
    private final Box settingsPanel = Box.createVerticalBox();
    private final JSlider brushSlider;
    private final JLabel brushSizeLabel = new JLabel();

    public PaintbrushTool() {
        this.settingsPanel.add(this.brushSizeLabel);
        this.brushSlider = new JSlider(1, 20, 1);
        this.settingsPanel.add(this.brushSlider);
        this.settingsPanel.add(Box.createGlue());
        this.brushSlider.setOpaque(false);
        this.brushSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PaintbrushTool.this.brushSizeLabel.setText("Paintbrush size: " + PaintbrushTool.this.brushSlider.getValue());
            }
        });
        this.brushSlider.setValue(5);
    }

    public String getName() {
        return "Paintbrush";
    }

    public void activate(SpectroEditSession session) {
        this.clipPanel = session.getClipPanel();
        this.clip = this.clipPanel.getClip();
        this.clipPanel.setRegionMode(false);
        this.clipPanel.addMouseListener(this.mouseHandler);
        this.clipPanel.addMouseMotionListener(this.mouseHandler);
    }

    public void deactivate() {
        this.clipPanel.removeMouseListener(this.mouseHandler);
        this.clipPanel.removeMouseMotionListener(this.mouseHandler);
        this.clip = null;
        this.clipPanel = null;
    }

    public JComponent getSettingsPanel() {
        return this.settingsPanel;
    }

    public String toString() {
        return "Paintbrush";
    }

    private class PaintbrushMouseHandler
    implements MouseMotionListener,
    MouseListener {
        private PaintbrushMouseHandler() {
        }

        public void mouseDragged(MouseEvent e) {
            Point p = PaintbrushTool.this.clipPanel.toClipCoords(e.getPoint());
            int radius = PaintbrushTool.this.brushSlider.getValue();
            Rectangle updateRegion = new Rectangle(p.x - radius, p.y - radius, radius * 2, radius * 2);
            PaintbrushTool.this.clip.beginEdit(updateRegion, "Brush stroke");
            for (int x = p.x - radius; x < p.x + radius; ++x) {
                Frame f = PaintbrushTool.this.clip.getFrame(x);
                for (int y = p.y - radius; y < p.y + radius; ++y) {
                    f.setReal(y, 0.0);
                }
            }
            PaintbrushTool.this.clip.endEdit();
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            PaintbrushTool.this.clip.beginCompoundEdit("Painting");
            this.mouseDragged(e);
        }

        public void mouseReleased(MouseEvent e) {
            PaintbrushTool.this.clip.endCompoundEdit();
        }
    }
}

