/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.bluecow.spectro.ClipPanel;
import net.bluecow.spectro.ValueColorizer;
import net.bluecow.spectro.tool.CurvedSlider;

public class LogarithmicColorizer
implements ValueColorizer {
    private double preMult = 0.0;
    private double brightness = 0.0;
    private double contrast = 0.0;
    private boolean useRed = false;
    private final ClipPanel clipPanel;
    private final JComponent settingsPanel;

    LogarithmicColorizer(ClipPanel clipPanel) {
        this.clipPanel = clipPanel;
        final CurvedSlider preMultSlider = new CurvedSlider(0.0, 7000.0, 4.0);
        preMultSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LogarithmicColorizer.this.setPreMult(preMultSlider.getCurvedValue());
            }
        });
        final JSlider brightnessSlider = new JSlider(-300, 300, 0);
        brightnessSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LogarithmicColorizer.this.setBrightness(brightnessSlider.getValue());
            }
        });
        final CurvedSlider contrastSlider = new CurvedSlider(0.0, 10000.0, 4.0);
        contrastSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LogarithmicColorizer.this.setContrast(contrastSlider.getCurvedValue());
            }
        });
        final JCheckBox useRedCheckbox = new JCheckBox("Use red", this.useRed);
        useRedCheckbox.setOpaque(false);
        useRedCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogarithmicColorizer.this.setUseRed(useRedCheckbox.isSelected());
            }
        });
        this.settingsPanel = Box.createVerticalBox();
        this.settingsPanel.add(new JLabel("Pre Multiplier"));
        this.settingsPanel.add(preMultSlider);
        this.settingsPanel.add(new JLabel("Brightness"));
        this.settingsPanel.add(brightnessSlider);
        this.settingsPanel.add(new JLabel("Contrast"));
        this.settingsPanel.add(contrastSlider);
        this.settingsPanel.add(useRedCheckbox);
        preMultSlider.setValue(20);
        brightnessSlider.setValue(0);
        contrastSlider.setValue(50);
    }

    public int colorFor(double val) {
        int greyVal = (int)(this.brightness + this.contrast * Math.log1p(Math.abs(this.preMult * val)));
        if (this.useRed) {
            if (greyVal < 0) {
                return 0;
            }
            if (greyVal <= 255) {
                return greyVal << 16 | greyVal << 8 | greyVal;
            }
            if (greyVal <= 512) {
                greyVal -= 256;
                greyVal = 256 - greyVal;
                return 0xFF0000 | greyVal << 8 | greyVal;
            }
            return 0xFF0000;
        }
        greyVal = Math.min(255, Math.max(0, greyVal));
        return greyVal << 16 | greyVal << 8 | greyVal;
    }

    public void setPreMult(double multiplier) {
        System.out.println("multiplier: " + multiplier);
        this.preMult = multiplier;
        this.clipPanel.updateImage(null);
        this.clipPanel.repaint();
    }

    public void setBrightness(double brightness) {
        System.out.println("brightness: " + brightness);
        this.brightness = brightness;
        this.clipPanel.updateImage(null);
        this.clipPanel.repaint();
    }

    public void setContrast(double contrast) {
        System.out.println("contrast: " + contrast);
        this.contrast = contrast;
        this.clipPanel.updateImage(null);
        this.clipPanel.repaint();
    }

    public void setUseRed(boolean useRed) {
        this.useRed = useRed;
        this.clipPanel.updateImage(null);
        this.clipPanel.repaint();
    }

    public JComponent getSettingsPanel() {
        return this.settingsPanel;
    }
}

