/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.cli;

import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.ivy.util.cli.ParseException;

public class Option {
    private String name;
    private String[] args;
    private String description;
    private boolean required;
    private boolean countArgs;
    private boolean deprecated;

    Option(String string, String[] stringArray, String string2, boolean bl, boolean bl2, boolean bl3) {
        this.name = string;
        this.args = stringArray;
        this.description = string2;
        this.required = bl;
        this.countArgs = bl2;
        this.deprecated = bl3;
        if (bl) {
            throw new UnsupportedOperationException("required option not supported yet");
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isCountArgs() {
        return this.countArgs;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    String[] parse(ListIterator listIterator) throws ParseException {
        if (this.isCountArgs()) {
            String[] stringArray = new String[this.args.length];
            for (int i = 0; i < stringArray.length; ++i) {
                if (!listIterator.hasNext()) {
                    this.missingArgument(i);
                }
                stringArray[i] = (String)listIterator.next();
                if (!stringArray[i].startsWith("-")) continue;
                this.missingArgument(i);
            }
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (string.startsWith("-")) {
                listIterator.previous();
                break;
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void missingArgument(int n) throws ParseException {
        if (n == 0) {
            throw new ParseException("no argument for: " + this.name);
        }
        throw new ParseException("missing argument for: " + this.name + ". Expected: " + this.getArgsSpec());
    }

    public String getSpec() {
        return "-" + this.name + " " + this.getArgsSpec();
    }

    private String getArgsSpec() {
        if (this.args.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.args.length; ++i) {
            stringBuffer.append("<").append(this.args[i]).append("> ");
        }
        return stringBuffer.toString();
    }
}

