=begin
 This is a machine generated stub using stdlib-doc for <b>class Array</b>
 Sources used:  ruby-1.8.7-p358
 Created by IntelliJ Ruby Stubs Generator.
=end

# Arrays are ordered, integer-indexed collections of any object. 
# Array indexing starts at 0, as in C or Java.  A negative index is 
# assumed to be relative to the end of the array---that is, an index of -1 
# indicates the last element of the array, -2 is the next to last 
# element in the array, and so on. 
class Array
    include Enumerable
    # Returns a new array populated with the given objects. 
    # 
    #   Array.[]( 1, 'a', /^A/ )
    #   Array[ 1, 'a', /^A/ ]
    #   [ 1, 'a', /^A/ ]
    def self.[](*args)
        #This is a stub, used for indexing
    end
    # Array.new(size=0, obj=nil)
    # Array.new(array)
    # Array.new(size) {|index| block }
    # 
    # Returns a new array. In the first form, the new array is
    # empty. In the second it is created with _size_ copies of _obj_
    # (that is, _size_ references to the same
    # _obj_). The third form creates a copy of the array
    # passed as a parameter (the array is generated by calling
    # to_ary  on the parameter). In the last form, an array
    # of the given size is created. Each element in this array is
    # calculated by passing the element's index to the given block and
    # storing the return value.
    # 
    #    Array.new
    #    Array.new(2)
    #    Array.new(5, "A")
    # 
    #    # only one copy of the object is created
    #    a = Array.new(2, Hash.new)
    #    a[0]['cat'] = 'feline'
    #    a
    #    a[1]['cat'] = 'Felix'
    #    a
    # 
    #    # here multiple copies are created
    #    a = Array.new(2) { Hash.new }
    #    a[0]['cat'] = 'feline'
    #    a
    # 
    #    squares = Array.new(5) {|i| i*i}
    #    squares
    # 
    #    copy = Array.new(squares)
    def initialize(*several_variants)
        #This is a stub, used for indexing
    end
    # array.replace(other_array)  -> array
    # 
    # Replaces the contents of <i>self</i> with the contents of
    # <i>other_array</i>, truncating or expanding if necessary.
    # 
    #    a = [ "a", "b", "c", "d", "e" ]
    #    a.replace([ "x", "y", "z" ])   #=> ["x", "y", "z"]
    #    a                              #=> ["x", "y", "z"]
    def initialize_copy(p1)
        #This is a stub, used for indexing
    end
    # array.to_s -> string
    # 
    # Returns _self_<code>.join</code>.
    # 
    #    [ "a", "e", "i", "o" ].to_s   #=> "aeio"
    def to_s()
        #This is a stub, used for indexing
    end
    # array.inspect  -> string
    # 
    # Create a printable version of <i>array</i>.
    def inspect()
        #This is a stub, used for indexing
    end
    # array.to_a     -> array
    # 
    # Returns _self_. If called on a subclass of Array, converts
    # the receiver to an Array object.
    def to_a()
        #This is a stub, used for indexing
    end
    # array.to_ary -> array
    # 
    # Returns _self_.
    def to_ary()
        #This is a stub, used for indexing
    end
    # array.frozen?  -> true or false
    # 
    # Return <code>true</code> if this array is frozen (or temporarily frozen
    # while being sorted).
    def frozen?()
        #This is a stub, used for indexing
    end
    # array == other_array   ->   bool
    # 
    # Equality---Two arrays are equal if they contain the same number
    # of elements and if each element is equal to (according to
    # Object.==) the corresponding element in the other array.
    # 
    #    [ "a", "c" ]    == [ "a", "c", 7 ]     #=> false
    #    [ "a", "c", 7 ] == [ "a", "c", 7 ]     #=> true
    #    [ "a", "c", 7 ] == [ "a", "d", "f" ]   #=> false
    def == other_array
        #This is a stub, used for indexing
    end
    # array.eql?(other)  -> true or false
    # 
    # Returns <code>true</code> if _array_ and _other_ are the same object,
    # or are both arrays with the same content.
    def eql?(other)
        #This is a stub, used for indexing
    end
    # array.hash   -> fixnum
    # 
    # Compute a hash-code for this array. Two arrays with the same content
    # will have the same hash code (and will compare using <code>eql?</code>).
    def hash()
        #This is a stub, used for indexing
    end
    # array[index]                -> obj      or nil
    # array[start, length]        -> an_array or nil
    # array[range]                -> an_array or nil
    # array.slice(index)          -> obj      or nil
    # array.slice(start, length)  -> an_array or nil
    # array.slice(range)          -> an_array or nil
    # 
    # Element Reference---Returns the element at _index_,
    # or returns a subarray starting at _start_ and
    # continuing for _length_ elements, or returns a subarray
    # specified by _range_.
    # Negative indices count backward from the end of the
    # array (-1 is the last element). Returns nil if the index
    # (or starting index) are out of range.
    # 
    #    a = [ "a", "b", "c", "d", "e" ]
    #    a[2] +  a[0] + a[1]    #=> "cab"
    #    a[6]                   #=> nil
    #    a[1, 2]                #=> [ "b", "c" ]
    #    a[1..3]                #=> [ "b", "c", "d" ]
    #    a[4..7]                #=> [ "e" ]
    #    a[6..10]               #=> nil
    #    a[-3, 3]               #=> [ "c", "d", "e" ]
    #    # special cases
    #    a[5]                   #=> nil
    #    a[5, 1]                #=> []
    #    a[5..10]               #=> []
    def [](*several_variants)
        #This is a stub, used for indexing
    end
    # array[index]         = obj                     ->  obj
    # array[start, length] = obj or an_array or nil  ->  obj or an_array or nil
    # array[range]         = obj or an_array or nil  ->  obj or an_array or nil
    # 
    # Element Assignment---Sets the element at _index_,
    # or replaces a subarray starting at _start_ and
    # continuing for _length_ elements, or replaces a subarray
    # specified by _range_.  If indices are greater than
    # the current capacity of the array, the array grows
    # automatically. A negative indices will count backward
    # from the end of the array. Inserts elements if _length_ is
    # zero. If +nil+ is used in the second and third form,
    # deletes elements from _self_. An +IndexError+ is raised if a
    # negative index points past the beginning of the array. See also
    # <code>Array#push</code>, and <code>Array#unshift</code>.
    # 
    #    a = Array.new
    #    a[4] = "4";                 #=> [nil, nil, nil, nil, "4"]
    #    a[0, 3] = [ 'a', 'b', 'c' ] #=> ["a", "b", "c", nil, "4"]
    #    a[1..2] = [ 1, 2 ]          #=> ["a", 1, 2, nil, "4"]
    #    a[0, 2] = "?"               #=> ["?", 2, nil, "4"]
    #    a[0..2] = "A"               #=> ["A", "4"]
    #    a[-1]   = "Z"               #=> ["A", "Z"]
    #    a[1..-1] = nil              #=> ["A"]
    def []=(*several_variants)
        #This is a stub, used for indexing
    end
    # array.at(index)   ->   obj  or nil
    # 
    # Returns the element at _index_. A
    # negative index counts from the end of _self_.  Returns +nil+
    # if the index is out of range. See also <code>Array#[]</code>.
    # (<code>Array#at</code> is slightly faster than <code>Array#[]</code>,
    # as it does not accept ranges and so on.)
    # 
    #    a = [ "a", "b", "c", "d", "e" ]
    #    a.at(0)     #=> "a"
    #    a.at(-1)    #=> "e"
    def at(index)
        #This is a stub, used for indexing
    end
    # array.fetch(index)                    -> obj
    # array.fetch(index, default )          -> obj
    # array.fetch(index) {|index| block }   -> obj
    # 
    # Tries to return the element at position <i>index</i>. If the index
    # lies outside the array, the first form throws an
    # <code>IndexError</code> exception, the second form returns
    # <i>default</i>, and the third form returns the value of invoking
    # the block, passing in the index. Negative values of <i>index</i>
    # count from the end of the array.
    # 
    #    a = [ 11, 22, 33, 44 ]
    #    a.fetch(1)               #=> 22
    #    a.fetch(-1)              #=> 44
    #    a.fetch(4, 'cat')        #=> "cat"
    #    a.fetch(4) { |i| i*i }   #=> 16
    def fetch(*several_variants)
        #This is a stub, used for indexing
    end
    # array.first   ->   obj or nil
    # array.first(n) -> an_array
    # 
    # Returns the first element, or the first +n+ elements, of the array.
    # If the array is empty, the first form returns <code>nil</code>, and the
    # second form returns an empty array.
    # 
    #    a = [ "q", "r", "s", "t" ]
    #    a.first    #=> "q"
    #    a.first(1) #=> ["q"]
    #    a.first(3) #=> ["q", "r", "s"]
    def first(*several_variants)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        to_enum.next
    end
    # array.last     ->  obj or nil
    # array.last(n)  ->  an_array
    # 
    # Returns the last element(s) of <i>self</i>. If the array is empty,
    # the first form returns <code>nil</code>.
    # 
    #    [ "w", "x", "y", "z" ].last   #=> "z"
    def last(*several_variants)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        to_enum.next
    end
    # array.concat(other_array)   ->  array
    # 
    # Appends the elements in other_array to _self_.
    # 
    #    [ "a", "b" ].concat( ["c", "d"] ) #=> [ "a", "b", "c", "d" ]
    def concat(other_array)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array << obj            -> array
    # 
    # Append---Pushes the given object on to the end of this array. This
    # expression returns the array itself, so several appends
    # may be chained together.
    # 
    #    [ 1, 2 ] << "c" << "d" << [ 3, 4 ]
    #            #=>  [ 1, 2, "c", "d", [ 3, 4 ] ]
    def << obj
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.push(obj, ... )   -> array
    # 
    # Append---Pushes the given object(s) on to the end of this array. This
    # expression returns the array itself, so several appends
    # may be chained together.
    # 
    #    a = [ "a", "b", "c" ]
    #    a.push("d", "e", "f")  
    #            #=> ["a", "b", "c", "d", "e", "f"]
    def push(obj, *smth)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.pop    -> obj or nil
    # array.pop(n) -> array
    # 
    # Removes the last element from <i>self</i> and returns it, or
    # <code>nil</code> if the array is empty.
    # 
    # If a number _n_ is given, returns an array of the last n elements
    # (or less) just like <code>array.slice!(-n, n)</code> does.
    # 
    #    a = [ "a", "b", "c", "d" ]
    #    a.pop     #=> "d"
    #    a.pop(2)  #=> ["b", "c"]
    #    a         #=> ["a"]
    def pop(*several_variants)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        to_enum.next
    end
    # array.shift    -> obj or nil
    # array.shift(n) -> array
    # 
    # Returns the first element of <i>self</i> and removes it (shifting all
    # other elements down by one). Returns <code>nil</code> if the array
    # is empty.
    # 
    # If a number _n_ is given, returns an array of the first n elements
    # (or less) just like <code>array.slice!(0, n)</code> does.
    # 
    #    args = [ "-m", "-q", "filename" ]
    #    args.shift     #=> "-m"
    #    args           #=> ["-q", "filename"]
    # 
    #    args = [ "-m", "-q", "filename" ]
    #    args.shift(2)  #=> ["-m", "-q"]
    #    args           #=> ["filename"]
    def shift(*several_variants)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.unshift(obj, ...)  -> array
    # 
    # Prepends objects to the front of <i>array</i>.
    # other elements up one.
    # 
    #    a = [ "b", "c", "d" ]
    #    a.unshift("a")   #=> ["a", "b", "c", "d"]
    #    a.unshift(1, 2)  #=> [ 1, 2, "a", "b", "c", "d"]
    def unshift(obj, *smth)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.insert(index, obj...)  -> array
    # 
    # Inserts the given values before the element with the given index
    # (which may be negative).
    # 
    #    a = %w{ a b c d }
    #    a.insert(2, 99)         #=> ["a", "b", 99, "c", "d"]
    #    a.insert(-2, 1, 2, 3)   #=> ["a", "b", 99, "c", 1, 2, 3, "d"]
    def insert(index, *objects)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.each {|item| block }   ->   array
    # 
    # Calls <i>block</i> once for each element in <i>self</i>, passing that
    # element as a parameter.
    # 
    #    a = [ "a", "b", "c" ]
    #    a.each {|x| print x, " -- " }
    # 
    # produces:
    # 
    #    a -- b -- c --
    def each()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        (yield to_enum.next); self
    end
    # array.each_index {|index| block }  ->  array
    # 
    # Same as <code>Array#each</code>, but passes the index of the element
    # instead of the element itself.
    # 
    #    a = [ "a", "b", "c" ]
    #    a.each_index {|x| print x, " -- " }
    # 
    # produces:
    # 
    #    0 -- 1 -- 2 --
    def each_index()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        (yield 0); self
    end
    # array.reverse_each {|item| block } 
    # 
    # Same as <code>Array#each</code>, but traverses <i>self</i> in reverse
    # order.
    # 
    #    a = [ "a", "b", "c" ]
    #    a.reverse_each {|x| print x, " " }
    # 
    # produces:
    # 
    #    c b a
    def reverse_each()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        (yield to_enum.next); self
    end
    # array.length -> int
    # 
    # Returns the number of elements in <i>self</i>. May be zero.
    # 
    #    [ 1, 2, 3, 4, 5 ].length   #=> 5
    def length()
        #This is a stub, used for indexing
    end
    alias size length
    # array.empty?   -> true or false
    # 
    # Returns <code>true</code> if <i>self</i> array contains no elements.
    # 
    #    [].empty?   #=> true
    def empty?()
        #This is a stub, used for indexing
    end
    # array.index(obj)           ->  int or nil
    # array.index {|item| block} ->  int or nil
    # 
    # Returns the index of the first object in <i>self</i> such that is
    # <code>==</code> to <i>obj</i>. If a block is given instead of an
    # argument, returns first object for which <em>block</em> is true.
    # Returns <code>nil</code> if no match is found.
    # 
    #    a = [ "a", "b", "c" ]
    #    a.index("b")        #=> 1
    #    a.index("z")        #=> nil
    #    a.index{|x|x=="b"}  #=> 1
    # 
    # This is an alias of <code>#find_index</code>.
    def find_index(p1 = v1)
        #This is a stub, used for indexing
    end
    # array.index(obj)           ->  int or nil
    # array.index {|item| block} ->  int or nil
    # 
    # Returns the index of the first object in <i>self</i> such that is
    # <code>==</code> to <i>obj</i>. If a block is given instead of an
    # argument, returns first object for which <em>block</em> is true.
    # Returns <code>nil</code> if no match is found.
    # 
    #    a = [ "a", "b", "c" ]
    #    a.index("b")        #=> 1
    #    a.index("z")        #=> nil
    #    a.index{|x|x=="b"}  #=> 1
    # 
    # This is an alias of <code>#find_index</code>.
    def index(*several_variants)
        #This is a stub, used for indexing
    end
    # array.rindex(obj)    ->  int or nil
    # 
    # Returns the index of the last object in <i>array</i>
    # <code>==</code> to <i>obj</i>. If a block is given instead of an
    # argument, returns first object for which <em>block</em> is
    # true. Returns <code>nil</code> if no match is found.
    # 
    #    a = [ "a", "b", "b", "b", "c" ]
    #    a.rindex("b")        #=> 3
    #    a.rindex("z")        #=> nil
    #    a.rindex{|x|x=="b"}  #=> 3
    def rindex(obj)
        #This is a stub, used for indexing
    end
    # array.indexes( i1, i2, ... iN )   -> an_array
    # 
    # Deprecated; use <code>Array#values_at</code>.
    def indexes(*i1_i2__in)
        #This is a stub, used for indexing
    end
    # array.indices( i1, i2, ... iN )   -> an_array
    # 
    # Deprecated; use <code>Array#values_at</code>.
    def indices(*i1_i2__in)
        #This is a stub, used for indexing
    end
    # array.join(sep=$,)    -> str
    # 
    # Returns a string created by converting each element of the array to
    # a string, separated by <i>sep</i>.
    # 
    #    [ "a", "b", "c" ].join        #=> "abc"
    #    [ "a", "b", "c" ].join("-")   #=> "a-b-c"
    def join(sep=$,)
        #This is a stub, used for indexing
    end
    # array.reverse -> an_array
    # 
    # Returns a new array containing <i>self</i>'s elements in reverse order.
    # 
    #    [ "a", "b", "c" ].reverse   #=> ["c", "b", "a"]
    #    [ 1 ].reverse               #=> [1]
    def reverse()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.reverse!   -> array 
    # 
    # Reverses _self_ in place.
    # 
    #    a = [ "a", "b", "c" ]
    #    a.reverse!       #=> ["c", "b", "a"]
    #    a                #=> ["c", "b", "a"]
    def reverse!()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.sort                   -> an_array 
    # array.sort {| a,b | block }  -> an_array 
    # 
    # Returns a new array created by sorting <i>self</i>. Comparisons for
    # the sort will be done using the <code><=></code> operator or using
    # an optional code block. The block implements a comparison between
    # <i>a</i> and <i>b</i>, returning -1, 0, or +1. See also
    # <code>Enumerable#sort_by</code>.
    # 
    #    a = [ "d", "a", "e", "c", "b" ]
    #    a.sort                    #=> ["a", "b", "c", "d", "e"]
    #    a.sort {|x,y| y <=> x }   #=> ["e", "d", "c", "b", "a"]
    def sort(*several_variants)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.sort!                   -> array
    # array.sort! {| a,b | block }  -> array 
    # 
    # Sorts _self_. Comparisons for
    # the sort will be done using the <code><=></code> operator or using
    # an optional code block. The block implements a comparison between
    # <i>a</i> and <i>b</i>, returning -1, 0, or +1. See also
    # <code>Enumerable#sort_by</code>.
    # 
    #    a = [ "d", "a", "e", "c", "b" ]
    #    a.sort                    #=> ["a", "b", "c", "d", "e"]
    #    a.sort {|x,y| y <=> x }   #=> ["e", "d", "c", "b", "a"]
    def sort!(*several_variants)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.collect {|item| block }  -> an_array
    # 
    # Invokes <i>block</i> once for each element of <i>self</i>. Creates a 
    # new array containing the values returned by the block.
    # See also <code>Enumerable#collect</code>.
    # 
    #    a = [ "a", "b", "c", "d" ]
    #    a.collect {|x| x + "!" }   #=> ["a!", "b!", "c!", "d!"]
    #    a                          #=> ["a", "b", "c", "d"]
    def collect()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        (yield to_enum.next).to_enum.to_a
    end
    # array.collect! {|item| block }   ->   array
    # 
    # Invokes the block once for each element of _self_, replacing the
    # element with the value returned by _block_.
    # See also <code>Enumerable#collect</code>.
    # 
    #    a = [ "a", "b", "c", "d" ]
    #    a.collect! {|x| x + "!" }
    #    a             #=>  [ "a!", "b!", "c!", "d!" ]
    def collect!()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        (yield to_enum.next).to_enum.to_a
    end
    # array.map     {|item| block }  -> an_array
    # 
    # Invokes <i>block</i> once for each element of <i>self</i>. Creates a 
    # new array containing the values returned by the block.
    # See also <code>Enumerable#collect</code>.
    # 
    #    a = [ "a", "b", "c", "d" ]
    #    a.collect {|x| x + "!" }   #=> ["a!", "b!", "c!", "d!"]
    #    a                          #=> ["a", "b", "c", "d"]
    def map()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        (yield to_enum.next).to_enum.to_a
    end
    # array.map!     {|item| block }   ->   array
    # 
    # Invokes the block once for each element of _self_, replacing the
    # element with the value returned by _block_.
    # See also <code>Enumerable#collect</code>.
    # 
    #    a = [ "a", "b", "c", "d" ]
    #    a.collect! {|x| x + "!" }
    #    a             #=>  [ "a!", "b!", "c!", "d!" ]
    def map!()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        (yield to_enum.next).to_enum.to_a
    end
    # array.select {|item| block } -> an_array
    # 
    # Invokes the block passing in successive elements from <i>array</i>,
    # returning an array containing those elements for which the block
    # returns a true value (equivalent to <code>Enumerable#select</code>).
    # 
    #    a = %w{ a b c d e f }
    #    a.select {|v| v =~ /[aeiou]/}   #=> ["a", "e"]
    def select()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        yield to_enum.next; self
    end
    # array.values_at(selector,... )  -> an_array
    # 
    # Returns an array containing the elements in
    # _self_ corresponding to the given selector(s). The selectors
    # may be either integer indices or ranges. 
    # See also <code>Array#select</code>.
    # 
    #    a = %w{ a b c d e f }
    #    a.values_at(1, 3, 5)
    #    a.values_at(1, 3, 5, 7)
    #    a.values_at(-1, -3, -5, -7)
    #    a.values_at(1..3, 2...5)
    def values_at(selector,*smth)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.delete(obj)            -> obj or nil 
    # array.delete(obj) { block }  -> obj or nil
    # 
    # Deletes items from <i>self</i> that are equal to <i>obj</i>. If
    # the item is not found, returns <code>nil</code>. If the optional
    # code block is given, returns the result of <i>block</i> if the item
    # is not found.
    # 
    #    a = [ "a", "b", "b", "b", "c" ]
    #    a.delete("b")                   #=> "b"
    #    a                               #=> ["a", "c"]
    #    a.delete("z")                   #=> nil
    #    a.delete("z") { "not found" }   #=> "not found"
    def delete(*several_variants)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        to_enum.next
    end
    # array.delete_at(index)  -> obj or nil
    # 
    # Deletes the element at the specified index, returning that element,
    # or <code>nil</code> if the index is out of range. See also
    # <code>Array#slice!</code>.
    # 
    #    a = %w( ant bat cat dog )
    #    a.delete_at(2)    #=> "cat"
    #    a                 #=> ["ant", "bat", "dog"]
    #    a.delete_at(99)   #=> nil
    def delete_at(index)
        #This is a stub, used for indexing
    end
    # array.delete_if {|item| block }  -> array
    # 
    # Deletes every element of <i>self</i> for which <i>block</i> evaluates
    # to <code>true</code>.
    # 
    #    a = [ "a", "b", "c" ]
    #    a.delete_if {|x| x >= "b" }   #=> ["a"]
    def delete_if()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        yield to_enum.next; self
    end
    # array.reject {|item| block }  -> an_array
    # 
    # Returns a new array containing the items in _self_
    # for which the block is not true.
    def reject()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        yield to_enum.next; self
    end
    # array.reject! {|item| block }  -> array or nil
    # 
    # Equivalent to <code>Array#delete_if</code>, deleting elements from
    # _self_ for which the block evaluates to true, but returns
    # <code>nil</code> if no changes were made. Also see
    # <code>Enumerable#reject</code>.
    def reject!()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        yield to_enum.next; self
    end
    # array.zip(arg, ...)                   -> an_array
    # array.zip(arg, ...) {| arr | block }  -> nil
    # 
    # Converts any arguments to arrays, then merges elements of
    # <i>self</i> with corresponding elements from each argument. This
    # generates a sequence of <code>self.size</code> <em>n</em>-element
    # arrays, where <em>n</em> is one more that the count of arguments. If
    # the size of any argument is less than <code>enumObj.size</code>,
    # <code>nil</code> values are supplied. If a block given, it is
    # invoked for each output array, otherwise an array of arrays is
    # returned.
    # 
    #    a = [ 4, 5, 6 ]
    #    b = [ 7, 8, 9 ]
    # 
    #    [1,2,3].zip(a, b)      #=> [[1, 4, 7], [2, 5, 8], [3, 6, 9]]
    #    [1,2].zip(a,b)         #=> [[1, 4, 7], [2, 5, 8]]
    #    a.zip([1,2],[8])       #=> [[4,1,8], [5,2,nil], [6,nil,nil]]
    def zip(*several_variants)
        #This is a stub, used for indexing
    end
    # array.transpose -> an_array
    # 
    # Assumes that <i>self</i> is an array of arrays and transposes the
    # rows and columns.
    # 
    #    a = [[1,2], [3,4], [5,6]]
    #    a.transpose   #=> [[1, 3, 5], [2, 4, 6]]
    def transpose()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.replace(other_array)  -> array
    # 
    # Replaces the contents of <i>self</i> with the contents of
    # <i>other_array</i>, truncating or expanding if necessary.
    # 
    #    a = [ "a", "b", "c", "d", "e" ]
    #    a.replace([ "x", "y", "z" ])   #=> ["x", "y", "z"]
    #    a                              #=> ["x", "y", "z"]
    def replace(other_array)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        other_ary
    end
    # array.clear    ->  array
    # 
    # Removes all elements from _self_.
    # 
    #    a = [ "a", "b", "c", "d", "e" ]
    #    a.clear    #=> [ ]
    def clear()
        #This is a stub, used for indexing
    end
    # array.fill(obj)                                -> array
    # array.fill(obj, start [, length])              -> array
    # array.fill(obj, range )                        -> array
    # array.fill {|index| block }                    -> array
    # array.fill(start [, length] ) {|index| block } -> array
    # array.fill(range) {|index| block }             -> array
    # 
    # The first three forms set the selected elements of <i>self</i> (which
    # may be the entire array) to <i>obj</i>. A <i>start</i> of
    # <code>nil</code> is equivalent to zero. A <i>length</i> of
    # <code>nil</code> is equivalent to <i>self.length</i>. The last three
    # forms fill the array with the value of the block. The block is
    # passed the absolute index of each element to be filled.
    # 
    #    a = [ "a", "b", "c", "d" ]
    #    a.fill("x")              #=> ["x", "x", "x", "x"]
    #    a.fill("z", 2, 2)        #=> ["x", "x", "z", "z"]
    #    a.fill("y", 0..1)        #=> ["y", "y", "z", "z"]
    #    a.fill {|i| i*i}         #=> [0, 1, 4, 9]
    #    a.fill(-2) {|i| i*i*i}   #=> [0, 1, 8, 27]
    def fill(*several_variants)
        #This is a stub, used for indexing
    end
    # array.include?(obj)   -> true or false
    # 
    # Returns <code>true</code> if the given object is present in
    # <i>self</i> (that is, if any object <code>==</code> <i>anObject</i>),
    # <code>false</code> otherwise.
    # 
    #    a = [ "a", "b", "c" ]
    #    a.include?("b")   #=> true
    #    a.include?("z")   #=> false
    def include?(obj)
        #This is a stub, used for indexing
    end
    # array <=> other_array   ->  -1, 0, +1
    # 
    # Comparison---Returns an integer (-1, 0,
    # or +1) if this array is less than, equal to, or greater than
    # other_array.  Each object in each array is compared
    # (using <=>). If any value isn't
    # equal, then that inequality is the return value. If all the
    # values found are equal, then the return is based on a
    # comparison of the array lengths.  Thus, two arrays are
    # ``equal'' according to <code>Array#<=></code> if and only if they have
    # the same length and the value of each element is equal to the
    # value of the corresponding element in the other array.
    # 
    #    [ "a", "a", "c" ]    <=> [ "a", "b", "c" ]   #=> -1
    #    [ 1, 2, 3, 4, 5, 6 ] <=> [ 1, 2 ]            #=> +1
    def <=> other_array
        #This is a stub, used for indexing
    end
    # array.slice(index)          -> obj      or nil
    # array.slice(start, length)  -> an_array or nil
    # array.slice(range)          -> an_array or nil
    # 
    # Element Reference---Returns the element at _index_,
    # or returns a subarray starting at _start_ and
    # continuing for _length_ elements, or returns a subarray
    # specified by _range_.
    # Negative indices count backward from the end of the
    # array (-1 is the last element). Returns nil if the index
    # (or starting index) are out of range.
    # 
    #    a = [ "a", "b", "c", "d", "e" ]
    #    a[2] +  a[0] + a[1]    #=> "cab"
    #    a[6]                   #=> nil
    #    a[1, 2]                #=> [ "b", "c" ]
    #    a[1..3]                #=> [ "b", "c", "d" ]
    #    a[4..7]                #=> [ "e" ]
    #    a[6..10]               #=> nil
    #    a[-3, 3]               #=> [ "c", "d", "e" ]
    #    # special cases
    #    a[5]                   #=> nil
    #    a[5, 1]                #=> []
    #    a[5..10]               #=> []
    def slice(*several_variants)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.slice!(index)         -> obj or nil
    # array.slice!(start, length) -> sub_array or nil
    # array.slice!(range)         -> sub_array or nil 
    # 
    # Deletes the element(s) given by an index (optionally with a length)
    # or by a range. Returns the deleted object, subarray, or
    # <code>nil</code> if the index is out of range. Equivalent to:
    # 
    #    def slice!(*args)
    #      result = self[*args]
    #      self[*args] = nil
    #      result
    #    end
    # 
    #    a = [ "a", "b", "c" ]
    #    a.slice!(1)     #=> "b"
    #    a               #=> ["a", "c"]
    #    a.slice!(-1)    #=> "c"
    #    a               #=> ["a"]
    #    a.slice!(100)   #=> nil
    #    a               #=> ["a"]
    def slice!(*several_variants)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.assoc(obj)   ->  an_array  or  nil
    # 
    # Searches through an array whose elements are also arrays
    # comparing _obj_ with the first element of each contained array
    # using obj.==.
    # Returns the first contained array that matches (that
    # is, the first associated array),
    # or +nil+ if no match is found.
    # See also <code>Array#rassoc</code>.
    # 
    #    s1 = [ "colors", "red", "blue", "green" ]
    #    s2 = [ "letters", "a", "b", "c" ]
    #    s3 = "foo"
    #    a  = [ s1, s2, s3 ]
    #    a.assoc("letters")  #=> [ "letters", "a", "b", "c" ]
    #    a.assoc("foo")      #=> nil
    def assoc(obj)
        #This is a stub, used for indexing
    end
    # array.rassoc(key) -> an_array or nil
    # 
    # Searches through the array whose elements are also arrays. Compares
    # <em>key</em> with the second element of each contained array using
    # <code>==</code>. Returns the first contained array that matches. See
    # also <code>Array#assoc</code>.
    # 
    #    a = [ [ 1, "one"], [2, "two"], [3, "three"], ["ii", "two"] ]
    #    a.rassoc("two")    #=> [2, "two"]
    #    a.rassoc("four")   #=> nil
    def rassoc(key)
        #This is a stub, used for indexing
    end
    # array + other_array   -> an_array
    # 
    # Concatenation---Returns a new array built by concatenating the
    # two arrays together to produce a third array.
    # 
    #    [ 1, 2, 3 ] + [ 4, 5 ]    #=> [ 1, 2, 3, 4, 5 ]
    def + other_array
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array * int     ->    an_array
    # array * str     ->    a_string
    # 
    # Repetition---With a String argument, equivalent to
    # self.join(str). Otherwise, returns a new array
    # built by concatenating the _int_ copies of _self_.
    # 
    #    [ 1, 2, 3 ] * 3    #=> [ 1, 2, 3, 1, 2, 3, 1, 2, 3 ]
    #    [ 1, 2, 3 ] * ","  #=> "1,2,3"
    def *(*several_variants)
        #This is a stub, used for indexing
    end
    # array - other_array    -> an_array
    # 
    # Array Difference---Returns a new array that is a copy of
    # the original array, removing any items that also appear in
    # other_array. (If you need set-like behavior, see the
    # library class Set.)
    # 
    #    [ 1, 1, 2, 2, 3, 3, 4, 5 ] - [ 1, 2, 4 ]  #=>  [ 3, 3, 5 ]
    def - other_array
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array & other_array
    # 
    # Set Intersection---Returns a new array
    # containing elements common to the two arrays, with no duplicates.
    # 
    #    [ 1, 1, 3, 5 ] & [ 1, 2, 3 ]   #=> [ 1, 3 ]
    def & other_array
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array | other_array     ->  an_array
    # 
    # Set Union---Returns a new array by joining this array with
    # other_array, removing duplicates.
    # 
    #    [ "a", "b", "c" ] | [ "c", "d", "a" ]
    #           #=> [ "a", "b", "c", "d" ]
    def | other_array
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.uniq   -> an_array
    # 
    # Returns a new array by removing duplicate values in <i>self</i>.
    # 
    #    a = [ "a", "a", "b", "b", "c" ]
    #    a.uniq   #=> ["a", "b", "c"]
    def uniq()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.uniq! -> array or nil
    # 
    # Removes duplicate elements from _self_.
    # Returns <code>nil</code> if no changes are made (that is, no
    # duplicates are found).
    # 
    #    a = [ "a", "a", "b", "b", "c" ]
    #    a.uniq!   #=> ["a", "b", "c"]
    #    b = [ "a", "b", "c" ]
    #    b.uniq!   #=> nil
    def uniq!()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.compact     ->  an_array
    # 
    # Returns a copy of _self_ with all +nil+ elements removed.
    # 
    #    [ "a", nil, "b", nil, "c", nil ].compact
    #                      #=> [ "a", "b", "c" ]
    def compact()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.compact!    ->   array  or  nil
    # 
    # Removes +nil+ elements from array.
    # Returns +nil+ if no changes were made.
    # 
    #    [ "a", nil, "b", nil, "c" ].compact! #=> [ "a", "b", "c" ]
    #    [ "a", "b", "c" ].compact!           #=> nil
    def compact!()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.flatten -> an_array
    # array.flatten(level) -> an_array
    # 
    # Returns a new array that is a one-dimensional flattening of this
    # array (recursively). That is, for every element that is an array,
    # extract its elements into the new array.  If the optional
    # <i>level</i> argument determines the level of recursion to flatten.
    # 
    #    s = [ 1, 2, 3 ]           #=> [1, 2, 3]
    #    t = [ 4, 5, 6, [7, 8] ]   #=> [4, 5, 6, [7, 8]]
    #    a = [ s, t, 9, 10 ]       #=> [[1, 2, 3], [4, 5, 6, [7, 8]], 9, 10]
    #    a.flatten                 #=> [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
    #    a = [ 1, 2, [3, [4, 5] ] ]
    #    a.flatten(1)              #=> [1, 2, 3, [4, 5]]
    def flatten(*several_variants)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.flatten! -> array or nil
    # array.flatten!(level) -> array or nil
    # 
    # Flattens _self_ in place.
    # Returns <code>nil</code> if no modifications were made (i.e.,
    # <i>array</i> contains no subarrays.)  If the optional <i>level</i>
    # argument determines the level of recursion to flatten.
    # 
    #    a = [ 1, 2, [3, [4, 5] ] ]
    #    a.flatten!   #=> [1, 2, 3, 4, 5]
    #    a.flatten!   #=> nil
    #    a            #=> [1, 2, 3, 4, 5]
    #    a = [ 1, 2, [3, [4, 5] ] ]
    #    a.flatten!(1) #=> [1, 2, 3, [4, 5]]
    def flatten!(*several_variants)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        self
    end
    # array.nitems -> int
    # 
    # Returns the number of non-<code>nil</code> elements in _self_.
    # 
    # May be zero.
    # 
    #    [ 1, nil, 3, nil, 5 ].nitems   #=> 3
    def nitems()
        #This is a stub, used for indexing
    end
    # array.count      -> int
    # array.count(obj) -> int
    # array.count { |item| block }  -> int
    # 
    # Returns the number of elements.  If an argument is given, counts
    # the number of elements which equals to <i>obj</i>.  If a block is
    # given, counts the number of elements yielding a true value.
    # 
    #    ary = [1, 2, 4, 2]
    #    ary.count             # => 4
    #    ary.count(2)          # => 2
    #    ary.count{|x|x%2==0}  # => 3
    def count(*several_variants)
        #This is a stub, used for indexing
    end
    # array.shuffle!        -> array or nil
    # 
    # Shuffles elements in _self_ in place.
    def shuffle!()
        #This is a stub, used for indexing
    end
    # array.shuffle -> an_array
    # 
    # Returns a new array with elements of this array shuffled.
    # 
    #    a = [ 1, 2, 3 ]           #=> [1, 2, 3]
    #    a.shuffle                 #=> [2, 3, 1]
    def shuffle()
        #This is a stub, used for indexing
    end
    # array.choice        -> obj
    # 
    # Choose a random element from an array.
    def choice()
        #This is a stub, used for indexing
    end
    # ary.cycle {|obj| block }
    # ary.cycle(n) {|obj| block }
    # 
    # Calls <i>block</i> for each element repeatedly _n_ times or
    # forever if none or nil is given.  If a non-positive number is
    # given or the array is empty, does nothing.  Returns nil if the
    # loop has finished without getting interrupted.
    # 
    #    a = ["a", "b", "c"]
    #    a.cycle {|x| puts x }  # print, a, b, c, a, b, c,.. forever.
    #    a.cycle(2) {|x| puts x }  # print, a, b, c, a, b, c.
    def cycle(*several_variants)
        #This is a stub, used for indexing
    end
    # ary.permutation { |p| block }          -> array
    # ary.permutation                        -> enumerator
    # ary.permutation(n) { |p| block }       -> array
    # ary.permutation(n)                     -> enumerator
    # 
    # When invoked with a block, yield all permutations of length <i>n</i>
    # of the elements of <i>ary</i>, then return the array itself.
    # If <i>n</i> is not specified, yield all permutations of all elements.
    # The implementation makes no guarantees about the order in which 
    # the permutations are yielded.
    # 
    # When invoked without a block, return an enumerator object instead.
    # 
    # Examples:
    # 
    #     a = [1, 2, 3]
    #     a.permutation.to_a     #=> [[1,2,3],[1,3,2],[2,1,3],[2,3,1],[3,1,2],[3,2,1]]
    #     a.permutation(1).to_a  #=> [[1],[2],[3]]
    #     a.permutation(2).to_a  #=> [[1,2],[1,3],[2,1],[2,3],[3,1],[3,2]]
    #     a.permutation(3).to_a  #=> [[1,2,3],[1,3,2],[2,1,3],[2,3,1],[3,1,2],[3,2,1]]
    #     a.permutation(0).to_a  #=> [[]] # one permutation of length 0
    #     a.permutation(4).to_a  #=> []   # no permutations of length 4
    def permutation(*several_variants)
        #This is a stub, used for indexing
    end
    # ary.combination(n) { |c| block }    -> ary
    # ary.combination(n)                  -> enumerator
    # 
    # When invoked with a block, yields all combinations of length <i>n</i> 
    # of elements from <i>ary</i> and then returns <i>ary</i> itself.
    # The implementation makes no guarantees about the order in which 
    # the combinations are yielded.
    # 
    # When invoked without a block, returns an enumerator object instead.
    # 
    # Examples:
    # 
    #     a = [1, 2, 3, 4]
    #     a.combination(1).to_a  #=> [[1],[2],[3],[4]]
    #     a.combination(2).to_a  #=> [[1,2],[1,3],[1,4],[2,3],[2,4],[3,4]]
    #     a.combination(3).to_a  #=> [[1,2,3],[1,2,4],[1,3,4],[2,3,4]]
    #     a.combination(4).to_a  #=> [[1,2,3,4]]
    #     a.combination(0).to_a  #=> [[]] # one combination of length 0
    #     a.combination(5).to_a  #=> []   # no combinations of length 5
    def combination(*several_variants)
        #This is a stub, used for indexing
    end
    # ary.product(other_ary, ...)
    # 
    # Returns an array of all combinations of elements from all arrays.
    # The length of the returned array is the product of the length
    # of ary and the argument arrays
    # 
    #    [1,2,3].product([4,5])     # => [[1,4],[1,5],[2,4],[2,5],[3,4],[3,5]]
    #    [1,2].product([1,2])       # => [[1,1],[1,2],[2,1],[2,2]]
    #    [1,2].product([3,4],[5,6]) # => [[1,3,5],[1,3,6],[1,4,5],[1,4,6],
    #                               #     [2,3,5],[2,3,6],[2,4,5],[2,4,6]]
    #    [1,2].product()            # => [[1],[2]]
    #    [1,2].product([])          # => []
    def product(other_ary, *smth)
        #This is a stub, used for indexing
    end
    # ary.take(n)               => array
    # 
    # Returns first n elements from <i>ary</i>.
    # 
    #    a = [1, 2, 3, 4, 5, 0]
    #    a.take(3)             # => [1, 2, 3]
    def take(n)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        yield to_enum.next; self
    end
    # ary.take_while {|arr| block }   => array
    # 
    # Passes elements to the block until the block returns nil or false,
    # then stops iterating and returns an array of all prior elements.
    # 
    #    a = [1, 2, 3, 4, 5, 0]
    #    a.take_while {|i| i < 3 }   # => [1, 2]
    def take_while()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        yield to_enum.next; self
    end
    # ary.drop(n)               => array
    # 
    # Drops first n elements from <i>ary</i>, and returns rest elements
    # in an array.
    # 
    #    a = [1, 2, 3, 4, 5, 0]
    #    a.drop(3)             # => [4, 5, 0]
    def drop(n)
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        yield to_enum.next; self
    end
    # ary.drop_while {|arr| block }   => array
    # 
    # Drops elements up to, but not including, the first element for
    # which the block returns nil or false and returns an array
    # containing the remaining elements.
    # 
    #    a = [1, 2, 3, 4, 5, 0]
    #    a.drop_while {|i| i < 3 }   # => [3, 4, 5, 0]
    def drop_while()
        #This is a stub implementation, it may not coincide with the actual behavior of the method
        yield to_enum.next; self
    end
    def size()
        #This is a stub, used for indexing
    end
    def to_ptr(p1 = v1)
        #This is a stub, used for indexing
    end
    # arr.pack ( aTemplateString ) -> aBinaryString
    # 
    # Packs the contents of <i>arr</i> into a binary sequence according to
    # the directives in <i>aTemplateString</i> (see the table below)
    # Directives ``A,'' ``a,'' and ``Z'' may be followed by a count,
    # which gives the width of the resulting field. The remaining
    # directives also may take a count, indicating the number of array
    # elements to convert. If the count is an asterisk
    # (``<code>*</code>''), all remaining array elements will be
    # converted. Any of the directives ``<code>sSiIlL</code>'' may be
    # followed by an underscore (``<code>_</code>'') to use the underlying
    # platform's native size for the specified type; otherwise, they use a
    # platform-independent size. Spaces are ignored in the template
    # string. See also <code>String#unpack</code>.
    # 
    #    a = [ "a", "b", "c" ]
    #    n = [ 65, 66, 67 ]
    #    a.pack("A3A3A3")   #=> "a  b  c  "
    #    a.pack("a3a3a3")   #=> "a\000\000b\000\000c\000\000"
    #    n.pack("ccc")      #=> "ABC"
    # 
    # Directives for +pack+.
    # 
    #  Integer   | Array   |
    #  Directive | Element | Meaning
    #  ------------------------------------------------------------------------
    #     C      | Integer | 8-bit unsigned integer (unsigned char)
    #     S      | Integer | 16-bit unsigned integer, native endian (uint16_t)
    #     L      | Integer | 32-bit unsigned integer, native endian (uint32_t)
    #     Q      | Integer | 64-bit unsigned integer, native endian (uint64_t)
    #            |         |
    #     c      | Integer | 8-bit signed integer (char)
    #     s      | Integer | 16-bit signed integer, native endian (int16_t)
    #     l      | Integer | 32-bit signed integer, native endian (int32_t)
    #     q      | Integer | 64-bit signed integer, native endian (int64_t)
    #            |         | 
    #     S_     | Integer | unsigned short, native endian
    #     I, I_  | Integer | unsigned int, native endian
    #     L_     | Integer | unsigned long, native endian
    #            |         |
    #     s_     | Integer | signed short, native endian
    #     i, i_  | Integer | signed int, native endian
    #     l_     | Integer | signed long, native endian
    #            |         |
    #     n      | Integer | 16-bit unsigned integer, network (big-endian) byte order
    #     N      | Integer | 32-bit unsigned integer, network (big-endian) byte order
    #     v      | Integer | 16-bit unsigned integer, VAX (little-endian) byte order
    #     V      | Integer | 32-bit unsigned integer, VAX (little-endian) byte order
    #            |         |
    #     U      | Integer | UTF-8 character
    #     w      | Integer | BER-compressed integer
    # 
    #  Float     |         |
    #  Directive |         | Meaning
    #  ------------------------------------------------------------------------
    #     D, d   | Float   | double-precision float, native format
    #     F, f   | Float   | single-precision float, native format
    #     E      | Float   | double-precision float, little-endian byte order
    #     e      | Float   | single-precision float, little-endian byte order
    #     G      | Float   | double-precision float, network (big-endian) byte order
    #     g      | Float   | single-precision float, network (big-endian) byte order
    # 
    #  String    |         |
    #  Directive |         | Meaning
    #  ------------------------------------------------------------------------
    #     A      | String  | arbitrary binary string (space padded, count is width)
    #     a      | String  | arbitrary binary string (null padded, count is width)
    #     Z      | String  | same as ``a'', except that null is added with *
    #     B      | String  | bit string (MSB first)
    #     b      | String  | bit string (LSB first)
    #     H      | String  | hex string (high nibble first)
    #     h      | String  | hex string (low nibble first)
    #     u      | String  | UU-encoded string
    #     M      | String  | quoted printable, MIME encoding (see RFC2045)
    #     m      | String  | base64 encoded string (see RFC 2045, count is width)
    #     P      | String  | pointer to a structure (fixed-length string)
    #     p      | String  | pointer to a null-terminated string
    # 
    #  Misc.     |         |
    #  Directive |         | Meaning
    #  ------------------------------------------------------------------------
    #     @      | ---     | moves to absolute position
    #     X      | ---     | back up a byte
    #     x      | ---     | null byte
    def pack( aTemplateString )
        #This is a stub, used for indexing
    end
end
