/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.autoupload.FileListenerImpl;
import com.jetbrains.plugins.webDeployment.autoupload.MuteFilter;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoUploadComponent
implements ProjectComponent {
    public static final Logger LOG = Logger.getInstance(AutoUploadComponent.class);
    private final Project myProject;
    private FileListenerImpl myListener;
    private final Map<MuteLock, MuteFilter> myMutedPaths = new ConcurrentHashMap<MuteLock, MuteFilter>();

    protected AutoUploadComponent(Project project) {
        this.myProject = project;
    }

    public static AutoUploadComponent getInstance(@NotNull Project project) {
        if (project == null) {
            AutoUploadComponent.$$$reportNull$$$0(0);
        }
        return (AutoUploadComponent)project.getComponent(AutoUploadComponent.class);
    }

    public void initComponent() {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void deploymentConfigChanged() {
                AutoUploadComponent.this.addOrRemoveListener();
            }

            @Override
            public void optionsChanged() {
                AutoUploadComponent.this.addOrRemoveListener();
            }

            @Override
            public void excludedPathsChanged() {
                AutoUploadComponent.this.addOrRemoveListener();
            }
        });
    }

    public void projectOpened() {
        this.addOrRemoveListener();
    }

    public void projectClosed() {
        this.addOrRemoveListener();
    }

    public void addOrRemoveListener() {
        boolean shouldBeListening;
        PublishConfig publishConfig = PublishConfig.getInstance(this.myProject).clone();
        List<Object> defaultServers = Collections.emptyList();
        boolean bl = shouldBeListening = this.myProject.isOpen() && !this.myProject.isDisposed() && publishConfig.getAutoUploadState() != PublishConfig.AutoUploadState.NEVER;
        if (shouldBeListening) {
            defaultServers = publishConfig.findValidDefaultTransferableServers();
            boolean bl2 = shouldBeListening = !defaultServers.isEmpty();
        }
        if (shouldBeListening) {
            if (this.myListener == null) {
                this.myListener = new FileListenerImpl(this.myProject, publishConfig, defaultServers){

                    @Override
                    protected boolean isMuted(@NotNull VirtualFile virtualFile) {
                        if (virtualFile == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return AutoUploadComponent.this.isMuted(virtualFile);
                    }

                    @Override
                    protected boolean isMuted(@NotNull VirtualFile parent, @NotNull String fileName) {
                        if (parent == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (fileName == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        return AutoUploadComponent.this.isMuted(parent, fileName);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "virtualFile";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "parent";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[0] = "fileName";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/plugins/webDeployment/AutoUploadComponent$2";
                        objectArray[2] = "isMuted";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)this.myListener);
            } else {
                this.myListener.setConfigs(publishConfig, defaultServers);
            }
            if (publishConfig.getAutoUploadState() == PublishConfig.AutoUploadState.ON_EXPLICIT_SAVE) {
                this.myListener.registerActionListener();
            } else {
                this.myListener.unregisterActionListener();
            }
        } else if (this.myListener != null) {
            LocalFileSystem.getInstance().removeVirtualFileListener((VirtualFileListener)this.myListener);
            this.myListener.unregisterActionListener();
            this.myListener.stopUpload();
            this.myListener = null;
        }
    }

    @NotNull
    public MuteLock mutePaths(@NotNull MuteFilter filter) {
        if (filter == null) {
            AutoUploadComponent.$$$reportNull$$$0(1);
        }
        MuteLock lock = new MuteLock();
        this.myMutedPaths.put(lock, filter);
        MuteLock muteLock = lock;
        if (muteLock == null) {
            AutoUploadComponent.$$$reportNull$$$0(2);
        }
        return muteLock;
    }

    public void unmutePaths(@NotNull MuteLock lock) {
        if (lock == null) {
            AutoUploadComponent.$$$reportNull$$$0(3);
        }
        this.myMutedPaths.remove(lock);
    }

    private boolean isMuted(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            AutoUploadComponent.$$$reportNull$$$0(4);
        }
        for (MuteFilter filter : this.myMutedPaths.values()) {
            if (!filter.isMuted(virtualFile)) continue;
            return true;
        }
        return false;
    }

    private boolean isMuted(@NotNull VirtualFile parent, @NotNull String fileName) {
        if (parent == null) {
            AutoUploadComponent.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            AutoUploadComponent.$$$reportNull$$$0(6);
        }
        for (MuteFilter filter : this.myMutedPaths.values()) {
            if (!filter.isMuted(parent, fileName)) continue;
            return true;
        }
        return false;
    }

    public static void executeWriteActionSilently(@Nullable Project project, @NotNull MuteFilter muteFilter, Runnable runnable) {
        if (muteFilter == null) {
            AutoUploadComponent.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (muteFilter == null) {
                AutoUploadComponent.$$$reportNull$$$0(9);
            }
            AutoUploadComponent.executeSilently(project, muteFilter, runnable);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeSilently(Project project, @NotNull MuteFilter muteFilter, Runnable runnable) {
        if (muteFilter == null) {
            AutoUploadComponent.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        MuteLock lock = null;
        if (project != null && !project.isDisposed()) {
            lock = AutoUploadComponent.getInstance(project).mutePaths(muteFilter);
        }
        try {
            runnable.run();
        }
        finally {
            if (lock != null && !project.isDisposed()) {
                AutoUploadComponent.getInstance(project).unmutePaths(lock);
            }
        }
    }

    public static void saveDocumentsSilently(Project project, Change[] changes) {
        AutoUploadComponent.executeWriteActionSilently(project, MuteFilter.create(changes), () -> {
            FileDocumentManager mgr = FileDocumentManager.getInstance();
            for (Change change : changes) {
                Document document;
                VirtualFile file;
                ContentRevision contentRevision = change.getAfterRevision();
                if (contentRevision == null || (file = contentRevision.getFile().getVirtualFile()) == null || !file.isValid() || (document = mgr.getDocument(file)) == null) continue;
                mgr.saveDocument(document);
            }
        });
    }

    public static void saveDocumentsSilently(Project project, Collection<VirtualFile> roots) {
        AutoUploadComponent.executeWriteActionSilently(project, MuteFilter.create(roots), () -> {
            FileDocumentManager mgr = FileDocumentManager.getInstance();
            for (Document document : mgr.getUnsavedDocuments()) {
                VirtualFile file = mgr.getFile(document);
                if (file == null || !file.isValid()) continue;
                boolean save = false;
                for (VirtualFile root : roots) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
                    save = true;
                    break;
                }
                if (!save) continue;
                mgr.saveDocument(document);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/AutoUploadComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "muteFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/AutoUploadComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "mutePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "mutePaths";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unmutePaths";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMuted";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeWriteActionSilently";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeSilently";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeWriteActionSilently$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MuteLock {
    }
}

