/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.popup;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.Utils;
import com.intellij.diagram.actions.PopupCallback;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.uml.core.actions.popup.UmlAddNodesCallback;
import com.intellij.uml.core.actions.popup.UmlElementsListCellRenderer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AddElementsFromPopupAction
extends DiagramAction {
    private final DiagramElementsProvider myProvider;
    private final DiagramBuilder myBuilder;
    private final DiagramProvider myUmlProvider;

    public AddElementsFromPopupAction(DiagramElementsProvider provider, DiagramBuilder builder) {
        this.myProvider = provider;
        this.myBuilder = builder;
        this.myUmlProvider = builder.getProvider();
        this.setShortcutSet(provider.getShortcutSet());
        this.registerCustomShortcutSet(provider.getShortcutSet(), builder.getView().getCanvasComponent());
    }

    public final boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(0);
        }
        return false;
    }

    @Nullable
    public Object[] getElements(Object element, Project project) {
        return this.myProvider.getElements(element, project);
    }

    public String getActionName() {
        return "Add elements";
    }

    @NotNull
    public String getPopupTitle(Object element, Project project) {
        String string = this.myProvider.getHeaderName(element, project);
        if (string == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void update(@NotNull AnActionEvent e) {
        DiagramNode selectedNode;
        if (e == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(2);
        }
        boolean enabled = (selectedNode = AddElementsFromPopupAction.getSelectedNode(AddElementsFromPopupAction.getBuilder((AnActionEvent)e))) != null && !(selectedNode instanceof DiagramNoteNode) && this.myProvider.isEnabledOn(selectedNode.getIdentifyingElement());
        e.getPresentation().setText(this.myProvider.getName());
        e.getPresentation().setEnabled(enabled);
    }

    @Nullable
    public static DiagramNode getSelectedNode(DiagramBuilder builder) {
        if (builder == null) {
            return null;
        }
        List nodes = GraphViewUtil.getSelectedNodes((Graph2D)builder.getGraph());
        if (nodes.size() != 1) {
            return null;
        }
        Node node = (Node)nodes.get(0);
        return builder.getNodeObject(node);
    }

    public void perform(@NotNull AnActionEvent e) {
        if (e == null) {
            AddElementsFromPopupAction.$$$reportNull$$$0(3);
        }
        DiagramBuilder builder = AddElementsFromPopupAction.getBuilder((AnActionEvent)e);
        DiagramNode umlNode = AddElementsFromPopupAction.getSelectedNode(builder);
        if (builder == null || umlNode == null) {
            return;
        }
        this.showPopup(builder, umlNode);
    }

    private void showPopup(DiagramBuilder builder, DiagramNode umlNode) {
        Graph2D graph = builder.getGraph();
        Graph2DView view = builder.getView();
        List nodes = GraphViewUtil.getSelectedNodes((Graph2D)graph);
        if (nodes.size() != 1) {
            return;
        }
        Node node = (Node)nodes.get(0);
        JBPopup[] popup = new JBPopup[1];
        Object element = umlNode.getIdentifyingElement();
        Runnable process = () -> {
            MouseMotionListener[] listeners;
            Object[] elements = this.getElements(element, builder.getProject());
            if (elements == null) {
                return;
            }
            ArrayList<Object> existen = new ArrayList<Object>();
            for (DiagramNode umlnode : builder.getNodeObjects()) {
                existen.add(umlnode.getIdentifyingElement());
            }
            DefaultUmlElementsListCellRenderer renderer = new DefaultUmlElementsListCellRenderer(existen);
            Arrays.sort(elements, renderer.getComparator());
            JBList list = new JBList(elements);
            list.setCellRenderer(renderer);
            for (MouseMotionListener listener : listeners = list.getMouseMotionListeners()) {
                list.removeMouseMotionListener(listener);
            }
            UmlAddNodesCallback callback = new UmlAddNodesCallback(builder, (JList)list);
            popup[0] = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setItemChoosenCallback(DiagramAction.createCallback((DiagramBuilder)builder, (PopupCallback)new PopupCallback.Adapter((Runnable)callback, this.getActionName()))).setMovable(true).setNamerForFiltering(o -> builder.getProvider().getElementManager().getElementTitle(o)).setTitle(this.getPopupTitle(element, builder.getProject())).createPopup();
        };
        Runnable run = () -> ApplicationManager.getApplication().runReadAction(process);
        if (this.myProvider.showProgress()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(run, this.myProvider.getProgressMessage(), true, builder.getProject());
        } else {
            run.run();
        }
        if (popup[0] != null) {
            Utils.showPopupBeneathNode((JBPopup)popup[0], (Node)node, (Graph2DView)view);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/popup/AddElementsFromPopupAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/popup/AddElementsFromPopupAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUndoable";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DefaultUmlElementsListCellRenderer
    extends UmlElementsListCellRenderer {
        private final List existen;

        DefaultUmlElementsListCellRenderer(List existen) {
            super(AddElementsFromPopupAction.this.myUmlProvider);
            this.existen = existen;
        }

        @Override
        public Comparator<Object> getComparator() {
            Comparator comp = super.getComparator();
            return (c1, c2) -> {
                boolean b1 = this.existen.contains(c1);
                boolean b2 = this.existen.contains(c2);
                if (b1 && b2 || !b1 && !b2) {
                    int result = AddElementsFromPopupAction.this.myProvider.getComparator().compare(c1, c2);
                    return result == 0 ? comp.compare(c1, c2) : result;
                }
                return b1 ? 1 : -1;
            };
        }

        @Override
        protected int getIconFlags() {
            return 0;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.removeAll();
            String moduleName = null;
            DefaultListCellRenderer rightRenderer = DefaultUmlElementsListCellRenderer.getRightCellRenderer(value);
            if (rightRenderer != null) {
                Component rightCellRendererComponent = rightRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.add(rightCellRendererComponent, "East");
                moduleName = rightRenderer.getText();
                JPanel spacer = new JPanel();
                spacer.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
                spacer.setBackground(isSelected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
                this.add((Component)spacer, "Center");
            }
            Component leftCellRendererComponent = new LeftRenderer(moduleName).getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.add(leftCellRendererComponent, "West");
            this.setBackground(isSelected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
            return this;
        }

        private class LeftRenderer
        extends ColoredListCellRenderer {
            private final String myModuleName;

            LeftRenderer(String moduleName) {
                this.myModuleName = moduleName;
            }

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    LeftRenderer.$$$reportNull$$$0(0);
                }
                if (value instanceof PsiElement) {
                    SimpleTextAttributes nameAttributes;
                    VirtualFile vFile;
                    PsiElement element = (PsiElement)value;
                    String name = DefaultUmlElementsListCellRenderer.this.getElementText(element);
                    Color color = list.getForeground();
                    PsiFile psiFile = element.getContainingFile();
                    boolean isProblemFile = false;
                    if (psiFile != null && (vFile = psiFile.getVirtualFile()) != null) {
                        if (WolfTheProblemSolver.getInstance((Project)psiFile.getProject()).isProblemFile(vFile)) {
                            isProblemFile = true;
                        }
                        FileStatus status = FileStatusManager.getInstance((Project)psiFile.getProject()).getStatus(vFile);
                        color = status.getColor();
                    }
                    TextAttributes attributes = null;
                    TextAttributesKey attributesKey = null;
                    ItemPresentation presentation = null;
                    if (value instanceof NavigationItem) {
                        presentation = ((NavigationItem)value).getPresentation();
                    }
                    if (presentation instanceof ColoredItemPresentation) {
                        attributesKey = ((ColoredItemPresentation)presentation).getTextAttributesKey();
                    }
                    if (attributesKey != null) {
                        attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey);
                    }
                    if (DefaultUmlElementsListCellRenderer.this.existen.contains(element)) {
                        attributes = new TextAttributes((Color)JBColor.GRAY, null, null, null, 2);
                    }
                    if (isProblemFile) {
                        attributes = TextAttributes.merge((TextAttributes)new TextAttributes(color, null, (Color)JBColor.red, EffectType.WAVE_UNDERSCORE, 0), (TextAttributes)attributes);
                    }
                    SimpleTextAttributes simpleTextAttributes = nameAttributes = attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : null;
                    if (nameAttributes == null) {
                        nameAttributes = new SimpleTextAttributes(0, color);
                    }
                    assert (name != null) : "Null name for PSI element " + element;
                    this.append(name, nameAttributes);
                    this.setIcon(element.getIcon(DefaultUmlElementsListCellRenderer.this.getIconFlags()));
                } else {
                    DiagramState presentation = AddElementsFromPopupAction.this.myBuilder.getPresentation();
                    DiagramElementManager elementManager = AddElementsFromPopupAction.this.myUmlProvider.getElementManager();
                    this.setIcon(elementManager.getItemIcon(value, presentation));
                    SimpleColoredText text = elementManager.getItemName(value, presentation);
                    if (text != null && DefaultUmlElementsListCellRenderer.this.existen.contains(value) && text.getTexts().size() == 1) {
                        text = new SimpleColoredText((String)text.getTexts().get(0), new SimpleTextAttributes(2, (Color)JBColor.GRAY));
                    }
                    if (text != null) {
                        text.appendToComponent((ColoredTextContainer)this);
                    }
                }
                this.setPaintFocusBorder(false);
                this.setBackground(selected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/uml/core/actions/popup/AddElementsFromPopupAction$DefaultUmlElementsListCellRenderer$LeftRenderer", "customizeCellRenderer"));
            }
        }
    }
}

