/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

class ValueContainerMap<Key, Value>
extends PersistentHashMap<Key, UpdatableValueContainer<Value>> {
    @NotNull
    private final DataExternalizer<Value> myValueExternalizer;
    private final boolean myKeyIsUniqueForIndexedFile;

    ValueContainerMap(@NotNull File file, @NotNull KeyDescriptor<Key> keyKeyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, boolean keyIsUniqueForIndexedFile) throws IOException {
        if (file == null) {
            ValueContainerMap.$$$reportNull$$$0(0);
        }
        if (keyKeyDescriptor == null) {
            ValueContainerMap.$$$reportNull$$$0(1);
        }
        if (valueExternalizer == null) {
            ValueContainerMap.$$$reportNull$$$0(2);
        }
        super(file, keyKeyDescriptor, new ValueContainerExternalizer(valueExternalizer));
        this.myValueExternalizer = valueExternalizer;
        this.myKeyIsUniqueForIndexedFile = keyIsUniqueForIndexedFile;
    }

    @NotNull
    Object getDataAccessLock() {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        if (persistentEnumeratorBase == null) {
            ValueContainerMap.$$$reportNull$$$0(3);
        }
        return persistentEnumeratorBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPut(Key key, UpdatableValueContainer<Value> container) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            final ChangeTrackingValueContainer valueContainer = (ChangeTrackingValueContainer)container;
            if (!valueContainer.needsCompacting() && !this.myKeyIsUniqueForIndexedFile) {
                this.appendData(key, new PersistentHashMap.ValueDataAppender(){

                    @Override
                    public void append(@NotNull DataOutput out) throws IOException {
                        if (out == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        valueContainer.saveTo(out, ValueContainerMap.this.myValueExternalizer);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/indexing/impl/ValueContainerMap$1", "append"));
                    }
                });
            } else {
                super.doPut(key, valueContainer);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyKeyDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/ValueContainerMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/ValueContainerMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataAccessLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ValueContainerExternalizer<T>
    implements DataExternalizer<UpdatableValueContainer<T>> {
        @NotNull
        private final DataExternalizer<T> myValueExternalizer;

        private ValueContainerExternalizer(@NotNull DataExternalizer<T> valueExternalizer) {
            if (valueExternalizer == null) {
                ValueContainerExternalizer.$$$reportNull$$$0(0);
            }
            this.myValueExternalizer = valueExternalizer;
        }

        @Override
        public void save(@NotNull DataOutput out, @NotNull UpdatableValueContainer<T> container) throws IOException {
            if (out == null) {
                ValueContainerExternalizer.$$$reportNull$$$0(1);
            }
            if (container == null) {
                ValueContainerExternalizer.$$$reportNull$$$0(2);
            }
            container.saveTo(out, this.myValueExternalizer);
        }

        @Override
        @NotNull
        public UpdatableValueContainer<T> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                ValueContainerExternalizer.$$$reportNull$$$0(3);
            }
            ValueContainerImpl<T> valueContainer = new ValueContainerImpl<T>();
            valueContainer.readFrom((DataInputStream)in, this.myValueExternalizer);
            ValueContainerImpl<T> valueContainerImpl = valueContainer;
            if (valueContainerImpl == null) {
                ValueContainerExternalizer.$$$reportNull$$$0(4);
            }
            return valueContainerImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueExternalizer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/impl/ValueContainerMap$ValueContainerExternalizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/impl/ValueContainerMap$ValueContainerExternalizer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

