/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model;

import com.intellij.database.dialects.postgres.model.PgAccessMethod;
import com.intellij.database.dialects.postgres.model.PgAggregate;
import com.intellij.database.dialects.postgres.model.PgCollation;
import com.intellij.database.dialects.postgres.model.PgDefType;
import com.intellij.database.dialects.postgres.model.PgDefTypeCheck;
import com.intellij.database.dialects.postgres.model.PgDescriptionService;
import com.intellij.database.dialects.postgres.model.PgExtension;
import com.intellij.database.dialects.postgres.model.PgForeignDataWrapper;
import com.intellij.database.dialects.postgres.model.PgForeignServer;
import com.intellij.database.dialects.postgres.model.PgModelFun;
import com.intellij.database.dialects.postgres.model.PgOperator;
import com.intellij.database.dialects.postgres.model.PgRole;
import com.intellij.database.dialects.postgres.model.PgRoutine;
import com.intellij.database.dialects.postgres.model.PgSequence;
import com.intellij.database.dialects.postgres.model.PgTable;
import com.intellij.database.dialects.postgres.model.PgTableColumn;
import com.intellij.database.dialects.postgres.model.PgTrigger;
import com.intellij.database.dialects.postgres.model.PgUserMapping;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.properties.PgAccessMethodType;
import com.intellij.database.model.properties.PgAggregateKind;
import com.intellij.database.model.properties.PgDataTypeSubCategory;
import com.intellij.database.model.properties.PgDataTypeSubKind;
import com.intellij.database.model.properties.PgRoutineConcurrencyKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u000205H\u0002J\u0018\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020=H\u0002\u00a8\u0006>"}, d2={"Lcom/intellij/database/dialects/postgres/model/PgDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "PgOptions", "", "", "options", "content", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describePgAccessMethod", "method", "Lcom/intellij/database/dialects/postgres/model/PgAccessMethod;", "describePgAggregate", "aggregate", "Lcom/intellij/database/dialects/postgres/model/PgAggregate;", "describePgCollation", "collation", "Lcom/intellij/database/dialects/postgres/model/PgCollation;", "describePgDefType", "dt", "Lcom/intellij/database/dialects/postgres/model/PgDefType;", "describePgDefTypeCheck", "check", "Lcom/intellij/database/dialects/postgres/model/PgDefTypeCheck;", "describePgExtension", "extension", "Lcom/intellij/database/dialects/postgres/model/PgExtension;", "describePgForeignDataWrapper", "wrapper", "Lcom/intellij/database/dialects/postgres/model/PgForeignDataWrapper;", "describePgForeignServer", "server", "Lcom/intellij/database/dialects/postgres/model/PgForeignServer;", "describePgOperator", "op", "Lcom/intellij/database/dialects/postgres/model/PgOperator;", "describePgRole", "role", "Lcom/intellij/database/dialects/postgres/model/PgRole;", "describePgRoutine", "routine", "Lcom/intellij/database/dialects/postgres/model/PgRoutine;", "describePgSequence", "seq", "Lcom/intellij/database/dialects/postgres/model/PgSequence;", "describePgTable", "table", "Lcom/intellij/database/dialects/postgres/model/PgTable;", "describePgTableColumn", "column", "Lcom/intellij/database/dialects/postgres/model/PgTableColumn;", "describePgTrigger", "trig", "Lcom/intellij/database/dialects/postgres/model/PgTrigger;", "withSurrogates", "", "describePgUserMapping", "mapping", "Lcom/intellij/database/dialects/postgres/model/PgUserMapping;", "intellij.database.dialects"})
public final class PgDescriptionService
extends DescriptionService {
    @Override
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof PgSequence ? this.describePgSequence((PgSequence)e) : (basicElement instanceof PgRoutine ? this.describePgRoutine((PgRoutine)e) : (basicElement instanceof PgTable ? this.describePgTable((PgTable)e) : (basicElement instanceof PgTableColumn ? this.describePgTableColumn((PgTableColumn)e) : (basicElement instanceof PgDefType ? this.describePgDefType((PgDefType)e) : (basicElement instanceof PgOperator ? this.describePgOperator((PgOperator)e) : (basicElement instanceof PgTrigger ? this.describePgTrigger((PgTrigger)e, context.getWithSurrogates()) : (basicElement instanceof PgDefTypeCheck ? this.describePgDefTypeCheck((PgDefTypeCheck)e) : (basicElement instanceof PgCollation ? this.describePgCollation((PgCollation)e) : (basicElement instanceof PgRole ? this.describePgRole((PgRole)e) : (basicElement instanceof PgForeignDataWrapper ? this.describePgForeignDataWrapper((PgForeignDataWrapper)e) : (basicElement instanceof PgForeignServer ? this.describePgForeignServer((PgForeignServer)e) : (basicElement instanceof PgUserMapping ? this.describePgUserMapping((PgUserMapping)e) : (basicElement instanceof PgAggregate ? this.describePgAggregate((PgAggregate)e) : (basicElement instanceof PgAccessMethod ? this.describePgAccessMethod((PgAccessMethod)e) : (basicElement instanceof PgExtension ? this.describePgExtension((PgExtension)e) : super.content(e, context))))))))))))))));
    }

    private final String describePgSequence(PgSequence seq) {
        String def = this.describeSequence(seq);
        String category = seq.isBelongsToColumn() ? "private" : "shared";
        String dataType = !PgModelFun.hasDefaultType(seq) ? "data type: " + seq.getDataType() : "";
        String cache_size = !PgModelFun.hasDefaultCacheSize(seq) ? "cache size: " + seq.getCacheSize() : "";
        String string = " " + dataType;
        StringBuilder stringBuilder = new StringBuilder().append(category).append(' ').append(def);
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string3 = ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
        string = " " + cache_size;
        stringBuilder = stringBuilder.append(string3);
        String string4 = string;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string3 = ((Object)StringsKt.trimEnd((CharSequence)string4)).toString();
        return stringBuilder.append(string3).toString();
    }

    private final String describePgTable(PgTable table) {
        String d2 = this.describeTable(table);
        List<Long> list = table.getAncestorIds();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"table.ancestorIds");
        Collection collection = list;
        if (!collection.isEmpty()) {
            d2 = d2 + " (" + ModelFun.namesAsString((Collection<? extends BasicNamedElement>)PgModelFun.getAncestors(table)) + ")";
        }
        Set<Long> set = table.getSuccessorIds();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"table.successorIds");
        collection = set;
        if (!collection.isEmpty()) {
            d2 = d2 + " {" + ModelFun.namesAsString((Collection<? extends BasicNamedElement>)PgModelFun.getSuccessors(table)) + "}";
        }
        return d2;
    }

    @NotNull
    public final String describePgRoutine(@NotNull PgRoutine routine) {
        PgRoutineConcurrencyKind pgRoutineConcurrencyKind;
        PgRoutineConcurrencyKind it;
        Intrinsics.checkParameterIsNotNull((Object)routine, (String)"routine");
        String r = this.describeRoutine(routine);
        ArrayList<String> attributes = new ArrayList<String>();
        PgRoutineConcurrencyKind pgRoutineConcurrencyKind2 = routine.getConcurrencyKind();
        if (pgRoutineConcurrencyKind2 != null && (it = (pgRoutineConcurrencyKind = pgRoutineConcurrencyKind2)) != PgRoutineConcurrencyKind.UNSAFE) {
            StringBuilder stringBuilder = new StringBuilder().append("parallel ");
            PgRoutineConcurrencyKind pgRoutineConcurrencyKind3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pgRoutineConcurrencyKind3), (String)"it");
            attributes.add(stringBuilder.append(pgRoutineConcurrencyKind3.getModifier()).toString());
        }
        if (routine.isLeakproof()) {
            attributes.add("leakproof");
        }
        if (routine.isWindow()) {
            attributes.add("window");
        }
        if (routine.isStrict()) {
            attributes.add("strict");
        }
        if (routine.isSecurityDefiner()) {
            attributes.add("security definer");
        }
        if (PgModelFun.isCostDefined(routine)) {
            attributes.add("cost " + PgModelFun.costAsString(routine));
        }
        if (PgModelFun.isRowsDefined(routine)) {
            attributes.add("rows " + PgModelFun.rowsAsString(routine));
        }
        attributes.addAll((Collection)routine.getConfigurationParameters());
        return r + (attributes.isEmpty() ? "" : " attributes: " + CollectionsKt.joinToString$default((Iterable)attributes, null, null, null, (int)0, null, (Function1)describePgRoutine.2.INSTANCE, (int)31, null));
    }

    private final String describePgTableColumn(PgTableColumn column2) {
        String d2 = this.describeColumn(column2);
        if (column2.isInherited()) {
            d2 = "inherited " + d2;
        }
        return d2;
    }

    private final String describePgDefType(PgDefType dt) {
        PgDataTypeSubKind pgDataTypeSubKind = dt.getSubKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pgDataTypeSubKind), (String)"dt.subKind");
        PgDataTypeSubKind sk = pgDataTypeSubKind;
        PgDataTypeSubCategory pgDataTypeSubCategory = dt.getSubCategory();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pgDataTypeSubCategory), (String)"dt.subCategory");
        PgDataTypeSubCategory sc = pgDataTypeSubCategory;
        StringBuilder b2 = new StringBuilder(60);
        b2.append(sk.human_readable_name());
        if (sc != PgDataTypeSubCategory.NONE && Intrinsics.areEqual((Object)sc.human_readable_name(), (Object)sk.human_readable_name()) ^ true) {
            b2.append(' ').append('(').append(sc.human_readable_name()).append(')');
        }
        if (dt.getDefinition() != null) {
            b2.append(" of ").append(dt.getDefinition());
        }
        List<String> list = dt.getLabels();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"dt.labels");
        Collection collection = list;
        if (!collection.isEmpty()) {
            StringBuilder stringBuilder = b2.append(" of {");
            List<String> list2 = dt.getLabels();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"dt.labels");
            stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).append("}");
        }
        if (dt.getDefaultExpression() != null) {
            b2.append(" default ").append(dt.getDefaultExpression());
        }
        if (dt.isNotNull()) {
            b2.append(" NN");
        }
        String string = b2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    private final String describePgOperator(PgOperator op) {
        StringBuilder b2 = new StringBuilder(60);
        String string = op.getOperatorKind().name();
        StringBuilder stringBuilder = b2;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        stringBuilder.append(string4).append(" operator (");
        if (Intrinsics.areEqual((Object)op.getLeftType(), (Object)DataType.UNKNOWN) ^ true) {
            b2.append(op.getLeftType());
        }
        if (Intrinsics.areEqual((Object)op.getLeftType(), (Object)DataType.UNKNOWN) ^ true && Intrinsics.areEqual((Object)op.getRightType(), (Object)DataType.UNKNOWN) ^ true) {
            b2.append(", ");
        }
        if (Intrinsics.areEqual((Object)op.getRightType(), (Object)DataType.UNKNOWN) ^ true) {
            b2.append(op.getRightType());
        }
        b2.append(") -> ");
        b2.append(op.getResultType());
        if (op.getCallRoutineName() != null) {
            b2.append(" [bound to ").append(op.getCallRoutineName()).append(']');
        }
        String string5 = b2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"b.toString()");
        return string5;
    }

    private final String describePgTrigger(PgTrigger trig, boolean withSurrogates) {
        Object rName;
        String d2 = this.describeTrigger(trig);
        PgRoutine r = PgModelFun.getCallRoutine(trig);
        long rId = trig.getCallRoutineId();
        Object object = r;
        if (object == null || (object = ModelFun.nameInContextOfSchema((BasicSchemaObject)object, trig.getSchema())) == null) {
            object = rId != 0L ? "???" : null;
        }
        if ((rName = object) != null) {
            d2 = d2 + " -> " + (String)rName + "()";
            if (withSurrogates) {
                d2 = d2 + " [id=" + rId + ']';
            }
        }
        return d2;
    }

    private final String describePgDefTypeCheck(PgDefTypeCheck check) {
        return "check " + check.getPredicate();
    }

    private final String describePgCollation(PgCollation collation) {
        return "lc_collate: " + collation.getCollate() + ", lc_ctype: " + collation.getCType();
    }

    private final String describePgRole(PgRole role) {
        String string;
        String desc = "";
        if (role.isSuperRole()) {
            desc = desc + " superuser";
        }
        if (role.isCreateDb()) {
            desc = desc + " createdb";
        }
        if (role.isCreateRole()) {
            desc = desc + " createrole";
        }
        if (!role.isInherit()) {
            desc = desc + " noinherit";
        }
        if (role.isReplication()) {
            desc = desc + " replication";
        }
        if (role.isBypassRls()) {
            desc = desc + " bypassrls";
        }
        if (role.getConnectionLimit() >= 0L) {
            desc = desc + " connection limit " + role.getConnectionLimit();
        }
        if (role.getValidUntil() != null) {
            desc = desc + " valid until " + role.getValidUntil();
        }
        String string2 = string = desc;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    private final String describePgForeignDataWrapper(PgForeignDataWrapper wrapper) {
        String string;
        List attributes = new ArrayList();
        if (wrapper.getValidator() != null) {
            attributes.add("validator: " + wrapper.getValidator());
        }
        if (wrapper.getHandler() != null) {
            attributes.add("handler: " + wrapper.getHandler());
        }
        List<String> list = wrapper.getOptions();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"wrapper.options");
        attributes.addAll((Collection)this.PgOptions(list));
        String string2 = string = "foreign data wrapper " + CollectionsKt.joinToString$default((Iterable)attributes, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    private final String describePgForeignServer(PgForeignServer server) {
        String string;
        List attributes = new ArrayList();
        if (server.getType() != null) {
            attributes.add("type: " + server.getType());
        }
        if (server.getVersion() != null) {
            attributes.add("version: " + server.getVersion());
        }
        List<String> list = server.getOptions();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"server.options");
        attributes.addAll((Collection)this.PgOptions(list));
        String string2 = string = "foreign server " + CollectionsKt.joinToString$default((Iterable)attributes, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    private final String describePgAccessMethod(PgAccessMethod method) {
        List attributes = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder().append("type: ");
        PgAccessMethodType pgAccessMethodType = method.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pgAccessMethodType), (String)"method.type");
        attributes.add(stringBuilder.append(pgAccessMethodType.getModifier()).toString());
        if (method.getHandler() != null) {
            attributes.add("handler: " + method.getHandler());
        }
        return CollectionsKt.joinToString$default((Iterable)attributes, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String describePgExtension(PgExtension extension) {
        List attributes = new ArrayList();
        if (extension.getVersion() != null) {
            attributes.add("version: " + extension.getVersion());
        }
        if (extension.getSchemaName() != null) {
            attributes.add("schemaName: '" + extension.getSchemaName() + '\'');
        }
        attributes.add("availableUpdates: " + extension.getAvailableUpdates());
        return "extension " + CollectionsKt.joinToString$default((Iterable)attributes, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String describePgUserMapping(PgUserMapping mapping) {
        String string;
        List attributes = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder().append("user: ");
        String string2 = mapping.getUser();
        if (string2 == null) {
            string2 = "public";
        }
        attributes.add(stringBuilder.append(string2).toString());
        List<String> list = mapping.getOptions();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"mapping.options");
        attributes.addAll((Collection)this.PgOptions(list));
        String string3 = string = "user mapping " + CollectionsKt.joinToString$default((Iterable)attributes, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    private final String describePgAggregate(PgAggregate aggregate) {
        List attributes = new ArrayList();
        attributes.add("transition: " + aggregate.getTransition());
        attributes.add("transition type: " + aggregate.getTransitionDataType());
        if (aggregate.getFinal() != null) {
            attributes.add("final function: " + aggregate.getFinal());
        }
        if (aggregate.isFinalExtra()) {
            attributes.add("final extra arguments");
        }
        if (aggregate.getCombine() != null) {
            attributes.add("combine function: " + aggregate.getCombine());
        }
        if (aggregate.getSerialization() != null) {
            attributes.add("serialization function: " + aggregate.getSerialization());
        }
        if (aggregate.getDeserialization() != null) {
            attributes.add("deserialization function: " + aggregate.getDeserialization());
        }
        if (aggregate.getInitialValue() != null) {
            attributes.add("initial value: " + aggregate.getInitialValue());
        }
        if (aggregate.getSortOperator() != null) {
            attributes.add("sort operator: " + aggregate.getSortOperator());
        }
        if (aggregate.getStateSize() != 0L) {
            attributes.add("state size: " + aggregate.getStateSize());
        }
        if (aggregate.getInverseTransition() != null) {
            attributes.add("inverse transition: " + aggregate.getInverseTransition());
        }
        if (aggregate.getMovingTransition() != null) {
            attributes.add("moving transition: " + aggregate.getMovingTransition());
        }
        if (Intrinsics.areEqual((Object)aggregate.getMovingStateType(), (Object)DataType.UNKNOWN) ^ true) {
            attributes.add("moving state type: " + aggregate.getMovingStateType());
        }
        if (aggregate.getMovingStateSize() != 0L) {
            attributes.add("moving state size: " + aggregate.getMovingStateSize());
        }
        if (aggregate.getMovingFinal() != null) {
            attributes.add("moving final function: " + aggregate.getMovingFinal());
        }
        if (aggregate.isMovingFinalExtra()) {
            attributes.add("moving final extra arguments");
        }
        if (aggregate.getMovingInitialValue() != null) {
            attributes.add("moving initial value: " + aggregate.getMovingInitialValue());
        }
        if (aggregate.getAggregateKind() != PgAggregateKind.NORMAL) {
            attributes.add("kind: " + aggregate.getAggregateKind().getName());
        }
        if (aggregate.getConcurrencyKind() != PgRoutineConcurrencyKind.UNSAFE) {
            StringBuilder stringBuilder = new StringBuilder().append("concurrency kind: ");
            PgRoutineConcurrencyKind pgRoutineConcurrencyKind = aggregate.getConcurrencyKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pgRoutineConcurrencyKind), (String)"aggregate.concurrencyKind");
            attributes.add(stringBuilder.append(pgRoutineConcurrencyKind.getModifier()).toString());
        }
        if (aggregate.getDirectArgs() != 0) {
            attributes.add("direct arguments: " + aggregate.getDirectArgs());
        }
        return CollectionsKt.joinToString$default((Iterable)attributes, null, null, null, (int)0, null, null, (int)63, null);
    }

    private final List<String> PgOptions(List<String> options) {
        Object object;
        List it;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)options;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            object = StringsKt.split$default((CharSequence)((CharSequence)((Object)it)), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (List)item$iv$iv;
            collection = destination$iv$iv;
            object = (String)CollectionsKt.first((List)it) + " '" + (String)CollectionsKt.last((List)it) + '\'';
            collection.add(object);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }
}

