/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.generic.introspector.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.properties.JdbcParameterType;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import gnu.trove.TIntHashSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoutineArgumentIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.RoutineArgument> {
    private final Dbms myDbms;
    private final JdbcHelper myJdbcHelper;
    private final boolean myCatIsPkg;
    private final DatabaseMetaDataWrapper.Schema mySchema;
    @NotNull
    private final Function<DatabaseMetaDataWrapper.Routine, DasRoutine.Kind> myKindProvider;
    private final boolean myProc;
    private final MetaDataUtil.SpecNamer myNamer;
    private final TIntHashSet myPositions;
    private String myLastOrigName;
    private String myLastSpecName;
    private int myNum;
    private DasRoutine.Kind myKind;

    public RoutineArgumentIt(@Nullable ResultSet rs, @NotNull Dbms dbms, @NotNull DatabaseMetaDataWrapper.Schema schema, boolean catIsPkg, @NotNull Function<DatabaseMetaDataWrapper.Routine, DasRoutine.Kind> kindProvider, boolean proc) throws SQLException {
        if (dbms == null) {
            RoutineArgumentIt.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            RoutineArgumentIt.$$$reportNull$$$0(1);
        }
        if (kindProvider == null) {
            RoutineArgumentIt.$$$reportNull$$$0(2);
        }
        super(rs);
        this.myNamer = new MetaDataUtil.SpecNamer();
        this.myPositions = new TIntHashSet();
        this.myNum = 0;
        this.myKind = DasRoutine.Kind.NONE;
        this.myDbms = dbms;
        this.myCatIsPkg = catIsPkg;
        this.mySchema = schema;
        this.myKindProvider = kindProvider;
        this.myProc = proc;
        this.myJdbcHelper = DbImplUtil.getJdbcHelper(this.myDbms);
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.RoutineArgument createStorage() {
        DatabaseMetaDataWrapper.RoutineArgument routineArgument = new DatabaseMetaDataWrapper.RoutineArgument(new DatabaseMetaDataWrapper.Routine(this.mySchema, null, ""));
        if (routineArgument == null) {
            RoutineArgumentIt.$$$reportNull$$$0(3);
        }
        return routineArgument;
    }

    @Override
    protected DatabaseMetaDataWrapper.RoutineArgument calcValue() throws SQLException {
        DatabaseMetaDataWrapper.RoutineArgument res2 = (DatabaseMetaDataWrapper.RoutineArgument)this.getStorageToFill();
        try {
            String cat = this.getCatalog();
            res2.routine.pkg = this.myCatIsPkg ? StringUtil.nullize((String)cat) : null;
            String schema = this.getSchema();
            if (!StringUtil.equalsIgnoreCase((CharSequence)this.mySchema.schema, (CharSequence)schema)) {
                return (DatabaseMetaDataWrapper.RoutineArgument)this.skip();
            }
            String origName = this.getRoutineName();
            Pair<String, Short> curName = GenericIntrospectorLegacyModelUtils.fixProcedureName(this.mySchema.schema, this.myDbms, origName);
            if (curName == null) {
                return (DatabaseMetaDataWrapper.RoutineArgument)this.skip();
            }
            res2.routine.name = (String)curName.first;
            res2.routine.number = (Short)curName.second;
            String curSpec = this.getSpecificRoutineName();
            res2.routine.specificName = this.myNamer.getSpecName(curSpec, res2.routine.name, res2.routine.pkg);
            int pos = this.getPosition();
            if ((pos != -1 && this.myPositions.contains(pos) || !Comparing.equal((String)origName, (String)this.myLastOrigName)) && Comparing.equal((String)this.myLastSpecName, (String)res2.routine.specificName)) {
                this.myNamer.finish(curSpec, res2.routine.name, res2.routine.pkg);
                res2.routine.specificName = this.myNamer.getSpecName(curSpec, res2.routine.name, res2.routine.pkg);
                this.myPositions.clear();
            }
            if (!Comparing.equal((String)this.myLastSpecName, (String)res2.routine.specificName)) {
                this.myNum = 0;
                this.myLastSpecName = res2.routine.specificName;
                this.myLastOrigName = origName;
                this.myKind = (DasRoutine.Kind)this.myKindProvider.fun((Object)res2.routine);
                this.myPositions.clear();
            }
            res2.routine.kind = this.myKind;
            res2.name = this.getColumnName();
            res2.type = this.getDataType();
            res2.typeName = this.getTypeName();
            res2.typeSuffix = null;
            int precision = this.getPrecision();
            int length = this.getLength();
            res2.scale = this.getScale();
            int charOctetLength = this.getCharOctetLength();
            res2.nullable = this.isNullable();
            res2.def = this.getColumnDef();
            JdbcParameterType columnType = this.getColumnType();
            res2.position = pos;
            if (res2.position == -1) {
                res2.position = 0;
            }
            while (this.myPositions.contains(res2.position)) {
                ++res2.position;
            }
            this.myPositions.add(res2.position);
            res2.length = precision != 0 ? precision : (length != 0 ? length : charOctetLength);
            boolean retParam = false;
            if (res2.routine.kind == DasRoutine.Kind.FUNCTION && (pos == 0 || pos == -1 && "returnValue".equals(res2.name) || this.myDbms.isMysql() && this.myNum == 0)) {
                retParam = true;
            } else if (res2.routine.kind != DasRoutine.Kind.FUNCTION && pos == 0 && "RETURN_VALUE".equals(res2.name)) {
                return (DatabaseMetaDataWrapper.RoutineArgument)this.skip();
            }
            res2.direction = retParam ? DasArgument.Direction.RETURN : RoutineArgumentIt.asDirection(columnType);
            if (res2.direction == DasArgument.Direction.RETURN) {
                res2.name = null;
                res2.position = 0;
                if (res2.routine.kind == DasRoutine.Kind.PROCEDURE) {
                    return (DatabaseMetaDataWrapper.RoutineArgument)this.skip();
                }
            }
            this.myJdbcHelper.adjustType((JdbcHelper.Type)res2);
            ++this.myNum;
        }
        catch (SQLException e) {
            this.onError(res2, e);
            return (DatabaseMetaDataWrapper.RoutineArgument)this.skip();
        }
        return res2;
    }

    private JdbcParameterType getColumnType() throws SQLException {
        short type = this.myRs.getShort("COLUMN_TYPE", 5);
        return this.myProc ? JdbcParameterType.findByID(type) : JdbcParameterType.findByFuncID(type);
    }

    private String getColumnDef() throws SQLException {
        return this.myProc ? this.myRs.getString("COLUMN_DEF", 14) : null;
    }

    private boolean isNullable() throws SQLException {
        return this.myRs.getInt("NULLABLE", 12, 0) != 0;
    }

    private int getCharOctetLength() throws SQLException {
        return this.myRs.getInt("CHAR_OCTET_LENGTH", this.myProc ? 17 : 14, 0);
    }

    private int getScale() throws SQLException {
        return this.myRs.getInt("SCALE", 10, 0);
    }

    private int getLength() throws SQLException {
        return this.myRs.getInt("LENGTH", 9, 0);
    }

    private int getPrecision() throws SQLException {
        return this.myRs.getInt("PRECISION", 8, 0);
    }

    private String getTypeName() throws SQLException {
        return this.myRs.getString("TYPE_NAME", 7);
    }

    private int getDataType() throws SQLException {
        return this.myRs.getInt("DATA_TYPE", 6, 0);
    }

    private String getColumnName() throws SQLException {
        return this.myRs.getString("COLUMN_NAME", 4);
    }

    private int getPosition() throws SQLException {
        return this.myRs.getInt("ORDINAL_POSITION", this.myProc ? 18 : 15, -1);
    }

    private String getSpecificRoutineName() throws SQLException {
        return this.myRs.getString("SPECIFIC_NAME", 20);
    }

    private String getRoutineName() throws SQLException {
        return this.myRs.getString(this.myProc ? "PROCEDURE_NAME" : "FUNCTION_NAME", 3);
    }

    @NotNull
    private String getSchema() throws SQLException {
        String string = StringUtil.notNullize((String)this.myRs.getString(this.myProc ? "PROCEDURE_SCHEM" : "FUNCTION_SCHEM", 2), (String)this.mySchema.schema);
        if (string == null) {
            RoutineArgumentIt.$$$reportNull$$$0(4);
        }
        return string;
    }

    private String getCatalog() throws SQLException {
        return this.myRs.getString(this.myProc ? "PROCEDURE_CAT" : "FUNCTION_CAT", 1);
    }

    private static DasArgument.Direction asDirection(JdbcParameterType type) {
        if (type == JdbcParameterType.IN) {
            return DasArgument.Direction.IN;
        }
        if (type == JdbcParameterType.INOUT) {
            return DasArgument.Direction.INOUT;
        }
        if (type == JdbcParameterType.OUT) {
            return DasArgument.Direction.OUT;
        }
        if (type == JdbcParameterType.RESULT) {
            return DasArgument.Direction.RESULT;
        }
        if (type == JdbcParameterType.RETURN) {
            return DasArgument.Direction.RETURN;
        }
        return DasArgument.Direction.IN;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.RoutineArgument cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.routine.schema.database, cur.routine.schema.schema, cur.routine.name);
        this.addError(title, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kindProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/RoutineArgumentIt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/RoutineArgumentIt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStorage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchema";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.Routine, DatabaseMetaDataWrapper.RoutineArgument, DatabaseMetaDataWrapper.RoutineArgument> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.RoutineArgument> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.RoutineArgument> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.RoutineArgument> it) {
            final String specificName = ((DatabaseMetaDataWrapper.RoutineArgument)it.current()).routine.specificName;
            ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.RoutineArgument> groupIt = new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.RoutineArgument>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.RoutineArgument item) {
                    return Comparing.equal((String)specificName, (String)item.routine.specificName);
                }
            };
            if (groupIt == null) {
                Grouping.$$$reportNull$$$0(1);
            }
            return groupIt;
        }

        @Override
        protected DatabaseMetaDataWrapper.Routine getItem(ClosableIt<DatabaseMetaDataWrapper.RoutineArgument> it) {
            return ((DatabaseMetaDataWrapper.RoutineArgument)it.current()).routine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/RoutineArgumentIt$Grouping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/RoutineArgumentIt$Grouping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGroupIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

