/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataHookUpBase;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridPagingModelImpl;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.TxMarkerAuditor;
import com.intellij.database.run.session.Session;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class DataBusGridDataHookUp
extends GridDataHookUpBase<DataConsumer.Row, DataConsumer.Column>
implements DataRequest.OwnerEx,
TxMarkerAuditor.TxMarkerHolder {
    protected final DataProducer myProducer;
    protected final DataAuditor.BusyCounter myBusyCounter;
    protected final DataGridListModel myModel;
    protected final GridPagingModelImpl.MultiPage<DataConsumer.Row, DataConsumer.Column> myPageModel;
    protected final DataBusLoader myLoader;
    protected final Map<DataRequest, GridRequestSource<DataConsumer.Row, DataConsumer.Column>> myRequestSourceMap;
    private final DataBus.Consuming myMessageBus;

    protected DataBusGridDataHookUp(@NotNull Project project, @NotNull Session session2) {
        if (project == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(1);
        }
        super(project);
        this.myRequestSourceMap = new WeakHashMap<DataRequest, GridRequestSource<DataConsumer.Row, DataConsumer.Column>>();
        this.myMessageBus = session2.getMessageBus().filterFor(this);
        this.myProducer = this.myMessageBus.getDataProducer();
        this.myBusyCounter = new DataAuditor.BusyCounter();
        this.myMessageBus.addAuditor(this.myBusyCounter);
        this.myModel = new DataGridListModel();
        this.myPageModel = new GridPagingModelImpl.MultiPage<DataConsumer.Row, DataConsumer.Column>(this.myModel);
        this.myLoader = this.createLoader();
        this.myMessageBus.addAuditor(this.createAuditor());
        this.myMessageBus.addConsumer(DataGridUtil.createEDTSafeWrapper(this.myLoader, this));
    }

    @NotNull
    protected DataAuditor createAuditor() {
        BusAuditor busAuditor = new BusAuditor();
        if (busAuditor == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(2);
        }
        return busAuditor;
    }

    @NotNull
    public DataGridListModel getModel() {
        DataGridListModel dataGridListModel = this.myModel;
        if (dataGridListModel == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(3);
        }
        return dataGridListModel;
    }

    @Override
    @NotNull
    public GridPagingModel<DataConsumer.Row, DataConsumer.Column> getPageModel() {
        GridPagingModelImpl.MultiPage<DataConsumer.Row, DataConsumer.Column> multiPage = this.myPageModel;
        if (multiPage == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(4);
        }
        return multiPage;
    }

    @NotNull
    public DataBusLoader getLoader() {
        DataBusLoader dataBusLoader = this.myLoader;
        if (dataBusLoader == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(5);
        }
        return dataBusLoader;
    }

    @Override
    public int getBusyCount() {
        return this.myBusyCounter.getCount();
    }

    @Override
    public void cancelRequests() {
        this.getMessageBus().getDataProducer().processRequest(new DataRequest.Cancel(this));
    }

    @Override
    @NotNull
    public DataBus.Consuming getMessageBus() {
        DataBus.Consuming consuming = this.myMessageBus;
        if (consuming == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(6);
        }
        return consuming;
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        DataRequest.TxMarker txMarker = DataRequest.NONE;
        if (txMarker == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(7);
        }
        return txMarker;
    }

    @Override
    public void setCurrentTx(@NotNull DataRequest.TxMarker txMarker) {
        if (txMarker == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(8);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.setCurrentTx(autoCommit ? DataRequest.AUTO_COMMIT : DataRequest.START_NEW);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = StringUtil.notNullize((String)this.myLoader.getQueryText());
        if (string == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void dispose() {
    }

    public int getResultSetIndex() {
        return this.myLoader.getResultSetIndex();
    }

    @Nullable
    public String getQueryText() {
        return this.myLoader.getQueryText();
    }

    @Nullable
    public String getUnlimitedQueryText(boolean ordered) {
        return this.getQueryText();
    }

    @NotNull
    protected DataBusLoader createLoader() {
        DataBusLoader dataBusLoader = new DataBusLoader();
        if (dataBusLoader == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(10);
        }
        return dataBusLoader;
    }

    protected void processRequest(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull DataRequest request, ReloadPolicy reloadPolicy) {
        if (source == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(11);
        }
        if (request == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(12);
        }
        this.myRequestSourceMap.put(request, source);
        request.getPromise().onProcessed(aVoid -> {
            if (request == null) {
                DataBusGridDataHookUp.$$$reportNull$$$0(13);
            }
            if (source == null) {
                DataBusGridDataHookUp.$$$reportNull$$$0(14);
            }
            boolean isSucceeded = request.getPromise().isSucceeded();
            if (reloadPolicy == ReloadPolicy.WHEN_PROCESSED || reloadPolicy == ReloadPolicy.WHEN_DONE && isSucceeded) {
                this.myLoader.reloadCurrentPage(source);
            } else {
                this.notifyRequestFinished(source, isSucceeded);
            }
        });
        this.myProducer.processRequest(request);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataBusGridDataHookUp";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "txMarker";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataBusGridDataHookUp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAuditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPageModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoader";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTx";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentTx";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processRequest";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processRequest$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class QueryAttributes {
        private final Integer limit;
        private final boolean ordered;

        private QueryAttributes(@Nullable Integer limit, boolean ordered) {
            this.limit = limit;
            this.ordered = ordered;
        }

        public boolean isOrdered() {
            return this.ordered;
        }

        @NotNull
        public OptionalInt limit() {
            OptionalInt optionalInt = this.limit == null ? OptionalInt.empty() : OptionalInt.of(this.limit);
            if (optionalInt == null) {
                QueryAttributes.$$$reportNull$$$0(0);
            }
            return optionalInt;
        }

        @NotNull
        public static QueryAttributes unlimited(boolean ordered) {
            QueryAttributes queryAttributes = new QueryAttributes(null, ordered);
            if (queryAttributes == null) {
                QueryAttributes.$$$reportNull$$$0(1);
            }
            return queryAttributes;
        }

        @NotNull
        public static QueryAttributes limited(int limit, boolean order) {
            QueryAttributes queryAttributes = new QueryAttributes(limit, order);
            if (queryAttributes == null) {
                QueryAttributes.$$$reportNull$$$0(2);
            }
            return queryAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/datagrid/DataBusGridDataHookUp$QueryAttributes";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "limit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unlimited";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "limited";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    protected class BusAuditor
    extends DataAuditor.Adapter {
        protected BusAuditor() {
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message2, @Nullable Throwable th) {
            GridRequestSource<DataConsumer.Row, DataConsumer.Column> source;
            if (context == null) {
                BusAuditor.$$$reportNull$$$0(0);
            }
            if ((source = DataBusGridDataHookUp.this.myRequestSourceMap.get(context.request)) != null) {
                DataBusGridDataHookUp.this.notifyRequestError(source, message2, th);
            }
        }

        @Override
        public void updateCountReceived(@NotNull DataRequest.Context context, int updateCount2) {
            GridRequestSource<DataConsumer.Row, DataConsumer.Column> source;
            if (context == null) {
                BusAuditor.$$$reportNull$$$0(1);
            }
            if ((source = DataBusGridDataHookUp.this.myRequestSourceMap.get(context.request)) != null) {
                DataBusGridDataHookUp.this.notifyUpdateCountReceived(source, updateCount2);
            }
        }

        @Override
        public void txCompleted(@NotNull DataRequest.Context context, @NotNull DataAuditor.TxEvent event) {
            if (context == null) {
                BusAuditor.$$$reportNull$$$0(2);
            }
            if (event == null) {
                BusAuditor.$$$reportNull$$$0(3);
            }
            if (!event.reverted || !this.reloadOnRollback()) {
                return;
            }
            int startIdx = DataBusGridDataHookUp.this.myPageModel.getPageStart();
            int pageSize = DataBusGridDataHookUp.this.myPageModel.getPageSize();
            DataBusGridDataHookUp.this.myLoader.updateQueryText(DbImplUtil.isPageSizeUnlimited(pageSize) ? QueryAttributes.unlimited(true) : QueryAttributes.limited(startIdx + pageSize, true));
            String query = (String)ObjectUtils.assertNotNull((Object)DataBusGridDataHookUp.this.myLoader.getQueryText());
            int resultSetIdx = DataBusGridDataHookUp.this.myLoader.getResultSetIndex();
            DataRequest.Constraints constraints = DataRequest.newConstraints(startIdx, pageSize, resultSetIdx);
            DataRequest request = DataRequest.newRequest(DataBusGridDataHookUp.this, DataRequest.AUTO_COMMIT, query, constraints);
            request.getPromise().onProcessed(aVoid -> DataBusGridDataHookUp.this.setCurrentTx(DataRequest.START_NEW));
            DataBusGridDataHookUp.this.myProducer.processRequest(request);
        }

        protected boolean reloadOnRollback() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataBusGridDataHookUp$BusAuditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCountReceived";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "txCompleted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static enum ReloadPolicy {
        WHEN_DONE,
        WHEN_PROCESSED,
        DO_NOT_RELOAD;

    }

    public class DataBusLoader
    implements DataConsumer,
    GridLoader<DataConsumer.Row, DataConsumer.Column> {
        private String myQueryText;
        private boolean myQueryInvalidated;
        private boolean myTotalRowCountInvalidated;
        private int myResultSetIndex;
        private int myRowsLoaded = -1;

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] columns, int firstRowNum) {
            boolean sameQuery;
            if (context == null) {
                DataBusLoader.$$$reportNull$$$0(0);
            }
            if (!(sameQuery = Comparing.equal((String)this.myQueryText, (String)context.getQuery())) || this.myTotalRowCountInvalidated) {
                DataBusGridDataHookUp.this.myPageModel.setTotalRowCount(0L, false);
            }
            DataBusGridDataHookUp.this.myPageModel.setPageStart(firstRowNum);
            DataBusGridDataHookUp.this.myPageModel.setPageEnd(firstRowNum - 1);
            this.myRowsLoaded = 0;
            DataBusGridDataHookUp.this.myModel.setUpdatingNow(true);
            this.myResultSetIndex = resultSetIndex;
            this.setQueryText(context.getQuery());
            DataBusGridDataHookUp.this.setCurrentTx(context.txMarker);
            columns = this.prepareColumns(columns);
            boolean sameColumns = this.sameColumnsAsInModel(columns);
            if (!sameQuery || !sameColumns) {
                DataBusGridDataHookUp.this.myModel.removeRows(0, DataBusGridDataHookUp.this.myModel.getRowCount());
                DataBusGridDataHookUp.this.myModel.setColumns(Arrays.asList(columns));
            }
            this.validateRowCount();
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                DataBusLoader.$$$reportNull$$$0(1);
            }
            if (rows.isEmpty()) {
                return;
            }
            if (this.myRowsLoaded == 0) {
                DataBusGridDataHookUp.this.myPageModel.setPageStart(rows.get((int)0).rowNum);
            }
            DataBusGridDataHookUp.this.myPageModel.setPageEnd(rows.get((int)(rows.size() - 1)).rowNum);
            DataBusGridDataHookUp.this.myModel.setRows(this.myRowsLoaded, rows);
            this.myRowsLoaded += rows.size();
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                DataBusLoader.$$$reportNull$$$0(2);
            }
            if (this.myRowsLoaded >= 0 && this.myRowsLoaded < DataBusGridDataHookUp.this.myModel.getRowCount()) {
                int rowsToRemove = DataBusGridDataHookUp.this.myModel.getRowCount() - this.myRowsLoaded;
                DataBusGridDataHookUp.this.myModel.removeRows(DataBusGridDataHookUp.this.myModel.getRowCount() - rowsToRemove, rowsToRemove);
            }
            DataBusGridDataHookUp.this.myModel.setUpdatingNow(false);
            if ((long)total > DataBusGridDataHookUp.this.myPageModel.getTotalRowCount() || DataBusGridDataHookUp.this.myPageModel.getPageEnd() == total) {
                DataBusGridDataHookUp.this.myPageModel.setTotalRowCount(total, DataBusGridDataHookUp.this.myPageModel.getPageEnd() >= total);
            }
        }

        @Override
        public void reloadCurrentPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(3);
            }
            this.load(source, Math.max(1, DataBusGridDataHookUp.this.myPageModel.getPageStart()), true);
        }

        @Override
        public void loadNextPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(4);
            }
            this.load(source, DataBusGridDataHookUp.this.myPageModel.getPageEnd() + 1, true);
        }

        @Override
        public void loadPreviousPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(5);
            }
            this.load(source, Math.max(1, DataBusGridDataHookUp.this.myPageModel.getPageStart()), false);
        }

        @Override
        public void loadLastPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            int pageSize;
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(6);
            }
            this.load(source, -((pageSize = DataBusGridDataHookUp.this.myPageModel.getPageSize()) > 0 ? pageSize : 100), false, true);
        }

        @Override
        public void loadFirstPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(7);
            }
            this.load(source, 1, true);
        }

        @Override
        public void load(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int rowDataIdx) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(8);
            }
            this.load(source, rowDataIdx, true);
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(9);
            }
            DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
        }

        @Override
        public void applyFilter(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(10);
            }
            DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
        }

        @Nullable
        public String getQueryText() {
            return this.myQueryText;
        }

        public int getResultSetIndex() {
            return this.myResultSetIndex;
        }

        public void invalidateQuery() {
            this.myQueryInvalidated = true;
        }

        @NotNull
        protected Promise<Void> load(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int startIndex, boolean forward) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(11);
            }
            Promise<Void> promise = this.load(source, startIndex, true, forward);
            if (promise == null) {
                DataBusLoader.$$$reportNull$$$0(12);
            }
            return promise;
        }

        @NotNull
        protected Promise<Void> load(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int startIndex, boolean limit, boolean forward) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(13);
            }
            boolean unlimited = !limit || DbImplUtil.isPageSizeUnlimited(DataBusGridDataHookUp.this.myPageModel.getPageSize());
            this.updateQueryText(unlimited ? QueryAttributes.unlimited(true) : QueryAttributes.limited(startIndex + DataBusGridDataHookUp.this.myPageModel.getPageSize(), true));
            if (this.myQueryText == null) {
                DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
                Promise promise = Promises.rejectedPromise();
                if (promise == null) {
                    DataBusLoader.$$$reportNull$$$0(14);
                }
                return promise;
            }
            DataBusGridDataHookUp owner = DataBusGridDataHookUp.this;
            DataRequest r = DataRequest.newRequest(owner, this.myQueryText, startIndex, forward, DataBusGridDataHookUp.this.myPageModel.getPageSize(), this.myResultSetIndex);
            DataBusGridDataHookUp.this.processRequest(source, r, ReloadPolicy.DO_NOT_RELOAD);
            AsyncPromise<Void> asyncPromise = r.getPromise();
            if (asyncPromise == null) {
                DataBusLoader.$$$reportNull$$$0(15);
            }
            return asyncPromise;
        }

        protected boolean canUpdateQueryText() {
            return false;
        }

        protected final void updateQueryText(@NotNull QueryAttributes attributes) {
            if (attributes == null) {
                DataBusLoader.$$$reportNull$$$0(16);
            }
            if (this.canUpdateQueryText()) {
                this.setQueryText(this.createQueryText(attributes));
            }
        }

        @Nullable
        protected String createQueryText(@NotNull QueryAttributes attributes) {
            if (attributes == null) {
                DataBusLoader.$$$reportNull$$$0(17);
            }
            return null;
        }

        protected DataConsumer.Column[] prepareColumns(@NotNull DataConsumer.Column[] columns) {
            if (columns == null) {
                DataBusLoader.$$$reportNull$$$0(18);
            }
            return columns;
        }

        protected void setQueryText(String query) {
            this.myQueryText = query;
            this.validateQuery();
        }

        protected void invalidateRowCount() {
            this.myTotalRowCountInvalidated = true;
        }

        protected boolean isQueryInvalidated() {
            return this.myQueryInvalidated;
        }

        protected boolean sameColumnsAsInModel(DataConsumer.Column[] columns) {
            if (columns.length != DataBusGridDataHookUp.this.myModel.getColumnCount()) {
                return false;
            }
            for (int i2 = 0; i2 < columns.length; ++i2) {
                if (Comparing.equal((Object)columns[i2], (Object)DataBusGridDataHookUp.this.myModel.getColumn(ModelIndex.forColumn(DataBusGridDataHookUp.this.myModel, i2)))) continue;
                return false;
            }
            return true;
        }

        private void validateQuery() {
            this.myQueryInvalidated = false;
        }

        private void validateRowCount() {
            this.myTotalRowCountInvalidated = false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 12: 
                case 14: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 12: 
                case 14: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 12: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader";
                    break;
                }
                case 12: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "load";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setColumns";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addRows";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "afterLastRowAdded";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "reloadCurrentPage";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "loadNextPage";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "loadPreviousPage";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "loadLastPage";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "loadFirstPage";
                    break;
                }
                case 8: 
                case 11: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "load";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "updateTotalRowCount";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFilter";
                    break;
                }
                case 12: 
                case 14: 
                case 15: {
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "updateQueryText";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "createQueryText";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareColumns";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 12: 
                case 14: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

