/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ConversionGraph;
import com.intellij.database.data.types.DataConverter;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataTypeConversion {
    private final Dbms myFirstDbms;
    private final DasDataSource myFirstSystem;
    private final DataConsumer.Column myFirstColumn;
    private final Object myObject;
    private final Dbms mySecondDbms;
    private final DasDataSource mySecondSystem;
    private final DataGrid mySecondGrid;
    private final ModelIndex<DataConsumer.Column> mySecondColumnIdx;
    private final ModelIndex<DataConsumer.Row> mySecondRowIdx;

    public DataTypeConversion(@NotNull Dbms firstDbms, @Nullable DasDataSource firstSystem, @NotNull DataConsumer.Column firstColumn, @NotNull Dbms secondDbms, @Nullable DasDataSource secondSystem, @NotNull ModelIndex<DataConsumer.Column> secondColIdx, @NotNull ModelIndex<DataConsumer.Row> secondRowIdx, @NotNull DataGrid grid, @Nullable Object object) {
        if (firstDbms == null) {
            DataTypeConversion.$$$reportNull$$$0(0);
        }
        if (firstColumn == null) {
            DataTypeConversion.$$$reportNull$$$0(1);
        }
        if (secondDbms == null) {
            DataTypeConversion.$$$reportNull$$$0(2);
        }
        if (secondColIdx == null) {
            DataTypeConversion.$$$reportNull$$$0(3);
        }
        if (secondRowIdx == null) {
            DataTypeConversion.$$$reportNull$$$0(4);
        }
        if (grid == null) {
            DataTypeConversion.$$$reportNull$$$0(5);
        }
        this.myFirstDbms = firstDbms;
        this.myFirstSystem = firstSystem;
        this.myFirstColumn = firstColumn;
        this.mySecondSystem = secondSystem;
        this.myObject = object;
        this.mySecondDbms = secondDbms;
        this.mySecondColumnIdx = secondColIdx;
        this.mySecondRowIdx = secondRowIdx;
        this.mySecondGrid = grid;
    }

    @NotNull
    public CellMutation.Builder convert() {
        Object unwrapped = ObjectFormatter.unwrap(this.myObject);
        CellMutation.Builder builder = new CellMutation.Builder().row(this.mySecondRowIdx).column(this.mySecondColumnIdx).value(null);
        DataConsumer.Column column2 = this.mySecondGrid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(this.mySecondColumnIdx);
        if (column2 == null) {
            CellMutation.Builder builder2 = builder;
            if (builder2 == null) {
                DataTypeConversion.$$$reportNull$$$0(6);
            }
            return builder2;
        }
        Function<Object, Object> converter = DataTypeConversion.getConverter(this.myFirstDbms, this.mySecondDbms, this.myFirstSystem, this.mySecondSystem, this.myFirstColumn, column2, unwrapped);
        CellMutation.Builder builder3 = converter == null ? builder : builder.value(converter.fun(unwrapped));
        if (builder3 == null) {
            DataTypeConversion.$$$reportNull$$$0(7);
        }
        return builder3;
    }

    public boolean isValid() {
        return this.mySecondColumnIdx.isValid(this.mySecondGrid) && this.mySecondRowIdx.isValid(this.mySecondGrid);
    }

    @Nullable
    public static Function<Object, Object> getConverter(@NotNull Dbms firstDbms, @NotNull Dbms secondDbms, @Nullable DasDataSource firstSystem, @Nullable DasDataSource secondSystem, @NotNull ColumnDescriptor firstDescriptor, @NotNull ColumnDescriptor secondDescriptor, @Nullable Object o) {
        Domain to;
        if (firstDbms == null) {
            DataTypeConversion.$$$reportNull$$$0(8);
        }
        if (secondDbms == null) {
            DataTypeConversion.$$$reportNull$$$0(9);
        }
        if (firstDescriptor == null) {
            DataTypeConversion.$$$reportNull$$$0(10);
        }
        if (secondDescriptor == null) {
            DataTypeConversion.$$$reportNull$$$0(11);
        }
        Domain firstDomain = DomainRegistry.getDomain(firstDbms, DbImplUtil.getDatabaseVersion(firstSystem), firstDescriptor, true);
        Domain secondDomain = DomainRegistry.getDomain(secondDbms, DbImplUtil.getDatabaseVersion(secondSystem), secondDescriptor, false);
        if (secondDomain == null && !DataTypeConversion.isSameTypes(firstDbms, secondDbms, firstDescriptor, secondDescriptor)) {
            return null;
        }
        Domain from = (Domain)ObjectUtils.chooseNotNull((Object)firstDomain, (Object)Domain.EMPTY);
        Function<Object, Object> converter = ConversionGraph.getConverter(o, from, to = (Domain)ObjectUtils.chooseNotNull((Object)secondDomain, (Object)Domain.EMPTY));
        return converter == null ? null : (secondDomain == null ? converter : (firstDomain == null ? DataConverter.ObjectToText.tweak(converter, firstDescriptor, firstDbms) : converter));
    }

    private static boolean isSameTypes(@NotNull Dbms firstDbms, @NotNull Dbms secondDbms, @NotNull ColumnDescriptor first, @NotNull ColumnDescriptor second) {
        if (firstDbms == null) {
            DataTypeConversion.$$$reportNull$$$0(12);
        }
        if (secondDbms == null) {
            DataTypeConversion.$$$reportNull$$$0(13);
        }
        if (first == null) {
            DataTypeConversion.$$$reportNull$$$0(14);
        }
        if (second == null) {
            DataTypeConversion.$$$reportNull$$$0(15);
        }
        return DbImplUtil.getDatabaseDialect(firstDbms) == DbImplUtil.getDatabaseDialect(secondDbms) && StringUtil.equals((CharSequence)first.getTypeName(), (CharSequence)second.getTypeName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstDbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstColumn";
                break;
            }
            case 2: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondDbms";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondColIdx";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondRowIdx";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/DataTypeConversion";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstDescriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondDescriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/DataTypeConversion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getConverter";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSameTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private Dbms myFirstDbms;
        private DataConsumer.Column myFirstColumn;
        private int myFirstRowIdx;
        private int myFirstColumnIdx;
        private DasDataSource myFirstSystem;
        private Object myObject;
        private Dbms mySecondDbms;
        private DataGrid mySecondGrid;
        private DasDataSource mySecondSystem;
        private ModelIndex<DataConsumer.Column> mySecondColumnIdx;
        private ModelIndex<DataConsumer.Row> mySecondRowIdx;

        public Builder() {
        }

        private Builder(@Nullable Dbms firstDbms, @Nullable DataConsumer.Column firstColumn, int firstRowIdx, int firstColumnIdx, @Nullable DasDataSource firstSystem, @Nullable Object object, @Nullable Dbms secondDbms, @Nullable DataGrid secondGrid, @Nullable DasDataSource secondSystem, @Nullable ModelIndex<DataConsumer.Column> secondColumnIdx, @Nullable ModelIndex<DataConsumer.Row> secondRowIdx) {
            this.myFirstDbms = firstDbms;
            this.myFirstColumn = firstColumn;
            this.myFirstRowIdx = firstRowIdx;
            this.myFirstColumnIdx = firstColumnIdx;
            this.myFirstSystem = firstSystem;
            this.myObject = object;
            this.mySecondDbms = secondDbms;
            this.mySecondGrid = secondGrid;
            this.mySecondSystem = secondSystem;
            this.mySecondColumnIdx = secondColumnIdx;
            this.mySecondRowIdx = secondRowIdx;
        }

        @NotNull
        public Builder firstDbms(@NotNull Dbms dbms) {
            if (dbms == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myFirstDbms = dbms;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder firstColumn(@NotNull DataConsumer.Column column2) {
            if (column2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myFirstColumn = column2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder firstRowIdx(int rowIdx) {
            this.myFirstRowIdx = rowIdx;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder firstColumnIdx(int columnIdx) {
            this.myFirstColumnIdx = columnIdx;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        public Builder value(@Nullable Object value) {
            this.myObject = value;
            return this;
        }

        public Builder secondDbms(@NotNull Dbms dbms) {
            if (dbms == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.mySecondDbms = dbms;
            return this;
        }

        @NotNull
        public Builder secondGrid(@NotNull DataGrid grid) {
            if (grid == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.mySecondGrid = grid;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        public Builder secondColumnIndex(@NotNull ModelIndex<DataConsumer.Column> idx) {
            if (idx == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.mySecondColumnIdx = idx;
            return this;
        }

        @NotNull
        public Builder secondRowIdx(@NotNull ModelIndex<DataConsumer.Row> idx) {
            if (idx == null) {
                Builder.$$$reportNull$$$0(10);
            }
            this.mySecondRowIdx = idx;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder;
        }

        @NotNull
        public Builder offset(int rows, int columns) {
            this.secondRowIdx(ViewIndex.forRow(this.mySecondGrid, this.myFirstRowIdx + rows).toModel(this.mySecondGrid));
            Builder builder = this.secondColumnIndex(ViewIndex.forColumn(this.mySecondGrid, this.myFirstColumnIdx + columns).toModel(this.mySecondGrid));
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public Builder firstSystem(@Nullable DasDataSource system) {
            this.myFirstSystem = system;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder;
        }

        @NotNull
        public Builder secondSystem(@Nullable DasDataSource system) {
            this.mySecondSystem = system;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder;
        }

        @NotNull
        public Builder copy() {
            Builder builder = new Builder(this.myFirstDbms, this.myFirstColumn, this.myFirstRowIdx, this.myFirstColumnIdx, this.myFirstSystem, this.myObject, this.mySecondDbms, this.mySecondGrid, this.mySecondSystem, this.mySecondColumnIdx, this.mySecondRowIdx);
            if (builder == null) {
                Builder.$$$reportNull$$$0(15);
            }
            return builder;
        }

        @NotNull
        public DataTypeConversion build() {
            DataTypeConversion dataTypeConversion = new DataTypeConversion(this.myFirstDbms, this.myFirstSystem, this.myFirstColumn, this.mySecondDbms, this.mySecondSystem, this.mySecondColumnIdx, this.mySecondRowIdx, this.mySecondGrid, this.myObject);
            if (dataTypeConversion == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return dataTypeConversion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/DataTypeConversion$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idx";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/DataTypeConversion$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "firstDbms";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "firstColumn";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "firstRowIdx";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "firstColumnIdx";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "secondGrid";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "secondRowIdx";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "offset";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "firstSystem";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "secondSystem";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "firstDbms";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "firstColumn";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "secondDbms";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "secondGrid";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "secondColumnIndex";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "secondRowIdx";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

