/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.MergedChange;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcs.log.impl.VcsFileStatusInfoMerger;
import com.intellij.vcs.log.impl.VcsIndexableDetails;
import com.intellij.vcs.log.impl.VcsStatusMerger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class VcsChangesLazilyParsedDetails
extends VcsCommitMetadataImpl
implements VcsFullCommitDetails,
VcsIndexableDetails {
    private static final Logger LOG = Logger.getInstance(VcsChangesLazilyParsedDetails.class);
    protected static final Changes EMPTY_CHANGES = new EmptyChanges();
    @NotNull
    protected final AtomicReference<Changes> myChanges;

    /*
     * WARNING - void declaration
     */
    public VcsChangesLazilyParsedDetails(@NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull VcsUser author, @NotNull String message, @NotNull VcsUser committer, long l) {
        void authorTime;
        if (hash == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(0);
        }
        if (parents == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(1);
        }
        if (root == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(2);
        }
        if (subject == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(3);
        }
        if (author == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(4);
        }
        if (message == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(5);
        }
        if (committer == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(6);
        }
        super(hash, parents, commitTime, root, subject, author, message, committer, (long)authorTime);
        this.myChanges = new AtomicReference();
    }

    @Override
    @NotNull
    public Map<String, Change.Type> getModifiedPaths(int parent) {
        Map<String, Change.Type> map = this.myChanges.get().getModifiedPaths(parent);
        if (map == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(7);
        }
        return map;
    }

    @Override
    @NotNull
    public Collection<Couple<String>> getRenamedPaths(int parent) {
        Collection<Couple<String>> collection = this.myChanges.get().getRenamedPaths(parent);
        if (collection == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public Collection<Change> getChanges() {
        Collection<Change> collection;
        try {
            collection = this.myChanges.get().getMergedChanges();
        }
        catch (VcsException e) {
            LOG.error("Error happened when parsing changes", (Throwable)e);
            List<Change> list2 = Collections.emptyList();
            if (list2 == null) {
                VcsChangesLazilyParsedDetails.$$$reportNull$$$0(10);
            }
            return list2;
        }
        if (collection == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public Collection<Change> getChanges(int parent) {
        Collection<Change> collection;
        try {
            collection = this.myChanges.get().getChanges(parent);
        }
        catch (VcsException e) {
            LOG.error("Error happened when parsing changes", (Throwable)e);
            List<Change> list2 = Collections.emptyList();
            if (list2 == null) {
                VcsChangesLazilyParsedDetails.$$$reportNull$$$0(12);
            }
            return list2;
        }
        if (collection == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Override
    public boolean hasRenames() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subject";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "author";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "committer";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedPaths";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenamedPaths";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ParsedChanges
    implements Changes {
        @NotNull
        private final Collection<Change> myMergedChanges;
        @NotNull
        private final List<? extends Collection<Change>> myChanges;

        ParsedChanges(@NotNull Collection<Change> mergedChanges, @NotNull List<? extends Collection<Change>> changes2) {
            if (mergedChanges == null) {
                ParsedChanges.$$$reportNull$$$0(0);
            }
            if (changes2 == null) {
                ParsedChanges.$$$reportNull$$$0(1);
            }
            this.myMergedChanges = mergedChanges;
            this.myChanges = changes2;
        }

        @Override
        @NotNull
        public Collection<Change> getMergedChanges() {
            Collection<Change> collection = this.myMergedChanges;
            if (collection == null) {
                ParsedChanges.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<Change> getChanges(int parent) {
            Collection<Change> collection = this.myChanges.get(parent);
            if (collection == null) {
                ParsedChanges.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @Override
        @NotNull
        public Map<String, Change.Type> getModifiedPaths(int parent) {
            HashMap changes2 = ContainerUtil.newHashMap();
            for (Change change : this.getChanges(parent)) {
                Change.Type type = change.getType();
                if (type.equals((Object)Change.Type.MOVED)) continue;
                if (change.getAfterRevision() != null) {
                    changes2.put(change.getAfterRevision().getFile().getPath(), type);
                }
                if (change.getBeforeRevision() == null) continue;
                changes2.put(change.getBeforeRevision().getFile().getPath(), type);
            }
            HashMap hashMap = changes2;
            if (hashMap == null) {
                ParsedChanges.$$$reportNull$$$0(4);
            }
            return hashMap;
        }

        @Override
        @NotNull
        public Collection<Couple<String>> getRenamedPaths(int parent) {
            HashSet renames = ContainerUtil.newHashSet();
            for (Change change : this.getChanges(parent)) {
                if (!change.getType().equals((Object)Change.Type.MOVED) || change.getAfterRevision() == null || change.getBeforeRevision() == null) continue;
                renames.add(Couple.of((Object)change.getBeforeRevision().getFile().getPath(), (Object)change.getAfterRevision().getFile().getPath()));
            }
            HashSet hashSet = renames;
            if (hashSet == null) {
                ParsedChanges.$$$reportNull$$$0(5);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mergedChanges";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails$ParsedChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails$ParsedChanges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergedChanges";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModifiedPaths";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRenamedPaths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected abstract class UnparsedChanges
    implements Changes {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final List<List<VcsFileStatusInfo>> myChangesOutput;
        @NotNull
        private final VcsStatusMerger<VcsFileStatusInfo> myStatusMerger;

        public UnparsedChanges(@NotNull Project project, List<List<VcsFileStatusInfo>> changesOutput) {
            if (project == null) {
                UnparsedChanges.$$$reportNull$$$0(0);
            }
            if (changesOutput == null) {
                UnparsedChanges.$$$reportNull$$$0(1);
            }
            this.myStatusMerger = new VcsFileStatusInfoMerger();
            this.myProject = project;
            this.myChangesOutput = changesOutput;
        }

        @NotNull
        protected ParsedChanges parseChanges() throws VcsException {
            List<Change> mergedChanges = this.parseMergedChanges();
            List<Collection<Change>> changes2 = this.computeChanges(mergedChanges);
            ParsedChanges parsedChanges = new ParsedChanges(mergedChanges, changes2);
            VcsChangesLazilyParsedDetails.this.myChanges.compareAndSet(this, parsedChanges);
            ParsedChanges parsedChanges2 = parsedChanges;
            if (parsedChanges2 == null) {
                UnparsedChanges.$$$reportNull$$$0(2);
            }
            return parsedChanges2;
        }

        @NotNull
        private List<Change> parseMergedChanges() throws VcsException {
            List<VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo>> statuses = this.getMergedStatusInfo();
            List<Change> changes2 = this.parseStatusInfo(ContainerUtil.map(statuses, VcsStatusMerger.MergedStatusInfo::getStatusInfo), 0);
            LOG.assertTrue(changes2.size() == statuses.size(), (Object)("Incorrectly parsed statuses " + statuses + " to changes " + changes2));
            if (VcsChangesLazilyParsedDetails.this.getParents().size() <= 1) {
                List<Change> list2 = changes2;
                if (list2 == null) {
                    UnparsedChanges.$$$reportNull$$$0(3);
                }
                return list2;
            }
            ArrayList<Change> wrappedChanges = new ArrayList<Change>(statuses.size());
            for (int i = 0; i < statuses.size(); ++i) {
                wrappedChanges.add(new MyMergedChange(changes2.get(i), statuses.get(i)));
            }
            ArrayList<Change> arrayList = wrappedChanges;
            if (arrayList == null) {
                UnparsedChanges.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @Override
        @NotNull
        public Collection<Change> getMergedChanges() throws VcsException {
            Collection<Change> collection = this.parseChanges().getMergedChanges();
            if (collection == null) {
                UnparsedChanges.$$$reportNull$$$0(5);
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<Change> getChanges(int parent) throws VcsException {
            Collection<Change> collection = this.parseChanges().getChanges(parent);
            if (collection == null) {
                UnparsedChanges.$$$reportNull$$$0(6);
            }
            return collection;
        }

        @Override
        @NotNull
        public Map<String, Change.Type> getModifiedPaths(int parent) {
            HashMap changes2 = ContainerUtil.newHashMap();
            for (VcsFileStatusInfo status : this.myChangesOutput.get(parent)) {
                String secondPath = status.getSecondPath();
                if (secondPath != null) continue;
                changes2.put(this.absolutePath(status.getFirstPath()), status.getType());
            }
            HashMap hashMap = changes2;
            if (hashMap == null) {
                UnparsedChanges.$$$reportNull$$$0(7);
            }
            return hashMap;
        }

        @Override
        @NotNull
        public Collection<Couple<String>> getRenamedPaths(int parent) {
            HashSet renames = ContainerUtil.newHashSet();
            for (VcsFileStatusInfo status : this.myChangesOutput.get(parent)) {
                String secondPath = status.getSecondPath();
                if (secondPath == null) continue;
                renames.add(Couple.of((Object)this.absolutePath(status.getFirstPath()), (Object)this.absolutePath(secondPath)));
            }
            HashSet hashSet = renames;
            if (hashSet == null) {
                UnparsedChanges.$$$reportNull$$$0(8);
            }
            return hashSet;
        }

        @NotNull
        protected String absolutePath(@NotNull String path) {
            if (path == null) {
                UnparsedChanges.$$$reportNull$$$0(9);
            }
            String string = VcsChangesLazilyParsedDetails.this.getRoot().getPath() + "/" + path;
            if (string == null) {
                UnparsedChanges.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        private List<Collection<Change>> computeChanges(@NotNull Collection<Change> mergedChanges) throws VcsException {
            if (mergedChanges == null) {
                UnparsedChanges.$$$reportNull$$$0(11);
            }
            if (this.myChangesOutput.size() == 1) {
                List<Collection<Change>> list2 = Collections.singletonList(mergedChanges);
                if (list2 == null) {
                    UnparsedChanges.$$$reportNull$$$0(12);
                }
                return list2;
            }
            ArrayList changes2 = ContainerUtil.newArrayListWithCapacity((int)this.myChangesOutput.size());
            for (int i = 0; i < this.myChangesOutput.size(); ++i) {
                changes2.add(this.parseStatusInfo(this.myChangesOutput.get(i), i));
            }
            ArrayList arrayList = changes2;
            if (arrayList == null) {
                UnparsedChanges.$$$reportNull$$$0(13);
            }
            return arrayList;
        }

        @NotNull
        protected abstract List<Change> parseStatusInfo(@NotNull List<VcsFileStatusInfo> var1, int var2) throws VcsException;

        @NotNull
        private List<VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo>> getMergedStatusInfo() {
            List<VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo>> list2 = this.myStatusMerger.merge(this.myChangesOutput);
            if (list2 == null) {
                UnparsedChanges.$$$reportNull$$$0(14);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesOutput";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails$UnparsedChanges";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mergedChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails$UnparsedChanges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseChanges";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseMergedChanges";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergedChanges";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModifiedPaths";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRenamedPaths";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "absolutePath";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeChanges";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergedStatusInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "absolutePath";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "computeChanges";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyMergedChange
        extends MergedChange {
            @NotNull
            private final VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo> myStatusInfo;
            @NotNull
            private final Supplier<List<Change>> mySourceChanges;

            MyMergedChange(@NotNull Change change, VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo> statusInfo) {
                if (change == null) {
                    MyMergedChange.$$$reportNull$$$0(0);
                }
                if (statusInfo == null) {
                    MyMergedChange.$$$reportNull$$$0(1);
                }
                super(change);
                this.myStatusInfo = statusInfo;
                this.mySourceChanges = Suppliers.memoize(() -> {
                    ArrayList sourceChanges = ContainerUtil.newArrayList();
                    try {
                        for (int parent = 0; parent < this.myStatusInfo.getMergedStatusInfos().size(); ++parent) {
                            sourceChanges.addAll(UnparsedChanges.this.parseStatusInfo(Collections.singletonList(this.myStatusInfo.getMergedStatusInfos().get(parent)), parent));
                        }
                    }
                    catch (VcsException e) {
                        LOG.error((Throwable)e);
                    }
                    return sourceChanges;
                });
            }

            @Override
            public List<Change> getSourceChanges() {
                return (List)this.mySourceChanges.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "change";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "statusInfo";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails$UnparsedChanges$MyMergedChange";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    protected static class EmptyChanges
    implements Changes {
        protected EmptyChanges() {
        }

        @Override
        @NotNull
        public Collection<Change> getMergedChanges() {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                EmptyChanges.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        @NotNull
        public Collection<Change> getChanges(int parent) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                EmptyChanges.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        @NotNull
        public Map<String, Change.Type> getModifiedPaths(int parent) {
            Map<String, Change.Type> map = Collections.emptyMap();
            if (map == null) {
                EmptyChanges.$$$reportNull$$$0(2);
            }
            return map;
        }

        @Override
        @NotNull
        public Collection<Couple<String>> getRenamedPaths(int parent) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                EmptyChanges.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails$EmptyChanges";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergedChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModifiedPaths";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRenamedPaths";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static interface Changes {
        @NotNull
        public Collection<Change> getMergedChanges() throws VcsException;

        @NotNull
        public Collection<Change> getChanges(int var1) throws VcsException;

        @NotNull
        public Map<String, Change.Type> getModifiedPaths(int var1);

        @NotNull
        public Collection<Couple<String>> getRenamedPaths(int var1);
    }
}

