/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.jetbrains.performancePlugin.MessagesBundle;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class InspectionCommandEx
extends AbstractCommand {
    public static final String PREFIX = "%InspectCodeEx";
    private final Project myProject;
    private final Options myOptions;

    public InspectionCommandEx(@NotNull String text, int line, @NotNull Project project) {
        if (text == null) {
            InspectionCommandEx.$$$reportNull$$$0(0);
        }
        if (project == null) {
            InspectionCommandEx.$$$reportNull$$$0(1);
        }
        super(text, line);
        this.myOptions = new Options();
        this.myProject = project;
        if (text.startsWith(PREFIX)) {
            Args.parse((Object)this.myOptions, (String[])text.substring(PREFIX.length()).trim().split(" "));
        }
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        PsiDirectory psiDirectory;
        VirtualFile directory;
        if (context == null) {
            InspectionCommandEx.$$$reportNull$$$0(2);
        }
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper(this.myProject);
        InspectionManagerEx inspectionManagerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)this.myProject);
        InspectionProfileManager profileManager = InspectionProfileManager.getInstance((Project)this.myProject);
        InspectionProfileImpl profile = StringUtil.isNotEmpty((String)this.myOptions.profileName) ? profileManager.getProfile(this.myOptions.profileName) : profileManager.getCurrentProfile();
        NamedScope namedScope = NamedScopesHolder.getScope((Project)this.myProject, (String)this.myOptions.scopeName);
        AnalysisScope analysisScope = null;
        if (namedScope != null) {
            analysisScope = new AnalysisScope((SearchScope)GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)namedScope), this.myProject);
        } else if (StringUtil.isNotEmpty((String)this.myOptions.directory) && (directory = VfsUtil.findRelativeFile((VirtualFile)this.myProject.getBaseDir(), (String[])new String[]{this.myOptions.directory})) != null && (psiDirectory = (PsiDirectory)ReadAction.compute(() -> PsiManager.getInstance((Project)this.myProject).findDirectory(directory))) != null) {
            analysisScope = new AnalysisScope(psiDirectory);
        }
        if (analysisScope == null) {
            analysisScope = new AnalysisScope(this.myProject);
        }
        GlobalInspectionContextImpl inspectionContext = new GlobalInspectionContextImpl(this.myProject, inspectionManagerEx.getContentManager()){

            protected void notifyInspectionsFinished(@NotNull AnalysisScope scope) {
                if (scope == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.notifyInspectionsFinished(scope);
                context.message(MessagesBundle.message("command.inspection.finish", new Object[0]), InspectionCommandEx.this.getLine());
                actionCallback.setDone();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/performancePlugin/commands/InspectionCommandEx$1", "notifyInspectionsFinished"));
            }
        };
        inspectionContext.setExternalProfile(profile);
        inspectionContext.doInspections(analysisScope);
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            InspectionCommandEx.$$$reportNull$$$0(3);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/InspectionCommandEx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/InspectionCommandEx";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Options {
        @Argument
        public String scopeName;
        @Argument
        public String profileName;
        @Argument
        public String directory;
    }
}

