/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContextualUnionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSExoticStringLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSKeyofType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.JSWrapperType;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.resolve.TypeScriptTypeHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeRelations {
    public static final int INFINITE_SUBSTITUTION_LIMIT = 50;
    private static final JSType.LocalTypeKey EXPAND_TYPE_KEY = JSType.createLocalTypeKey((String)"expand.type.recursive");
    private static final JSType.LocalTypeKey ENUM_VALUES_UNION_TYPE_KEY = JSType.createLocalTypeKey((String)"enum.values.union.type");
    private static final Key<Boolean> IS_EXPANDED = Key.create((String)"type.is.expanded");
    private static final Key<Boolean> ARGUMENTS_ARE_EXPANDED = Key.create((String)"generic.arguments.are.expanded");

    public static boolean isTypeDerivedFrom(@Nullable JSType source, @Nullable JSType target, @NotNull ProcessingContext subtypingContext) {
        if (subtypingContext == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(0);
        }
        if (source instanceof JSUnionType) {
            return StreamEx.of(((JSUnionType)source).getTypes()).allMatch(el -> {
                if (subtypingContext == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(51);
                }
                return TypeScriptTypeRelations.isTypeDerivedFrom(el, target, subtypingContext);
            });
        }
        if (target instanceof JSUnionType) {
            return StreamEx.of(((JSUnionType)target).getTypes()).anyMatch(el -> {
                if (subtypingContext == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(50);
                }
                return TypeScriptTypeRelations.isTypeDerivedFrom(source, el, subtypingContext);
            });
        }
        if (source instanceof JSPrimitiveType) {
            return TypeScriptTypeRelations.hasBaseType((JSNamedType)source, target);
        }
        return TypeScriptTypeRelations.isTypeSubtypeOf(source, target, subtypingContext);
    }

    public static boolean hasBaseType(@NotNull JSNamedType base, @Nullable JSType toCheck) {
        if (base == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(1);
        }
        if (toCheck instanceof JSNamedType) {
            return TypeScriptTypeHelper.areNamedTypesClassAssignable(base, (JSNamedType)toCheck).isAssignable();
        }
        if (toCheck instanceof JSIntersectionTypeImpl) {
            return StreamEx.of(((JSIntersectionTypeImpl)toCheck).getTypes()).anyMatch(el -> {
                if (base == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(49);
                }
                return TypeScriptTypeRelations.hasBaseType(base, el);
            });
        }
        return false;
    }

    public static boolean isTypeSubtypeOf(@Nullable JSType source, @Nullable JSType target, @NotNull ProcessingContext processingContext) {
        if (processingContext == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(2);
        }
        if (source == null || target == null) {
            return false;
        }
        assert (processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) != null);
        return TypeScriptTypeRelations.isTypeRelatedTo(target, source, processingContext);
    }

    public static boolean areTypesComparable(@Nullable JSType type1, @Nullable JSType type2, @Nullable ProcessingContext context) {
        return TypeScriptTypeRelations.isTypeComparableTo(type1, type2, context) || TypeScriptTypeRelations.isTypeComparableTo(type2, type1, context);
    }

    public static boolean isTypeComparableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        block3: {
            block2: {
                if (!(source instanceof JSUnionType)) break block2;
                for (JSType sourceSubType : ((JSUnionType)source).getTypes()) {
                    if (!TypeScriptTypeRelations.isTypeComparableTo(sourceSubType, target, context)) continue;
                    return true;
                }
                break block3;
            }
            if (!(target instanceof JSUnionType)) break block3;
            for (JSType targetSubType : ((JSUnionType)target).getTypes()) {
                if (!TypeScriptTypeRelations.isTypeRelatedTo(source, targetSubType, context)) continue;
                return true;
            }
        }
        return TypeScriptTypeRelations.isTypeRelatedTo(source, target, context);
    }

    public static boolean isTypeAssignableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return TypeScriptTypeRelations.isTypeRelatedTo(target, source, context);
    }

    public static boolean isTypeSubsetOf(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        JSType targetCanonical;
        if (source == null || target == null) {
            return source == target;
        }
        JSType sourceCanonical = TypeScriptTypeRelations.getCanonicalType(source);
        if (sourceCanonical.isEquivalentTo(targetCanonical = TypeScriptTypeRelations.getCanonicalType(target), context)) {
            return true;
        }
        return targetCanonical instanceof JSUnionType && TypeScriptTypeRelations.isTypeSubsetOfUnionType(sourceCanonical, (JSUnionType)targetCanonical, context);
    }

    public static JSType getCanonicalType(@Nullable JSType type) {
        if (type instanceof JSDecoratedType) {
            type = ((JSDecoratedType)type).getOriginalType();
        }
        return TypeScriptTypeRelations.getCanonicalTypeForExoticLiterals(type);
    }

    @Contract(value="!null->!null")
    public static JSType getCanonicalTypeForExoticLiterals(@Nullable JSType type) {
        if (type instanceof JSExoticStringLiteralType) {
            return ((JSExoticStringLiteralType)type).asSimpleLiteralType();
        }
        return type;
    }

    public static boolean isTypeRelatedTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return source != null && TypeScriptTypeRelations.getRegularTypeOfLiteralType(source).isDirectlyAssignableType(TypeScriptTypeRelations.getRegularTypeOfLiteralType(target), context);
    }

    public static boolean typeMaybeAssignableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        if (source instanceof JSUnionType) {
            return ((JSUnionType)source).getTypes().stream().anyMatch(el -> TypeScriptTypeRelations.typeMaybeAssignableTo(el, target, context));
        }
        return TypeScriptTypeRelations.isTypeAssignableTo(source, target, context);
    }

    public static boolean isTypeSubsetOfUnionType(@NotNull JSType source, @NotNull JSUnionType target, @Nullable ProcessingContext context) {
        if (source == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(3);
        }
        if (target == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(4);
        }
        List<JSType> types = target.getTypes();
        if (source instanceof JSUnionType) {
            List<JSType> subTypes = ((JSUnionType)source).getTypes();
            for (JSType type : subTypes) {
                if (TypeScriptTypeRelations.containsType(types, type, context)) continue;
                return false;
            }
            return true;
        }
        return TypeScriptTypeRelations.containsType(types, source, context);
    }

    public static boolean containsType(@NotNull List<? extends JSType> types, @NotNull JSType sourceType, @Nullable ProcessingContext context) {
        if (types == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(5);
        }
        if (sourceType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(6);
        }
        return types.stream().anyMatch(el -> {
            if (sourceType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(48);
            }
            return TypeScriptTypeRelations.getCanonicalType(el).isEquivalentTo(TypeScriptTypeRelations.getCanonicalType(sourceType), context);
        });
    }

    @Contract(value="!null -> !null; null -> null")
    public static JSType expandAndOptimizeTypeRecursive(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof JSUtilType || type.getResolvedFlag(IS_EXPANDED) == Boolean.TRUE) {
            return type;
        }
        JSType expandedType = (JSType)type.getResolvedFlag((Key)EXPAND_TYPE_KEY);
        if (expandedType != null) {
            return expandedType;
        }
        JSType after = JSCompositeTypeImpl.optimizeTypeIfComposite(TypeScriptTypeRelations.expandAliasesRecursive(type));
        if (TypeScriptTypeRelations.isInstanceOfOrUnionTypePart(after, JSTypeofTypeImpl.class)) {
            return after;
        }
        JSType result2 = type.getLocalCachedType(() -> after, EXPAND_TYPE_KEY);
        if (result2 instanceof JSUtilType) {
            return result2;
        }
        result2.setResolvedFlag(IS_EXPANDED, (Object)Boolean.TRUE);
        return result2;
    }

    private static boolean isInstanceOfOrUnionTypePart(@NotNull JSType result2, @NotNull Class<? extends JSType> typeClass) {
        if (result2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(7);
        }
        if (typeClass == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(8);
        }
        if (typeClass.isInstance(result2)) {
            return true;
        }
        if (result2 instanceof JSUnionOrIntersectionType) {
            List<JSType> types = ((JSUnionOrIntersectionType)result2).getTypes();
            return types.size() > 0 && types.stream().anyMatch(el -> {
                if (typeClass == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(47);
                }
                return TypeScriptTypeRelations.isInstanceOfOrUnionTypePart(el, typeClass);
            });
        }
        if (result2 instanceof JSWrapperType) {
            return TypeScriptTypeRelations.isInstanceOfOrUnionTypePart(((JSWrapperType)result2).getOriginalType(), typeClass);
        }
        return false;
    }

    @Deprecated
    @Contract(value="!null->!null")
    public static JSType expandAliasesRecursive(@Nullable JSType originalType) {
        if (originalType == null) {
            return null;
        }
        JSType type = TypeScriptTypeRelations.expandAliasesRecursive(originalType, null, (Set<JSResolvedTypeId>)ContainerUtil.newTroveSet());
        return type == null ? JSAnyType.get(originalType.getSource()) : type;
    }

    @NotNull
    public static JSType expandAliasesForGenericArguments(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(9);
        }
        if (type instanceof JSGenericTypeImpl) {
            if (type.getResolvedFlag(ARGUMENTS_ARE_EXPANDED) == Boolean.TRUE) {
                JSType jSType = type;
                if (jSType == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(10);
                }
                return jSType;
            }
            List<JSType> oldArguments = ((JSGenericTypeImpl)type).getArguments();
            List<JSType> newArguments = oldArguments.stream().map(el -> TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(el)).collect(Collectors.toList());
            if (ContainerUtil.equalsIdentity(newArguments, oldArguments)) {
                type.setResolvedFlag(ARGUMENTS_ARE_EXPANDED, (Object)Boolean.TRUE);
                JSType jSType = type;
                if (jSType == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(11);
                }
                return jSType;
            }
            JSGenericTypeImpl expanded = new JSGenericTypeImpl(type.getSource(), ((JSGenericTypeImpl)type).getType(), newArguments);
            expanded.setResolvedFlag(ARGUMENTS_ARE_EXPANDED, Boolean.TRUE);
            JSGenericTypeImpl jSGenericTypeImpl = expanded;
            if (jSGenericTypeImpl == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(12);
            }
            return jSGenericTypeImpl;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            JSType jSType = ((JSUnionOrIntersectionType)type).transformTypes((NullableFunction<? super JSType, JSType>)((NullableFunction)el -> TypeScriptTypeRelations.expandAliasesForGenericArguments(el)));
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(13);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(14);
        }
        return jSType;
    }

    public static boolean isInstantiable(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(15);
        }
        return type instanceof JSKeyofType || type instanceof TypeScriptMappedJSTypeImpl || type instanceof JSGenericParameterImpl || type instanceof TypeScriptConditionalTypeJSTypeImpl;
    }

    @Nullable
    private static JSType expandAliasesRecursive(@NotNull JSType originalType, @Nullable JSGenericTypeImpl genericOwner, @NotNull Set<JSResolvedTypeId> visited) {
        PsiElement sourceElement;
        if (originalType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(16);
        }
        if (visited == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(17);
        }
        ProgressManager.checkCanceled();
        if (visited.size() > 50) {
            Logger.getInstance(TypeScriptTypeRelations.class).error("Infinite type substitution " + originalType.getTypeText());
            return null;
        }
        JSType valuableType = JSTypeUtils.getValuableType(originalType, false, false, false);
        if (valuableType != originalType) {
            if (!visited.add(originalType.getResolvedTypeId())) {
                return null;
            }
            return TypeScriptTypeRelations.expandAliasesRecursive(valuableType, genericOwner, visited);
        }
        if (originalType instanceof JSDecoratedTypeImpl) {
            JSDecoratedTypeImpl decoratedType = (JSDecoratedTypeImpl)originalType;
            JSType nestedType = decoratedType.getType();
            if (!visited.add(nestedType.getResolvedTypeId())) {
                return null;
            }
            JSType expandedNested = TypeScriptTypeRelations.expandAliasesRecursive(nestedType, genericOwner, visited);
            if (expandedNested == null) {
                return null;
            }
            if (expandedNested == nestedType) {
                return originalType;
            }
            return new JSDecoratedTypeImpl(originalType.getSource(), expandedNested, decoratedType.getDecorations());
        }
        if (originalType instanceof JSGenericTypeImpl && !((sourceElement = originalType.getSource().getSourceElement()) instanceof JSDocComment)) {
            JSType nestedType = ((JSGenericTypeImpl)originalType).getType();
            JSType expanded = TypeScriptTypeRelations.expandAliasesRecursive(nestedType, (JSGenericTypeImpl)originalType, visited);
            return expanded == nestedType ? originalType : expanded;
        }
        if (originalType instanceof JSResolvableType) {
            return TypeScriptTypeRelations.expandForSingleType((JSResolvableType)originalType, genericOwner, visited);
        }
        if (originalType instanceof JSUnionOrIntersectionType) {
            List<JSType> types = ((JSUnionOrIntersectionType)originalType).getTypes();
            if (!visited.add(originalType.getResolvedTypeId())) {
                return null;
            }
            List<JSType> expandedTypes = types.stream().map(el -> {
                if (visited == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(46);
                }
                return TypeScriptTypeRelations.expandAliasesRecursive(el, genericOwner, (Set<JSResolvedTypeId>)ContainerUtil.newTroveSet((Collection)visited));
            }).filter(el -> el != null).collect(Collectors.toList());
            int expandedSize = expandedTypes.size();
            if (types.size() != expandedSize) {
                if (expandedSize == 0) {
                    return null;
                }
                if (expandedSize == 1) {
                    return expandedTypes.get(0);
                }
                JSType result2 = TypeScriptTypeRelations.createTypeBy(originalType, expandedTypes);
                return result2.copyWithStrict(false);
            }
            if (ContainerUtil.equalsIdentity(types, expandedTypes)) {
                return originalType;
            }
            return TypeScriptTypeRelations.createTypeBy(originalType, expandedTypes);
        }
        return originalType;
    }

    @NotNull
    private static JSType createTypeBy(@NotNull JSType originalType, @NotNull List<JSType> expandedTypes) {
        if (originalType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(18);
        }
        if (expandedTypes == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(19);
        }
        if (originalType instanceof JSContextualUnionTypeImpl) {
            JSContextualUnionTypeImpl jSContextualUnionTypeImpl = new JSContextualUnionTypeImpl(originalType.getSource(), expandedTypes);
            if (jSContextualUnionTypeImpl == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(20);
            }
            return jSContextualUnionTypeImpl;
        }
        if (originalType instanceof JSCompositeTypeImpl) {
            JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(originalType.getSource(), expandedTypes);
            if (jSCompositeTypeImpl == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(21);
            }
            return jSCompositeTypeImpl;
        }
        if (originalType instanceof JSIntersectionTypeImpl) {
            JSIntersectionTypeImpl jSIntersectionTypeImpl = new JSIntersectionTypeImpl(originalType.getSource(), expandedTypes);
            if (jSIntersectionTypeImpl == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(22);
            }
            return jSIntersectionTypeImpl;
        }
        JSType jSType = originalType;
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(23);
        }
        return jSType;
    }

    @Nullable
    private static JSType expandForSingleType(@NotNull JSResolvableType toApply, @Nullable JSGenericTypeImpl genericType, @NotNull Set<JSResolvedTypeId> expanded) {
        JSResolvedTypeInfo info;
        TypeScriptTypeAlias alias;
        if (toApply == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(24);
        }
        if (expanded == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(25);
        }
        if ((alias = (info = toApply.resolveType()).getDeclarationOfType(TypeScriptTypeAlias.class)) == null) {
            return toApply;
        }
        if (!TypeScriptTypeRelations.validateAliases(info, alias)) {
            return toApply;
        }
        JSType declaration = info.getAliasedType();
        if (declaration == null) {
            return toApply;
        }
        if (genericType != null) {
            JSTypeSubstitutor generics = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)alias, genericType);
            generics = generics == null ? null : generics.transformValues(type -> JSTypeUtils.getValuableType(type, false));
            declaration = JSTypeUtils.applyGenericArguments(declaration, generics);
        }
        if (!expanded.add(toApply.getResolvedTypeId())) {
            return null;
        }
        JSType afterProcessing = TypeScriptTypeRelations.expandAliasesRecursive(declaration, null, expanded);
        if (afterProcessing instanceof JSRecordType || afterProcessing instanceof TypeScriptMappedJSTypeImpl) {
            Object aliasType = toApply;
            if (genericType != null) {
                aliasType = new JSGenericTypeImpl(genericType.getSource(), (JSType)aliasType, genericType.getArguments());
            }
            return new JSAliasTypeImpl((JSType)aliasType, afterProcessing, afterProcessing.getSource());
        }
        return afterProcessing;
    }

    private static boolean validateAliases(@NotNull JSResolvedTypeInfo info, @NotNull TypeScriptTypeAlias alias) {
        if (info == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(26);
        }
        if (alias == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(27);
        }
        Collection<? extends PsiElement> declarations = info.getDeclarations();
        String name = alias.getName();
        return name != null && !declarations.stream().anyMatch(e -> !(e instanceof TypeScriptTypeAlias) || !name.equals(((TypeScriptTypeAlias)e).getName()));
    }

    @NotNull
    public static JSType filterType(@Nullable JSType type, @NotNull Predicate<? super JSType> filter, @NotNull PsiElement context) {
        if (filter == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(28);
        }
        if (context == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(29);
        }
        if (type == null) {
            TypeScriptNeverJSTypeImpl typeScriptNeverJSTypeImpl = new TypeScriptNeverJSTypeImpl(JSTypeSourceFactory.createTypeSource(context, true));
            if (typeScriptNeverJSTypeImpl == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(30);
            }
            return typeScriptNeverJSTypeImpl;
        }
        if (type instanceof JSCompositeTypeImpl) {
            List<JSType> types = ((JSCompositeTypeImpl)type).getTypes();
            List resultTypes = ContainerUtil.filter(types, el -> {
                if (filter == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(45);
                }
                return filter.apply(el);
            });
            if (types.size() == resultTypes.size()) {
                JSType jSType = type;
                if (jSType == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(31);
                }
                return jSType;
            }
            JSType jSType = TypeScriptTypeRelations.getUnionType(resultTypes, type.getSource());
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(32);
            }
            return jSType;
        }
        Object object = filter.apply((Object)type) ? type : new TypeScriptNeverJSTypeImpl(type.getSource());
        if (object == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(33);
        }
        return object;
    }

    @Contract(value="!null -> !null")
    public static JSType getAsUnionTypeIfEnumWithLiterals(@Nullable JSType type) {
        if (!(type instanceof JSResolvableType) || !type.isTypeScript()) {
            return type;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
        if (info.isEnumWithLiteralValues()) {
            return type.getLocalCachedType(() -> {
                JSType result2 = TypeScriptTypeRelations.createEnumValuesUnionType(type, info);
                return result2 == null ? type : result2;
            }, ENUM_VALUES_UNION_TYPE_KEY);
        }
        return type;
    }

    @NotNull
    public static JSType getUnionType(@NotNull Collection<? extends JSType> resultTypes, @NotNull JSTypeSource source) {
        if (resultTypes == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(34);
        }
        if (source == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(35);
        }
        JSType jSType = JSCompositeTypeImpl.getCommonType(resultTypes, source, true);
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(36);
        }
        return jSType;
    }

    @Contract(value="!null -> !null")
    public static JSType getRegularTypeOfLiteralType(@Nullable JSType valueType) {
        if (valueType instanceof JSWrapperType) {
            valueType = ((JSWrapperType)valueType).getOriginalType();
        }
        if ((valueType = TypeScriptTypeRelations.getCanonicalTypeForExoticLiterals(valueType)) instanceof JSLiteralType && ((JSLiteralType)valueType).allowWidening()) {
            return ((JSLiteralType)valueType).copyWithAllowWidening(false);
        }
        return valueType;
    }

    @Nullable
    public static JSType createEnumValuesUnionType(@NotNull JSType elementType, @NotNull JSResolvedTypeInfo resolvedType) {
        TypeScriptEnum enumDeclaration;
        if (elementType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(37);
        }
        if (resolvedType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(38);
        }
        if ((enumDeclaration = resolvedType.getDeclarationOfType(TypeScriptEnum.class)) == null) {
            return null;
        }
        JSField[] members = enumDeclaration.getFields();
        if (members.length == 0) {
            return null;
        }
        ArrayList combinedTypeMembers = ContainerUtil.newArrayListWithCapacity((int)members.length);
        for (JSField member : members) {
            combinedTypeMembers.add(JSNamedType.createType(elementType.getTypeText() + "." + member.getName(), JSTypeSourceFactory.createTypeSource((PsiElement)member, true), JSTypeContext.INSTANCE, false));
        }
        return new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)enumDeclaration, true), combinedTypeMembers);
    }

    @Nullable
    public static JSType getBestChoiceType(@Nullable JSType lType, @Nullable JSType rType, @NotNull PsiElement context) {
        if (context == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(39);
        }
        if (lType == null) {
            return rType;
        }
        if (rType == null) {
            return lType;
        }
        if (lType instanceof JSAnyType) {
            return TypeScriptTypeRelations.replaceTypeSourceByNotStrict(rType);
        }
        if (rType instanceof JSAnyType) {
            return TypeScriptTypeRelations.replaceTypeSourceByNotStrict(lType);
        }
        if (!DialectDetector.isTypeScript(context)) {
            return JSTypeUtils.getCommonType(lType, rType, DialectDetector.dialectOfElement(context), true);
        }
        ProcessingContext processingContext = JSTypeComparingContextService.getProcessingContextWithCache(context);
        boolean firstAssignableToSecond = TypeScriptTypeRelations.isTypeAssignableTo(lType, rType, processingContext);
        boolean secondAssignableToFirst = TypeScriptTypeRelations.isTypeAssignableTo(rType, lType, processingContext);
        if (secondAssignableToFirst && !firstAssignableToSecond) {
            return lType;
        }
        if (firstAssignableToSecond && !secondAssignableToFirst) {
            return rType;
        }
        processingContext.put(JSTypeComparingCache.SUBTYPING_CONTEXT, (Object)true);
        if (lType.isDirectlyAssignableType(rType, processingContext)) {
            return lType;
        }
        if (rType.isDirectlyAssignableType(lType, processingContext)) {
            return rType;
        }
        return JSTypeUtils.getCommonType(lType, rType, DialectDetector.dialectOfElement(context), true);
    }

    @NotNull
    private static JSType replaceTypeSourceByNotStrict(JSType partType) {
        JSType jSType = JSTypeUtils.copyWithStrictRecursive(partType, false);
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(40);
        }
        return jSType;
    }

    public static boolean checkEnumTypeForPrimitive(@NotNull JSResolvedTypeInfo resolvedType, @NotNull Class<?> primitiveClass) {
        TypeScriptEnumField field;
        if (resolvedType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(41);
        }
        if (primitiveClass == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(42);
        }
        if ((field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class)) == null) {
            return false;
        }
        EnumConstantValue value = field.getConstantValue();
        return primitiveClass.isInstance(value.getExpandedJSType(null));
    }

    public static boolean isNotNullInferredPrimitive(@Nullable JSType expressionJSType) {
        return TypeScriptTypeRelations.hasExplicitDecorators(expressionJSType, JSTypeGuardChecker.NOTNULL_PRIMITIVE);
    }

    public static boolean hasExplicitDecorators(@Nullable JSType expressionJSType, @NotNull Set<JSDecoratedType.TypeDecoration> decorators) {
        if (decorators == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(43);
        }
        if (expressionJSType instanceof JSUnionType) {
            List<JSType> types = ((JSUnionType)expressionJSType).getTypes();
            return types.size() > 0 && types.stream().allMatch(cur -> {
                if (decorators == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(44);
                }
                return TypeScriptTypeRelations.hasExplicitDecorators(cur, decorators);
            });
        }
        if (!(expressionJSType instanceof JSDecoratedType)) {
            return false;
        }
        JSDecoratedType decoratedType = (JSDecoratedType)expressionJSType;
        for (JSDecoratedType.TypeDecoration decorator : decorators) {
            if (decoratedType.hasDecorator(decorator)) continue;
            return false;
        }
        return true;
    }

    @Contract(value="!null->!null")
    public static JSType removeInferredDecorators(@Nullable JSType type) {
        if (type instanceof JSDecoratedType) {
            JSType original = ((JSDecoratedType)type).getOriginalType();
            Set decorations = ((JSDecoratedType)type).getDecorations();
            Set<JSDecoratedType.TypeDecoration> newDecorators = decorations.stream().filter(el -> el == JSDecoratedType.TypeDecoration.JSDOC_NULLABLE || el == JSDecoratedType.TypeDecoration.JSDOC_NOTNULL).collect(Collectors.toSet());
            return newDecorators.isEmpty() ? original : new JSDecoratedTypeImpl(type.getSource(), original, newDecorators);
        }
        if (type instanceof JSUnionType) {
            return ((JSUnionType)type).transformTypes((NullableFunction<? super JSType, JSType>)((NullableFunction)TypeScriptTypeRelations::removeInferredDecorators));
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtypingContext";
                break;
            }
            case 1: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 3: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 6: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeClass";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 17: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandedTypes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toApply";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expanded";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 28: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultTypes";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedType";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveClass";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "expandAliasesForGenericArguments";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeBy";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "filterType";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionType";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceTypeSourceByNotStrict";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTypeDerivedFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasBaseType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTypeSubtypeOf";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTypeSubsetOfUnionType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceOfOrUnionTypePart";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "expandAliasesForGenericArguments";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 40: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isInstantiable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "expandAliasesRecursive";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createTypeBy";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "expandForSingleType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "validateAliases";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "filterType";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getUnionType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createEnumValuesUnionType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getBestChoiceType";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkEnumTypeForPrimitive";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitDecorators";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasExplicitDecorators$15";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterType$13";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$expandAliasesRecursive$9";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isInstanceOfOrUnionTypePart$6";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$containsType$4";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasBaseType$2";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isTypeDerivedFrom$1";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isTypeDerivedFrom$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

