/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.PackageVersionRangeMatchRequest;
import com.intellij.javascript.nodejs.packageJson.PackageVersionRangeMatchResponse;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class PackageVersionRangeMatcher {
    private static final Logger LOG = Logger.getInstance(PackageVersionRangeMatcher.class);
    private static final long TOTAL_WAIT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private static volatile File WORKING_DIRECTORY;
    private static final Map<Key, Value> CACHE;

    private PackageVersionRangeMatcher() {
    }

    public static boolean isMatched(@NotNull NodeJsLocalInterpreter interpreter, @NotNull List<PackageVersionRangeMatchRequest> requests) {
        if (interpreter == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(0);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(1);
        }
        try {
            List<PackageVersionRangeMatchResponse> mismatches = PackageVersionRangeMatcher.findMismatches(requests, (ThrowableComputable<NodeJsInterpreter, ExecutionException>)((ThrowableComputable)() -> {
                if (interpreter == null) {
                    PackageVersionRangeMatcher.$$$reportNull$$$0(25);
                }
                return interpreter;
            }));
            return mismatches.isEmpty();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    @NotNull
    public static List<PackageVersionRangeMatchResponse> findMismatches(final @NotNull Project project, @NotNull List<PackageVersionRangeMatchRequest> requests) throws ExecutionException {
        if (project == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(2);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(3);
        }
        List<PackageVersionRangeMatchResponse> list = PackageVersionRangeMatcher.findMismatches(requests, new ThrowableComputable<NodeJsInterpreter, ExecutionException>(){

            public NodeJsInterpreter compute() throws ExecutionException {
                NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(project).getInterpreter();
                return NodeInterpreterUtil.getValidInterpreterOrThrow(interpreter);
            }
        });
        if (list == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> findMismatches(@NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull ThrowableComputable<NodeJsInterpreter, ExecutionException> interpreterComputable) throws ExecutionException {
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(5);
        }
        if (interpreterComputable == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(6);
        }
        RequestsAndResponses requestsAndResponses = PackageVersionRangeMatcher.getCached(requests);
        ArrayList responses = ContainerUtil.newArrayList();
        responses.addAll(requestsAndResponses.myCachedResponses);
        if (!requestsAndResponses.myRequestsToRun.isEmpty()) {
            responses.addAll(PackageVersionRangeMatcher.doMatch(requestsAndResponses.myRequestsToRun, interpreterComputable));
        }
        PackageVersionRangeMatcher.validateResponses(requests, responses);
        List list = ContainerUtil.filter((Collection)responses, response -> !response.isMatched() && !response.hasErrors());
        if (list == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static RequestsAndResponses getCached(@NotNull List<PackageVersionRangeMatchRequest> requests) {
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(8);
        }
        ArrayList responses = ContainerUtil.newArrayList();
        ArrayList requestsToRun = ContainerUtil.newArrayList();
        for (PackageVersionRangeMatchRequest request : requests) {
            Key key = new Key(request.getVersionRange(), request.getVersion());
            Value value = CACHE.get(key);
            if (value != null) {
                responses.add(new PackageVersionRangeMatchResponse(request, value.myMatched, value.myInvalidVersion, value.myInvalidVersionRange));
                continue;
            }
            requestsToRun.add(request);
        }
        RequestsAndResponses requestsAndResponses = new RequestsAndResponses(requestsToRun, responses);
        if (requestsAndResponses == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(9);
        }
        return requestsAndResponses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static List<PackageVersionRangeMatchResponse> doMatch(@NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull ThrowableComputable<NodeJsInterpreter, ExecutionException> interpreterComputable) throws ExecutionException {
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(10);
        }
        if (interpreterComputable == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(11);
        }
        Map<Key, Value> map = CACHE;
        // MONITORENTER : map
        ArrayList responses = ContainerUtil.newArrayList();
        RequestsAndResponses requestsAndResponses = PackageVersionRangeMatcher.getCached(requests);
        responses.addAll(requestsAndResponses.myCachedResponses);
        if (!requestsAndResponses.myRequestsToRun.isEmpty()) {
            List<PackageVersionRangeMatchResponse> result2 = PackageVersionRangeMatcher.run(requestsAndResponses.myRequestsToRun, (NodeJsInterpreter)interpreterComputable.compute());
            for (PackageVersionRangeMatchResponse response : result2) {
                CACHE.put(new Key(response.getRequest().getVersionRange(), response.getRequest().getVersion()), new Value(response.isMatched(), response.isInvalidVersion(), response.isInvalidVersionRange()));
            }
            responses.addAll(result2);
        }
        ArrayList arrayList = responses;
        // MONITOREXIT : map
        if (arrayList != null) return arrayList;
        PackageVersionRangeMatcher.$$$reportNull$$$0(12);
        return arrayList;
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> run(@NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull NodeJsInterpreter interpreter) throws ExecutionException {
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(13);
        }
        if (interpreter == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(14);
        }
        GeneralCommandLine commandLine = PackageVersionRangeMatcher.createCommandLine(interpreter, requests);
        long startNano = System.nanoTime();
        CapturingProcessHandler processHandler = NodeCommandLineUtil.createCapturingProcessHandler(commandLine);
        ProcessOutput output = processHandler.runProcess((int)TOTAL_WAIT_TIMEOUT_MILLIS, true);
        if (output.isTimeout()) {
            throw new ExecutionException("'" + commandLine.getCommandLineString() + "' command run is timed out (>" + TOTAL_WAIT_TIMEOUT_MILLIS + " ms)");
        }
        if (output.getExitCode() != 0) {
            throw new ExecutionException("Failed to run " + NodeCommandLineUtil.formatErrorMessage(commandLine, output));
        }
        List<PackageVersionRangeMatchResponse> result2 = PackageVersionRangeMatcher.parse(output.getStdout(), interpreter);
        PackageVersionRangeMatcher.validateResponses(requests, result2);
        LOG.info("Matching " + requests.size() + " done in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms");
        List<PackageVersionRangeMatchResponse> list = result2;
        if (list == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static void validateResponses(@NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull List<PackageVersionRangeMatchResponse> responses) throws ExecutionException {
        List processed;
        HashSet processedSet;
        HashSet<PackageVersionRangeMatchRequest> original;
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(16);
        }
        if (responses == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(17);
        }
        if (!(original = new HashSet<PackageVersionRangeMatchRequest>(requests)).equals(processedSet = new HashSet(processed = ContainerUtil.map(responses, response -> response.getRequest())))) {
            throw new ExecutionException("Responses do not match requests: requests: " + requests + ", responses: " + processed);
        }
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull NodeJsInterpreter interpreter, @NotNull List<PackageVersionRangeMatchRequest> requests) throws ExecutionException {
        if (interpreter == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(18);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(19);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.setWorkDirectory(PackageVersionRangeMatcher.getWorkingDirectory());
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.addParameter(HelperFilesLocator.resolvePathForExecution("package-version-range-matcher/bin/batch-matcher"));
        for (PackageVersionRangeMatchRequest request : requests) {
            commandLine.addParameter("--package");
            commandLine.addParameter(request.getPackageName());
            commandLine.addParameter(request.getVersionRange());
            commandLine.addParameter(request.getVersion());
        }
        NodeCommandLineConfigurator.find(interpreter).configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(20);
        }
        return generalCommandLine;
    }

    @NotNull
    private static File getWorkingDirectory() throws ExecutionException {
        File workingDirectory = WORKING_DIRECTORY;
        if (workingDirectory == null || !workingDirectory.isDirectory()) {
            try {
                WORKING_DIRECTORY = workingDirectory = FileUtil.createTempDirectory((String)"intellij-package-json-version-range-check", null, (boolean)true);
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        File file2 = workingDirectory;
        if (file2 == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(21);
        }
        return file2;
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> parse(@NotNull String content, @NotNull NodeJsInterpreter interpreter) throws ExecutionException {
        JsonArray array;
        if (content == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(22);
        }
        if (interpreter == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(23);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        try {
            array = JsonUtil.parseJsonArray((String)content);
        }
        catch (Exception e) {
            throw new ExecutionException("Cannot parse result from " + interpreter.getReferenceName() + ": " + content, (Throwable)e);
        }
        for (JsonElement element : array) {
            JsonObject obj = element.getAsJsonObject();
            String packageName = JsonUtil.getChildAsString((JsonObject)obj, (String)"packageName");
            String versionRange = JsonUtil.getChildAsString((JsonObject)obj, (String)"versionRange");
            String version = JsonUtil.getChildAsString((JsonObject)obj, (String)"version");
            Boolean matched = JsonUtil.getChildAsBooleanObj((JsonObject)obj, (String)"matched");
            boolean invalidVersion = JsonUtil.getChildAsBoolean((JsonObject)obj, (String)"invalidVersion", (boolean)false);
            boolean invalidVersionRange = JsonUtil.getChildAsBoolean((JsonObject)obj, (String)"invalidVersionRange", (boolean)false);
            if (invalidVersion || invalidVersionRange) {
                matched = false;
            }
            if (packageName == null || versionRange == null || version == null || matched == null) {
                throw new ExecutionException("packageName: " + packageName + ", versionRange: " + versionRange + ", version: " + version + ", matched: " + matched);
            }
            result2.add(new PackageVersionRangeMatchResponse(new PackageVersionRangeMatchRequest(packageName, versionRange, version), matched, invalidVersion, invalidVersionRange));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    static {
        CACHE = ContainerUtil.createConcurrentSoftMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 20: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 20: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 20: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterComputable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responses";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findMismatches";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCached";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doMatch";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMatched";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findMismatches";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 20: 
            case 21: 
            case 24: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCached";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doMatch";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "validateResponses";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isMatched$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 20: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RequestsAndResponses {
        public final List<PackageVersionRangeMatchRequest> myRequestsToRun;
        public final List<PackageVersionRangeMatchResponse> myCachedResponses;

        RequestsAndResponses(@NotNull List<PackageVersionRangeMatchRequest> requestsToRun, @NotNull List<PackageVersionRangeMatchResponse> cachedResponses) {
            if (requestsToRun == null) {
                RequestsAndResponses.$$$reportNull$$$0(0);
            }
            if (cachedResponses == null) {
                RequestsAndResponses.$$$reportNull$$$0(1);
            }
            this.myRequestsToRun = requestsToRun;
            this.myCachedResponses = cachedResponses;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "requestsToRun";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cachedResponses";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher$RequestsAndResponses";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Value {
        private final boolean myMatched;
        private final boolean myInvalidVersion;
        private final boolean myInvalidVersionRange;

        Value(boolean matched, boolean invalidVersion, boolean invalidVersionRange) {
            this.myMatched = matched;
            this.myInvalidVersion = invalidVersion;
            this.myInvalidVersionRange = invalidVersionRange;
        }
    }

    private static class Key {
        private final String myVersionRange;
        private final String myVersion;

        Key(@NotNull String versionRange, @NotNull String version) {
            if (versionRange == null) {
                Key.$$$reportNull$$$0(0);
            }
            if (version == null) {
                Key.$$$reportNull$$$0(1);
            }
            this.myVersionRange = versionRange;
            this.myVersion = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.myVersionRange.equals(key.myVersionRange) && this.myVersion.equals(key.myVersion);
        }

        public int hashCode() {
            int result2 = this.myVersionRange.hashCode();
            result2 = 31 * result2 + this.myVersion.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "versionRange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher$Key";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

