/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.IGlobalVariable;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class NthRefNode
extends Node
implements IGlobalVariable {
    private int matchNumber;

    public NthRefNode(SourcePosition position, int matchNumber) {
        super(position);
        this.matchNumber = matchNumber;
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        NthRefNode other = (NthRefNode)node;
        return this.isNameMatch(other.getName()) && this.getMatchNumber() == other.getMatchNumber();
    }

    public NodeType getNodeType() {
        return NodeType.NTHREFNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitNthRefNode(this);
    }

    public int getMatchNumber() {
        return this.matchNumber;
    }

    public String getName() {
        return "" + this.getMatchNumber();
    }

    public String getLexicalName() {
        return "$" + this.getName();
    }

    public void setName(String newName) {
        this.matchNumber = new Integer(newName);
    }

    public SourcePosition getNamePosition() {
        return this.getPosition().fromEnd(this.getName().length());
    }

    public SourcePosition getLexicalNamePosition() {
        return this.getPosition();
    }

    public boolean isNameMatch(String name) {
        return this.getName().equals(name);
    }
}

