/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.epp;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.puppet.epp.EppLanguage;
import com.intellij.lang.puppet.epp.elementTypes.EppElementTypes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EppFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    @NotNull
    private final Set<Language> myRelevantLanguages;
    @NotNull
    private final Language myTemplateDataLanguage;

    public EppFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            EppFileViewProvider.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            EppFileViewProvider.$$$reportNull$$$0(1);
        }
        super(manager, virtualFile, eventSystemEnabled);
        this.myRelevantLanguages = new THashSet();
        this.myTemplateDataLanguage = EppFileViewProvider.computeTemplateLanguage(virtualFile);
        this.myRelevantLanguages.add(this.getBaseLanguage());
        this.myRelevantLanguages.add(this.getTemplateDataLanguage());
    }

    @NotNull
    public static Language computeTemplateLanguage(@NotNull VirtualFile virtualFile) {
        FileType fileType;
        if (virtualFile == null) {
            EppFileViewProvider.$$$reportNull$$$0(2);
        }
        if (!((fileType = EppFileViewProvider.getTemplateFileType(virtualFile)) instanceof LanguageFileType)) {
            Language language = StdLanguages.TEXT;
            if (language == null) {
                EppFileViewProvider.$$$reportNull$$$0(3);
            }
            return language;
        }
        Language language = ((LanguageFileType)fileType).getLanguage();
        Language language2 = language instanceof TemplateLanguage ? StdLanguages.HTML : language;
        if (language2 == null) {
            EppFileViewProvider.$$$reportNull$$$0(4);
        }
        return language2;
    }

    @Nullable
    private static FileType getTemplateFileType(@Nullable VirtualFile virtualFile) {
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (virtualFile == null) {
            return null;
        }
        List nameChunks = StringUtil.split((String)virtualFile.getName(), (String)".");
        if (nameChunks.size() < 3) {
            return FileTypes.PLAIN_TEXT;
        }
        FileType fileType = fileTypeManager.getFileTypeByExtension((String)nameChunks.get(nameChunks.size() - 2));
        return fileType == UnknownFileType.INSTANCE ? FileTypes.PLAIN_TEXT : fileType;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        boolean isTemplateLanguage;
        if (lang == null) {
            EppFileViewProvider.$$$reportNull$$$0(5);
        }
        boolean bl = isTemplateLanguage = lang == this.getTemplateDataLanguage();
        if (lang != this.getBaseLanguage() && !isTemplateLanguage) {
            return null;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition == null) {
            return null;
        }
        PsiFile psiFile = parserDefinition.createFile((FileViewProvider)this);
        if (isTemplateLanguage && psiFile instanceof PsiFileImpl) {
            ((PsiFileImpl)psiFile).setContentElementType(EppElementTypes.EPP_TEMPLATE_DATA);
        }
        return psiFile;
    }

    @NotNull
    public Language getBaseLanguage() {
        EppLanguage eppLanguage = EppLanguage.INSTANCE;
        if (eppLanguage == null) {
            EppFileViewProvider.$$$reportNull$$$0(6);
        }
        return eppLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = this.myRelevantLanguages;
        if (set == null) {
            EppFileViewProvider.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            EppFileViewProvider.$$$reportNull$$$0(8);
        }
        return language;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        if (fileCopy == null) {
            EppFileViewProvider.$$$reportNull$$$0(9);
        }
        EppFileViewProvider eppFileViewProvider = new EppFileViewProvider((PsiManager)this.getManager(), fileCopy, false);
        if (eppFileViewProvider == null) {
            EppFileViewProvider.$$$reportNull$$$0(10);
        }
        return eppFileViewProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/epp/EppFileViewProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/epp/EppFileViewProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTemplateLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateLanguage";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

