/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import b.h.la;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.SdkRefresher;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherBase;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.ConfiguredRvmSdk;
import org.jetbrains.plugins.ruby.version.management.rvm.LocalRvmPathsSettings;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmVersionManagerHandler;

public final class RvmSdkRefresher
extends SdkRefresherBase {
    public static final Object REQUESTOR;
    @NonNls
    public static final String RUBY_GEMSET_FILE_NAME = ".ruby-gemset";
    @NonNls
    public static final String RUBY_VERSION_FILE_NAME = ".ruby-version";
    @NonNls
    public static final String RVMRC_FILE_NAME = ".rvmrc";
    private static final Logger k;
    @NonNls
    private static final String r = "RVM Support";
    private static final Pattern m;
    private static final Pattern j;
    private static final Pattern f;
    private static final Pattern q;
    @NonNls
    private static final String l = ".versions.conf";
    public static final Set<String> VERSION_CONFIG_FILE_NAMES;
    private static final Set<String> h;
    private static final Set<String> p;
    private static final Key<String> n;
    @NotNull
    private final Map<Project, VirtualFileListener> g = Maps.newConcurrentMap();
    private final LocalRvmPathsSettings i = LocalRvmPathsSettings.getInstance();
    private AtomicNullableLazyValue<RvmVersionManagerHandler.RvmEnvironment> o;
    private static final long v;

    public RvmSdkRefresher() {
        this.c();
    }

    @Override
    @Nullable
    public String suggestSdkName(@NotNull String executablePath, @NotNull String sdkHomePath, @NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        long l2 = v ^ 0x2FF4716F73CL;
        if (executablePath == null) {
            RvmSdkRefresher.d(0);
        }
        if (sdkHomePath == null) {
            RvmSdkRefresher.d(1);
        }
        if (versionManagerSdkAdditionalData == null) {
            RvmSdkRefresher.d(2);
        }
        if (!(versionManagerSdkAdditionalData instanceof RvmSdkData)) {
            return null;
        }
        String string = "RVM: " + sdkHomePath;
        String string2 = ((RvmSdkData)versionManagerSdkAdditionalData).getGemsetName();
        if (!StringUtil.isEmpty((String)string2)) {
            return string + RVMSupportUtil.getGemsetSuffix(string2);
        }
        return string;
    }

    @Override
    public void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            RvmSdkRefresher.d(3);
        }
        RvmrcWatcher rvmrcWatcher = new RvmrcWatcher(project, this.i);
        this.g.put(project, rvmrcWatcher);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)rvmrcWatcher);
        RvmSdkRefresher.a(project, this.i);
    }

    @Override
    public void onProjectClosed(@NotNull Project project) {
        if (project == null) {
            RvmSdkRefresher.d(4);
        }
        VirtualFileListener virtualFileListener = this.g.remove(project);
        assert (virtualFileListener != null);
        VirtualFileManager.getInstance().removeVirtualFileListener(virtualFileListener);
    }

    @Override
    @NotNull
    protected List<String> getPossibleVersionManagersPaths() {
        List list2 = ContainerUtil.map(RvmVersionManagerHandler.RVM_SEARCH_PATHS_LIST, string -> Paths.get(string, this.getVersionManagerHandler().getVersionManagerExecutableName()).toString());
        if (list2 == null) {
            RvmSdkRefresher.d(5);
        }
        return list2;
    }

    private void c() {
        this.o = AtomicNullableLazyValue.createValue(() -> RvmVersionManagerHandler.RvmEnvironment.compute(this.getVersionManagerPath(), RubyLocalRunner.getRunner(null)));
    }

    @Nullable
    private RvmVersionManagerHandler.RvmEnvironment d() {
        return (RvmVersionManagerHandler.RvmEnvironment)Objects.requireNonNull(this.o).getValue();
    }

    @Override
    @NotNull
    protected List<String> getInstallationsRootsPathNames() {
        RvmVersionManagerHandler.RvmEnvironment rvmEnvironment = this.d();
        List<String> list2 = rvmEnvironment == null ? Collections.emptyList() : Collections.singletonList(rvmEnvironment.getGemsPath());
        if (list2 == null) {
            RvmSdkRefresher.d(6);
        }
        return list2;
    }

    @Override
    @NotNull
    protected Stream<? extends RubySdkInfo> getSdkInfosForInterpreterHome(@NotNull String versionManagerPathName, @NotNull VirtualFile interpreterHome) {
        String string;
        long l2 = v ^ 0x340040459556L;
        if (versionManagerPathName == null) {
            RvmSdkRefresher.d(7);
        }
        if (interpreterHome == null) {
            RvmSdkRefresher.d(8);
        }
        if (p.contains(string = interpreterHome.getName())) {
            this.myLog.debug("Skipping directory: " + string);
            Stream stream2 = Stream.empty();
            if (stream2 == null) {
                RvmSdkRefresher.d(9);
            }
            return stream2;
        }
        RvmVersionManagerHandler.RvmEnvironment rvmEnvironment = this.d();
        if (rvmEnvironment == null) {
            this.myLog.debug("Something is wrong, environment is empty");
            Stream stream3 = Stream.empty();
            if (stream3 == null) {
                RvmSdkRefresher.d(10);
            }
            return stream3;
        }
        ArrayList arrayList = new ArrayList(StringUtil.split((String)string, (String)"@", (boolean)true));
        String string2 = (String)arrayList.remove(0);
        VirtualFile virtualFile = VfsUtil.findRelativeFile((VirtualFile)rvmEnvironment.getRubiesVirtualFile(), (String[])new String[]{string2});
        if (virtualFile == null) {
            this.myLog.debug("Unable to find interpreter home: [gem home: " + interpreterHome + "; interpreter name: " + string2 + "; rubies home: " + rvmEnvironment.getRubiesVirtualFile() + "]");
            Stream stream4 = Stream.empty();
            if (stream4 == null) {
                RvmSdkRefresher.d(11);
            }
            return stream4;
        }
        Stream<RubySdkInfo> stream5 = Stream.of(new RubySdkInfo(versionManagerPathName, virtualFile, arrayList.isEmpty() ? null : (String)arrayList.get(0)));
        if (stream5 == null) {
            RvmSdkRefresher.d(12);
        }
        return stream5;
    }

    @Override
    @NotNull
    protected Set<? extends RubySdkInfo> getSdkInfos() {
        this.c();
        Set<? extends RubySdkInfo> set = super.getSdkInfos();
        if (set == null) {
            RvmSdkRefresher.d(13);
        }
        return set;
    }

    public static void updateRVMSdks() {
        SdkRefresher.getRefreshers().stream().filter(sdkRefresher -> sdkRefresher instanceof RvmSdkRefresher).forEach(SdkRefresher::refreshSDKs);
    }

    public static boolean applySdkToRubyVersionFile(@NotNull Module module, @NotNull String gemset, @NotNull String sdkVersion) throws IOException {
        VirtualFile virtualFile;
        long l2 = v ^ 0x83CBAA0CD8AL;
        if (module == null) {
            RvmSdkRefresher.d(14);
        }
        if (gemset == null) {
            RvmSdkRefresher.d(15);
        }
        if (sdkVersion == null) {
            RvmSdkRefresher.d(16);
        }
        if ((virtualFile = RModuleUtil.getInstance().getFirstContentRoot(module)) == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile.findOrCreateChildData((Object)virtualFile, RUBY_VERSION_FILE_NAME);
        LoadTextUtil.write((Project)module.getProject(), (VirtualFile)virtualFile2, (Object)REQUESTOR, (String)sdkVersion, (long)-1L);
        VirtualFile virtualFile3 = virtualFile.findOrCreateChildData((Object)virtualFile, RUBY_GEMSET_FILE_NAME);
        LoadTextUtil.write((Project)module.getProject(), (VirtualFile)virtualFile3, (Object)new Object(), (String)gemset, (long)-1L);
        return true;
    }

    @Nullable
    public static String getVersion(@NotNull Sdk sdk) {
        String string;
        if (sdk == null) {
            RvmSdkRefresher.d(17);
        }
        if (RVMSupportUtil.isRVMInterpreter(sdk) && (string = RVMSupportUtil.getRVMSdkVersion(sdk)) != null) {
            return string;
        }
        if (RbenvGemsetManager.isRbenvSdk(sdk) && (string = RbenvGemsetManager.getSdkVersion(sdk)) != null) {
            return string;
        }
        return null;
    }

    public static void createRVMGemset(@Nullable Project project, @NotNull Sdk rootRVMSdk, @NotNull String gemset, @NotNull NullableConsumer<? super Sdk> postAction) {
        if (rootRVMSdk == null) {
            RvmSdkRefresher.d(18);
        }
        if (gemset == null) {
            RvmSdkRefresher.d(19);
        }
        if (postAction == null) {
            RvmSdkRefresher.d(20);
        }
        MultiMap multiMap = new MultiMap();
        multiMap.putValue((Object)rootRVMSdk, (Object)gemset);
        RvmSdkRefresher.createRVMGemsets(project, (MultiMap<Sdk, String>)multiMap, postAction);
    }

    public static void createRVMGemsets(@Nullable Project project, final @NotNull MultiMap<Sdk, String> rootRVMSdkToNewGemsets, @NotNull NullableConsumer<? super Sdk> postAction) {
        long l2 = v ^ 0x22A21D24AA9EL;
        if (rootRVMSdkToNewGemsets == null) {
            RvmSdkRefresher.d(21);
        }
        if (postAction == null) {
            RvmSdkRefresher.d(22);
        }
        final PairConsumer pairConsumer = (sdk, string) -> {
            long l2 = v ^ 0x16C6689732ADL;
            if (postAction == null) {
                RvmSdkRefresher.d(42);
            }
            RubyRunner rubyRunner = RunnerUtil.getRunner(sdk, null);
            VirtualFile virtualFile = LocalRvmPathsSettings.getInstance().getRvmExecutable();
            if (virtualFile == null) {
                return;
            }
            String string2 = virtualFile.getCanonicalPath();
            if (string2 == null) {
                return;
            }
            try {
                String string3 = RvmSdkRefresher.getVersion(sdk);
                rubyRunner.execute((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(sdk, string2, string3, "gemset", "create", string).withProject(project)).inSameThread(Registry.intValue((String)"command.line.execution.timeout")));
                VirtualFile virtualFile2 = LocalRvmPathsSettings.getInstance().getGemsFolder();
                VirtualFile virtualFile3 = LocalRvmPathsSettings.getInstance().getInterpretersFolder();
                if (virtualFile2 == null || virtualFile3 == null) {
                    return;
                }
                RefreshQueue.getInstance().refresh(false, false, () -> {
                    if (postAction == null) {
                        RvmSdkRefresher.d(43);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (postAction == null) {
                            RvmSdkRefresher.d(44);
                        }
                        RvmSdkRefresher.updateRVMSdks();
                        postAction.consume((Object)RVMSupportUtil.findRVMGemsetSdk(sdk, string));
                    });
                }, new VirtualFile[]{virtualFile2, virtualFile3});
            }
            catch (ExecutionException executionException) {
                k.error("Cannot create rvm gemset; " + executionException.getMessage());
            }
        };
        Task.Backgroundable backgroundable = new Task.Backgroundable(project, RBundle.message((String)"new.project.wizard.rvm.gemset.create.gemsets.title"), false){
            private static final long a = la.a(-8357812682757166361L, 7461776889541538538L, MethodHandles.lookup().lookupClass()).a(128676734676954L);

            public void run(@NotNull ProgressIndicator indicator) {
                long l2 = a ^ 0x6561049FEE95L;
                if (indicator == null) {
                    1.a(0);
                }
                int n2 = rootRVMSdkToNewGemsets.values().size();
                int n3 = 0;
                indicator.setIndeterminate(false);
                for (Sdk sdk : rootRVMSdkToNewGemsets.keySet()) {
                    for (String string : rootRVMSdkToNewGemsets.get((Object)sdk)) {
                        indicator.setFraction((double)n3++ / (double)n2);
                        indicator.setText(RBundle.message((String)"new.project.wizard.rvm.gemset.create.title", (Object[])new Object[]{RvmSdkRefresher.getVersion(sdk) + '@' + string}));
                        pairConsumer.consume((Object)sdk, (Object)string);
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x55F0A47FFC5AL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkRefresher$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)backgroundable);
    }

    public static boolean applyGemsetToConfig(@NotNull Module module, @NotNull String gemset, @NotNull String sdkVersion) {
        if (module == null) {
            RvmSdkRefresher.d(23);
        }
        if (gemset == null) {
            RvmSdkRefresher.d(24);
        }
        if (sdkVersion == null) {
            RvmSdkRefresher.d(25);
        }
        return (Boolean)WriteAction.compute(() -> {
            long l2 = v ^ 0x14196B5726B7L;
            if (module == null) {
                RvmSdkRefresher.d(39);
            }
            if (gemset == null) {
                RvmSdkRefresher.d(40);
            }
            if (sdkVersion == null) {
                RvmSdkRefresher.d(41);
            }
            try {
                return RvmSdkRefresher.applySdkToRubyVersionFile(module, gemset, sdkVersion);
            }
            catch (IOException iOException) {
                k.error("Cannot apply " + sdkVersion + " version to rvm 'version' config file. " + iOException.getMessage());
                return false;
            }
        });
    }

    @Nullable
    public static String loadText(@NotNull VirtualFile file) {
        if (file == null) {
            RvmSdkRefresher.d(26);
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)file);
        }
        catch (IOException iOException) {
            k.warn((Throwable)iOException);
            return null;
        }
    }

    @NotNull
    public static String getRvmRubyDistName(@NotNull VirtualFile rubyInterpreter) {
        if (rubyInterpreter == null) {
            RvmSdkRefresher.d(27);
        }
        VirtualFile virtualFile = rubyInterpreter.getParent();
        VirtualFile virtualFile2 = virtualFile.getParent();
        String string = virtualFile2.getName();
        if (string == null) {
            RvmSdkRefresher.d(28);
        }
        return string;
    }

    private static boolean a(@Nullable String string) {
        return h.contains(string);
    }

    private static void a(@NotNull Project project, final @NotNull LocalRvmPathsSettings localRvmPathsSettings) {
        long l2 = v ^ 0xF84389FDE4CL;
        if (project == null) {
            RvmSdkRefresher.d(29);
        }
        if (localRvmPathsSettings == null) {
            RvmSdkRefresher.d(30);
        }
        if (!localRvmPathsSettings.isRvmSupportEnabled()) {
            return;
        }
        Module[] moduleArray = RModuleUtil.getInstance().getAllModulesWithRubySupport(project);
        if (moduleArray.length == 0) {
            return;
        }
        NotNullLazyValue<RVMSupportUtil.RubyDistToGemsetTable> notNullLazyValue = new NotNullLazyValue<RVMSupportUtil.RubyDistToGemsetTable>(){
            private static final long a = la.a(5526646338398300492L, -6731533055373853767L, MethodHandles.lookup().lookupClass()).a(220186198053588L);

            @NotNull
            protected RVMSupportUtil.RubyDistToGemsetTable compute() {
                RVMSupportUtil.RubyDistToGemsetTable rubyDistToGemsetTable = RvmSdkRefresher.a(localRvmPathsSettings);
                if (rubyDistToGemsetTable == null) {
                    2.a(0);
                }
                return rubyDistToGemsetTable;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0xC7B9FC70652L;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkRefresher$2", "compute"));
            }
        };
        for (Module module : moduleArray) {
            Project project2;
            String string;
            String string2;
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            if (!RVMSupportUtil.isRVMInterpreter(sdk)) continue;
            if (RubyRemoteInterpreterManager.getInstance().isRemoteSdk(sdk)) {
                k.debug(module.getName() + " configured to use remote sdk thus let's ignore rvm config file");
                continue;
            }
            ConfiguredRvmSdk configuredRvmSdk = RvmSdkRefresher.readSdkRefAndGemset(module);
            if (configuredRvmSdk == null || ((RVMSupportUtil.RubyDistToGemsetTable)notNullLazyValue.getValue()).isEmpty()) continue;
            String string3 = RVMSupportUtil.determineSuitableRVMSdkDist(configuredRvmSdk.getSdkDistName(), configuredRvmSdk.getGemset(), (RVMSupportUtil.RubyDistToGemsetTable)notNullLazyValue.getValue());
            if (string3 == null) {
                string2 = RBundle.message((String)"rvm.rvmrc.project.cannot.find.sdk.message", (Object[])new Object[]{configuredRvmSdk.getSdkFullName()});
                if (!StringUtil.equals((CharSequence)((CharSequence)module.getUserData(n)), (CharSequence)string2)) {
                    string = new Notification(r, RBundle.message((String)"rvm.rvmrc.project.notifications.title", (Object[])new Object[]{configuredRvmSdk.getSource()}), string2, NotificationType.WARNING);
                    Notifications.Bus.notify((Notification)string, (Project)project);
                    k.warn("Cannot find RVM '" + configuredRvmSdk.getSdkFullName() + "' sdk");
                }
                module.putUserData(n, (Object)string2);
                continue;
            }
            if (string3.equals(RVMSupportUtil.getRVMSdkDistName(sdk))) {
                return;
            }
            string2 = RVMSupportUtil.findSdkBy(string3, configuredRvmSdk.getGemset());
            if (string2 != null) {
                boolean bl2 = RModuleUtil.getInstance().changeModuleSdk((Sdk)string2, module);
                if (!bl2) continue;
                project2 = module.getProject();
                String string4 = PlatformUtils.isRubyMine() ? project2.getName() : module.getName();
                Notification notification = new Notification(r, RBundle.message((String)"rvm.rvmrc.project.notifications.title", (Object[])new Object[]{configuredRvmSdk.getSource()}), RBundle.message((String)"rvm.rvmrc.project.sdk.changed.message", (Object[])new Object[]{string4, configuredRvmSdk.getSource(), string2.getName()}), NotificationType.INFORMATION);
                Notifications.Bus.notify((Notification)notification, (Project)project2);
                module.putUserData(n, (Object)"");
                GemManager.addGemsForSdk((Sdk)string2);
                continue;
            }
            string = RBundle.message((String)"rvm.rvmrc.project.cannot.find.gemset.for.sdk.message", (Object[])new Object[]{configuredRvmSdk.getGemset(), configuredRvmSdk.getSdkDistName(), ApplicationNamesInfo.getInstance().getProductName()});
            if (StringUtil.equals((CharSequence)((CharSequence)module.getUserData(n)), (CharSequence)string)) continue;
            project2 = new Notification(r, RBundle.message((String)"rvm.rvmrc.project.notifications.title", (Object[])new Object[]{configuredRvmSdk.getSource()}), string, NotificationType.WARNING);
            Notifications.Bus.notify((Notification)project2, (Project)project);
            k.warn("Cannot find gemset '" + configuredRvmSdk.getGemset() + "' for dist: '" + string3 + "'");
            module.putUserData(n, (Object)string);
        }
    }

    @Nullable
    public static ConfiguredRvmSdk readSdkRefAndGemset(@NotNull Module module) {
        VirtualFile[] virtualFileArray;
        long l2 = v ^ 0x4F80FC1CDD4DL;
        if (module == null) {
            RvmSdkRefresher.d(31);
        }
        for (VirtualFile virtualFile : virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            VirtualFile virtualFile2 = virtualFile.findChild(RVMRC_FILE_NAME);
            if (virtualFile2 != null) {
                return RvmSdkRefresher.b(virtualFile2);
            }
            VirtualFile virtualFile3 = virtualFile.findChild(RUBY_VERSION_FILE_NAME);
            VirtualFile virtualFile4 = virtualFile.findChild(RUBY_GEMSET_FILE_NAME);
            if (virtualFile3 != null) {
                return RvmSdkRefresher.a(virtualFile3, virtualFile4);
            }
            VirtualFile virtualFile5 = virtualFile.findChild(l);
            if (virtualFile5 == null) continue;
            return RvmSdkRefresher.a(virtualFile5);
        }
        return null;
    }

    @Nullable
    private static ConfiguredRvmSdk a(@NotNull VirtualFile virtualFile) {
        long l2 = v ^ 0x41DCA1B7E86EL;
        if (virtualFile == null) {
            RvmSdkRefresher.d(32);
        }
        k.debug("Extracting ruby and gemset from " + virtualFile.getPath());
        String string = RvmSdkRefresher.loadText(virtualFile);
        if (StringUtil.isEmptyOrSpaces((String)string)) {
            return null;
        }
        Matcher matcher = f.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1).trim();
            Matcher matcher2 = q.matcher(string);
            return new ConfiguredRvmSdk(string2, matcher2.find() ? matcher2.group(1).trim() : null, l);
        }
        k.warn("unable to find sdk definition in " + virtualFile.getPath());
        return null;
    }

    @Nullable
    private static ConfiguredRvmSdk a(@NotNull VirtualFile virtualFile, @Nullable VirtualFile virtualFile2) {
        long l2 = v ^ 0x30CAB67D3B41L;
        if (virtualFile == null) {
            RvmSdkRefresher.d(33);
        }
        k.debug("Extracting ruby and gemset from " + virtualFile.getPath());
        String string = RvmSdkRefresher.b(RvmSdkRefresher.loadText(virtualFile));
        if (string == null) {
            return null;
        }
        if (virtualFile2 != null) {
            String string2 = RvmSdkRefresher.b(RvmSdkRefresher.loadText(virtualFile2));
            return new ConfiguredRvmSdk(string, string2, RUBY_VERSION_FILE_NAME);
        }
        return RVMSupportUtil.splitToRVMDistAndGemset(string, RUBY_VERSION_FILE_NAME);
    }

    @Nullable
    private static String b(@Nullable String string) {
        long l2 = v ^ 0x2FDE21B74AC7L;
        if (string == null) {
            return null;
        }
        String string2 = string.replaceAll("\n|\r", "").trim();
        if (StringUtil.isEmptyOrSpaces((String)string2)) {
            return null;
        }
        return string2;
    }

    @Nullable
    private static ConfiguredRvmSdk b(@NotNull VirtualFile virtualFile) {
        long l2 = v ^ 0x76409D31A81CL;
        if (virtualFile == null) {
            RvmSdkRefresher.d(34);
        }
        k.debug("Extracting ruby and gemset from " + virtualFile.getPath());
        String string = RvmSdkRefresher.loadText(virtualFile);
        if (!StringUtil.isEmpty((String)string)) {
            Object object;
            Matcher matcher;
            Matcher matcher2 = m.matcher(string);
            if (matcher2.find()) {
                matcher = matcher2;
            } else {
                object = j.matcher(string);
                Matcher matcher3 = matcher = ((Matcher)object).find() ? object : null;
            }
            if (matcher != null) {
                object = StringUtil.unquoteString((String)matcher.group(1).replace('\'', '\"').replace(";", ""));
                if (((String)object).startsWith("$")) {
                    object = RvmSdkRefresher.a(string, (String)object);
                }
            } else {
                object = RvmSdkRefresher.a(string, "$environment_id");
            }
            if (object != null) {
                return RVMSupportUtil.splitToRVMDistAndGemset((String)object, RVMRC_FILE_NAME);
            }
        }
        return null;
    }

    private static String a(String string, String string2) {
        long l2 = v ^ 0x10B96AB8E8FCL;
        try {
            Pattern pattern = Pattern.compile("^\\s*" + string2.substring(1) + "\\s*=\\s*(\\S*);?$", 8);
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                return StringUtil.unquoteString((String)matcher.group(1).replace('\'', '\"').replace(";", ""));
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    private static RVMSupportUtil.RubyDistToGemsetTable a(@NotNull LocalRvmPathsSettings localRvmPathsSettings) {
        if (localRvmPathsSettings == null) {
            RvmSdkRefresher.d(35);
        }
        if (SystemInfo.isUnix) {
            RVMSupportUtil.RubyDistToGemsetTable rubyDistToGemsetTable = RVMSupportUtil.getInterpreterDistName2GemSetsTable(localRvmPathsSettings.getInterpretersFolder(), localRvmPathsSettings.getGemsFolder());
            if (rubyDistToGemsetTable == null) {
                RvmSdkRefresher.d(36);
            }
            return rubyDistToGemsetTable;
        }
        RVMSupportUtil.RubyDistToGemsetTable rubyDistToGemsetTable = RVMSupportUtil.RubyDistToGemsetTable.emptyTable();
        if (rubyDistToGemsetTable == null) {
            RvmSdkRefresher.d(37);
        }
        return rubyDistToGemsetTable;
    }

    @Override
    @NotNull
    public RvmVersionManagerHandler getVersionManagerHandler() {
        RvmVersionManagerHandler rvmVersionManagerHandler = RvmVersionManagerHandler.getInstance();
        if (rvmVersionManagerHandler == null) {
            RvmSdkRefresher.d(38);
        }
        return rvmVersionManagerHandler;
    }

    static {
        v = la.a(1706727953809578194L, 3587236809557286518L, MethodHandles.lookup().lookupClass()).a(90349650917069L);
        long l2 = v ^ 0x279CCCCE4681L;
        REQUESTOR = new Object();
        k = Logger.getInstance(RvmSdkRefresher.class);
        m = Pattern.compile("(?:^|.*\\n)\\s*rvm\\s(?:.+[\\t ])?use\\s+(?:\\-\\-?\\w+\\s+)*(system|\\S*)?(\\s|;|$)");
        j = Pattern.compile("(?:^|.*\\n)\\s*rvm\\s+(?:\\-\\-?\\w+\\s+)*(system|\\S*)?(\\s|;|$)");
        f = Pattern.compile("^ruby=(.+)$", 8);
        q = Pattern.compile("^ruby-gemset=(.+)$", 8);
        VERSION_CONFIG_FILE_NAMES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{l, RUBY_VERSION_FILE_NAME}));
        h = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{RVMRC_FILE_NAME, l, RUBY_VERSION_FILE_NAME, RUBY_GEMSET_FILE_NAME}));
        p = ContainerUtil.newHashSet((Object[])new String[]{"default", "cache"});
        n = Key.create((String)"SDK warning message");
        NotificationGroup.balloonGroup((String)r);
    }

    private static /* synthetic */ void d(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = v ^ 0x739BD0E3CF85L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 36: 
            case 37: 
            case 38: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerSdkAdditionalData";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkRefresher";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPathName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterHome";
                break;
            }
            case 14: 
            case 23: 
            case 31: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: 
            case 19: 
            case 24: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemset";
                break;
            }
            case 16: 
            case 25: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkVersion";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootRVMSdk";
                break;
            }
            case 20: 
            case 22: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postAction";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootRVMSdkToNewGemsets";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyInterpreter";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myProject";
                break;
            }
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmPathsSettings";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionsConf";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyVersion";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRvmrc";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkRefresher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleVersionManagersPaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallationsRootsPathNames";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkInfos";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRvmRubyDistName";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterDistName2GemSetsTable";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerHandler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpened";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onProjectClosed";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "applySdkToRubyVersionFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createRVMGemset";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createRVMGemsets";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "applyGemsetToConfig";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRvmRubyDistName";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "applyRvmRCToModule";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "readSdkRefAndGemset";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "extractConfigFromVersionsConf";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "extractConfigFromRubyVersion";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "extractConfigFromRvmrc";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterDistName2GemSetsTable";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyGemsetToConfig$6";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRVMGemsets$5";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RvmrcWatcher
    implements VirtualFileListener {
        @NotNull
        final Project myProject;
        @NotNull
        private final LocalRvmPathsSettings a;
        private static final long b = la.a(5905769704040674381L, 6156429949809877748L, MethodHandles.lookup().lookupClass()).a(86393580697665L);

        private RvmrcWatcher(@NotNull Project project, @NotNull LocalRvmPathsSettings rvmPathsSettings) {
            if (project == null) {
                RvmrcWatcher.a(0);
            }
            if (rvmPathsSettings == null) {
                RvmrcWatcher.a(1);
            }
            this.myProject = project;
            this.a = rvmPathsSettings;
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                RvmrcWatcher.a(2);
            }
            if (REQUESTOR == event.getRequestor()) {
                return;
            }
            this.a(event.getFile());
        }

        private void a(@NotNull VirtualFile virtualFile) {
            long l2 = b ^ 0x45B53F11458BL;
            if (virtualFile == null) {
                RvmrcWatcher.a(3);
            }
            if (virtualFile.isDirectory()) {
                return;
            }
            if (!RvmSdkRefresher.a(virtualFile.getName())) {
                return;
            }
            k.debug("It looks like rvm config file (" + virtualFile.getPath() + ") has been changed (or created), let's update sdk for the project (" + this.myProject + ")");
            RvmSdkRefresher.a(this.myProject, this.a);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = b ^ 0x4532A287D18FL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rvmPathsSettings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkRefresher$RvmrcWatcher";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateSelectedSdkIfNeeded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

