/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.hash;

import b.h.la;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.hash.RubyHashTypeChecker;
import org.jetbrains.plugins.ruby.ruby.inspections.hash.RubyHashUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.hash.RubyRemoveHashKeyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;

public class RubyDuplicatedKeysInHashInspection
extends RubyInspection {
    public static final String SHORT_NAME = "RubyDuplicatedKeysInHashInspection";
    private static final long a = la.a(2243491300924028365L, -4037340774397729470L, MethodHandles.lookup().lookupClass()).a(116628856017487L);

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = a ^ 0x5A15E92F8790L;
        String string = RBundle.message((String)"inspection.duplicated.keys.in.hash");
        if (string == null) {
            RubyDuplicatedKeysInHashInspection.b(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        long l2 = a ^ 0xCF1A015D92CL;
        if (SHORT_NAME == null) {
            RubyDuplicatedKeysInHashInspection.b(1);
        }
        return SHORT_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyDuplicatedKeysInHashInspection.b(2);
        }
        DuplicateKeysInHashVisitor duplicateKeysInHashVisitor = new DuplicateKeysInHashVisitor(holder);
        if (duplicateKeysInHashVisitor == null) {
            RubyDuplicatedKeysInHashInspection.b(3);
        }
        return duplicateKeysInHashVisitor;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x1DBB1671DBD9L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyDuplicatedKeysInHashInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyDuplicatedKeysInHashInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class HashChecker {
        private final List<? extends RubyHashTypeChecker> a;

        HashChecker(boolean isAssocChecker) {
            ArrayList<? extends RubyHashTypeChecker> arrayList = new ArrayList<RubyHashTypeChecker>();
            arrayList.add(new RubyHashTypeChecker(){

                @Override
                public boolean isInstance(RPsiElement element) {
                    return element instanceof RLiteral;
                }

                @Override
                public String getElementText(RPsiElement element) {
                    return ((RLiteral)element).getContent();
                }
            });
            if (isAssocChecker) {
                arrayList.add(new RubyHashTypeChecker(){

                    @Override
                    public boolean isInstance(RPsiElement element) {
                        return element instanceof RSymbol || element instanceof RAssocKey;
                    }

                    @Override
                    public String getElementText(RPsiElement element) {
                        if (element instanceof RSymbol) {
                            return ((RSymbol)element).getContent().getText();
                        }
                        return element.getName();
                    }
                });
            } else {
                arrayList.add(new RubyHashTypeChecker(){

                    @Override
                    public boolean isInstance(RPsiElement element) {
                        return element instanceof RSymbol;
                    }

                    @Override
                    public String getElementText(RPsiElement element) {
                        return ((RSymbol)element).getContent().getText();
                    }
                });
            }
            this.a = arrayList;
        }

        public boolean acceptElement(RPsiElement element) {
            boolean bl2 = false;
            for (RubyHashTypeChecker rubyHashTypeChecker : this.a) {
                if (!rubyHashTypeChecker.isInstance(element)) continue;
                rubyHashTypeChecker.put(element);
                bl2 = true;
            }
            return bl2;
        }

        public boolean checkElementCount(RPsiElement element) {
            for (RubyHashTypeChecker rubyHashTypeChecker : this.a) {
                if (!rubyHashTypeChecker.isInstance(element)) continue;
                return rubyHashTypeChecker.get(element) > 1;
            }
            return false;
        }
    }

    private static class DuplicateKeysInHashVisitor
    extends RubyInspectionVisitor {
        private static final long b = la.a(7505435751649432413L, 5137805530500375564L, MethodHandles.lookup().lookupClass()).a(62374351605572L);

        DuplicateKeysInHashVisitor(ProblemsHolder holder) {
            super(holder);
        }

        @Override
        public void visitRAssocList(RAssocList rAssocList) {
            this.c(rAssocList.getElements());
        }

        @Override
        public void visitRListOfExpressions(RListOfExpressions rListOfExpressions) {
            if (rListOfExpressions == null || PsiTreeUtil.getParentOfType((PsiElement)rListOfExpressions, RCall.class, (boolean)true) == null) {
                return;
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (PsiElement psiElement = rListOfExpressions.getLastChild(); psiElement != null; psiElement = psiElement.getPrevSibling()) {
                RPsiElement rPsiElement;
                if (!(psiElement instanceof RAssoc) || (rPsiElement = ((RAssoc)psiElement).getKey()) == null || !(rPsiElement instanceof RSymbol) && !(rPsiElement instanceof RAssocKey) || hashSet.add(rPsiElement.getName())) continue;
                this.a((RPsiElement)((RAssoc)psiElement));
            }
        }

        @Override
        public void visitRArrayIndexing(RArrayIndexing arrayIndexing) {
            switch (RubyHashUtil.checkSyntax(arrayIndexing)) {
                case ARRAY_TYPE: {
                    this.b(arrayIndexing.getIndexes());
                    break;
                }
                case ASSOC_TYPE: {
                    this.c(arrayIndexing.getIndexes());
                    break;
                }
                case LIST_TYPE: {
                    this.a(arrayIndexing.getIndexes());
                    break;
                }
            }
        }

        private void a(List<RPsiElement> list2) {
            RPsiElement rPsiElement;
            int n2;
            HashChecker hashChecker = new HashChecker(false);
            for (n2 = 0; n2 < list2.size(); n2 += 2) {
                rPsiElement = list2.get(n2);
                hashChecker.acceptElement(rPsiElement);
            }
            for (n2 = 0; n2 < list2.size(); n2 += 2) {
                rPsiElement = list2.get(n2);
                if (!hashChecker.checkElementCount(rPsiElement)) continue;
                this.a(rPsiElement);
            }
        }

        private void c(List<RPsiElement> list2) {
            HashChecker hashChecker = new HashChecker(true);
            for (RPsiElement rPsiElement : list2) {
                if (!(rPsiElement instanceof RAssoc)) continue;
                hashChecker.acceptElement(((RAssoc)rPsiElement).getKey());
            }
            for (RPsiElement rPsiElement : list2) {
                RPsiElement rPsiElement2;
                if (!(rPsiElement instanceof RAssoc) || !hashChecker.checkElementCount(rPsiElement2 = ((RAssoc)rPsiElement).getKey())) continue;
                this.a(rPsiElement2);
            }
        }

        private void b(List<RPsiElement> list2) {
            HashChecker hashChecker = new HashChecker(false);
            List<RPsiElement> list3 = RubyHashUtil.collectKeysFromArray(list2, false);
            for (RPsiElement rPsiElement : list3) {
                hashChecker.acceptElement(rPsiElement);
            }
            for (RPsiElement rPsiElement : list3) {
                if (!hashChecker.checkElementCount(rPsiElement)) continue;
                this.a(rPsiElement);
            }
        }

        private void a(RPsiElement rPsiElement) {
            long l2 = b ^ 0x70B65B54A661L;
            this.registerProblem((PsiElement)rPsiElement, RBundle.message((String)"inspection.duplicated.keys.in.hash.msg"), new RubyRemoveHashKeyFix());
        }
    }
}

