/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.langs.rhtml.lang.formatter.helpers;

import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ERbElementTypes;
import org.jetbrains.plugins.ruby.erb.psi.ERbTokenTypes;
import org.jetbrains.plugins.ruby.rails.langs.rhtml.lang.formatter.helpers.RHTMLFormatterUtil;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyFormattingProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementType;

public class RHTMLWrapProcessor
extends RubyFormattingProcessor {
    public RHTMLWrapProcessor(CommonCodeStyleSettings settings) {
        super(settings);
    }

    public Wrap getWrapForNode(ASTNode node, @Nullable FileViewProvider fileViewProvider) {
        if (node == null) {
            return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
        }
        IElementType iElementType = node.getElementType();
        if ((iElementType == ERbElementTypes.RHTML_XML_TAG || iElementType == ERbTokenTypes.RHTML_INJECTION_IN_HTML) && fileViewProvider != null && RHTMLFormatterUtil.isScripletRHTMLXmlTagNode(node)) {
            PsiElement psiElement = fileViewProvider.findElementAt(node.getStartOffset() - 1, (Language)HTMLLanguage.INSTANCE);
            String string = RHTMLWrapProcessor.a(psiElement != null ? psiElement.getText() : null);
            boolean bl2 = string != null && string.endsWith("\n");
            return Wrap.createWrap((WrapType)(bl2 ? WrapType.NONE : WrapType.ALWAYS), (boolean)true);
        }
        if (iElementType instanceof RubyElementType) {
            Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
        }
        return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
    }

    @Nullable
    private static String a(@Nullable String string) {
        int n2;
        if (string == null) {
            return string;
        }
        for (n2 = string.length() - 1; n2 >= 0 && string.charAt(n2) == ' '; --n2) {
        }
        if (n2 >= 0) {
            string = string.substring(0, n2 + 1);
        }
        return string;
    }

    public static Wrap createTagAttributesWrap(WrapType wrapType) {
        return Wrap.createWrap((WrapType)wrapType, (boolean)false);
    }

    public static Wrap createTagTextWrap(WrapType wrapType) {
        return Wrap.createWrap((WrapType)wrapType, (boolean)true);
    }
}

