/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.module;

import b.h.la;
import com.intellij.ProjectTopics;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Producer;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.util.XmlStringUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.RubyVMOptions;
import org.jetbrains.plugins.ruby.cli.RMInspectionToolLaunchSettings;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.detector.GemDetector;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsHolder;
import org.jetbrains.plugins.ruby.gem.module.GemScannerSuppressor;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemProvider;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.gems.DirectoryGemsProvider;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.util.ProjectQueues;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public class GemRequirementsChangeWatcher
implements GemManager.GemSetListener {
    private static final Logger h;
    @NotNull
    private final Module c;
    private final ModuleRootManager i;
    private final PsiManager n;
    private final GemRequirementsHolder m;
    private final ModuleGemInfrastructure q;
    private final Object o;
    private volatile boolean a;
    private final AtomicBoolean g;
    private final Set<VirtualFile> j;
    private final List<VirtualFile> e;
    private final RailsApp f;
    @Nullable
    private VirtualFile p;
    private volatile Notification d;
    private final PsiTreeChangeAdapter k;
    private MessageBusConnection b;
    private MessageBusConnection l;
    private static final long r;

    public GemRequirementsChangeWatcher(@NotNull Module module, ModuleRootManager moduleRootManager, PsiManager psiManager, GemRequirementsHolder holder, ModuleGemInfrastructure infrastructure) {
        if (module == null) {
            GemRequirementsChangeWatcher.a(0);
        }
        this.o = new Object();
        this.g = new AtomicBoolean(false);
        this.j = new HashSet<VirtualFile>();
        this.e = new ArrayList<VirtualFile>();
        this.k = new AddGemRequirementUpdateListener();
        this.c = module;
        this.i = moduleRootManager;
        this.n = psiManager;
        this.m = holder;
        this.q = infrastructure;
        this.f = RailsApp.fromModule(this.c);
    }

    @Override
    public void gemSetChanged() {
        long l2 = r ^ 0x489AD183736BL;
        ProjectQueues.getInstance(this.c).queue("GemsetsUpdateQueue", Update.create((Object)this.c, () -> this.a((Boolean)null)), (Producer<MergingUpdateQueue>)((Producer)() -> {
            long l2 = r ^ 0x5F0381601FA3L;
            return new MergingUpdateQueue("GemsetsUpdateQueue", 500, true, null, null, null, false).setRestartTimerOnAdd(true);
        }));
    }

    public static GemRequirementsChangeWatcher getInstance(Module module) {
        return (GemRequirementsChangeWatcher)ModuleServiceManager.getService((Module)module, GemRequirementsChangeWatcher.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void f() {
        if (RubyVMOptions.disableGemsScanner()) {
            return;
        }
        PsiTreeChangeAdapter psiTreeChangeAdapter = this.k;
        synchronized (psiTreeChangeAdapter) {
            this.n.addPsiTreeChangeListener((PsiTreeChangeListener)this.k, (Disposable)this.c);
            this.b = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.c);
            this.l = this.c.getMessageBus().connect();
            this.l.subscribe(GemManager.GEMSET_CHANGED_TOPIC, (Object)this);
            this.l.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){
                private static final long a = la.a(8460019061009566595L, -8764818088988269034L, MethodHandles.lookup().lookupClass()).a(52231366742113L);

                public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                    if (project == null) {
                        1.a(0);
                    }
                    if (module == null) {
                        1.a(1);
                    }
                    if (GemRequirementsChangeWatcher.this.c.equals(module) || GemRequirementsChangeWatcher.this.c.isDisposed()) {
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (GemRequirementsChangeWatcher.this.c.isDisposed()) {
                            return;
                        }
                        GemManager.updateGemset(GemRequirementsChangeWatcher.this.c);
                    });
                }

                public void moduleAdded(@NotNull Project project, @NotNull Module addedModule) {
                    if (project == null) {
                        1.a(2);
                    }
                    if (addedModule == null) {
                        1.a(3);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (GemRequirementsChangeWatcher.this.c.isDisposed()) {
                            return;
                        }
                        GemManager.updateGemset(GemRequirementsChangeWatcher.this.c);
                    });
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    long l2 = a ^ 0x310117E63DF0L;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "module";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "addedModule";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/GemRequirementsChangeWatcher$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "moduleRemoved";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "moduleAdded";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void l() {
        PsiTreeChangeAdapter psiTreeChangeAdapter = this.k;
        synchronized (psiTreeChangeAdapter) {
            this.n.removePsiTreeChangeListener((PsiTreeChangeListener)this.k);
            if (this.b != null) {
                this.b.disconnect();
            }
            this.b = null;
            if (this.l != null) {
                this.l.disconnect();
            }
            this.l = null;
        }
    }

    private void a(PsiTreeChangeEvent psiTreeChangeEvent, boolean bl2) {
        PsiFile psiFile = GemRequirementsChangeWatcher.b(psiTreeChangeEvent);
        PsiElement psiElement = psiTreeChangeEvent.getParent();
        if (psiFile != null) {
            if (bl2 && psiElement instanceof PsiDirectory && this.a((PsiFileSystemItem)psiElement)) {
                this.m.removeRequirements(psiFile.getVirtualFile());
            }
            if (!this.a((PsiFileSystemItem)psiFile)) {
                return;
            }
            GemDetector gemDetector = GemRequirementsChangeWatcher.getDetector(psiFile);
            if (gemDetector != null) {
                this.addFileScan(psiFile.getVirtualFile());
            }
            return;
        }
        PsiDirectory psiDirectory = GemRequirementsChangeWatcher.a(psiTreeChangeEvent);
        if (psiDirectory != null && (bl2 && this.a((PsiFileSystemItem)psiElement) || this.a((PsiFileSystemItem)psiDirectory))) {
            if (!bl2) {
                this.b(psiDirectory.getVirtualFile());
            } else {
                this.m.removeRequirementsFromDirectory(psiDirectory.getVirtualFile());
            }
        }
    }

    private boolean a(@Nullable PsiFileSystemItem psiFileSystemItem) {
        if (psiFileSystemItem == null || !psiFileSystemItem.isValid()) {
            return false;
        }
        String string = psiFileSystemItem.getName();
        if (this.p != null && this.p.isValid() && !BundlerUtil.isGemfile(psiFileSystemItem) && !GemRequirementsChangeWatcher.a(string)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFileSystemItem);
        if (module != this.c || !RModuleUtil.getInstance().hasRubySupport(module)) {
            return false;
        }
        return !this.i(psiFileSystemItem.getVirtualFile());
    }

    private boolean i(VirtualFile virtualFile) {
        if (this.f == null) {
            return false;
        }
        return this.f.isVendorFile(virtualFile);
    }

    @Nullable
    private Boolean f(@Nullable VirtualFile virtualFile) {
        long l2 = r ^ 0x2734754E4C98L;
        h.assertTrue(ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed(), (Object)"no read access, scripts running ahead");
        GemDetector gemDetector = GemRequirementsChangeWatcher.a(virtualFile);
        return gemDetector != null ? this.b(virtualFile, gemDetector) : null;
    }

    @Nullable
    private Boolean b(@NotNull VirtualFile virtualFile, @NotNull GemDetector gemDetector) {
        if (virtualFile == null) {
            GemRequirementsChangeWatcher.a(1);
        }
        if (gemDetector == null) {
            GemRequirementsChangeWatcher.a(2);
        }
        Boolean bl2 = null;
        Pair pair = (Pair)ReadAction.compute(() -> {
            if (virtualFile == null) {
                GemRequirementsChangeWatcher.a(5);
            }
            if (gemDetector == null) {
                GemRequirementsChangeWatcher.a(6);
            }
            return Pair.create((Object)this.a(virtualFile, gemDetector), (Object)RModuleUtil.getInstance().findRubySdkForModule(this.c));
        });
        if (((Boolean)pair.getFirst()).booleanValue()) {
            Sdk sdk = (Sdk)pair.getSecond();
            bl2 = this.q.hasMissingGems(sdk);
            Set<GemDependency> set = gemDetector.detect(this.c.getProject(), sdk, virtualFile);
            if (this.c.isDisposed()) {
                return null;
            }
            this.m.updateRequirements(set, virtualFile);
        } else {
            this.m.removeRequirements(virtualFile);
        }
        return bl2;
    }

    private boolean a(@NotNull VirtualFile virtualFile, GemDetector gemDetector) {
        long l2 = r ^ 0x2883D4CC00B1L;
        if (virtualFile == null) {
            GemRequirementsChangeWatcher.a(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.c.isDisposed()) {
            return false;
        }
        ModuleFileIndex moduleFileIndex = this.i.getFileIndex();
        boolean bl2 = virtualFile.isValid();
        if (bl2 && moduleFileIndex.isInContent(virtualFile) && gemDetector.accepts(virtualFile)) {
            if (this.p != null && this.p.isValid() && !virtualFile.equals(this.p) && !virtualFile.getName().endsWith(".gemspec")) {
                return false;
            }
            for (ModuleGemProvider moduleGemProvider : ModuleGemProvider.EP_NAME.getExtensionList()) {
                VirtualFile virtualFile2;
                if (!(moduleGemProvider instanceof DirectoryGemsProvider) || (virtualFile2 = ((DirectoryGemsProvider)moduleGemProvider).getVendoringRoot(this.c)) == null || !VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Contract(value="null -> null")
    public static GemDetector getDetector(PsiFile file) {
        return file != null ? (GemDetector)GemDetector.EXTENSION.forLanguage(file.getLanguage()) : null;
    }

    @Nullable
    private static GemDetector a(VirtualFile virtualFile) {
        if (virtualFile == null) {
            return null;
        }
        FileType fileType = virtualFile.getFileType();
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        return (GemDetector)GemDetector.EXTENSION.forLanguage(((LanguageFileType)fileType).getLanguage());
    }

    @Nullable
    private static PsiFile b(PsiTreeChangeEvent psiTreeChangeEvent) {
        PsiFile psiFile = psiTreeChangeEvent.getFile();
        PsiElement psiElement = psiTreeChangeEvent.getChild();
        if (psiFile == null && psiElement instanceof PsiFile) {
            return (PsiFile)psiElement;
        }
        return psiFile;
    }

    @Nullable
    private static PsiDirectory a(PsiTreeChangeEvent psiTreeChangeEvent) {
        PsiElement psiElement = psiTreeChangeEvent.getElement();
        PsiElement psiElement2 = psiTreeChangeEvent.getChild();
        boolean bl2 = psiElement instanceof PsiDirectory;
        if (!bl2 && psiElement2 instanceof PsiDirectory) {
            return (PsiDirectory)psiElement2;
        }
        return bl2 ? (PsiDirectory)psiElement : null;
    }

    public void start() {
        if (this.c.isDisposed() || !RModuleUtil.getInstance().hasRubySupport(this.c)) {
            return;
        }
        if (!RMInspectionToolLaunchSettings.getInstance().isActivated()) {
            this.f();
        }
        this.a(() -> {
            this.p = BundlerUtil.getGemfile(this.c);
            this.g();
        });
    }

    public void stop() {
        this.l();
        this.a(() -> {
            this.p = null;
            this.m.clear();
            this.j();
        });
    }

    private void a(final @NotNull Runnable runnable) {
        long l2 = r ^ 0x6D45A7BF05C0L;
        if (runnable == null) {
            GemRequirementsChangeWatcher.a(4);
        }
        final Project project = this.c.getProject();
        ProjectQueues.getInstance(project).queue("GemRequirementsChangeWatcherQueue", new Task.Backgroundable(project, RBundle.message((String)"gems.scanning.title", (Object[])new Object[]{this.c.getName()}), false){
            private static final long a = la.a(-422252411521650309L, -6065355656629172181L, MethodHandles.lookup().lookupClass()).a(210348231443916L);

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.a(0);
                }
                DumbService.getInstance((Project)project).repeatUntilPassesInSmartMode(() -> {
                    if (runnable == null) {
                        2.a(1);
                    }
                    if (GemRequirementsChangeWatcher.this.c.isDisposed()) {
                        return;
                    }
                    runnable.run();
                });
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = a ^ 0x3E5E5840D318L;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scanner";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/GemRequirementsChangeWatcher$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void g() {
        long l2 = r ^ 0x127C804271CCL;
        if (this.c.isDisposed()) {
            return;
        }
        h.info("Initial scan started");
        long l3 = System.currentTimeMillis();
        this.m.clear();
        Ref ref = new Ref();
        if (this.p != null && this.p.isValid()) {
            ref.set((Object)this.f(this.p));
        } else {
            VirtualFile[] virtualFileArray;
            for (VirtualFile virtualFile : virtualFileArray = this.i.getContentRoots()) {
                GemRequirementsChangeWatcher.a((Ref<Boolean>)ref, this.g(virtualFile));
            }
        }
        h.info("Initial scan took: " + (System.currentTimeMillis() - l3) + " ms");
        if (ApplicationManagerEx.getApplicationEx().isInternal()) {
            h.info("Detected: " + this.m.getRequirements());
        }
        this.a((Boolean)ref.get());
    }

    private static void a(Ref<Boolean> ref, Boolean bl2) {
        if (ref.get() != null) {
            if (bl2 != null) {
                ref.set((Object)((Boolean)ref.get() != false || bl2 != false ? 1 : 0));
            }
        } else {
            ref.set((Object)bl2);
        }
    }

    private void a(@Nullable Boolean bl2) {
        long l2 = r ^ 0x7E1220FA62L;
        if (this.c.isDisposed()) {
            return;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(this.c);
        if (sdk == null) {
            h.warn("No Sdk selected for " + this.c);
            return;
        }
        Boolean bl3 = bl2 == null ? this.q.hasMissingGems(sdk) : bl2;
        Set<GemDependency> set = this.m.getRequirements();
        Set<GemDependency> set2 = GemUtil.getMissingDependencies(sdk, this.c, set);
        Notification notification = this.d;
        if (bl3 != null && bl3.booleanValue() || bl3 == null && set2.size() > 0) {
            if (notification == null || notification.isExpired()) {
                this.d = new MissingGemsNotification(this);
                Notifications.Bus.notify((Notification)this.d, (Project)this.c.getProject());
            }
        } else {
            ApplicationManager.getApplication().invokeLater(() -> GemRequirementsChangeWatcher.b(notification));
        }
        if (!(bl3 == null || bl3.booleanValue() || set2.size() <= 0 || this.p != null && this.p.isValid())) {
            h.error("Infrastructure reported that no gems missing, but we have detected: " + set2);
        }
        this.j();
    }

    private void j() {
        Runnable runnable = () -> {
            if (this.c.isDisposed()) {
                return;
            }
            GemManager.updateGemset(this.c);
            RbenvGemsetManager.refreshAttachedGemsetSdks(this.c);
            RMInspectionToolLaunchSettings rMInspectionToolLaunchSettings = RMInspectionToolLaunchSettings.getInstance();
            if (rMInspectionToolLaunchSettings.isActivated() && rMInspectionToolLaunchSettings.getVerboseLevel() > 0) {
                this.c();
            }
            DaemonCodeAnalyzer.getInstance((Project)this.c.getProject()).restart();
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            runnable.run();
        } else {
            application.invokeLater(runnable);
        }
    }

    private void c() {
        long l2 = r ^ 0x2C2A4828040AL;
        System.out.println("\nFollowing gems were detected:\n");
        Set<GemInfo> set = GemManager.getAllGems(this.c);
        if (set.isEmpty()) {
            System.out.println("    <no gems>");
        } else {
            for (GemInfo gemInfo : set) {
                System.out.println("    " + gemInfo.toString() + (gemInfo.isValid() ? "" : " [invalid]"));
            }
        }
    }

    @Nullable
    private Boolean g(VirtualFile virtualFile2) {
        if (this.c.isDisposed()) {
            return null;
        }
        if (virtualFile2 == null) {
            return null;
        }
        Ref ref = new Ref();
        this.i.getFileIndex().iterateContentUnderDirectory(virtualFile2, virtualFile -> {
            ThreeState threeState = (ThreeState)ReadAction.compute(() -> {
                if (this.c.isDisposed()) {
                    return ThreeState.NO;
                }
                if (!virtualFile.isValid() || virtualFile.isDirectory() || GemRequirementsChangeWatcher.a(virtualFile) == null) {
                    return ThreeState.YES;
                }
                return ThreeState.UNSURE;
            });
            if (threeState != ThreeState.UNSURE) {
                return threeState.toBoolean();
            }
            GemRequirementsChangeWatcher.a((Ref<Boolean>)ref, this.f(virtualFile));
            return true;
        }, virtualFile -> (Boolean)ReadAction.compute(() -> !GemScannerSuppressor.isFileSuppressed(virtualFile, this.c)));
        return (Boolean)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualFile[] m() {
        Object object = this.o;
        synchronized (object) {
            VirtualFile virtualFile;
            VirtualFile[] virtualFileArray = new VirtualFile[this.j.size() + this.e.size()];
            int n2 = 0;
            Iterator<VirtualFile> iterator = this.j.iterator();
            while (iterator.hasNext()) {
                virtualFileArray[n2] = virtualFile = iterator.next();
                ++n2;
            }
            iterator = this.e.iterator();
            while (iterator.hasNext()) {
                virtualFileArray[n2] = virtualFile = iterator.next();
                ++n2;
            }
            this.j.clear();
            this.e.clear();
            return virtualFileArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileScan(VirtualFile file) {
        Object object = this.o;
        synchronized (object) {
            if (this.e(file)) {
                return;
            }
            this.j.add(file);
            this.i();
        }
    }

    private boolean e(VirtualFile virtualFile) {
        for (VirtualFile virtualFile2 : this.e) {
            if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(VirtualFile virtualFile) {
        Object object = this.o;
        synchronized (object) {
            if (this.e(virtualFile) || this.i(virtualFile)) {
                return;
            }
            for (VirtualFile virtualFile2 : new ArrayList<VirtualFile>(this.j)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (boolean)false)) continue;
                this.j.remove(virtualFile2);
            }
            this.e.add(virtualFile);
            this.i();
        }
    }

    private void i() {
        long l2 = r ^ 0x6B4AED46A86EL;
        if (!this.a) {
            ProjectQueues.getInstance(this.c).queue("UpdateGemRequirementsQueue", new GemRequirementScan(), (Producer<MergingUpdateQueue>)((Producer)() -> {
                long l2 = r ^ 0x5EC4D808C90AL;
                return new MergingUpdateQueue("UpdateGemRequirementsQueue", 5000, true, null).setRestartTimerOnAdd(true);
            }));
        } else {
            this.g.set(true);
        }
    }

    private static boolean a(String string) {
        long l2 = r ^ 0x1EC4F42C1B78L;
        return string.endsWith(".gemspec") || BundlerUtil.isGemfileLockName(string);
    }

    private static void b(Notification notification) {
        if (notification != null && !notification.isExpired()) {
            notification.expire();
        }
    }

    static {
        r = la.a(-1730007933410680120L, 1709808070203684176L, MethodHandles.lookup().lookupClass()).a(122945311916201L);
        h = Logger.getInstance(GemRequirementsChangeWatcher.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = r ^ 0x465F59DB0B4FL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scanner";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/GemRequirementsChangeWatcher";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "detectAndAdd";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldScanForRequirements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addScanner";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$detectAndAdd$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class AddGemRequirementUpdateListener
    extends PsiTreeChangeAdapter {
        private static final long a = la.a(8823034367273250232L, -1542988738107194880L, MethodHandles.lookup().lookupClass()).a(212975048392106L);

        private AddGemRequirementUpdateListener() {
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.a(0);
            }
            GemRequirementsChangeWatcher.this.a(event, false);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.a(1);
            }
            GemRequirementsChangeWatcher.this.a(event, true);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.a(2);
            }
            GemRequirementsChangeWatcher.this.a(event, false);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.a(3);
            }
            GemRequirementsChangeWatcher.this.a(event, false);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.a(4);
            }
            GemRequirementsChangeWatcher.this.a(event, false);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x550F82286E5EL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/GemRequirementsChangeWatcher$AddGemRequirementUpdateListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MissingGemsNotification
    extends Notification {
        final /* synthetic */ GemRequirementsChangeWatcher this$0;
        private static final long a = la.a(3476475500956411786L, -1404343827249645859L, MethodHandles.lookup().lookupClass()).a(206438691687704L);

        private MissingGemsNotification(GemRequirementsChangeWatcher gemRequirementsChangeWatcher) {
            long l2 = a ^ 0x23578A8DD9CEL;
            this.this$0 = gemRequirementsChangeWatcher;
            super("Gem Manager", PlatformUtils.isRubyMine() ? "RubyMine Gem Manager" : "Ruby Plugin Gem Manager", XmlStringUtil.wrapInHtml((CharSequence)RBundle.message((String)"gems.requirements.missing", (Object[])new Object[]{PlatformUtils.isRubyMine() ? "RubyMine" : "Ruby plugin", gemRequirementsChangeWatcher.c.getName()})), NotificationType.WARNING, new NotificationListener(){
                private static final long a = la.a(-4039383951529894351L, -6756196136201012060L, MethodHandles.lookup().lookupClass()).a(152455146995320L);

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        1.a(0);
                    }
                    if (event == null) {
                        1.a(1);
                    }
                    GemRequirementsChangeWatcher.this.q.updateModuleGemset();
                    GemRequirementsChangeWatcher.b(notification);
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    long l2 = a ^ 0x4D7681F41DACL;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/ruby/gem/module/GemRequirementsChangeWatcher$MissingGemsNotification$1";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private class GemRequirementScan
    extends Update {
        private static final long a = la.a(1912426137494079668L, -5580827172929328327L, MethodHandles.lookup().lookupClass()).a(65032782412979L);

        GemRequirementScan() {
            super(GemRequirementsChangeWatcher.this.o);
        }

        public void run() {
            if (GemRequirementsChangeWatcher.this.a) {
                GemRequirementsChangeWatcher.this.g.set(true);
                return;
            }
            VirtualFile[] virtualFileArray = GemRequirementsChangeWatcher.this.m();
            if (GemRequirementsChangeWatcher.this.c.getProject().isDisposed() || virtualFileArray.length == 0) {
                return;
            }
            GemRequirementsChangeWatcher.this.a(() -> {
                long l2 = GemRequirementScan.a ^ 0x136848720A9AL;
                try {
                    GemRequirementsChangeWatcher.this.a = true;
                    h.debug("Scanning " + virtualFileArray.length + " targets");
                    Ref ref = new Ref();
                    for (VirtualFile virtualFile : virtualFileArray) {
                        boolean bl2 = (Boolean)ReadAction.compute(() -> virtualFile.isValid());
                        if (!bl2) continue;
                        if (!virtualFile.isDirectory()) {
                            String string;
                            if (BundlerUtil.isGemfile(GemRequirementsChangeWatcher.this.c.getProject(), virtualFile)) {
                                string = GemRequirementsChangeWatcher.this.p;
                                GemRequirementsChangeWatcher.this.p = BundlerUtil.getGemfile(GemRequirementsChangeWatcher.this.c);
                                if (string == null && GemRequirementsChangeWatcher.this.p != null && GemRequirementsChangeWatcher.this.p.isValid()) {
                                    GemRequirementsChangeWatcher.this.m.clear();
                                }
                            }
                            string = virtualFile.getName();
                            VirtualFile virtualFile2 = GemRequirementsChangeWatcher.this.p;
                            VirtualFile virtualFile3 = virtualFile2 != null && string.endsWith(".gemspec") ? virtualFile2 : virtualFile;
                            GemRequirementsChangeWatcher.a((Ref<Boolean>)ref, GemRequirementsChangeWatcher.this.f(virtualFile3));
                            continue;
                        }
                        GemRequirementsChangeWatcher.a((Ref<Boolean>)ref, GemRequirementsChangeWatcher.this.g(virtualFile));
                    }
                    GemRequirementsChangeWatcher.this.a((Boolean)ref.get());
                }
                finally {
                    GemRequirementsChangeWatcher.this.a = false;
                    if (GemRequirementsChangeWatcher.this.g.compareAndSet(true, false)) {
                        GemRequirementsChangeWatcher.this.i();
                    }
                }
            });
        }
    }
}

