/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import b.h.la;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.gem.CachingRemoteGemProvider;
import org.jetbrains.plugins.ruby.gem.gem.GemRunner;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsModuleCache;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.tasks.rake.RakeTaskModuleCache;

public class GemInstallUtil {
    @NonNls
    private static final Pattern a;
    private static final Logger b;
    private static final long c;

    private GemInstallUtil() {
    }

    public static void installAndAddGemsInBackground(@NotNull Sdk sdk, @Nullable Module module, @NotNull Collection<GemDependency> gemsToInstall, boolean installDependencies, boolean generateDocs, @Nullable Runnable callback, @NotNull Map<GemDependency, String> errorHolder) {
        if (sdk == null) {
            GemInstallUtil.a(0);
        }
        if (gemsToInstall == null) {
            GemInstallUtil.a(1);
        }
        if (errorHolder == null) {
            GemInstallUtil.a(2);
        }
        GemInstallUtil.installGemsRequirements(sdk, module, gemsToInstall, installDependencies, generateDocs, true, true, true, callback, errorHolder);
    }

    public static void installGems(@NotNull Sdk sdk, @Nullable Module module, @NotNull Collection<? extends GemInfo> gems, boolean installDependencies, boolean generateDocs, @NotNull Map<GemDependency, String> errors) {
        if (sdk == null) {
            GemInstallUtil.a(3);
        }
        if (gems == null) {
            GemInstallUtil.a(4);
        }
        if (errors == null) {
            GemInstallUtil.a(5);
        }
        List list2 = ContainerUtil.map(gems, gemInfo -> gemInfo.asDependency());
        GemInstallUtil.installGemsDependencies(sdk, module, list2, installDependencies, generateDocs, errors);
    }

    public static void installGemsDependencies(@NotNull Sdk sdk, @Nullable Module module, @NotNull Collection<GemDependency> gemsToInstall, boolean installDependencies, boolean generateDocs, @NotNull Map<GemDependency, String> errorHolder) {
        if (sdk == null) {
            GemInstallUtil.a(6);
        }
        if (gemsToInstall == null) {
            GemInstallUtil.a(7);
        }
        if (errorHolder == null) {
            GemInstallUtil.a(8);
        }
        GemInstallUtil.a(sdk, module, gemsToInstall, null, installDependencies, generateDocs, false, true, false, null, errorHolder);
    }

    private static void a(@NotNull Sdk sdk, @Nullable Module module, @NotNull Collection<GemDependency> collection, @Nullable Computable<? extends Collection<GemDependency>> computable, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, @Nullable Runnable runnable, @NotNull Map<GemDependency, String> map) {
        long l2 = c ^ 0x7438225D1337L;
        if (sdk == null) {
            GemInstallUtil.a(9);
        }
        if (collection == null) {
            GemInstallUtil.a(10);
        }
        if (map == null) {
            GemInstallUtil.a(11);
        }
        if (collection.isEmpty() && computable == null) {
            return;
        }
        Project project = RModuleUtil.getInstance().getProject(module);
        final Runnable runnable2 = () -> {
            Collection collection2;
            if (collection == null) {
                GemInstallUtil.a(29);
            }
            if (map == null) {
                GemInstallUtil.a(30);
            }
            if (sdk == null) {
                GemInstallUtil.a(31);
            }
            Collection collection3 = collection2 = collection.isEmpty() && computable != null ? (Collection)computable.compute() : collection;
            if (collection2.isEmpty()) {
                GemInstallUtil.a(bl6, project, map);
                return;
            }
            GemInstallUtil.a(module, sdk, collection2, bl2, bl3, map, bl5);
            GemInstallUtil.a(bl6, project, map);
            if (runnable != null) {
                ApplicationManager.getApplication().invokeLater(runnable);
            }
        };
        String string = RBundle.message((String)"gems.gem.installing");
        Object object = bl4 ? new Task.Backgroundable(project, string){
            private static final long a = la.a(-3962631843238135508L, 8508631960143137320L, MethodHandles.lookup().lookupClass()).a(246311243799233L);

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.a(0);
                }
                runnable2.run();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x7905248F6CD7L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/gem/GemInstallUtil$1", "run"));
            }
        } : new Task.Modal(project, string, true){
            private static final long a = la.a(-4155414499469188049L, 1919685676043091213L, MethodHandles.lookup().lookupClass()).a(279899514205100L);

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.a(0);
                }
                runnable2.run();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3012671C7EB5L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/gem/GemInstallUtil$2", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)object);
    }

    private static void a(boolean bl2, Project project, Map<GemDependency, String> map) {
        if (bl2) {
            ApplicationManager.getApplication().invokeLater(() -> GemUiUtil.showInstallErrors(project, map));
        }
    }

    public static boolean installBundledRCov(Sdk sdk, Module module) {
        long l2 = c ^ 0x1DD9C57F9F95L;
        HashMap<GemDependency, String> hashMap = new HashMap<GemDependency, String>();
        try {
            List<GemDependency> list2 = GemInstallUtil.findBundledGemsToInstall("Bundled RCov gem not found", a);
            GemInstallUtil.installGemsRequirements(sdk, module, list2, !JRubySdkUtil.isJRubySDK(sdk), false, false, true, true, null, hashMap);
        }
        catch (ExecutionException executionException) {
            hashMap.put(GemDependency.any("rcov"), executionException.getMessage());
            GemUiUtil.showInstallErrors(module.getProject(), hashMap);
        }
        return hashMap.isEmpty();
    }

    public static List<GemDependency> findBundledGemsToInstall(String message, Pattern ... patterns) throws ExecutionException {
        long l2 = c ^ 0x144BFE7BEB69L;
        String string = RubyUtil.getScriptFullPath("rb/gems");
        if (string == null) {
            throw new ExecutionException(RBundle.message((String)"gems.gem.installing.failed") + ". " + message);
        }
        File file = new File(string);
        List list2 = ContainerUtil.map((Object[])patterns, (Function)((NullableFunction)pattern -> GemInstallUtil.findBundledDebugGem(file, pattern)));
        ArrayList<GemDependency> arrayList = new ArrayList<GemDependency>();
        for (String string2 : list2) {
            if (string2 == null) {
                throw new ExecutionException(RBundle.message((String)"gems.gem.installing.failed") + ". " + message);
            }
            arrayList.add(GemDependency.any(string2));
        }
        return arrayList;
    }

    @Nullable
    public static String findBundledDebugGem(File gemsDir, Pattern pattern) {
        File[] fileArray = gemsDir.listFiles();
        if (fileArray == null) {
            return null;
        }
        for (File file : fileArray) {
            Matcher matcher = pattern.matcher(file.getName());
            if (!matcher.matches()) continue;
            return file.getPath();
        }
        return null;
    }

    private static void a(@Nullable Module module, @NotNull Sdk sdk, @NotNull Collection<? extends GemDependency> collection, boolean bl2, boolean bl3, @NotNull Map<GemDependency, String> map, boolean bl4) {
        long l2 = c ^ 0x3AD7D34C90D0L;
        if (sdk == null) {
            GemInstallUtil.a(12);
        }
        if (collection == null) {
            GemInstallUtil.a(13);
        }
        if (map == null) {
            GemInstallUtil.a(14);
        }
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        Collection<GemInfo> collection2 = GemManager.getInstance().getAllGems(sdk, module);
        boolean bl5 = false;
        for (GemDependency gemDependency : collection) {
            if (bl5) {
                map.put(gemDependency, "Cancelled");
                continue;
            }
            GemInfo gemInfo = GemSearchUtil.findGem(collection2, gemDependency);
            if (gemInfo == null) {
                Pair<Boolean, String> pair = GemRunner.install(module, sdk, gemDependency, gemDependency.getUrl(), bl2, bl3);
                b.info("Installed gem: " + gemDependency.getDescription());
                if (!((Boolean)pair.first).booleanValue()) {
                    map.put(gemDependency, (String)pair.second);
                    bl5 = "Cancelled".equals(pair.second);
                }
            }
            bl5 |= progressIndicator.isCanceled();
        }
        RubyRemoteInterpreterManager.getInstance().updateGemsCopy(sdk, module, bl4);
        GemManager.getInstance().refresh(sdk);
    }

    public static boolean isRawGem(String fullName) {
        long l2 = c ^ 0x7B71EB2507B5L;
        return fullName.endsWith(".gem");
    }

    public static void installGemsRequirements(@NotNull Sdk sdk, @Nullable Module module, @NotNull Collection<GemDependency> gemsToInstall, boolean installDependencies, boolean generateDocs, boolean backgroundable, boolean asynchronous, boolean showErrors, @Nullable Runnable callback, @NotNull Map<GemDependency, String> errorHolder) {
        if (sdk == null) {
            GemInstallUtil.a(15);
        }
        if (gemsToInstall == null) {
            GemInstallUtil.a(16);
        }
        if (errorHolder == null) {
            GemInstallUtil.a(17);
        }
        GemInstallUtil.installGemsRequirements(sdk, module, gemsToInstall, false, installDependencies, generateDocs, backgroundable, asynchronous, showErrors, callback, errorHolder);
    }

    public static void installGemsRequirements(@NotNull Sdk sdk, @Nullable Module module, @NotNull Collection<GemDependency> gemsToInstall, boolean updateInstalledGems, boolean installDependencies, boolean generateDocs, boolean backgroundable, boolean asynchronous, boolean showErrors, @Nullable Runnable callback, @NotNull Map<GemDependency, String> errorHolder) {
        if (sdk == null) {
            GemInstallUtil.a(18);
        }
        if (gemsToInstall == null) {
            GemInstallUtil.a(19);
        }
        if (errorHolder == null) {
            GemInstallUtil.a(20);
        }
        List list2 = updateInstalledGems ? Collections.emptyList() : GemManager.getInstance().getAllGems(sdk, module);
        HashSet<GemDependency> hashSet = new HashSet<GemDependency>();
        GemDependency[] gemDependencyArray = gemsToInstall.toArray(new GemDependency[0]);
        HashSet<GemDependency> hashSet2 = new HashSet<GemDependency>();
        for (GemDependency gemDependency : gemDependencyArray) {
            GemInfo gemInfo;
            if (gemDependency.isFromPath() || (gemInfo = GemSearchUtil.findGem(list2, gemDependency)) != null) continue;
            if (gemDependency.size() == 1 && (gemDependency.getUrl() != null || GemInstallUtil.isRawGem(gemDependency.getName()))) {
                hashSet.add(gemDependency);
                continue;
            }
            hashSet2.add(gemDependency);
        }
        boolean bl2 = hashSet.isEmpty();
        GemInstallUtil.a(sdk, module, Collections.emptySet(), GemInstallUtil.a(module, sdk, hashSet2, errorHolder), installDependencies, generateDocs, backgroundable, asynchronous, showErrors && bl2, bl2 ? callback : null, errorHolder);
        GemInstallUtil.a(sdk, module, hashSet, null, installDependencies, generateDocs, backgroundable, asynchronous, showErrors, callback, errorHolder);
    }

    @NotNull
    public static Runnable createReloadRakeTasksAndGeneratorsCallBack(@NotNull Module module, @NotNull Sdk sdk) {
        if (module == null) {
            GemInstallUtil.a(21);
        }
        if (sdk == null) {
            GemInstallUtil.a(22);
        }
        Runnable runnable = () -> {
            if (module == null) {
                GemInstallUtil.a(25);
            }
            if (sdk == null) {
                GemInstallUtil.a(26);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (module == null) {
                    GemInstallUtil.a(27);
                }
                if (sdk == null) {
                    GemInstallUtil.a(28);
                }
                if (module.isDisposed()) {
                    return;
                }
                RakeTaskModuleCache.getInstance(module).reloadTasks(true, sdk);
                if (RailsApp.fromModule(module) != null) {
                    GeneratorsModuleCache.getInstance(module).reloadGenerators(true, sdk, true);
                }
            });
        };
        if (runnable == null) {
            GemInstallUtil.a(23);
        }
        return runnable;
    }

    private static Computable<Collection<GemDependency>> a(Module module, Sdk sdk, Set<? extends GemDependency> set, Map<GemDependency, String> map) {
        return () -> {
            long l2 = c ^ 0x314253083B96L;
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setText("Searching gem repositories...");
            }
            HashSet hashSet = new HashSet();
            for (GemDependency gemDependency : set) {
                String[] stringArray;
                String string = gemDependency.getUrl();
                if (string != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = string;
                } else {
                    stringArray = CachingRemoteGemProvider.getInstance().getCachedUrls();
                }
                String[] stringArray3 = stringArray;
                GemInstallUtil.a(module, sdk, gemDependency, stringArray3, hashSet, map);
            }
            return ContainerUtil.map(hashSet, gemInfo -> gemInfo.asDependency());
        };
    }

    private static void a(Module module, Sdk sdk, GemDependency gemDependency, String[] stringArray, Set<? super GemInfo> set, @NotNull Map<GemDependency, String> map) {
        long l2 = c ^ 0x6832338C1275L;
        if (map == null) {
            GemInstallUtil.a(24);
        }
        for (String string : stringArray) {
            GemDependency gemDependency2 = GemDependency.any(gemDependency.getName());
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null && progressIndicator.isCanceled()) {
                map.put(gemDependency2, "Cancelled");
                break;
            }
            Collection<GemInfo> collection = GemInstallUtil.a(module, sdk, gemDependency, string);
            GemInfo gemInfo = GemSearchUtil.findGem(collection, gemDependency);
            if (gemInfo != null) {
                b.debug("gem " + gemInfo.getName() + " found in repo " + string);
                set.add(gemInfo);
                break;
            }
            if (string != stringArray[stringArray.length - 1]) continue;
            map.put(gemDependency2, "No gem satisfying dependency found in remote gem repositories");
        }
    }

    @Nullable
    private static Collection<GemInfo> a(Module module, Sdk sdk, GemDependency gemDependency, String string) {
        return GemRunner.query(module, sdk, string, (Function<Object, Boolean>)((Function)object -> {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            return progressIndicator != null && progressIndicator.isCanceled();
        }), gemDependency.getName());
    }

    static {
        c = la.a(8738171309047473574L, 5151986684050023549L, MethodHandles.lookup().lookupClass()).a(181706283561986L);
        long l2 = c ^ 0x191BEE706079L;
        a = Pattern.compile("rcov-([0-9]+(\\.[0-9A-z]+)*)-java.gem");
        b = Logger.getInstance(GemInstallUtil.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x2899969EE972L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 23: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsToInstall";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gems";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemInstallUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemInstallUtil";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createReloadRakeTasksAndGeneratorsCallBack";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installAndAddGemsInBackground";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "installGems";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "installGemsDependencies";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "installGemsRequirements";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createReloadRakeTasksAndGeneratorsCallBack";
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "tryToFindRemoteGem";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createReloadRakeTasksAndGeneratorsCallBack$5";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$installGems$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

