/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.gnu.trove;

import org.jetbrains.coverage.gnu.trove.THash;

public abstract class TPrimitiveHash
extends THash {
    protected transient byte[] _states;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;

    public TPrimitiveHash() {
    }

    public TPrimitiveHash(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public TPrimitiveHash(int initialCapacity, float loadFactor) {
        this._loadFactor = loadFactor;
        this.setUp((int)((float)initialCapacity / loadFactor) + 1);
    }

    public Object clone() {
        TPrimitiveHash h = (TPrimitiveHash)super.clone();
        h._states = (byte[])this._states.clone();
        return h;
    }

    protected int capacity() {
        return this._states.length;
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._states[index] = 2;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._states = new byte[capacity];
        return capacity;
    }
}

