/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleHelper {
    public static Module[] getModules(Project project) {
        return ModuleManager.getInstance((Project)project).getModules();
    }

    public static boolean dependencyExists(@NotNull ModuleRootManager rootManager, @NotNull Library library) {
        OrderEntry[] orderEntries;
        if (rootManager == null) {
            ModuleHelper.$$$reportNull$$$0(0);
        }
        if (library == null) {
            ModuleHelper.$$$reportNull$$$0(1);
        }
        for (OrderEntry orderEntry : orderEntries = rootManager.getOrderEntries()) {
            LibraryOrderEntry libraryOrderEntry;
            Library moduleLibrary;
            if (!(orderEntry instanceof LibraryOrderEntry) || (moduleLibrary = (libraryOrderEntry = (LibraryOrderEntry)orderEntry).getLibrary()) == null || !moduleLibrary.equals(library) || !moduleLibrary.getTable().getTableLevel().equals(library.getTable().getTableLevel())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSuitableModule(@NotNull ScriptingLibraryModel libModel, @NotNull Module module, int moduleCount, @Nullable VirtualFile file) {
        if (libModel == null) {
            ModuleHelper.$$$reportNull$$$0(2);
        }
        if (module == null) {
            ModuleHelper.$$$reportNull$$$0(3);
        }
        if (file != null) {
            return module.getModuleContentScope().contains(file);
        }
        if (moduleCount == 1) {
            return true;
        }
        if (libModel.hasAssociatedModules()) {
            return libModel.isAssociatedWith(module);
        }
        return "WEB_MODULE".equals(module.getModuleTypeName());
    }

    public static void removeDependencies(@NotNull Project project, @NotNull Library library) {
        Module[] modules;
        if (project == null) {
            ModuleHelper.$$$reportNull$$$0(4);
        }
        if (library == null) {
            ModuleHelper.$$$reportNull$$$0(5);
        }
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            if (!ModuleHelper.dependencyExists(rootManager, library)) continue;
            ModuleHelper.removeDependency(rootManager, library);
        }
    }

    public static void removeDependency(@NotNull ModuleRootManager rootManager, @NotNull Library library) {
        if (rootManager == null) {
            ModuleHelper.$$$reportNull$$$0(6);
        }
        if (library == null) {
            ModuleHelper.$$$reportNull$$$0(7);
        }
        ModifiableRootModel model = rootManager.getModifiableModel();
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)orderEntry).getLibrary() != library) continue;
            model.removeOrderEntry(orderEntry);
        }
        model.commit();
    }

    public static Set<Module> getAssociatedModules(Project project, Library library) {
        Module[] modules;
        HashSet<Module> associatedModules = new HashSet<Module>();
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            if (!ModuleHelper.dependencyExists(rootManager, library)) continue;
            associatedModules.add(module);
        }
        return associatedModules;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootManager";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/ModuleHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "dependencyExists";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableModule";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDependencies";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDependency";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

