/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkFactory;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteSdkFactoryImpl<T extends RemoteSdkAdditionalData>
implements RemoteSdkFactory<T> {
    public Sdk createRemoteSdk(@Nullable Project project, @NotNull T data, @Nullable String sdkName, Collection<Sdk> existingSdks) throws RemoteSdkException {
        if (data == null) {
            RemoteSdkFactoryImpl.$$$reportNull$$$0(0);
        }
        String interpreterVersion = this.getInterpreterVersion(project, data);
        String name = StringUtil.isNotEmpty((String)sdkName) ? sdkName : this.getInterpreterName(data, interpreterVersion);
        SdkType sdkType = this.getSdkType(data);
        ProjectJdkImpl sdk = new ProjectJdkImpl(SdkConfigurationUtil.createUniqueSdkName((String)name, (Collection)Lists.newArrayList(existingSdks)), (SdkTypeId)sdkType);
        sdk.setHomePath(this.generateSdkHomePath(data));
        sdk.setVersionString(interpreterVersion);
        sdk.setSdkAdditionalData(data);
        data.setValid(true);
        return sdk;
    }

    public String generateSdkHomePath(@NotNull T data) {
        if (data == null) {
            RemoteSdkFactoryImpl.$$$reportNull$$$0(1);
        }
        return data.getSdkId();
    }

    @NotNull
    protected abstract SdkType getSdkType(@NotNull T var1);

    @NotNull
    protected abstract String getInterpreterName(@NotNull T var1, @Nullable String var2) throws RemoteSdkException;

    @Nullable
    protected abstract String getInterpreterVersion(Project var1, @NotNull T var2) throws RemoteSdkException;

    @NotNull
    public Sdk createUnfinished(T data, Collection<Sdk> existingSdks) {
        String name = this.getDefaultUnfinishedName();
        SdkType sdkType = this.getSdkType(data);
        ProjectJdkImpl sdk = new ProjectJdkImpl(SdkConfigurationUtil.createUniqueSdkName((String)name, (Collection)Lists.newArrayList(existingSdks)), (SdkTypeId)sdkType);
        sdk.setHomePath(this.generateSdkHomePath(data));
        sdk.setSdkAdditionalData(data);
        data.setValid(false);
        ProjectJdkImpl projectJdkImpl = sdk;
        if (projectJdkImpl == null) {
            RemoteSdkFactoryImpl.$$$reportNull$$$0(2);
        }
        return projectJdkImpl;
    }

    public String getDefaultUnfinishedName() {
        return "Remote " + this.sdkName() + " interpreter";
    }

    public boolean canSaveUnfinished() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteSdkFactoryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkFactoryImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnfinished";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteSdk";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateSdkHomePath";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

