/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import java.awt.Image;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubApiResponse;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubAuthorization;
import org.jetbrains.plugins.github.api.data.GithubBranch;
import org.jetbrains.plugins.github.api.data.GithubGist;
import org.jetbrains.plugins.github.api.data.GithubIssue;
import org.jetbrains.plugins.github.api.data.GithubIssueComment;
import org.jetbrains.plugins.github.api.data.GithubPullRequest;
import org.jetbrains.plugins.github.api.data.GithubPullRequestDetailed;
import org.jetbrains.plugins.github.api.data.GithubPullRequestDetailedWithHtml;
import org.jetbrains.plugins.github.api.data.GithubPullRequestMergeMethod;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.data.GithubResponsePage;
import org.jetbrains.plugins.github.api.data.GithubSearchedIssue;
import org.jetbrains.plugins.github.api.requests.GithubAuthorizationCreateRequest;
import org.jetbrains.plugins.github.api.requests.GithubChangeIssueStateRequest;
import org.jetbrains.plugins.github.api.requests.GithubGistRequest;
import org.jetbrains.plugins.github.api.requests.GithubPullRequestMergeRebaseRequest;
import org.jetbrains.plugins.github.api.requests.GithubPullRequestMergeRequest;
import org.jetbrains.plugins.github.api.requests.GithubPullRequestRequest;
import org.jetbrains.plugins.github.api.requests.GithubRepoRequest;
import org.jetbrains.plugins.github.api.requests.GithubRequestPagination;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.api.util.GithubApiSearchQueryBuilder;
import org.jetbrains.plugins.github.api.util.GithubApiUrlQueryBuilder;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006\u000e\u000f\u0010\u0011\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0007J'\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests;", "", "()V", "getQuery", "", "queryParts", "", "([Ljava/lang/String;)Ljava/lang/String;", "getUrl", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "suffixes", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;[Ljava/lang/String;)Ljava/lang/String;", "suffix", "Auth", "CurrentUser", "Entity", "Gists", "Repos", "Search", "intellij.vcs.github"})
public final class GithubApiRequests {
    public static final GithubApiRequests INSTANCE;

    private final String getUrl(GithubServerPath server, String suffix) {
        return server.toApiUrl() + suffix;
    }

    @NotNull
    public final String getUrl(@NotNull GithubServerPath server, String ... suffixes) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Intrinsics.checkParameterIsNotNull((Object)suffixes, (String)"suffixes");
        String string = StringsKt.append((StringBuilder)new StringBuilder(server.toApiUrl()), (String[])Arrays.copyOf(suffixes, suffixes.length)).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder(server.toA\u2026end(*suffixes).toString()");
        return string;
    }

    private final String getQuery(String ... queryParts) {
        StringBuilder builder = new StringBuilder();
        for (String part : queryParts) {
            CharSequence charSequence = part;
            if (charSequence.length() == 0) continue;
            charSequence = builder;
            if (charSequence.length() == 0) {
                builder.append("?");
            } else {
                builder.append("&");
            }
            builder.append(part);
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    private GithubApiRequests() {
    }

    static {
        GithubApiRequests githubApiRequests;
        INSTANCE = githubApiRequests = new GithubApiRequests();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "url", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "getAvatar", "Ljava/awt/Image;", "RepoSubs", "Repos", "intellij.vcs.github"})
    public static final class CurrentUser
    extends Entity {
        public static final CurrentUser INSTANCE;

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubAuthenticatedUser> get(@NotNull GithubServerPath server) {
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            return CurrentUser.get(INSTANCE.getUrl(server, CurrentUser.INSTANCE.getUrlSuffix()));
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubAuthenticatedUser> get(@NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
            String acceptMimeType$iv = null;
            return ((GithubApiRequest.Get)new GithubApiRequest.Get.Json<GithubAuthenticatedUser>(url, GithubAuthenticatedUser.class, acceptMimeType$iv)).withOperationName("get profile information");
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<Image> getAvatar(@NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            return new GithubApiRequest.Get<Image>(url, url){
                final /* synthetic */ String $url;

                @NotNull
                public Image extractResult(@NotNull GithubApiResponse response) {
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    return (Image)response.handleBody(getAvatar.extractResult.1.INSTANCE);
                }
                {
                    this.$url = $captured_local_variable$0;
                    super($super_call_param$1, null, 2, null);
                }
            }.withOperationName("get profile avatar");
        }

        private CurrentUser() {
            super("/user");
        }

        static {
            CurrentUser currentUser;
            INSTANCE = currentUser = new CurrentUser();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001c\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000e0\u00042\u0006\u0010\u000f\u001a\u00020\tH\u0007J2\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000e0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\fH\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser$Repos;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubRepo;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "name", "", "description", "private", "", "get", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "allAssociated", "pagination", "Lorg/jetbrains/plugins/github/api/requests/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class Repos
        extends Entity {
            public static final Repos INSTANCE;

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server, boolean allAssociated) {
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                return new GithubApiPagesLoader.Request<GithubRepo>(Repos.get$default(server, allAssociated, null, 4, null), (Function1)new Function1<String, GithubApiRequest<GithubResponsePage<GithubRepo>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubRepo>> invoke(@NotNull String p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        Repos cfr_ignored_0 = (Repos)this.receiver;
                        return Repos.get(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(Repos.class);
                    }

                    public final String getName() {
                        return "get";
                    }

                    public final String getSignature() {
                        return "get(Ljava/lang/String;)Lorg/jetbrains/plugins/github/api/GithubApiRequest;";
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static /* synthetic */ GithubApiPagesLoader.Request pages$default(GithubServerPath githubServerPath, boolean bl, int n, Object object) {
                if ((n & 2) != 0) {
                    bl = true;
                }
                return Repos.pages(githubServerPath, bl);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server) {
                return Repos.pages$default(server, false, 2, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, boolean allAssociated, @Nullable GithubRequestPagination pagination) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                String[] stringArray = new String[3];
                stringArray[0] = INSTANCE.getUrlSuffix();
                stringArray[1] = INSTANCE.getUrlSuffix();
                String[] stringArray2 = new String[2];
                stringArray2[0] = allAssociated ? "" : "type=owner";
                GithubRequestPagination githubRequestPagination = pagination;
                String string2 = githubRequestPagination != null ? githubRequestPagination.toString() : null;
                int n = 1;
                String[] stringArray3 = stringArray2;
                String[] stringArray4 = stringArray2;
                GithubApiRequests githubApiRequests = GithubApiRequests.INSTANCE;
                int n2 = 2;
                String[] stringArray5 = stringArray;
                String[] stringArray6 = stringArray;
                GithubServerPath githubServerPath = server;
                GithubApiRequests githubApiRequests2 = GithubApiRequests.INSTANCE;
                String string3 = string2;
                if (string3 == null) {
                    string3 = "";
                }
                stringArray3[n] = string = string3;
                stringArray5[n2] = githubApiRequests.getQuery(stringArray4);
                return Repos.get(githubApiRequests2.getUrl(githubServerPath, stringArray6));
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, boolean bl, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 2) != 0) {
                    bl = true;
                }
                if ((n & 4) != 0) {
                    githubRequestPagination = null;
                }
                return Repos.get(githubServerPath, bl, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, boolean allAssociated) {
                return Repos.get$default(server, allAssociated, null, 4, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server) {
                return Repos.get$default(server, false, null, 6, null);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubRepo>(url, GithubRepo.class, acceptMimeType$iv)).withOperationName("get user repositories");
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubRepo> create(@NotNull GithubServerPath server, @NotNull String name, @NotNull String description, boolean bl) {
                void body$iv;
                void url$iv;
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
                GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), INSTANCE.getUrlSuffix());
                GithubRepoRequest githubRepoRequest = new GithubRepoRequest(name, description, bl);
                return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubRepo>((String)url$iv, body$iv, GithubRepo.class)).withOperationName("create user repository");
            }

            private Repos() {
                super("/repos");
            }

            static {
                Repos repos;
                INSTANCE = repos = new Repos();
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J(\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser$RepoSubs;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/GithubRepo;", "url", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "pagination", "Lorg/jetbrains/plugins/github/api/requests/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class RepoSubs
        extends Entity {
            public static final RepoSubs INSTANCE;

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server) {
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                return new GithubApiPagesLoader.Request<GithubRepo>(RepoSubs.get$default(server, null, 2, null), (Function1)new Function1<String, GithubApiRequest<GithubResponsePage<GithubRepo>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubRepo>> invoke(@NotNull String p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        RepoSubs cfr_ignored_0 = (RepoSubs)this.receiver;
                        return RepoSubs.get(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(RepoSubs.class);
                    }

                    public final String getName() {
                        return "get";
                    }

                    public final String getSignature() {
                        return "get(Ljava/lang/String;)Lorg/jetbrains/plugins/github/api/GithubApiRequest;";
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @Nullable GithubRequestPagination pagination) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                String[] stringArray = new String[3];
                stringArray[0] = INSTANCE.getUrlSuffix();
                stringArray[1] = INSTANCE.getUrlSuffix();
                GithubRequestPagination githubRequestPagination = pagination;
                String string2 = githubRequestPagination != null ? githubRequestPagination.toString() : null;
                int n = 0;
                String[] stringArray2 = new String[1];
                String[] stringArray3 = stringArray2;
                GithubApiRequests githubApiRequests = GithubApiRequests.INSTANCE;
                int n2 = 2;
                String[] stringArray4 = stringArray;
                String[] stringArray5 = stringArray;
                GithubServerPath githubServerPath = server;
                GithubApiRequests githubApiRequests2 = GithubApiRequests.INSTANCE;
                String string3 = string2;
                if (string3 == null) {
                    string3 = "";
                }
                stringArray2[n] = string = string3;
                stringArray4[n2] = githubApiRequests.getQuery(stringArray3);
                return RepoSubs.get(githubApiRequests2.getUrl(githubServerPath, stringArray5));
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 2) != 0) {
                    githubRequestPagination = null;
                }
                return RepoSubs.get(githubServerPath, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server) {
                return RepoSubs.get$default(server, null, 2, null);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubRepo>(url, GithubRepo.class, acceptMimeType$iv)).withOperationName("get repository subscriptions");
            }

            private RepoSubs() {
                super("/subscriptions");
            }

            static {
                RepoSubs repoSubs;
                INSTANCE = repoSubs = new RepoSubs();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\r\u000e\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J(\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "delete", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "get", "Lorg/jetbrains/plugins/github/api/data/GithubRepoDetailed;", "Branches", "Forks", "Issues", "PullRequests", "intellij.vcs.github"})
    public static final class Repos
    extends Entity {
        public static final Repos INSTANCE;

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubRepoDetailed> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
            Intrinsics.checkParameterIsNotNull((Object)repoName, (String)"repoName");
            GithubApiRequest.Get.Optional.Companion companion = GithubApiRequest.Get.Optional.Companion;
            String url$iv = INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName);
            String acceptMimeType$iv = null;
            return ((GithubApiRequest.Get.Optional)new GithubApiRequest.Get.Optional.Json<GithubRepoDetailed>(url$iv, GithubRepoDetailed.class, acceptMimeType$iv)).withOperationName("get information for repository " + username + '/' + repoName);
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<Unit> delete(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
            Intrinsics.checkParameterIsNotNull((Object)repoName, (String)"repoName");
            return new GithubApiRequest.Delete(INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName)).withOperationName("delete repository " + username + '/' + repoName);
        }

        private Repos() {
            super("/repos");
        }

        static {
            Repos repos;
            INSTANCE = repos = new Repos();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J8\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Branches;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/GithubBranch;", "url", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "repoName", "pagination", "Lorg/jetbrains/plugins/github/api/requests/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class Branches
        extends Entity {
            public static final Branches INSTANCE;

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubBranch> pages(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
                Intrinsics.checkParameterIsNotNull((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubBranch>(Branches.get$default(server, username, repoName, null, 8, null), (Function1)new Function1<String, GithubApiRequest<GithubResponsePage<GithubBranch>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubBranch>> invoke(@NotNull String p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        Branches cfr_ignored_0 = (Branches)this.receiver;
                        return Branches.get(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(Branches.class);
                    }

                    public final String getName() {
                        return "get";
                    }

                    public final String getSignature() {
                        return "get(Ljava/lang/String;)Lorg/jetbrains/plugins/github/api/GithubApiRequest;";
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubBranch>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @Nullable GithubRequestPagination pagination) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
                Intrinsics.checkParameterIsNotNull((Object)repoName, (String)"repoName");
                String[] stringArray = new String[4];
                stringArray[0] = INSTANCE.getUrlSuffix();
                stringArray[1] = '/' + username + '/' + repoName;
                stringArray[2] = INSTANCE.getUrlSuffix();
                GithubRequestPagination githubRequestPagination = pagination;
                String string2 = githubRequestPagination != null ? githubRequestPagination.toString() : null;
                int n = 0;
                String[] stringArray2 = new String[1];
                String[] stringArray3 = stringArray2;
                GithubApiRequests githubApiRequests = GithubApiRequests.INSTANCE;
                int n2 = 3;
                String[] stringArray4 = stringArray;
                String[] stringArray5 = stringArray;
                GithubServerPath githubServerPath = server;
                GithubApiRequests githubApiRequests2 = GithubApiRequests.INSTANCE;
                String string3 = string2;
                if (string3 == null) {
                    string3 = "";
                }
                stringArray2[n] = string = string3;
                stringArray4[n2] = githubApiRequests.getQuery(stringArray3);
                return Branches.get(githubApiRequests2.getUrl(githubServerPath, stringArray5));
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    githubRequestPagination = null;
                }
                return Branches.get(githubServerPath, string, string2, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubBranch>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                return Branches.get$default(server, username, repoName, null, 8, null);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubBranch>> get(@NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubBranch>(url, GithubBranch.class, acceptMimeType$iv)).withOperationName("get branches");
            }

            private Branches() {
                super("/branches");
            }

            static {
                Branches branches;
                INSTANCE = branches = new Branches();
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J8\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Forks;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/GithubRepo;", "url", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "repoName", "pagination", "Lorg/jetbrains/plugins/github/api/requests/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class Forks
        extends Entity {
            public static final Forks INSTANCE;

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
                Intrinsics.checkParameterIsNotNull((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubRepo>(Forks.get$default(server, username, repoName, null, 8, null), (Function1)new Function1<String, GithubApiRequest<GithubResponsePage<GithubRepo>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubRepo>> invoke(@NotNull String p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        Forks cfr_ignored_0 = (Forks)this.receiver;
                        return Forks.get(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(Forks.class);
                    }

                    public final String getName() {
                        return "get";
                    }

                    public final String getSignature() {
                        return "get(Ljava/lang/String;)Lorg/jetbrains/plugins/github/api/GithubApiRequest;";
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @Nullable GithubRequestPagination pagination) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
                Intrinsics.checkParameterIsNotNull((Object)repoName, (String)"repoName");
                String[] stringArray = new String[4];
                stringArray[0] = INSTANCE.getUrlSuffix();
                stringArray[1] = '/' + username + '/' + repoName;
                stringArray[2] = INSTANCE.getUrlSuffix();
                GithubRequestPagination githubRequestPagination = pagination;
                String string2 = githubRequestPagination != null ? githubRequestPagination.toString() : null;
                int n = 0;
                String[] stringArray2 = new String[1];
                String[] stringArray3 = stringArray2;
                GithubApiRequests githubApiRequests = GithubApiRequests.INSTANCE;
                int n2 = 3;
                String[] stringArray4 = stringArray;
                String[] stringArray5 = stringArray;
                GithubServerPath githubServerPath = server;
                GithubApiRequests githubApiRequests2 = GithubApiRequests.INSTANCE;
                String string3 = string2;
                if (string3 == null) {
                    string3 = "";
                }
                stringArray2[n] = string = string3;
                stringArray4[n2] = githubApiRequests.getQuery(stringArray3);
                return Forks.get(githubApiRequests2.getUrl(githubServerPath, stringArray5));
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    githubRequestPagination = null;
                }
                return Forks.get(githubServerPath, string, string2, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                return Forks.get$default(server, username, repoName, null, 8, null);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubRepo>(url, GithubRepo.class, acceptMimeType$iv)).withOperationName("get forks");
            }

            private Forks() {
                super("/forks");
            }

            static {
                Forks forks;
                INSTANCE = forks = new Forks();
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0007JP\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J>\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0007J6\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Issues;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/GithubIssue;", "url", "", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "repoName", "id", "state", "assignee", "pagination", "Lorg/jetbrains/plugins/github/api/requests/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "updateState", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "open", "", "Comments", "intellij.vcs.github"})
        public static final class Issues
        extends Entity {
            public static final Issues INSTANCE;

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubIssue> pages(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @Nullable String state2, @Nullable String assignee2) {
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
                Intrinsics.checkParameterIsNotNull((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubIssue>(Issues.get$default(server, username, repoName, state2, assignee2, null, 32, null), (Function1)new Function1<String, GithubApiRequest<GithubResponsePage<GithubIssue>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubIssue>> invoke(@NotNull String p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        Issues cfr_ignored_0 = (Issues)this.receiver;
                        return Issues.get(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(Issues.class);
                    }

                    public final String getName() {
                        return "get";
                    }

                    public final String getSignature() {
                        return "get(Ljava/lang/String;)Lorg/jetbrains/plugins/github/api/GithubApiRequest;";
                    }
                });
            }

            @JvmStatic
            @NotNull
            public static /* synthetic */ GithubApiPagesLoader.Request pages$default(GithubServerPath githubServerPath, String string, String string2, String string3, String string4, int n, Object object) {
                if ((n & 8) != 0) {
                    string3 = null;
                }
                if ((n & 0x10) != 0) {
                    string4 = null;
                }
                return Issues.pages(githubServerPath, string, string2, string3, string4);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubIssue>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @Nullable String state2, @Nullable String assignee2, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
                Intrinsics.checkParameterIsNotNull((Object)repoName, (String)"repoName");
                return Issues.get(GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)new Function1<GithubApiUrlQueryBuilder, Unit>(state2, assignee2, pagination){
                    final /* synthetic */ String $state;
                    final /* synthetic */ String $assignee;
                    final /* synthetic */ GithubRequestPagination $pagination;

                    public final void invoke(@NotNull GithubApiUrlQueryBuilder $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        $receiver.param("state", this.$state);
                        $receiver.param("assignee", this.$assignee);
                        $receiver.param(this.$pagination);
                    }
                    {
                        this.$state = string;
                        this.$assignee = string2;
                        this.$pagination = githubRequestPagination;
                        super(1);
                    }
                }))));
            }

            @JvmStatic
            @NotNull
            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, String string3, String string4, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    string3 = null;
                }
                if ((n & 0x10) != 0) {
                    string4 = null;
                }
                if ((n & 0x20) != 0) {
                    githubRequestPagination = null;
                }
                return Issues.get(githubServerPath, string, string2, string3, string4, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubIssue>> get(@NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubIssue>(url, GithubIssue.class, acceptMimeType$iv)).withOperationName("get issues in repository");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest.Get.Optional<GithubIssue> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String id) {
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
                Intrinsics.checkParameterIsNotNull((Object)repoName, (String)"repoName");
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                GithubApiRequest.Get.Optional.Companion companion = GithubApiRequest.Get.Optional.Companion;
                String url$iv = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), "/", id);
                String acceptMimeType$iv = null;
                return new GithubApiRequest.Get.Optional.Json<GithubIssue>(url$iv, GithubIssue.class, acceptMimeType$iv);
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest.Post<GithubIssue> updateState(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String id, boolean open) {
                void body$iv;
                void url$iv;
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
                Intrinsics.checkParameterIsNotNull((Object)repoName, (String)"repoName");
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                GithubApiRequest.Patch.Companion companion = GithubApiRequest.Patch.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), "/", id);
                GithubChangeIssueStateRequest githubChangeIssueStateRequest = new GithubChangeIssueStateRequest(open ? "open" : "closed");
                return new GithubApiRequest.Patch.Json<GithubIssue>((String)url$iv, body$iv, GithubIssue.class);
            }

            private Issues() {
                super("/issues");
            }

            static {
                Issues issues;
                INSTANCE = issues = new Issues();
            }

            @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J@\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0007J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Issues$Comments;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/GithubIssueComment;", "url", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "repoName", "issueId", "pagination", "Lorg/jetbrains/plugins/github/api/requests/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
            public static final class Comments
            extends Entity {
                public static final Comments INSTANCE;

                @JvmStatic
                @NotNull
                public static final GithubApiPagesLoader.Request<GithubIssueComment> pages(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String issueId) {
                    Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                    Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
                    Intrinsics.checkParameterIsNotNull((Object)repoName, (String)"repoName");
                    Intrinsics.checkParameterIsNotNull((Object)issueId, (String)"issueId");
                    return new GithubApiPagesLoader.Request<GithubIssueComment>(Comments.get$default(server, username, repoName, issueId, null, 16, null), (Function1)new Function1<String, GithubApiRequest<GithubResponsePage<GithubIssueComment>>>(INSTANCE){

                        @NotNull
                        public final GithubApiRequest<GithubResponsePage<GithubIssueComment>> invoke(@NotNull String p1) {
                            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                            Comments cfr_ignored_0 = (Comments)this.receiver;
                            return Comments.get(p1);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(Comments.class);
                        }

                        public final String getName() {
                            return "get";
                        }

                        public final String getSignature() {
                            return "get(Ljava/lang/String;)Lorg/jetbrains/plugins/github/api/GithubApiRequest;";
                        }
                    });
                }

                @JvmStatic
                @NotNull
                public static final GithubApiPagesLoader.Request<GithubIssueComment> pages(@NotNull String url) {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    return new GithubApiPagesLoader.Request<GithubIssueComment>(Comments.get(url), (Function1)new Function1<String, GithubApiRequest<GithubResponsePage<GithubIssueComment>>>(INSTANCE){

                        @NotNull
                        public final GithubApiRequest<GithubResponsePage<GithubIssueComment>> invoke(@NotNull String p1) {
                            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                            Comments cfr_ignored_0 = (Comments)this.receiver;
                            return Comments.get(p1);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(Comments.class);
                        }

                        public final String getName() {
                            return "get";
                        }

                        public final String getSignature() {
                            return "get(Ljava/lang/String;)Lorg/jetbrains/plugins/github/api/GithubApiRequest;";
                        }
                    });
                }

                @JvmStatic
                @NotNull
                public static final GithubApiRequest<GithubResponsePage<GithubIssueComment>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String issueId, @Nullable GithubRequestPagination pagination) {
                    Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                    Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
                    Intrinsics.checkParameterIsNotNull((Object)repoName, (String)"repoName");
                    Intrinsics.checkParameterIsNotNull((Object)issueId, (String)"issueId");
                    return Comments.get(GithubApiRequests.INSTANCE.getUrl(server, Repos.INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), "/", issueId, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)new Function1<GithubApiUrlQueryBuilder, Unit>(pagination){
                        final /* synthetic */ GithubRequestPagination $pagination;

                        public final void invoke(@NotNull GithubApiUrlQueryBuilder $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                            $receiver.param(this.$pagination);
                        }
                        {
                            this.$pagination = githubRequestPagination;
                            super(1);
                        }
                    }))));
                }

                @JvmStatic
                @NotNull
                public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, String string3, GithubRequestPagination githubRequestPagination, int n, Object object) {
                    if ((n & 0x10) != 0) {
                        githubRequestPagination = null;
                    }
                    return Comments.get(githubServerPath, string, string2, string3, githubRequestPagination);
                }

                @JvmStatic
                @NotNull
                public static final GithubApiRequest<GithubResponsePage<GithubIssueComment>> get(@NotNull String url) {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    GithubApiRequest.Get.Companion companion = GithubApiRequest.Get.Companion;
                    String acceptMimeType$iv = "application/vnd.github.v3.html+json";
                    return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubIssueComment>(url, GithubIssueComment.class, acceptMimeType$iv)).withOperationName("get comments for issue");
                }

                private Comments() {
                    super("/comments");
                }

                static {
                    Comments comments;
                    INSTANCE = comments = new Comments();
                }
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0007J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00042\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J.\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0007J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\tH\u0007J.\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0007\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$PullRequests;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestDetailed;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "title", "description", "head", "base", "get", "url", "getHtml", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestDetailedWithHtml;", "getMergeUrl", "pullRequest", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequest;", "merge", "", "commitSubject", "commitBody", "headSha", "rebaseMerge", "squashMerge", "intellij.vcs.github"})
        public static final class PullRequests
        extends Entity {
            public static final PullRequests INSTANCE;

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubPullRequestDetailed> get(@NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.Json<GithubPullRequestDetailed>(url, GithubPullRequestDetailed.class, acceptMimeType$iv)).withOperationName("get pull request");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubPullRequestDetailedWithHtml> getHtml(@NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                GithubApiRequest.Get.Companion companion = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = "application/vnd.github.v3.html+json";
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.Json<GithubPullRequestDetailedWithHtml>(url, GithubPullRequestDetailedWithHtml.class, acceptMimeType$iv)).withOperationName("get pull request");
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubPullRequestDetailed> create(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String title, @NotNull String description, @NotNull String head, @NotNull String base) {
                void body$iv;
                void url$iv;
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
                Intrinsics.checkParameterIsNotNull((Object)repoName, (String)"repoName");
                Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
                Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
                Intrinsics.checkParameterIsNotNull((Object)head, (String)"head");
                Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
                GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix());
                GithubPullRequestRequest githubPullRequestRequest = new GithubPullRequestRequest(title, description, head, base);
                return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubPullRequestDetailed>((String)url$iv, body$iv, GithubPullRequestDetailed.class)).withOperationName("create pull request in " + username + '/' + repoName);
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<Unit> merge(@NotNull GithubPullRequest pullRequest, @NotNull String commitSubject, @NotNull String commitBody, @NotNull String headSha) {
                void body$iv;
                void url$iv;
                Intrinsics.checkParameterIsNotNull((Object)pullRequest, (String)"pullRequest");
                Intrinsics.checkParameterIsNotNull((Object)commitSubject, (String)"commitSubject");
                Intrinsics.checkParameterIsNotNull((Object)commitBody, (String)"commitBody");
                Intrinsics.checkParameterIsNotNull((Object)headSha, (String)"headSha");
                GithubApiRequest.Put.Companion companion = GithubApiRequest.Put.Companion;
                String string = INSTANCE.getMergeUrl(pullRequest);
                GithubPullRequestMergeRequest githubPullRequestMergeRequest = new GithubPullRequestMergeRequest(commitSubject, commitBody, headSha, GithubPullRequestMergeMethod.merge);
                return ((GithubApiRequest.Put)new GithubApiRequest.Put.Json<Unit>((String)url$iv, body$iv, Unit.class)).withOperationName("merge pull request " + pullRequest.getNumber());
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<Unit> squashMerge(@NotNull GithubPullRequest pullRequest, @NotNull String commitSubject, @NotNull String commitBody, @NotNull String headSha) {
                void body$iv;
                void url$iv;
                Intrinsics.checkParameterIsNotNull((Object)pullRequest, (String)"pullRequest");
                Intrinsics.checkParameterIsNotNull((Object)commitSubject, (String)"commitSubject");
                Intrinsics.checkParameterIsNotNull((Object)commitBody, (String)"commitBody");
                Intrinsics.checkParameterIsNotNull((Object)headSha, (String)"headSha");
                GithubApiRequest.Put.Companion companion = GithubApiRequest.Put.Companion;
                String string = INSTANCE.getMergeUrl(pullRequest);
                GithubPullRequestMergeRequest githubPullRequestMergeRequest = new GithubPullRequestMergeRequest(commitSubject, commitBody, headSha, GithubPullRequestMergeMethod.squash);
                return ((GithubApiRequest.Put)new GithubApiRequest.Put.Json<Unit>((String)url$iv, body$iv, Unit.class)).withOperationName("squash and merge pull request " + pullRequest.getNumber());
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<Unit> rebaseMerge(@NotNull GithubPullRequest pullRequest, @NotNull String headSha) {
                void body$iv;
                void url$iv;
                Intrinsics.checkParameterIsNotNull((Object)pullRequest, (String)"pullRequest");
                Intrinsics.checkParameterIsNotNull((Object)headSha, (String)"headSha");
                GithubApiRequest.Put.Companion companion = GithubApiRequest.Put.Companion;
                String string = INSTANCE.getMergeUrl(pullRequest);
                GithubPullRequestMergeRebaseRequest githubPullRequestMergeRebaseRequest = new GithubPullRequestMergeRebaseRequest(headSha);
                return ((GithubApiRequest.Put)new GithubApiRequest.Put.Json<Unit>((String)url$iv, body$iv, Unit.class)).withOperationName("rebase and merge pull request " + pullRequest.getNumber());
            }

            private final String getMergeUrl(GithubPullRequest pullRequest) {
                return pullRequest.getUrl() + "/merge";
            }

            private PullRequests() {
                super("/pulls");
            }

            static {
                PullRequests pullRequests;
                INSTANCE = pullRequests = new PullRequests();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\fH\u0007J \u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\fH\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Gists;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubGist;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "contents", "", "Lorg/jetbrains/plugins/github/api/requests/GithubGistRequest$FileContent;", "description", "", "public", "", "delete", "", "id", "get", "intellij.vcs.github"})
    public static final class Gists
    extends Entity {
        public static final Gists INSTANCE;

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubGist> create(@NotNull GithubServerPath server, @NotNull List<? extends GithubGistRequest.FileContent> contents, @NotNull String description, boolean bl) {
            void url$iv;
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Intrinsics.checkParameterIsNotNull(contents, (String)"contents");
            Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
            GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
            String string = INSTANCE.getUrl(server, Gists.INSTANCE.getUrlSuffix());
            GithubGistRequest body$iv = new GithubGistRequest(contents, description, bl);
            return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubGist>((String)url$iv, body$iv, GithubGist.class)).withOperationName("create gist");
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubGist> get(@NotNull GithubServerPath server, @NotNull String id) {
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            GithubApiRequest.Get.Optional.Companion companion = GithubApiRequest.Get.Optional.Companion;
            String url$iv = INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + id);
            String acceptMimeType$iv = null;
            return ((GithubApiRequest.Get.Optional)new GithubApiRequest.Get.Optional.Json<GithubGist>(url$iv, GithubGist.class, acceptMimeType$iv)).withOperationName("get gist " + id);
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<Unit> delete(@NotNull GithubServerPath server, @NotNull String id) {
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            return new GithubApiRequest.Delete(INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + id)).withOperationName("delete gist " + id);
        }

        private Gists() {
            super("/gists");
        }

        static {
            Gists gists;
            INSTANCE = gists = new Gists();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Search;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "Issues", "intellij.vcs.github"})
    public static final class Search
    extends Entity {
        public static final Search INSTANCE;

        private Search() {
            super("/search");
        }

        static {
            Search search;
            INSTANCE = search = new Search();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J0\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007JP\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J>\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Search$Issues;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/GithubSearchedIssue;", "url", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "query", "pagination", "Lorg/jetbrains/plugins/github/api/requests/GithubRequestPagination;", "repoPath", "Lorg/jetbrains/plugins/github/api/GithubFullPath;", "state", "assignee", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class Issues
        extends Entity {
            public static final Issues INSTANCE;

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubSearchedIssue> pages(@NotNull GithubServerPath server, @Nullable GithubFullPath repoPath, @Nullable String state2, @Nullable String assignee2, @Nullable String query) {
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                return new GithubApiPagesLoader.Request<GithubSearchedIssue>(Issues.get$default(server, repoPath, state2, assignee2, query, null, 32, null), (Function1)new Function1<String, GithubApiRequest<GithubResponsePage<GithubSearchedIssue>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubSearchedIssue>> invoke(@NotNull String p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        Issues cfr_ignored_0 = (Issues)this.receiver;
                        return Issues.get(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(Issues.class);
                    }

                    public final String getName() {
                        return "get";
                    }

                    public final String getSignature() {
                        return "get(Ljava/lang/String;)Lorg/jetbrains/plugins/github/api/GithubApiRequest;";
                    }
                });
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubSearchedIssue>> get(@NotNull GithubServerPath server, @Nullable GithubFullPath repoPath, @Nullable String state2, @Nullable String assignee2, @Nullable String query, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                return Issues.get(GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)new Function1<GithubApiUrlQueryBuilder, Unit>(repoPath, state2, assignee2, query, pagination){
                    final /* synthetic */ GithubFullPath $repoPath;
                    final /* synthetic */ String $state;
                    final /* synthetic */ String $assignee;
                    final /* synthetic */ String $query;
                    final /* synthetic */ GithubRequestPagination $pagination;

                    public final void invoke(@NotNull GithubApiUrlQueryBuilder $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        $receiver.param("q", GithubApiSearchQueryBuilder.Companion.searchQuery((Function1<? super GithubApiSearchQueryBuilder, Unit>)((Function1)new Function1<GithubApiSearchQueryBuilder, Unit>(this){
                            final /* synthetic */ get.1 this$0;

                            public final void invoke(@NotNull GithubApiSearchQueryBuilder $receiver) {
                                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                                GithubFullPath githubFullPath = this.this$0.$repoPath;
                                String string = githubFullPath != null ? githubFullPath.getFullName() : null;
                                String string2 = "repo";
                                GithubApiSearchQueryBuilder githubApiSearchQueryBuilder = $receiver;
                                String string3 = string;
                                if (string3 == null) {
                                    string3 = "";
                                }
                                String string4 = string3;
                                githubApiSearchQueryBuilder.qualifier(string2, string4);
                                $receiver.qualifier("state", this.this$0.$state);
                                $receiver.qualifier("assignee", this.this$0.$assignee);
                                $receiver.query(this.this$0.$query);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        })));
                        $receiver.param(this.$pagination);
                    }
                    {
                        this.$repoPath = githubFullPath;
                        this.$state = string;
                        this.$assignee = string2;
                        this.$query = string3;
                        this.$pagination = githubRequestPagination;
                        super(1);
                    }
                }))));
            }

            @JvmStatic
            @NotNull
            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, GithubFullPath githubFullPath, String string, String string2, String string3, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 0x20) != 0) {
                    githubRequestPagination = null;
                }
                return Issues.get(githubServerPath, githubFullPath, string, string2, string3, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubSearchedIssue>> get(@NotNull GithubServerPath server, @NotNull String query, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
                return Issues.get(GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)new Function1<GithubApiUrlQueryBuilder, Unit>(query, pagination){
                    final /* synthetic */ String $query;
                    final /* synthetic */ GithubRequestPagination $pagination;

                    public final void invoke(@NotNull GithubApiUrlQueryBuilder $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        $receiver.param("q", this.$query);
                        $receiver.param(this.$pagination);
                    }
                    {
                        this.$query = string;
                        this.$pagination = githubRequestPagination;
                        super(1);
                    }
                }))));
            }

            @JvmStatic
            @NotNull
            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 4) != 0) {
                    githubRequestPagination = null;
                }
                return Issues.get(githubServerPath, string, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubSearchedIssue>> get(@NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonSearchPage<GithubSearchedIssue>(url, GithubSearchedIssue.class, acceptMimeType$iv)).withOperationName("search issues in repository");
            }

            private Issues() {
                super("/issues");
            }

            static {
                Issues issues;
                INSTANCE = issues = new Issues();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\r0\u00042\u0006\u0010\u000e\u001a\u00020\nH\u0007J(\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\r0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Auth;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubAuthorization;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "scopes", "", "", "note", "get", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "pagination", "Lorg/jetbrains/plugins/github/api/requests/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
    public static final class Auth
    extends Entity {
        public static final Auth INSTANCE;

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubAuthorization> create(@NotNull GithubServerPath server, @NotNull List<String> scopes, @NotNull String note) {
            void url$iv;
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Intrinsics.checkParameterIsNotNull(scopes, (String)"scopes");
            Intrinsics.checkParameterIsNotNull((Object)note, (String)"note");
            GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
            String string = INSTANCE.getUrl(server, Auth.INSTANCE.getUrlSuffix());
            GithubAuthorizationCreateRequest body$iv = new GithubAuthorizationCreateRequest(scopes, note, null);
            return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubAuthorization>((String)url$iv, body$iv, GithubAuthorization.class)).withOperationName("create authorization " + note);
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubResponsePage<GithubAuthorization>> get(@NotNull GithubServerPath server, @Nullable GithubRequestPagination pagination) {
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            return Auth.get(INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)new Function1<GithubApiUrlQueryBuilder, Unit>(pagination){
                final /* synthetic */ GithubRequestPagination $pagination;

                public final void invoke(@NotNull GithubApiUrlQueryBuilder $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    $receiver.param(this.$pagination);
                }
                {
                    this.$pagination = githubRequestPagination;
                    super(1);
                }
            }))));
        }

        @JvmStatic
        @NotNull
        public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, GithubRequestPagination githubRequestPagination, int n, Object object) {
            if ((n & 2) != 0) {
                githubRequestPagination = null;
            }
            return Auth.get(githubServerPath, githubRequestPagination);
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubResponsePage<GithubAuthorization>> get(@NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
            String acceptMimeType$iv = null;
            return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubAuthorization>(url, GithubAuthorization.class, acceptMimeType$iv)).withOperationName("get authorizations");
        }

        @JvmStatic
        @NotNull
        public static final GithubApiPagesLoader.Request<GithubAuthorization> pages(@NotNull GithubServerPath server, @Nullable GithubRequestPagination pagination) {
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            return new GithubApiPagesLoader.Request<GithubAuthorization>(Auth.get(server, pagination), (Function1)new Function1<String, GithubApiRequest<GithubResponsePage<GithubAuthorization>>>(INSTANCE){

                @NotNull
                public final GithubApiRequest<GithubResponsePage<GithubAuthorization>> invoke(@NotNull String p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    Auth cfr_ignored_0 = (Auth)this.receiver;
                    return Auth.get(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(Auth.class);
                }

                public final String getName() {
                    return "get";
                }

                public final String getSignature() {
                    return "get(Ljava/lang/String;)Lorg/jetbrains/plugins/github/api/GithubApiRequest;";
                }
            });
        }

        @JvmStatic
        @NotNull
        public static /* synthetic */ GithubApiPagesLoader.Request pages$default(GithubServerPath githubServerPath, GithubRequestPagination githubRequestPagination, int n, Object object) {
            if ((n & 2) != 0) {
                githubRequestPagination = null;
            }
            return Auth.pages(githubServerPath, githubRequestPagination);
        }

        private Auth() {
            super("/authorizations");
        }

        static {
            Auth auth;
            INSTANCE = auth = new Auth();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "", "urlSuffix", "", "(Ljava/lang/String;)V", "getUrlSuffix", "()Ljava/lang/String;", "intellij.vcs.github"})
    public static abstract class Entity {
        @NotNull
        private final String urlSuffix;

        @NotNull
        public final String getUrlSuffix() {
            return this.urlSuffix;
        }

        public Entity(@NotNull String urlSuffix) {
            Intrinsics.checkParameterIsNotNull((Object)urlSuffix, (String)"urlSuffix");
            this.urlSuffix = urlSuffix;
        }
    }
}

