/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run.config;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.run.config.HttpEnvironmentComboBox;
import com.intellij.ws.http.request.run.config.HttpRequestComboBox;
import com.intellij.ws.http.request.run.config.HttpRequestRunConfiguration;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestRunConfigurationEditor
extends SettingsEditor<HttpRequestRunConfiguration> {
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myPathField;
    private HttpEnvironmentComboBox myEnvironmentComboBox;
    private HttpRequestComboBox myRequestNameComboBox;
    private JBLabel myEnvLabel;
    private JBLabel myRequestLabel;
    private final Project myProject;

    public HttpRequestRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            HttpRequestRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myPathField.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                HttpEnvironmentComboBox.HttpEnvironmentItem env;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String envName = (env = HttpRequestRunConfigurationEditor.this.myEnvironmentComboBox.getSelectedItem()) != null ? env.getName() : null;
                HttpRequestRunConfigurationEditor.this.updateState(HttpRequestRunConfigurationEditor.this.myPathField.getText(), envName, HttpRequestRunConfigurationEditor.this.myRequestNameComboBox.getSelectedRequestIndex());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/http/request/run/config/HttpRequestRunConfigurationEditor$1", "textChanged"));
            }
        });
        this.myEnvLabel.setLabelFor((Component)((Object)this.myEnvironmentComboBox));
        this.myRequestLabel.setLabelFor((Component)((Object)this.myRequestNameComboBox));
    }

    protected void resetEditorFrom(@NotNull HttpRequestRunConfiguration configuration) {
        if (configuration == null) {
            HttpRequestRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        HttpRequestRunConfiguration.Settings settings = configuration.getSettings();
        this.myPathField.setText(settings.getFilePath());
        this.updateState(settings.getFilePath(), settings.getEnvironment(), settings.getIndex());
    }

    private void updateState(@Nullable String path, @Nullable String env, int index) {
        PsiFile file = HttpRequestRunConfiguration.findFileByPath(this.myProject, path);
        this.myEnvironmentComboBox.reset(this.myProject, file, env);
        this.myEnvironmentComboBox.setEnabled(this.myEnvironmentComboBox.getModel().getSize() > 1);
        if (file instanceof HttpRequestPsiFile) {
            this.myRequestNameComboBox.reset((HttpRequestPsiFile)file, index);
            this.myRequestNameComboBox.setEnabled(this.myRequestNameComboBox.getModel().getSize() > 1);
        } else {
            this.myRequestNameComboBox.setEnabled(false);
        }
    }

    protected void applyEditorTo(@NotNull HttpRequestRunConfiguration configuration) {
        if (configuration == null) {
            HttpRequestRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        HttpRequestRunConfiguration.Settings settings = configuration.getSettings();
        settings.setFilePath(this.myPathField.getText());
        settings.setIndex(this.myRequestNameComboBox.getSelectedRequestIndex());
        HttpEnvironmentComboBox.HttpEnvironmentItem env = this.myEnvironmentComboBox.getSelectedItem();
        settings.setEnvironment(env == null ? "" : env.getName());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            HttpRequestRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myEnvironmentComboBox = new HttpEnvironmentComboBox();
        this.myRequestNameComboBox = new HttpRequestComboBox();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/config/HttpRequestRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/config/HttpRequestRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Configuration", (int)0, (int)0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("com/intellij/ws/rest/client/RestClientBundle").getString("http.request.run.configuration.file.label"));
        jPanel3.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myEnvLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("com/intellij/ws/rest/client/RestClientBundle").getString("http.request.run.configuration.env.label"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        HttpEnvironmentComboBox httpEnvironmentComboBox = this.myEnvironmentComboBox;
        jPanel3.add((Component)((Object)httpEnvironmentComboBox), new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myRequestLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/intellij/ws/rest/client/RestClientBundle").getString("http.request.run.configuration.index.label"));
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        HttpRequestComboBox httpRequestComboBox = this.myRequestNameComboBox;
        jPanel4.add((Component)((Object)httpRequestComboBox), new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel3.setLabelFor((Component)textFieldWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

