# 索引の使い方
インラインタグ `@<idx>` および `@<hidx>` を用いて、索引単語を埋め込むことができます。索引を整列するにはその索引単語の「読み」が必要ですが、LaTeX ビルダにおいては、用意した辞書や形態素解析を使い、読み順に整列して紙面化します。

## 注意
* LaTeX の mendex コマンドの実装に依存しているため、 現時点では英語または日本語以外の挙動は不明です。
* 形態素解析は、外部ソフトウェアの MeCab (http://taku910.github.io/mecab/) 、その辞書である IPA 辞書、MeCab の Ruby バインドである mecab に依存しています。
* LaTeX ビルダ以外のビルダでは、埋め込んだ索引を利用する手法を提供していません。後述のヒントを参照してください。
* LaTeX ビルダでの索引生成機能は、デフォルトで無効にしています。設定 YAML ファイルで明示的に有効にする必要があります。

## MeCab のセットアップ
形態素解析による自動読みを使用する場合、MeCab (http://taku910.github.io/mecab/) およびその辞書、Ruby バインドライブラリの mecab をインストールしておく必要があります。

Debian GNU/Linux あるいは Ubuntu の環境では、次のようにパッケージをインストールします。

```
apt install mecab mecab-ipadic-utf8 ruby-mecab
```

MeCab 標準の辞書としては IPA 辞書と Juman 辞書がありますが、本機能の自動読みのためには「-Oyomi」オプションがサポートされている必要があり、これに対応しているのは IPA 辞書のみです。

## 設定
review-pdfmaker での索引作成を有効にするため、config.yml (別の設定ファイルを使う場合はその YAML ファイル) に、次のように追加します。

```
pdfmaker:
  makeindex: true
```

re ファイル内に、`@<idx>` または `@<hidx>` インラインタグを使って索引を埋め込みます。`@<idx>` は、指定の文字列をそのまま紙面に出力するとともに索引とします。`@<hidx>` (hidden index) は、指定の文字列を索引とするのみで、紙面には出力しません。`@<hidx>` の場合は文字列内を `<<>>` で区切り、`親索引語<<>>子索引語`、`親索引語<<>>子索引語<<>>孫索引語`  とレベル分けした索引を指定できます。

```
@<idx>{表示もする索引}です
  ↓
表示もする索引です

[索引]
ひ
表示もする索引....1
```

```
@<hidx>{表示しない索引}です@<hidx>{親<<>>子}
  ↓
です

[索引]
お
 親
   子................1


ひ
 表示しない索引....1
```

## 読み辞書
形態素解析は万能ではなく、特に短い単語は音読み・訓読みの違いで期待と異なる結果になりやすく、また辞書に載っていない専門的な単語は読みを解釈できずにおかしな結果になります。

内部で使用している mendex プログラムに与える読み辞書を用意すれば、まずその辞書でのマッチングを試み、マッチングしなかったときに形態素解析を試みる、という手順をとることができます。また、MeCab を利用できない環境でも、すべての索引単語を解決できる読み辞書を用意すれば、索引機能を利用できます。

辞書は次のように熟語と読みのペアをタブまたはスペースで区切ったテキストファイルとして作成します。

```
漢字  かんじ
読み  よみ
α    あるふぁ
```

このファイルを config.yml 設定ファイルで指定します (以下では my.dic を指定)。

```
pdfmaker:
  makeindex: true
  makeindex_dic: my.dic
```

なお、mendex のアルゴリズム上、辞書や形態素解析の適用は常にうまくいくとは限りません。たとえば「表 (ひょう、おもて)」のように 2 通りの読み方があるような語を使い分けたいというときには、review-pdfmaker のフック機能を使い、LaTeX のソースファイルに変換したところで LaTeX の索引命令に読みを明示する (たとえば `\index{おもて@表}`) といった対処が必要になるでしょう。LaTeX の索引命令の詳細については、mendex コマンドのオンラインマニュアルを参照してください。

## カスタマイズ
`pdfmaker:` 以下に記述可能な YAML 設定を以下にまとめます。

* `makeindex`: `true` で索引を作成 (デフォルト: `null`＝作成しない)
* `makeindex_command`: 索引作成の支援コマンド (デフォルト: `mendex`)
* `makeindex_options`: 支援コマンドのオプション (デフォルト: `-f -r -I utf8`)
* `makeindex_sty`: 支援コマンドで使うスタイルファイル (デフォルト: `null`)
* `makeindex_dic`: 支援コマンドで使う読み辞書ファイル (デフォルト: `null`)
* `makeindex_mecab`: MeCab による形態素解析を試みる (デフォルト: `true`＝使用する)
* `makeindex_mecab_opts`: MeCab で読みを取得するオプション (デフォルト: `-Oyomi`)

たとえば索引ページの見た目の表現は mendex コマンドのデフォルトのものが使われますが、設定をファイルで用意し、`makeindex_sty` にそのファイルを指定すれば変更できます。設定については mendex コマンドのオンラインマニュアルを参照してください。

## ヒント
「注意」で述べたとおり、LaTeX ビルダ以外のビルダでそれを活用する方法は提供していません。というのも、ほかのビルダでは、索引を読み順に並べ替えたり、それを表現したりといった方法についての一般的な解が存在しないからです。

EPUB (HTML ビルダ) では `<!-- IDX:索引文字列 -->` のコメントで、IDGXML ビルダでは `<index value="索引文字列">` の XML 要素で、それぞれ索引は埋め込まれます。たとえばこれらを拾い出して、独自の辞書読み・整列ツール (LaTeX の mendex コマンドを流用するなど) を用意する方法が考えられるでしょう。
