/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.PlatformTestCase;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TempFiles {
    private final Collection<File> myFilesToDelete;

    public TempFiles(@NotNull Collection<File> filesToDelete) {
        if (filesToDelete == null) {
            TempFiles.$$$reportNull$$$0(0);
        }
        this.myFilesToDelete = filesToDelete;
    }

    @Nullable
    public VirtualFile createVFile(@NotNull String prefix) {
        if (prefix == null) {
            TempFiles.$$$reportNull$$$0(1);
        }
        return TempFiles.getVFileByFile(this.createTempFile(prefix));
    }

    @Nullable
    public VirtualFile createVFile(@NotNull String prefix, String postfix) {
        if (prefix == null) {
            TempFiles.$$$reportNull$$$0(2);
        }
        return TempFiles.getVFileByFile(this.createTempFile(prefix, postfix));
    }

    @NotNull
    public File createTempFile(@NotNull String prefix) {
        if (prefix == null) {
            TempFiles.$$$reportNull$$$0(3);
        }
        File file = this.createTempFile(prefix, null);
        if (file == null) {
            TempFiles.$$$reportNull$$$0(4);
        }
        return file;
    }

    @NotNull
    public File createTempFile(@NotNull String prefix, String suffix) {
        if (prefix == null) {
            TempFiles.$$$reportNull$$$0(5);
        }
        File file = this.createTempFile(prefix, suffix, true);
        if (file == null) {
            TempFiles.$$$reportNull$$$0(6);
        }
        return file;
    }

    @NotNull
    public File createTempFile(@NotNull String prefix, String suffix, boolean isRefreshVfs) {
        File file;
        if (prefix == null) {
            TempFiles.$$$reportNull$$$0(7);
        }
        try {
            File tempFile = FileUtilRt.createTempFile((String)prefix, (String)suffix, (boolean)false);
            this.tempFileCreated(tempFile);
            if (isRefreshVfs) {
                TempFiles.getVFileByFile(tempFile);
            }
            file = tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file == null) {
            TempFiles.$$$reportNull$$$0(8);
        }
        return file;
    }

    private void tempFileCreated(@NotNull File tempFile) {
        if (tempFile == null) {
            TempFiles.$$$reportNull$$$0(9);
        }
        this.myFilesToDelete.add(tempFile);
    }

    @Nullable
    public static VirtualFile getVFileByFile(@NotNull File tempFile) {
        if (tempFile == null) {
            TempFiles.$$$reportNull$$$0(10);
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile);
    }

    @NotNull
    public File createTempDir() {
        File file = this.createTempDir("dir");
        if (file == null) {
            TempFiles.$$$reportNull$$$0(11);
        }
        return file;
    }

    @NotNull
    private File createTempDir(@NotNull String prefix) {
        File file;
        if (prefix == null) {
            TempFiles.$$$reportNull$$$0(12);
        }
        try {
            File dir = FileUtil.createTempDirectory((String)prefix, (String)"test", (boolean)false);
            this.tempFileCreated(dir);
            PlatformTestCase.synchronizeTempDirVfs(TempFiles.getVFileByFile(dir));
            file = dir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file == null) {
            TempFiles.$$$reportNull$$$0(13);
        }
        return file;
    }

    @Nullable
    public VirtualFile createTempVDir() {
        return this.createTempVDir("dir");
    }

    @Nullable
    public VirtualFile createTempVDir(@NotNull String prefix) {
        if (prefix == null) {
            TempFiles.$$$reportNull$$$0(14);
        }
        return TempFiles.getVFileByFile(this.createTempDir(prefix));
    }

    public void deleteAll() {
        for (File file : this.myFilesToDelete) {
            if (FileUtil.delete((File)file)) continue;
            file.deleteOnExit();
        }
    }

    public VirtualFile createVFile(final @NotNull VirtualFile parentDir, final @NotNull String name, final @NotNull String text) {
        if (parentDir == null) {
            TempFiles.$$$reportNull$$$0(15);
        }
        if (name == null) {
            TempFiles.$$$reportNull$$$0(16);
        }
        if (text == null) {
            TempFiles.$$$reportNull$$$0(17);
        }
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    VirtualFile virtualFile = parentDir.createChildData((Object)this, name);
                    VfsUtil.saveText((VirtualFile)virtualFile, (String)(text + "\n"));
                    return virtualFile;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/TempFiles";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/TempFiles";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createVFile";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tempFileCreated";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVFileByFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTempDir";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTempVDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

