/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.DebuggableRunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.intellij.javascript.debugger.execution.DebuggableProcessState;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Function;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u001c\u0010\u001b\u001a\u00020\f2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0004J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u001c\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020'0-2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J&\u0010.\u001a\u00020\f2\u001e\u0010/\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\tJ\u001e\u00100\u001a\b\u0012\u0004\u0012\u00020$0-2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R(\u0010\b\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00061"}, d2={"Lcom/intellij/javascript/debugger/execution/DebuggableProcessState;", "T", "Lcom/intellij/javascript/debugger/execution/DebuggableProcessRunConfiguration;", "Lcom/intellij/execution/runners/DebuggableRunProfileState;", "configuration", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/intellij/javascript/debugger/execution/DebuggableProcessRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "additionalEnvironmentHandler", "Lkotlin/Function1;", "", "", "", "getConfiguration", "()Lcom/intellij/javascript/debugger/execution/DebuggableProcessRunConfiguration;", "Lcom/intellij/javascript/debugger/execution/DebuggableProcessRunConfiguration;", "getEnvironment", "()Lcom/intellij/execution/runners/ExecutionEnvironment;", "inputPath", "getInputPath", "()Ljava/lang/String;", "addConsoleFilters", "builder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "addInputPathArg", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "configureAdditionalEnvironment", "env", "configureCommandLine", "debugPort", "", "configureEnvironment", "createConsole", "Lcom/intellij/execution/ui/ConsoleView;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "createProcessHandler", "execute", "Lcom/intellij/execution/ExecutionResult;", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "Lorg/jetbrains/concurrency/Promise;", "registerAdditionalEnvironment", "handler", "startProcess", "intellij.javascript.debugger"})
public abstract class DebuggableProcessState<T extends DebuggableProcessRunConfiguration>
implements DebuggableRunProfileState {
    private Function1<? super Map<String, String>, Unit> additionalEnvironmentHandler;
    @NotNull
    private final T configuration;
    @NotNull
    private final ExecutionEnvironment environment;

    @NotNull
    public final ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<RunnerSettings> runner) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
        Object object = this.execute(-1).blockingGet(10);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (ExecutionResult)object;
    }

    @NotNull
    public Promise<ExecutionResult> execute(int debugPort) {
        Promise promise2 = this.startProcess(new GeneralCommandLine(), debugPort).then(new Function<T, SUB_RESULT>(this){
            final /* synthetic */ DebuggableProcessState this$0;

            @NotNull
            public final DefaultExecutionResult fun(ProcessHandler it) {
                ProcessHandler processHandler = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)processHandler, (String)"it");
                return new DefaultExecutionResult((ExecutionConsole)DebuggableProcessState.access$createConsole(this.this$0, processHandler), it);
            }
            {
                this.this$0 = debuggableProcessState;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"startProcess(GeneralComm\u2026(createConsole(it), it) }");
        return promise2;
    }

    private final ConsoleView createConsole(ProcessHandler processHandler) {
        TextConsoleBuilderImpl consoleBuilder2 = new TextConsoleBuilderImpl(this, this.environment.getProject()){
            final /* synthetic */ DebuggableProcessState this$0;

            @NotNull
            protected ConsoleView createConsole() {
                return (ConsoleView)new ConsoleViewImpl(this, this.this$0.getEnvironment().getProject(), this.getScope(), this.isViewer(), true){
                    final /* synthetic */ createConsole.consoleBuilder.1 this$0;

                    @Nullable
                    public Object getData(@NotNull String dataId) {
                        Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
                        Object object = super.getData(dataId);
                        if (object == null) {
                            object = LangDataKeys.RUN_PROFILE.is(dataId) ? this.this$0.this$0.getEnvironment().getRunProfile() : null;
                        }
                        return object;
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
                    }
                };
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        this.addConsoleFilters((TextConsoleBuilder)consoleBuilder2);
        ConsoleView consoleView = consoleBuilder2.getConsole();
        if (consoleView == null) {
            Intrinsics.throwNpe();
        }
        ConsoleView console = consoleView;
        console.attachToProcess(processHandler);
        return console;
    }

    protected void addConsoleFilters(@NotNull TextConsoleBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
    }

    @NotNull
    protected String getInputPath() {
        String string = this.configuration.getInputPath();
        if (string == null) {
            throw (Throwable)new ExecutionException("Program input path not specified");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.inputPath \u2026nput path not specified\")");
        String inputPath = string;
        if (ScriptFileUtil.isMemoryScriptPath((String)inputPath)) {
            return inputPath;
        }
        String string2 = FileUtilRt.toSystemDependentName((String)PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.environment.getProject())).expandPath(inputPath));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileUtilRt.toSystemDepen\u2026t).expandPath(inputPath))");
        return string2;
    }

    @NotNull
    protected Promise<ProcessHandler> startProcess(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        String string = this.configuration.getEffectiveExePath();
        if (string == null) {
            throw (Throwable)new ExecutionException("Program path not specified");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.effectiveE\u2026gram path not specified\")");
        String exePath = string;
        commandLine.setExePath(this.configuration.correctExePath(exePath));
        String string2 = this.configuration.getEffectiveWorkingDirectory();
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            commandLine.withWorkDirectory(it);
        }
        this.configureCommandLine(commandLine, debugPort);
        this.configureEnvironment(commandLine);
        ProcessHandler processHandler = this.createProcessHandler(commandLine, debugPort);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)this.environment.getProject());
        return Promises.resolvedPromise((Object)processHandler);
    }

    protected void configureEnvironment(@NotNull GeneralCommandLine commandLine) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        if (this.additionalEnvironmentHandler != null) {
            Map map2;
            Map map3 = this.configuration.getEnvs();
            Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"configuration.envs");
            Map $receiver = map2 = MapsKt.toMutableMap((Map)map3);
            this.configureAdditionalEnvironment($receiver);
            map = map2;
        } else {
            Map map4 = this.configuration.getEnvs();
            map = map4;
            Intrinsics.checkExpressionValueIsNotNull((Object)map4, (String)"configuration.envs");
        }
        Map map5 = map;
        commandLine.withEnvironment(map5);
        commandLine.withParentEnvironmentType(this.configuration.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
    }

    protected final void addInputPathArg(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        commandLine.addParameters(new String[]{this.getInputPath()});
    }

    protected final void configureAdditionalEnvironment(@NotNull Map<String, String> env) {
        block0: {
            Intrinsics.checkParameterIsNotNull(env, (String)"env");
            Function1<? super Map<String, String>, Unit> function1 = this.additionalEnvironmentHandler;
            if (function1 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function1.invoke(env);
        }
    }

    public final void registerAdditionalEnvironment(@NotNull Function1<? super Map<String, String>, Unit> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        this.additionalEnvironmentHandler = handler;
    }

    @NotNull
    protected ProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        return (ProcessHandler)new OSProcessHandler(commandLine);
    }

    protected void configureCommandLine(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
    }

    @NotNull
    protected final T getConfiguration() {
        return this.configuration;
    }

    @NotNull
    protected final ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    public DebuggableProcessState(@NotNull T configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        this.configuration = configuration;
        this.environment = environment;
    }

    @NotNull
    public static final /* synthetic */ ConsoleView access$createConsole(DebuggableProcessState $this, @NotNull ProcessHandler processHandler) {
        return $this.createConsole(processHandler);
    }
}

