/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang.selector;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.angular2.lang.selector.Angular2DirectiveSimpleSelector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2SelectorMatcher<T> {
    private final Map<String, List<SelectorContext<T>>> _elementMap = new HashMap<String, List<SelectorContext<T>>>();
    private final Map<String, Angular2SelectorMatcher<T>> _elementPartialMap = new HashMap<String, Angular2SelectorMatcher<T>>();
    private final Map<String, List<SelectorContext<T>>> _classMap = new HashMap<String, List<SelectorContext<T>>>();
    private final Map<String, Angular2SelectorMatcher<T>> _classPartialMap = new HashMap<String, Angular2SelectorMatcher<T>>();
    private final Map<String, Map<String, List<SelectorContext<T>>>> _attrValueMap = new HashMap<String, Map<String, List<SelectorContext<T>>>>();
    private final Map<String, Map<String, Angular2SelectorMatcher<T>>> _attrValuePartialMap = new HashMap<String, Map<String, Angular2SelectorMatcher<T>>>();
    private final List<SelectorListContext> _listContexts = new ArrayList<SelectorListContext>();

    public static <T> Angular2SelectorMatcher<T> createNotMatcher(List<Angular2DirectiveSimpleSelector> notSelectors) {
        Angular2SelectorMatcher<Object> notMatcher = new Angular2SelectorMatcher<Object>();
        notMatcher.addSelectables(notSelectors, null);
        return notMatcher;
    }

    public void addSelectables(@NotNull List<Angular2DirectiveSimpleSelector> cssSelectors, @Nullable T context) {
        if (cssSelectors == null) {
            Angular2SelectorMatcher.$$$reportNull$$$0(0);
        }
        SelectorListContext listContext = null;
        if (cssSelectors.size() > 1) {
            listContext = new SelectorListContext(cssSelectors);
            this._listContexts.add(listContext);
        }
        for (Angular2DirectiveSimpleSelector selector : cssSelectors) {
            this._addSelectable(selector, context, listContext);
        }
    }

    private void _addSelectable(@NotNull Angular2DirectiveSimpleSelector cssSelector, @Nullable T callbackCtxt, @Nullable SelectorListContext listContext) {
        boolean isTerminal;
        int i;
        if (cssSelector == null) {
            Angular2SelectorMatcher.$$$reportNull$$$0(1);
        }
        Angular2SelectorMatcher<T> matcher = this;
        String element = cssSelector.element;
        List<String> classNames = cssSelector.classNames;
        List<String> attrs = cssSelector.attrs;
        SelectorContext<T> selectable = new SelectorContext<T>(cssSelector, callbackCtxt, listContext);
        if (StringUtil.isNotEmpty((String)element)) {
            boolean isTerminal2;
            boolean bl = isTerminal2 = attrs.isEmpty() && classNames.isEmpty();
            if (isTerminal2) {
                this._addTerminal(matcher._elementMap, element, selectable);
            } else {
                matcher = this._addPartial(matcher._elementPartialMap, element);
            }
        }
        for (i = 0; i < classNames.size(); ++i) {
            isTerminal = attrs.size() == 0 && i == classNames.size() - 1;
            String className = classNames.get(i);
            if (isTerminal) {
                super._addTerminal(matcher._classMap, className, selectable);
                continue;
            }
            matcher = super._addPartial(matcher._classPartialMap, className);
        }
        for (i = 0; i < attrs.size(); i += 2) {
            isTerminal = i == attrs.size() - 2;
            String name = attrs.get(i);
            String value = attrs.get(i + 1);
            if (isTerminal) {
                Map terminalValuesMap = matcher._attrValueMap.computeIfAbsent(name, k -> new HashMap());
                super._addTerminal(terminalValuesMap, value, selectable);
                continue;
            }
            Map partialValuesMap = matcher._attrValuePartialMap.computeIfAbsent(name, k -> new HashMap());
            matcher = super._addPartial(partialValuesMap, value);
        }
    }

    private void _addTerminal(@NotNull Map<String, List<SelectorContext<T>>> map, @NotNull String name, @NotNull SelectorContext<T> selectable) {
        if (map == null) {
            Angular2SelectorMatcher.$$$reportNull$$$0(2);
        }
        if (name == null) {
            Angular2SelectorMatcher.$$$reportNull$$$0(3);
        }
        if (selectable == null) {
            Angular2SelectorMatcher.$$$reportNull$$$0(4);
        }
        List terminalList = map.computeIfAbsent(name, k -> new SmartList());
        terminalList.add(selectable);
    }

    private Angular2SelectorMatcher<T> _addPartial(@NotNull Map<String, Angular2SelectorMatcher<T>> map, @NotNull String name) {
        if (map == null) {
            Angular2SelectorMatcher.$$$reportNull$$$0(5);
        }
        if (name == null) {
            Angular2SelectorMatcher.$$$reportNull$$$0(6);
        }
        return map.computeIfAbsent(name, k -> new Angular2SelectorMatcher());
    }

    public boolean match(@NotNull Angular2DirectiveSimpleSelector cssSelector, @Nullable BiConsumer<Angular2DirectiveSimpleSelector, T> matchedCallback) {
        if (cssSelector == null) {
            Angular2SelectorMatcher.$$$reportNull$$$0(7);
        }
        String element = cssSelector.element;
        List<String> classNames = cssSelector.classNames;
        List<String> attrs = cssSelector.attrs;
        this._listContexts.forEach(l -> {
            l.alreadyMatched = false;
        });
        boolean result = this._matchTerminal(this._elementMap, element, cssSelector, matchedCallback);
        result |= this._matchPartial(this._elementPartialMap, element, cssSelector, matchedCallback);
        for (String className : classNames) {
            result |= this._matchTerminal(this._classMap, className, cssSelector, matchedCallback);
            result |= this._matchPartial(this._classPartialMap, className, cssSelector, matchedCallback);
        }
        for (int i = 0; i < attrs.size(); i += 2) {
            String name = attrs.get(i);
            String value = attrs.get(i + 1);
            Map<String, List<SelectorContext<T>>> terminalValuesMap = this._attrValueMap.get(name);
            if (StringUtil.isNotEmpty((String)value)) {
                result |= this._matchTerminal(terminalValuesMap, "", cssSelector, matchedCallback);
            }
            result |= this._matchTerminal(terminalValuesMap, value, cssSelector, matchedCallback);
            Map<String, Angular2SelectorMatcher<T>> partialValuesMap = this._attrValuePartialMap.get(name);
            if (StringUtil.isNotEmpty((String)value)) {
                result |= this._matchPartial(partialValuesMap, "", cssSelector, matchedCallback);
            }
            result |= this._matchPartial(partialValuesMap, value, cssSelector, matchedCallback);
        }
        return result;
    }

    private boolean _matchTerminal(@Nullable Map<String, List<SelectorContext<T>>> map, @Nullable String name, @NotNull Angular2DirectiveSimpleSelector cssSelector, @Nullable BiConsumer<Angular2DirectiveSimpleSelector, T> matchedCallback) {
        if (cssSelector == null) {
            Angular2SelectorMatcher.$$$reportNull$$$0(8);
        }
        if (map == null || name == null) {
            return false;
        }
        List selectables = map.getOrDefault(name, Collections.emptyList());
        List starSelectables = map.getOrDefault("*", Collections.emptyList());
        if (selectables.isEmpty() && starSelectables.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (SelectorContext selectable : ContainerUtil.concat(selectables, starSelectables)) {
            result = selectable.finalize(cssSelector, matchedCallback) || result;
        }
        return result;
    }

    private boolean _matchPartial(@Nullable Map<String, Angular2SelectorMatcher<T>> map, @Nullable String name, @NotNull Angular2DirectiveSimpleSelector cssSelector, @Nullable BiConsumer<Angular2DirectiveSimpleSelector, T> matchedCallback) {
        if (cssSelector == null) {
            Angular2SelectorMatcher.$$$reportNull$$$0(9);
        }
        if (map == null || name == null) {
            return false;
        }
        Angular2SelectorMatcher<T> nestedSelector = map.get(name);
        if (nestedSelector == null) {
            return false;
        }
        return nestedSelector.match(cssSelector, matchedCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssSelectors";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssSelector";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectable";
                break;
            }
        }
        objectArray2[1] = "org/angular2/lang/selector/Angular2SelectorMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addSelectables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "_addSelectable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "_addTerminal";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "_addPartial";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "match";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "_matchTerminal";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "_matchPartial";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SelectorContext<T> {
        public final List<Angular2DirectiveSimpleSelector> notSelectors;
        public final Angular2DirectiveSimpleSelector selector;
        public final T context;
        public final SelectorListContext listContext;

        SelectorContext(@NotNull Angular2DirectiveSimpleSelector selector, @Nullable T context, @Nullable SelectorListContext listContext) {
            if (selector == null) {
                SelectorContext.$$$reportNull$$$0(0);
            }
            this.notSelectors = selector.notSelectors;
            this.selector = selector;
            this.context = context;
            this.listContext = listContext;
        }

        boolean finalize(@NotNull Angular2DirectiveSimpleSelector cssSelector, @Nullable BiConsumer<Angular2DirectiveSimpleSelector, T> callback) {
            if (cssSelector == null) {
                SelectorContext.$$$reportNull$$$0(1);
            }
            boolean result = true;
            if (!this.notSelectors.isEmpty() && (this.listContext == null || this.listContext.alreadyMatched)) {
                Angular2SelectorMatcher notMatcher = Angular2SelectorMatcher.createNotMatcher(this.notSelectors);
                boolean bl = result = !notMatcher.match(cssSelector, null);
            }
            if (result && callback != null && (this.listContext == null || !this.listContext.alreadyMatched)) {
                if (this.listContext != null) {
                    this.listContext.alreadyMatched = true;
                }
                callback.accept(this.selector, (Angular2DirectiveSimpleSelector)this.context);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cssSelector";
                    break;
                }
            }
            objectArray2[1] = "org/angular2/lang/selector/Angular2SelectorMatcher$SelectorContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finalize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SelectorListContext {
        public boolean alreadyMatched;
        public final List<Angular2DirectiveSimpleSelector> selectors;

        SelectorListContext(@NotNull List<Angular2DirectiveSimpleSelector> selectors) {
            if (selectors == null) {
                SelectorListContext.$$$reportNull$$$0(0);
            }
            this.alreadyMatched = false;
            this.selectors = selectors;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectors", "org/angular2/lang/selector/Angular2SelectorMatcher$SelectorListContext", "<init>"));
        }
    }
}

