/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.sql.SqlCommand;
import org.jetbrains.dekaf.sql.SqlStatement;

public class SqlScript {
    @NotNull
    private final SqlStatement[] myStatements;
    private final int myCount;

    public SqlScript(String ... statements) {
        this(SqlScript.makeStatementsFromStrings(statements));
    }

    @NotNull
    private static SqlStatement[] makeStatementsFromStrings(@NotNull String[] statements) {
        int n = statements.length;
        SqlStatement[] r = new SqlStatement[n];
        for (int i = 0; i < n; ++i) {
            r[i] = new SqlCommand(statements[i]);
        }
        return r;
    }

    public SqlScript(SqlStatement ... statements) {
        this(statements, true);
    }

    public SqlScript(SqlScript ... scripts) {
        this(SqlScript.joinStatements(scripts));
    }

    private static List<SqlStatement> joinStatements(SqlScript[] scripts) {
        ArrayList<SqlStatement> b = new ArrayList<SqlStatement>();
        for (SqlScript script : scripts) {
            b.addAll(script.getStatements());
        }
        return b;
    }

    public SqlScript(@NotNull Collection<? extends SqlStatement> statements) {
        this(statements.toArray(new SqlStatement[statements.size()]), false);
    }

    private SqlScript(@NotNull SqlStatement[] statements, boolean copy) {
        int n = statements.length;
        if (copy) {
            this.myStatements = new SqlStatement[n];
            System.arraycopy(statements, 0, this.myStatements, 0, n);
        } else {
            this.myStatements = statements;
        }
        this.myCount = n;
    }

    @NotNull
    public List<? extends SqlStatement> getStatements() {
        return Collections.unmodifiableList(Arrays.asList(this.myStatements));
    }

    public boolean hasStatements() {
        return this.myCount > 0;
    }

    public int count() {
        return this.myCount;
    }

    @NotNull
    public String toString() {
        switch (this.myCount) {
            case 0: {
                return "";
            }
            case 1: {
                return this.myStatements[0].getSourceText();
            }
        }
        StringBuilder b = new StringBuilder();
        String delimiterString = this.getScriptDelimiterString();
        b.append(this.myStatements[0].getSourceText());
        for (int i = 1; i < this.myCount; ++i) {
            if (b.charAt(b.length() - 1) != '\n') {
                b.append('\n');
            }
            b.append(delimiterString).append('\n');
            b.append(this.myStatements[i].getSourceText());
        }
        return b.toString();
    }

    @NotNull
    protected String getScriptDelimiterString() {
        return ";";
    }
}

