/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.performancePlugin.MessagesBundle;
import com.jetbrains.performancePlugin.Timer;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.profilers.YourKitProfilerHandler;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class StopProfileCommand
extends AbstractCommand {
    public static final String PREFIX = "%stopProfile";
    private final Project myProject;

    public StopProfileCommand(@NotNull String text, int line, Project project) {
        if (text == null) {
            StopProfileCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
        this.myProject = project;
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            StopProfileCommand.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper(this.myProject);
        Timer timer = Timer.instance;
        try {
            if (!ApplicationManagerEx.getApplicationEx().isInternal()) {
                String path = YourKitProfilerHandler.getInstance().stopProfiling(new ArrayList<String>());
                if (StringUtil.isEmpty((String)path)) {
                    context.error(MessagesBundle.message("command.stop.time", new Object[0]), this.getLine());
                    actionCallback.reject(MessagesBundle.message("command.stop.time", new Object[0]));
                } else {
                    boolean isFail;
                    File snapshot = new File(path);
                    String time = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
                    File snapshotWithName = new File(snapshot.getParent() + File.separator + timer.getActivityName() + '-' + time + ".snapshot");
                    ProfilersController.getInstance().setReportsPath(snapshotWithName.getAbsolutePath());
                    ProfilersController.getInstance().setStoppedByScript(true);
                    boolean bl = isFail = !snapshot.renameTo(snapshotWithName);
                    if (isFail) {
                        context.message(MessagesBundle.message("command.stop.notrenamed", new Object[0]), this.getLine());
                    }
                    actionCallback.setDone();
                }
            } else {
                actionCallback.setDone();
            }
        }
        catch (Exception exception) {
            actionCallback.reject(exception.getMessage());
        }
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            StopProfileCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/StopProfileCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/StopProfileCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

