/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.zendtool.second;

import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.data.FrameworkOption;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class Zend2HelpParser {
    private static final Logger LOG = Logger.getInstance(Zend2HelpParser.class);
    private static final String SEPARATOR = "    ";
    private final List<FrameworkCommand> myCommands = new ArrayList<FrameworkCommand>();
    private final FrameworkDescription myFrameworkDescription;
    private int myLineNumber;
    private final String[] myLines;
    private final String[] myCommandText;
    private final String myWholeOutput;
    private final String myExecutableName;

    Zend2HelpParser(ScriptRunnerUtil.ScriptOutput output, String[] commandText, FrameworkDescription frameworkDescription, String executableName) {
        this(output.getOutputToParseArray(), commandText, output.getDescriptiveOutput(), frameworkDescription, executableName);
    }

    Zend2HelpParser(String[] lines, String[] commandText, String wholeOutput, FrameworkDescription frameworkDescription, String executableName) {
        this.myFrameworkDescription = frameworkDescription;
        this.myLines = lines;
        this.myCommandText = commandText;
        this.myWholeOutput = wholeOutput;
        this.myExecutableName = executableName;
    }

    public List<FrameworkCommand> getCommands() throws FrameworkDescriptionProvider.FrameworkParseException {
        this.parse();
        return this.myCommands;
    }

    private void parse() throws FrameworkDescriptionProvider.FrameworkParseException {
        String line = this.getNextLine();
        while (line != null && (line.isEmpty() || line.startsWith("ZFTool") || line.startsWith("---"))) {
            line = this.getNextLine();
        }
        FrameworkCommand command = null;
        ArrayList<String> optionsAndParamsInfo = new ArrayList<String>();
        StringBuilder helpBuilder = new StringBuilder();
        helpBuilder.append("<html>");
        while (line != null) {
            if (line.startsWith("  " + this.myExecutableName) || line.startsWith(this.myExecutableName)) {
                line = this.checkNextLineAsContinuation(line);
                command = this.parseCommand(line, this.myCommandText, this.myWholeOutput, this.myFrameworkDescription);
                this.addPreviousCommandHelpToCommonHelp(helpBuilder);
                this.myCommands.add(command);
            } else if (!line.isEmpty()) {
                if (!line.startsWith(" ")) {
                    if (!optionsAndParamsInfo.isEmpty()) {
                        this.improveHelp(command, optionsAndParamsInfo);
                    }
                    command = null;
                    optionsAndParamsInfo.clear();
                    if (line.startsWith("Reason for failure:")) {
                        this.addPreviousCommandHelpToCommonHelp(helpBuilder);
                        helpBuilder.append("</html>");
                        this.myFrameworkDescription.setHelp(helpBuilder.toString());
                        return;
                    }
                } else {
                    line = this.checkNextLineAsContinuation(line);
                    optionsAndParamsInfo.add(line);
                }
            }
            line = this.getNextLine();
        }
    }

    private void addPreviousCommandHelpToCommonHelp(StringBuilder helpBuilder) {
        if (!this.myCommands.isEmpty()) {
            String commandHelp = this.myCommands.get(this.myCommands.size() - 1).getHelp();
            helpBuilder.append(Zend2HelpParser.unwrapBasicLineHelp(commandHelp));
        }
    }

    private String checkNextLineAsContinuation(String line) {
        String nextLine = this.getNextLine();
        if (nextLine != null && nextLine.startsWith(SEPARATOR)) {
            line = line + " " + nextLine.trim();
            this.checkNextLineAsContinuation(line);
        } else {
            this.moveBack();
        }
        return line;
    }

    private void improveHelp(FrameworkCommand command, List<String> info) throws FrameworkDescriptionProvider.FrameworkParseException {
        if (command == null) {
            throw new FrameworkDescriptionProvider.FrameworkParseException(this.myCommandText, this.myWholeOutput, "Command not found");
        }
        String basicLine = command.getHelp();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append(Zend2HelpParser.unwrapBasicLineHelp(basicLine));
        sb.append("<table>");
        for (String s : info) {
            int separatorIndex = (s = Zend2HelpParser.escapeBraces(s)).indexOf(SEPARATOR);
            if (separatorIndex == -1) {
                sb.append("<tr><td>").append(s).append("</td></tr>");
                continue;
            }
            sb.append("<tr><td>").append(s.substring(0, separatorIndex).trim()).append("</td><td>").append(s.substring(separatorIndex).trim()).append("</td></tr>");
        }
        sb.append("</table>").append("</html>");
        command.setHelp(sb.toString());
    }

    private static String wrapBasicLine(String line) {
        return "<html><table><tr><td><b>" + Zend2HelpParser.escapeBraces(line).replaceFirst(SEPARATOR, "<b></td><td>") + "</td></tr></table>" + "</html>";
    }

    private static String unwrapBasicLineHelp(String help) {
        return help.substring("<html>".length(), help.length() - "</html>".length());
    }

    private FrameworkCommand parseCommand(String line, String[] commandText, String output, FrameworkDescription framework) throws FrameworkDescriptionProvider.FrameworkParseException {
        int separatorIndex = line.indexOf(SEPARATOR);
        if (separatorIndex == -1) {
            throw new FrameworkDescriptionProvider.FrameworkParseException(commandText, output, "Command without separator:" + line);
        }
        String command = line.substring(0, separatorIndex).trim().substring(this.myExecutableName.length()).trim();
        int optionalParamIndex = command.indexOf("[");
        int paramIndex = command.indexOf("<");
        String basicText = optionalParamIndex == -1 && paramIndex == -1 ? command : (optionalParamIndex == -1 ? command.substring(0, paramIndex).trim() : (paramIndex == -1 ? command.substring(0, optionalParamIndex).trim() : command.substring(0, Math.min(paramIndex, optionalParamIndex))));
        command = command.substring(basicText.length()).trim();
        ArrayList<FrameworkCommand.Parameter> params = new ArrayList<FrameworkCommand.Parameter>();
        ArrayList<FrameworkOption> options = new ArrayList<FrameworkOption>();
        List parts = StringUtil.split((String)command, (String)" ", (boolean)true, (boolean)true);
        String currentElement = null;
        boolean isOptional = false;
        for (String part : parts) {
            if (currentElement != null) {
                currentElement = currentElement + part;
                if ((!isOptional || !currentElement.endsWith("]")) && (isOptional || !currentElement.endsWith(">"))) continue;
                Zend2HelpParser.parseElement(currentElement, isOptional, params, options);
                currentElement = null;
                continue;
            }
            if (part.startsWith("[")) {
                if (part.endsWith("]")) {
                    Zend2HelpParser.parseElement(part, true, params, options);
                    continue;
                }
                currentElement = part;
                isOptional = true;
                continue;
            }
            if (part.startsWith("<")) {
                if (part.endsWith(">")) {
                    Zend2HelpParser.parseElement(part, false, params, options);
                    continue;
                }
                currentElement = part;
                isOptional = false;
                continue;
            }
            throw new FrameworkDescriptionProvider.FrameworkParseException(commandText, output, "Unexpected element in parameters and options " + part + " in:" + line);
        }
        if (basicText.startsWith("version")) {
            basicText = "version";
        }
        return new FrameworkCommand(basicText, params, false, Zend2HelpParser.wrapBasicLine(line), Collections.emptyList(), framework);
    }

    private static void parseElement(String element, boolean isOptional, List<FrameworkCommand.Parameter> params, List<FrameworkOption> options) {
        if (isOptional) {
            element = element.substring(1, element.length() - 1);
        }
        if (element.startsWith("<")) {
            LOG.assertTrue(element.endsWith(">"), (Object)element);
            element = element.substring(1, element.length() - 1);
            params.add(new FrameworkCommand.Parameter(element, isOptional ? "null" : null));
        } else if (!element.startsWith("-")) {
            params.add(new FrameworkCommand.Parameter(element, isOptional ? "null" : null));
        }
    }

    private String getNextLine() {
        if (this.myLineNumber == this.myLines.length) {
            return null;
        }
        String line = this.myLines[this.myLineNumber];
        ++this.myLineNumber;
        return line == null ? this.getNextLine() : line;
    }

    private void moveBack() {
        --this.myLineNumber;
    }

    private static String escapeBraces(String text) {
        text = text.replaceAll("<", "&lt;");
        return text.replaceAll(">", "&gt;");
    }
}

