/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.framework.FrameworkCurrentInputData;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.completion.FrameworkCompletionContributor;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.parsing.OptionPart;
import com.jetbrains.php.framework.parsing.UserInputPart;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;

public class FrameworkInfoPopupTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            FrameworkInfoPopupTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            FrameworkInfoPopupTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            FrameworkInfoPopupTypedHandler.$$$reportNull$$$0(2);
        }
        FrameworkInfoPopupTypedHandler.movePopup(editor, charTyped, false);
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            FrameworkInfoPopupTypedHandler.$$$reportNull$$$0(3);
        }
        return result;
    }

    public static void movePopup(Editor editor, char charCame, boolean isBackspace) {
        EditorTextField editorTextField = (EditorTextField)editor.getDocument().getUserData(FrameworkCompletionContributor.EDITOR_TEXT_FIELD_KEY);
        if (editorTextField == null) {
            return;
        }
        String text = editorTextField.getText();
        if (!isBackspace) {
            text = text + charCame;
        }
        List<FrameworkCommand> commands = FrameworkDataService.getInstance(editor.getProject()).getCommands();
        FrameworkCompletionContributor.PopupInfo infoPopupTrinity = FrameworkCompletionContributor.PopupInfo.getPopupInfo(editor.getDocument());
        FrameworkCommand previousCommand = infoPopupTrinity == null ? null : infoPopupTrinity.command;
        FrameworkCurrentInputData inputData = FrameworkCurrentInputData.getOrUpdate(editor.getDocument(), text, commands);
        InfoPopupUpdateData updateData = FrameworkInfoPopupTypedHandler.getUpdateData(inputData, previousCommand);
        switch (updateData.myUpdateAction) {
            case CREATE: {
                FrameworkInfoPopupTypedHandler.showInfoPopup(text, editor, updateData.myMatchingCommand);
                break;
            }
            case DESTROY_CURRENT: {
                FrameworkCompletionContributor.destroyInfoPopup(editor);
                if (updateData.myMatchingCommand == null) break;
                FrameworkInfoPopupTypedHandler.showInfoPopup(text, editor, updateData.myMatchingCommand);
                break;
            }
            case DESTROY: {
                FrameworkCompletionContributor.destroyInfoPopup(editor);
                break;
            }
            case UPDATE: {
                JBPopup infoPopup;
                JBPopup jBPopup = infoPopup = infoPopupTrinity == null ? null : infoPopupTrinity.popup;
                if (infoPopup == null || infoPopup.isDisposed()) {
                    FrameworkCompletionContributor.PopupInfo.putPopupInfo(editor.getDocument(), null);
                    return;
                }
                VisualPosition visualPosition = editor.getCaretModel().getVisualPosition();
                Point p = editor.visualPositionToXY(new VisualPosition(visualPosition.line, visualPosition.column));
                SwingUtilities.convertPointToScreen(p, (Component)editorTextField);
                p.translate(0, -infoPopup.getSize().height);
                int rightTextFieldPosition = editorTextField.getLocationOnScreen().x + editorTextField.getWidth() - 5;
                p.x = Math.min(p.x, rightTextFieldPosition);
                infoPopup.setLocation(p);
                int currentParameter = FrameworkUtils.getCurrentParameterNumber(text, updateData.myMatchingCommand);
                String newText = FrameworkCompletionContributor.getParamsDescription(infoPopupTrinity.command, true, currentParameter);
                infoPopupTrinity.label.setText(newText);
                infoPopup.setSize(infoPopupTrinity.label.getPreferredSize());
                break;
            }
        }
    }

    public static InfoPopupUpdateData getUpdateData(FrameworkCurrentInputData data, FrameworkCommand previousCommand) {
        List<UserInputPart> parts;
        UserInputPart part;
        FrameworkCommand matchingCommand = data.findCommand(true, true);
        if (matchingCommand != null && (part = (parts = FrameworkUtils.parseCurrentInput(data.getUserInput(), matchingCommand)).get(parts.size() - 1)) instanceof OptionPart && !part.getText().isEmpty()) {
            return new InfoPopupUpdateData(matchingCommand, InfoPopupUpdate.DESTROY);
        }
        if (previousCommand != null) {
            if (!previousCommand.equals(matchingCommand)) {
                return new InfoPopupUpdateData(matchingCommand, InfoPopupUpdate.DESTROY_CURRENT);
            }
            return new InfoPopupUpdateData(matchingCommand, InfoPopupUpdate.UPDATE);
        }
        if (matchingCommand != null && !matchingCommand.getParameters().isEmpty()) {
            return new InfoPopupUpdateData(matchingCommand, InfoPopupUpdate.CREATE);
        }
        return new InfoPopupUpdateData(matchingCommand, InfoPopupUpdate.IGNORE);
    }

    public static void showInfoPopup(String inputText, Editor editor, FrameworkCommand command) {
        if (!command.getParameters().isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
            int currentParameter = FrameworkUtils.getCurrentParameterNumber(inputText, command);
            JLabel renderer = new JLabel(FrameworkCompletionContributor.getParamsDescription(command, true, currentParameter));
            renderer.setFont(UIUtil.getLabelFont());
            renderer.setBackground(HintUtil.getInformationColor());
            renderer.setOpaque(true);
            renderer.setBorder(BorderFactory.createCompoundBorder(LineBorder.createGrayLineBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            JBPopupFactory popupFactory = JBPopupFactory.getInstance();
            JBPopup infoPopup = popupFactory.createComponentPopupBuilder((JComponent)renderer, (JComponent)renderer).createPopup();
            Dimension preferredSize = renderer.getPreferredSize();
            infoPopup.getContent().setBorder(null);
            RelativePoint relativePoint = FrameworkInfoPopupTypedHandler.getInfoPopupPosition(editor, preferredSize);
            infoPopup.show(relativePoint);
            FrameworkCompletionContributor.PopupInfo.putPopupInfo(editor.getDocument(), new FrameworkCompletionContributor.PopupInfo(infoPopup, renderer, command));
        } else {
            FrameworkCompletionContributor.PopupInfo.putPopupInfo(editor.getDocument(), null);
        }
    }

    private static RelativePoint getInfoPopupPosition(Editor editor, Dimension preferredSize) {
        VisualPosition visualPosition = editor.getCaretModel().getVisualPosition();
        Point p = editor.visualPositionToXY(new VisualPosition(visualPosition.line, visualPosition.column));
        p.y = -preferredSize.height;
        EditorTextField textField = (EditorTextField)editor.getDocument().getUserData(FrameworkCompletionContributor.EDITOR_TEXT_FIELD_KEY);
        assert (textField != null);
        return new RelativePoint((Component)textField, p);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/FrameworkInfoPopupTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/FrameworkInfoPopupTypedHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InfoPopupUpdateData {
        public final FrameworkCommand myMatchingCommand;
        public final InfoPopupUpdate myUpdateAction;

        public InfoPopupUpdateData(FrameworkCommand matchingCommand, InfoPopupUpdate updateAction) {
            this.myMatchingCommand = matchingCommand;
            this.myUpdateAction = updateAction;
        }
    }

    public static enum InfoPopupUpdate {
        CREATE,
        UPDATE,
        DESTROY_CURRENT,
        IGNORE,
        DESTROY;

    }
}

