/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework;

import com.intellij.codeInsight.editorActions.BaseEnterHandler;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.FrameworkCurrentInputData;
import com.jetbrains.php.framework.FrameworkExecutionProcessCreator;
import com.jetbrains.php.framework.FrameworkGenerationVfsListener;
import com.jetbrains.php.framework.FrameworkHistoryKeyListener;
import com.jetbrains.php.framework.FrameworkRunConsoleAction;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.FrameworkWorkingFolderService;
import com.jetbrains.php.framework.completion.FrameworkCompletionContributor;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.ui.FrameworkConsoleViewImpl;
import com.jetbrains.php.framework.ui.FrameworkToolWindowComponent;
import com.jetbrains.php.framework.ui.FrameworkUiUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkEditorActionHandler
extends BaseEnterHandler {
    private static final Logger LOG = Logger.getInstance(FrameworkEditorActionHandler.class);
    @NonNls
    private static final SimpleDateFormat FINISH_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final Key<Pair<String, Long>> ERROR_MESSAGE_KEY = Key.create((String)"errorMessageFroCommandLineToolInput");
    private static final int ERROR_NOTIFICATION_TIMEOUT_IN_MILLIS = 5000;
    private final EditorActionHandler myOriginalHandler;
    private JBPopup myErrorPopup;

    public FrameworkEditorActionHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            FrameworkEditorActionHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            FrameworkEditorActionHandler.$$$reportNull$$$0(1);
        }
        return FrameworkEditorActionHandler.isEnterEnabled(editor, dataContext) || this.myOriginalHandler.isEnabled(editor, caret, dataContext);
    }

    private static boolean isEnterEnabled(Editor editor, DataContext dataContext) {
        if (editor.getDocument().getUserData(FrameworkCompletionContributor.EDITOR_TEXT_FIELD_KEY) == null) {
            return false;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project != null && !project.isDefault();
    }

    public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
        boolean block;
        boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
        if (!FrameworkEditorActionHandler.isEnterEnabled(editor, dataContext)) {
            this.executeNext(editor, caret, dataContext);
            return;
        }
        EditorTextField editorTextField = (EditorTextField)editor.getDocument().getUserData(FrameworkCompletionContributor.EDITOR_TEXT_FIELD_KEY);
        LOG.assertTrue(editorTextField != null);
        editor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                FrameworkEditorActionHandler.this.cancelErrorPopup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/framework/FrameworkEditorActionHandler$1", "documentChanged"));
            }
        });
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        assert (project != null);
        String userCommand = editor.getDocument().getText();
        UserInputAnalyzer userInputAnalyzer = new UserInputAnalyzer(userCommand, editor.getDocument(), dataContext, project);
        if (!userInputAnalyzer.isExecutable && (block = this.showErrorMessageAndBlockExecutionIfNeeded(editor, isTest, editorTextField, userInputAnalyzer))) {
            this.executeNext(editor, caret, dataContext);
            return;
        }
        String commandToExecute = userInputAnalyzer.myCommandToExecute;
        FrameworkHistoryKeyListener historyKeyListener = (FrameworkHistoryKeyListener)editor.getUserData(FrameworkHistoryKeyListener.HISTORY_LISTENER_KEY);
        LOG.assertTrue(historyKeyListener != null);
        FrameworkDescription framework = userInputAnalyzer.myCommand == null ? null : userInputAnalyzer.myCommand.getFrameworkDescription();
        historyKeyListener.addNewExecutedCommand(userCommand, framework);
        FrameworkEditorActionHandler.executeCommandInToolwindow(project, commandToExecute, userCommand, FrameworkBundle.message("framework.run.console.action.running.command.0", commandToExecute));
        FrameworkCompletionContributor.destroyInfoPopup(editor);
        if (!isTest && !FrameworkDataService.isConsoleInToolWindow()) {
            JBPopup popup = (JBPopup)editor.getDocument().getUserData(FrameworkRunConsoleAction.FRAMEWORK_COMMAND_POPUP_IN_DOCUMENT_KEY);
            LOG.assertTrue(popup != null);
            popup.cancel();
        }
    }

    private boolean showErrorMessageAndBlockExecutionIfNeeded(Editor editor, boolean test, EditorTextField editorTextField, UserInputAnalyzer userInputAnalyzer) {
        if (userInputAnalyzer.myErrorMessage != null) {
            Pair previousNotification = (Pair)editor.getUserData(ERROR_MESSAGE_KEY);
            if (previousNotification != null && editorTextField.getText().equals(previousNotification.getFirst()) && System.currentTimeMillis() - (Long)previousNotification.getSecond() < 5000L) {
                editor.putUserData(ERROR_MESSAGE_KEY, null);
                return false;
            }
            editor.putUserData(ERROR_MESSAGE_KEY, (Object)Pair.create((Object)editorTextField.getText(), (Object)System.currentTimeMillis()));
            if (!test && (this.myErrorPopup == null || this.myErrorPopup.isDisposed())) {
                this.showErrorPopup(editorTextField, userInputAnalyzer.myErrorMessage);
            }
        }
        return true;
    }

    private static void executeCommandInToolwindow(final @NotNull Project project, final String commandToExecute, String tabTitle, String actionTitle) {
        if (project == null) {
            FrameworkEditorActionHandler.$$$reportNull$$$0(2);
        }
        final boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
        ToolWindow toolWindow = FrameworkUiUtils.getOrRegisterToolWindow(project);
        ContentManager contentManager = toolWindow.getContentManager();
        final FrameworkToolWindowComponent toolWindowComponent = FrameworkToolWindowComponent.getToolWindowComponent(contentManager);
        final FrameworkConsoleViewImpl consoleView = toolWindowComponent.getOrCreateAvailableConsole(project);
        if (!isTest) {
            toolWindowComponent.setSelectedComponent(consoleView.getComponent());
            toolWindowComponent.setOutputConsoleTabTitle(consoleView, tabTitle);
            if (FrameworkDataService.isConsoleInToolWindow()) {
                toolWindowComponent.setText(null);
            }
        }
        consoleView.printCommandStartSign();
        consoleView.scrollToEnd();
        if (!toolWindow.isVisible()) {
            toolWindow.show(null);
        }
        if (!FrameworkWorkingFolderService.isChangeDirectoryCommand(commandToExecute)) {
            FileDocumentManager.getInstance().saveAllDocuments();
            Task.Backgroundable t = new Task.Backgroundable(project, actionTitle, true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(final @NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Semaphore done = new Semaphore();
                    Ref handlerRef = new Ref();
                    Runnable innerRunnable = () -> {
                        if (project == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (indicator == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        LocalHistoryAction localHistoryAction = !isTest ? LocalHistory.getInstance().startAction(this.getTitle()) : null;
                        try {
                            FrameworkEditorActionHandler.runCommand(commandToExecute, (Ref<OSProcessHandler>)handlerRef, consoleView, FrameworkWorkingFolderService.getInstance(project));
                        }
                        catch (ExecutionException e) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (project == null) {
                                    2.$$$reportNull$$$0(4);
                                }
                                consoleView.print(commandToExecute + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                                consoleView.print(e.getMessage(), ConsoleViewContentType.ERROR_OUTPUT);
                                consoleView.scrollToEnd();
                                FrameworkEditorActionHandler.finishCommandExecution(localHistoryAction, done, toolWindowComponent, project);
                            }, indicator.getModalityState());
                            return;
                        }
                        OSProcessHandler processHandler = (OSProcessHandler)handlerRef.get();
                        consoleView.attachToProcess((ProcessHandler)processHandler);
                        toolWindowComponent.addProcessHandler(processHandler, consoleView);
                        if (!isTest) {
                            VirtualFile projectRoot = null;
                            VirtualFile baseDir = project.getBaseDir();
                            LOG.assertTrue(baseDir != null);
                            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(baseDir.getPath());
                            if (file != null && file.isValid()) {
                                projectRoot = file;
                            }
                            if (projectRoot != null) {
                                final Runnable afterRefreshRunnable = () -> {
                                    if (project == null) {
                                        2.$$$reportNull$$$0(3);
                                    }
                                    FrameworkEditorActionHandler.finishCommandExecution(localHistoryAction, done, toolWindowComponent, project);
                                };
                                final VirtualFile finalProjectRoot = projectRoot;
                                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                                    public void processTerminated(@NotNull ProcessEvent event) {
                                        if (event == null) {
                                            1.$$$reportNull$$$0(0);
                                        }
                                        if (project.isDisposed()) {
                                            return;
                                        }
                                        FrameworkGenerationVfsListener.performVfsRefreshNotifyingVcs(project, afterRefreshRunnable, indicator.getModalityState(), finalProjectRoot);
                                    }

                                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/framework/FrameworkEditorActionHandler$2$1", "processTerminated"));
                                    }
                                });
                            }
                        }
                        processHandler.startNotify();
                    };
                    indicator.setIndeterminate(true);
                    done.down();
                    ApplicationManager.getApplication().executeOnPooledThread(innerRunnable);
                    while (!done.waitFor(200L)) {
                        if (!indicator.isCanceled() || handlerRef.isNull()) continue;
                        ((OSProcessHandler)handlerRef.get()).destroyProcess();
                        break;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/framework/FrameworkEditorActionHandler$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$run$2";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$null$1";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$null$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            t.queue();
        } else {
            consoleView.print(commandToExecute, ConsoleViewContentType.SYSTEM_OUTPUT);
            String output = FrameworkWorkingFolderService.getInstance(project).handleChangeDirectoryCommand(commandToExecute);
            consoleView.println(output, ConsoleViewContentType.SYSTEM_OUTPUT);
            if (FrameworkDataService.isConsoleInToolWindow()) {
                toolWindowComponent.requestFocusInEditor(project);
            }
        }
    }

    private static void finishCommandExecution(@Nullable LocalHistoryAction localHistoryAction, Semaphore done, FrameworkToolWindowComponent toolWindowComponent, Project project) {
        if (localHistoryAction != null) {
            localHistoryAction.finish();
        }
        done.up();
        if (FrameworkDataService.isConsoleInToolWindow()) {
            toolWindowComponent.requestFocusInEditor(project);
        }
    }

    private static void runCommand(String commandToExecute, Ref<OSProcessHandler> handlerRef, @Nullable FrameworkConsoleViewImpl consoleView, FrameworkWorkingFolderService service) throws ExecutionException {
        List commands = StringUtil.splitHonorQuotes((String)commandToExecute, (char)' ');
        ArrayList<String> newCommands = new ArrayList<String>(commands.size());
        for (String s : commands) {
            if (StringUtil.isQuotedString((String)s)) {
                newCommands.add(StringUtil.unquoteString((String)s));
                continue;
            }
            newCommands.add(s);
        }
        Ref startTimeHandler = new Ref();
        startTimeHandler.set((Object)System.currentTimeMillis());
        ProcessAdapter processListener = null;
        if (consoleView != null) {
            processListener = FrameworkEditorActionHandler.createPrintingProcessListener(consoleView, (Ref<Long>)startTimeHandler);
        }
        String exePath = (String)newCommands.remove(0);
        handlerRef.set((Object)new FrameworkExecutionProcessCreator(exePath, newCommands, service.getWorkingFolder()).createProcessHandler());
        if (processListener != null) {
            ((OSProcessHandler)handlerRef.get()).addProcessListener((ProcessListener)processListener);
        }
    }

    private void showErrorPopup(EditorTextField editorTextField, String errorText) {
        JComponent renderer = HintUtil.createErrorLabel((String)errorText);
        this.myErrorPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(renderer, renderer).createPopup();
        Dimension preferredSize = renderer.getPreferredSize();
        this.myErrorPopup.show(new RelativePoint((Component)editorTextField, new Point(0, -preferredSize.height)));
    }

    private void executeNext(Editor editor, Caret caret, DataContext dataContext) {
        if (this.myOriginalHandler.isEnabled(editor, caret, dataContext)) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
        }
    }

    private static ProcessAdapter createPrintingProcessListener(final FrameworkConsoleViewImpl consoleView, final Ref<Long> startTimeHandler) {
        return new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                int exitCode = event.getExitCode();
                Date current = new Date();
                String date = FINISH_TIME_FORMAT.format(current);
                consoleView.println(FrameworkBundle.message("framework.process.finished.with.exit.code.0.at.1.n", exitCode, date), ConsoleViewContentType.NORMAL_OUTPUT);
                long executionTime = current.getTime() - (Long)startTimeHandler.get();
                consoleView.println(FrameworkBundle.message("framework.execution.time.0.ms.n", executionTime), ConsoleViewContentType.NORMAL_OUTPUT);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/framework/FrameworkEditorActionHandler$3", "processTerminated"));
            }
        };
    }

    private void cancelErrorPopup() {
        if (this.myErrorPopup != null) {
            this.myErrorPopup.cancel();
            this.myErrorPopup = null;
        }
    }

    private static String getCommandWithMacrosToExecute(String userText, FrameworkCommand command) {
        if (!command.canBeUsedWithoutParameters() || FrameworkUtils.isCommandTextValid(userText, command)) {
            userText = userText.startsWith(command.getAliasedBasicText()) ? command.getInvocationBasicText() + userText.substring(command.getAliasedBasicText().length()) : command.getInvocationBasicText();
            if (!FrameworkUtils.containsMacro(command)) {
                return userText;
            }
            int providedParams = FrameworkUtils.getParameterNumber(userText.substring(command.getInvocationBasicText().length()));
            StringBuilder sb = new StringBuilder(userText.trim());
            List<FrameworkCommand.Parameter> parameters = command.getParameters();
            for (int i = providedParams; i <= FrameworkUtils.lastMacroParameterIndex(command); ++i) {
                sb.append(" ").append(parameters.get(i).getDefaultValue());
            }
            return sb.toString();
        }
        String result = command.getInvocationBasicText();
        if (userText.startsWith(command.getAliasedBasicText())) {
            StringBuilder sb = new StringBuilder();
            sb.append(result);
            String optionsString = userText.substring(command.getAliasedBasicText().length());
            List probableOptions = StringUtil.splitHonorQuotes((String)optionsString, (char)' ');
            for (String probableOption : probableOptions) {
                if (!probableOption.startsWith("-")) continue;
                sb.append(" ").append(probableOption);
            }
            return sb.toString();
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/framework/FrameworkEditorActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCommandInToolwindow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class UserInputAnalyzer {
        public final boolean isExecutable;
        public final String myErrorMessage;
        public final String myCommandToExecute;
        public final FrameworkCommand myCommand;

        UserInputAnalyzer(String userText, @Nullable Document document, DataContext dataContext, Project project) {
            String tempCommandToExecute;
            FrameworkDataService dataService = FrameworkDataService.getInstance(project);
            CommonDataKeys.EDITOR.getData(dataContext);
            FrameworkCurrentInputData data = document == null ? FrameworkCurrentInputData.countInputData(userText, dataService.getCommands()) : FrameworkCurrentInputData.getOrUpdate(document, userText, dataService.getCommands());
            this.myCommand = data.findCommand(true, false);
            if (userText.isEmpty()) {
                this.isExecutable = false;
                this.myErrorMessage = null;
                this.myCommandToExecute = null;
                return;
            }
            if (this.myCommand != null && !FrameworkUtils.isTextValid(userText, this.myCommand)) {
                this.isExecutable = false;
                this.myErrorMessage = FrameworkUtils.getErrorMessage(userText, this.myCommand);
            } else {
                this.isExecutable = true;
                this.myErrorMessage = null;
            }
            if (this.myCommand == null) {
                tempCommandToExecute = userText;
                for (Map.Entry<String, String> aliasEntry : dataService.getAliasesAndInvokeTexts().entrySet()) {
                    String alias = aliasEntry.getKey();
                    if (!userText.startsWith(alias) || userText.length() != alias.length() && userText.charAt(alias.length()) != ' ') continue;
                    tempCommandToExecute = userText.replaceFirst(alias, Matcher.quoteReplacement(aliasEntry.getValue()));
                    break;
                }
            } else {
                tempCommandToExecute = FrameworkEditorActionHandler.getCommandWithMacrosToExecute(userText, this.myCommand);
            }
            this.myCommandToExecute = FrameworkUtils.resolveMacros(tempCommandToExecute, dataContext);
        }
    }
}

