/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.jetbrains.php.framework.data.FrameworkCommand;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkCurrentInputData {
    private static final Key<FrameworkCurrentInputData> DOCUMENT_CURRENT_INPUT_DATA_KEY = Key.create((String)"DOCUMENT_CURRENT_INPUT_DATA_KEY");
    private final String userInput;
    private final FrameworkCommand strictMatchingCommand;
    private final List<? extends FrameworkCommand> matchingCommands;

    private FrameworkCurrentInputData(@NotNull String userInput, @Nullable FrameworkCommand strictMatchingCommand, @NotNull List<? extends FrameworkCommand> matchingCommands) {
        if (userInput == null) {
            FrameworkCurrentInputData.$$$reportNull$$$0(0);
        }
        if (matchingCommands == null) {
            FrameworkCurrentInputData.$$$reportNull$$$0(1);
        }
        this.userInput = userInput;
        this.strictMatchingCommand = strictMatchingCommand;
        this.matchingCommands = matchingCommands;
    }

    @NotNull
    protected String getUserInput() {
        String string = this.userInput;
        if (string == null) {
            FrameworkCurrentInputData.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public FrameworkCommand findCommand(boolean returnStrictMatchIfFound, boolean userTextMustContainCommand) {
        if (returnStrictMatchIfFound && this.strictMatchingCommand != null) {
            return this.strictMatchingCommand;
        }
        if (this.matchingCommands.size() != 1 || userTextMustContainCommand && !this.userInput.startsWith(this.matchingCommands.get(0).getAliasedBasicText().trim())) {
            return null;
        }
        return this.matchingCommands.get(0);
    }

    private static void putInDocument(@NotNull Document document, @Nullable FrameworkCurrentInputData data) {
        if (document == null) {
            FrameworkCurrentInputData.$$$reportNull$$$0(3);
        }
        document.putUserData(DOCUMENT_CURRENT_INPUT_DATA_KEY, (Object)data);
    }

    @Nullable
    private static FrameworkCurrentInputData getFromDocument(@NotNull Document document) {
        if (document == null) {
            FrameworkCurrentInputData.$$$reportNull$$$0(4);
        }
        return (FrameworkCurrentInputData)document.getUserData(DOCUMENT_CURRENT_INPUT_DATA_KEY);
    }

    @NotNull
    static FrameworkCurrentInputData countInputData(String userText, List<? extends FrameworkCommand> commands) {
        ArrayList<FrameworkCommand> matchingCommands = new ArrayList<FrameworkCommand>();
        FrameworkCommand strictMatchingCommand = null;
        for (FrameworkCommand frameworkCommand : commands) {
            if (!frameworkCommand.isEnabled()) continue;
            String aliasedText = frameworkCommand.getAliasedBasicText().trim();
            if (userText.equals(aliasedText) || userText.startsWith(aliasedText + " ")) {
                if (strictMatchingCommand == null || strictMatchingCommand.getAliasedBasicText().length() < frameworkCommand.getAliasedBasicText().length()) {
                    strictMatchingCommand = frameworkCommand;
                }
                matchingCommands.add(frameworkCommand);
                continue;
            }
            if (!aliasedText.startsWith(userText)) continue;
            matchingCommands.add(frameworkCommand);
        }
        FrameworkCurrentInputData frameworkCurrentInputData = new FrameworkCurrentInputData(userText, strictMatchingCommand, matchingCommands);
        if (frameworkCurrentInputData == null) {
            FrameworkCurrentInputData.$$$reportNull$$$0(5);
        }
        return frameworkCurrentInputData;
    }

    @NotNull
    public static FrameworkCurrentInputData getOrUpdate(@NotNull Document document, String currentInput, List<? extends FrameworkCommand> commands) {
        FrameworkCurrentInputData currentInputData;
        if (document == null) {
            FrameworkCurrentInputData.$$$reportNull$$$0(6);
        }
        if ((currentInputData = FrameworkCurrentInputData.getFromDocument(document)) == null || !currentInput.equals(currentInputData.getUserInput())) {
            currentInputData = FrameworkCurrentInputData.countInputData(currentInput, commands);
            FrameworkCurrentInputData.putInDocument(document, currentInputData);
        }
        FrameworkCurrentInputData frameworkCurrentInputData = currentInputData;
        if (frameworkCurrentInputData == null) {
            FrameworkCurrentInputData.$$$reportNull$$$0(7);
        }
        return frameworkCurrentInputData;
    }

    public static void clear(@NotNull Document document) {
        if (document == null) {
            FrameworkCurrentInputData.$$$reportNull$$$0(8);
        }
        FrameworkCurrentInputData.putInDocument(document, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userInput";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchingCommands";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/FrameworkCurrentInputData";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/FrameworkCurrentInputData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserInput";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "countInputData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putInDocument";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFromDocument";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clear";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

