/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import gnu.trove.THashMap;
import io.netty.handler.codec.http.HttpRequest;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolverKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u0007J\u0016\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/builtInWebServer/ssi/SsiExternalResolver;", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "parentPath", "", "parentFile", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/project/Project;Lio/netty/handler/codec/http/HttpRequest;Ljava/lang/String;Ljava/nio/file/Path;)V", "variables", "Lgnu/trove/THashMap;", "addVariableNames", "", "variableNames", "", "findFile", "originalPath", "virtual", "", "getFileLastModified", "", "path", "getFileSize", "getVariableValue", "name", "setVariableValue", "value", "intellij.platform.builtInServer.impl"})
public final class SsiExternalResolver {
    private final THashMap<String, String> variables;
    private final Project project;
    private final HttpRequest request;
    private final String parentPath;
    private final Path parentFile;

    public final void addVariableNames(@NotNull Collection<String> variableNames) {
        Intrinsics.checkParameterIsNotNull(variableNames, (String)"variableNames");
        for (String variableName : SsiExternalResolverKt.access$getVARIABLE_NAMES$p()) {
            String variableValue = this.getVariableValue(variableName);
            if (variableValue == null) continue;
            variableNames.add(variableName);
        }
    }

    public final void setVariableValue(@NotNull String name, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.variables.put((Object)name, (Object)value);
    }

    @Nullable
    public final String getVariableValue(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String value = (String)this.variables.get((Object)name);
        String string = value;
        if (string == null) {
            string = this.request.headers().get(name);
        }
        return string;
    }

    @Nullable
    public final Path findFile(@NotNull String originalPath, boolean virtual) {
        Intrinsics.checkParameterIsNotNull((Object)originalPath, (String)"originalPath");
        String path = FileUtil.toCanonicalPath((String)originalPath, (char)'/');
        if (!virtual) {
            return this.parentFile.resolve(path);
        }
        path = path.charAt(0) == '/' ? path : this.parentPath + '/' + path;
        WebServerPathToFileManager webServerPathToFileManager = WebServerPathToFileManager.Companion.getInstance(this.project);
        String string = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
        PathInfo pathInfo = WebServerPathToFileManager.getPathInfo$default(webServerPathToFileManager, string, true, null, 4, null);
        if (pathInfo == null) {
            return null;
        }
        PathInfo pathInfo2 = pathInfo;
        if (pathInfo2.getIoFile() == null) {
            VirtualFile virtualFile = pathInfo2.getFile();
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            return Paths.get(virtualFile.getPath(), new String[0]);
        }
        Path path2 = pathInfo2.getIoFile();
        if (path2 == null) {
            Intrinsics.throwNpe();
        }
        return path2;
    }

    public final long getFileLastModified(@NotNull String path, boolean virtual) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Path file2 = this.findFile(path, virtual);
        return file2 == null || !PathKt.exists((Path)file2) ? 0L : PathKt.lastModified((Path)file2).toMillis();
    }

    public final long getFileSize(@NotNull String path, boolean virtual) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Path file2 = this.findFile(path, virtual);
        return file2 == null || !PathKt.exists((Path)file2) ? -1L : PathKt.size((Path)file2);
    }

    public SsiExternalResolver(@NotNull Project project, @NotNull HttpRequest request, @NotNull String parentPath, @NotNull Path parentFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)parentPath, (String)"parentPath");
        Intrinsics.checkParameterIsNotNull((Object)parentFile, (String)"parentFile");
        this.project = project;
        this.request = request;
        this.parentPath = parentPath;
        this.parentFile = parentFile;
        this.variables = new THashMap();
    }
}

