/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.KeyboardFocusManager;
import java.awt.event.InputEvent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class ToggleActionCommand
extends AbstractCommand {
    public static final String PREFIX = "%toggle";
    public static final String ON = "on";
    public static final String OFF = "off";

    public ToggleActionCommand(String text, int line) {
        super(text, line, true);
    }

    @Override
    protected Promise<Object> _execute(PlaybackContext context) {
        boolean on;
        String[] args = this.getText().substring(PREFIX.length()).trim().split(" ");
        String syntaxText = "Syntax error, expected: %toggle on|off actionName";
        if (args.length != 2) {
            context.error(syntaxText, this.getLine());
            return Promises.rejectedPromise((Throwable)new RuntimeException(syntaxText));
        }
        if (ON.equalsIgnoreCase(args[0])) {
            on = true;
        } else if (OFF.equalsIgnoreCase(args[0])) {
            on = false;
        } else {
            context.error(syntaxText, this.getLine());
            return Promises.rejectedPromise((Throwable)new RuntimeException(syntaxText));
        }
        String actionId = args[1];
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action == null) {
            context.error("Unknown action id=" + actionId, this.getLine());
            return Promises.rejectedPromise((Throwable)new RuntimeException("Unknown action id=" + actionId));
        }
        if (!(action instanceof ToggleAction)) {
            String text = "Action is not a toggle action id=" + actionId;
            context.error(text, this.getLine());
            return Promises.rejectedPromise((String)text);
        }
        InputEvent inputEvent = ActionCommand.getInputEvent(actionId);
        ActionCallback result2 = new ActionCallback();
        context.getRobot().delay(Registry.intValue((String)"actionSystem.playback.delay"));
        IdeFocusManager fm = IdeFocusManager.getGlobalInstance();
        fm.doWhenFocusSettlesDown(() -> {
            Presentation presentation = action.getTemplatePresentation().clone();
            AnActionEvent event = new AnActionEvent(inputEvent, DataManager.getInstance().getDataContext(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()), "unknown", presentation, ActionManager.getInstance(), 0);
            ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action, (AnActionEvent)event, (boolean)false);
            Boolean state = (Boolean)event.getPresentation().getClientProperty("selected");
            if (state != on) {
                ActionManager.getInstance().tryToExecute(action, inputEvent, null, "unknown", true).doWhenProcessed(result2.createSetDoneRunnable());
            } else {
                result2.setDone();
            }
        });
        return Promises.toPromise((ActionCallback)result2);
    }
}

