/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTextConsoleView;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.CompositeView;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.actions.PinActiveTabAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class BuildView
extends CompositeView<ExecutionConsole>
implements BuildProgressListener,
ConsoleView,
DataProvider {
    public static final String CONSOLE_VIEW_NAME = "consoleView";
    private final AtomicReference<StartBuildEvent> myStartBuildEventRef = new AtomicReference();
    private final BuildDescriptor myBuildDescriptor;
    private final Project myProject;
    private final AtomicBoolean isBuildStartEventProcessed = new AtomicBoolean();
    private final List<BuildEvent> myAfterStartEvents = ContainerUtil.createConcurrentList();
    private final ViewManager myViewManager;

    public BuildView(Project project, BuildDescriptor buildDescriptor, String selectionStateKey, ViewManager viewManager) {
        this(project, null, buildDescriptor, selectionStateKey, viewManager);
    }

    public BuildView(Project project, @Nullable ExecutionConsole executionConsole, BuildDescriptor buildDescriptor, String selectionStateKey, ViewManager viewManager) {
        super(selectionStateKey);
        this.myProject = project;
        this.myBuildDescriptor = buildDescriptor;
        this.myViewManager = viewManager;
        if (executionConsole != null) {
            this.addView(executionConsole, CONSOLE_VIEW_NAME, viewManager.isConsoleEnabledByDefault());
        }
    }

    public void onEvent(@NotNull BuildEvent event) {
        if (event == null) {
            BuildView.$$$reportNull$$$0(0);
        }
        if (event instanceof StartBuildEvent) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (event == null) {
                    BuildView.$$$reportNull$$$0(15);
                }
                this.onStartBuild((StartBuildEvent)event);
                for (BuildEvent buildEvent : this.myAfterStartEvents) {
                    this.processEvent(buildEvent);
                }
                this.myAfterStartEvents.clear();
                this.isBuildStartEventProcessed.set(true);
            });
            return;
        }
        if (!this.isBuildStartEventProcessed.get()) {
            this.myAfterStartEvents.add(event);
        } else {
            this.processEvent(event);
        }
    }

    private void processEvent(BuildEvent event) {
        if (event instanceof OutputBuildEvent) {
            ExecutionConsole consoleView = this.getConsoleView();
            if (consoleView instanceof BuildProgressListener) {
                ((BuildProgressListener)consoleView).onEvent(event);
            }
        } else {
            String eventViewName = BuildTreeConsoleView.class.getName();
            BuildTreeConsoleView eventView = this.getView(eventViewName, BuildTreeConsoleView.class);
            if (eventView != null) {
                EdtExecutorService.getInstance().execute(() -> eventView.onEvent(event));
            }
        }
    }

    private void onStartBuild(StartBuildEvent startBuildEvent) {
        Object executionConsoleView;
        this.myStartBuildEventRef.set(startBuildEvent);
        String eventViewName = BuildTreeConsoleView.class.getName();
        BuildTreeConsoleView eventView = this.getView(eventViewName, BuildTreeConsoleView.class);
        if (eventView == null) {
            eventView = new BuildTreeConsoleView(this.myProject, this.myBuildDescriptor);
            this.addView(eventView, eventViewName, !this.myViewManager.isConsoleEnabledByDefault());
        }
        if ((executionConsoleView = this.getConsoleView()) == null) {
            Supplier descriptorSupplier = startBuildEvent.getContentDescriptorSupplier();
            Filter[] runContentDescriptor = descriptorSupplier != null ? (Filter[])descriptorSupplier.get() : null;
            executionConsoleView = runContentDescriptor != null && runContentDescriptor.getExecutionConsole() != null && runContentDescriptor.getExecutionConsole() != this ? runContentDescriptor.getExecutionConsole() : new BuildTextConsoleView(this.myProject);
            this.addView(executionConsoleView, CONSOLE_VIEW_NAME, this.myViewManager.isConsoleEnabledByDefault());
            if (runContentDescriptor != null && Disposer.findRegisteredObject((Disposable)runContentDescriptor, (Disposable)this) == null) {
                Disposer.register((Disposable)this, (Disposable)runContentDescriptor);
            }
        }
        BuildProcessHandler processHandler2 = startBuildEvent.getProcessHandler();
        if (executionConsoleView instanceof ConsoleView) {
            for (Filter filter : startBuildEvent.getExecutionFilters()) {
                ((ConsoleView)executionConsoleView).addMessageFilter(filter);
            }
            if (processHandler2 != null) {
                ((ConsoleView)executionConsoleView).attachToProcess((ProcessHandler)processHandler2);
                Consumer attachedConsoleConsumer = startBuildEvent.getAttachedConsoleConsumer();
                if (attachedConsoleConsumer != null) {
                    attachedConsoleConsumer.consume((Object)((ConsoleView)executionConsoleView));
                }
                if (!processHandler2.isStartNotified()) {
                    processHandler2.startNotify();
                }
            }
        }
        if (processHandler2 != null && !processHandler2.isStartNotified()) {
            processHandler2.startNotify();
        }
        eventView.onEvent((BuildEvent)startBuildEvent);
    }

    private ExecutionConsole getConsoleView() {
        return this.getView(CONSOLE_VIEW_NAME, ExecutionConsole.class);
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            BuildView.$$$reportNull$$$0(1);
        }
        if (contentType == null) {
            BuildView.$$$reportNull$$$0(2);
        }
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> {
            if (text == null) {
                BuildView.$$$reportNull$$$0(13);
            }
            if (contentType == null) {
                BuildView.$$$reportNull$$$0(14);
            }
            view.print(text, contentType);
        }));
    }

    private void delegateToConsoleView(Consumer<? super ConsoleView> viewConsumer) {
        ExecutionConsole console = this.getConsoleView();
        if (console instanceof ConsoleView) {
            viewConsumer.consume((Object)((ConsoleView)console));
        }
    }

    @Nullable
    private <R> R getConsoleViewValue(Function<? super ConsoleView, ? extends R> viewConsumer) {
        ExecutionConsole console = this.getConsoleView();
        if (console instanceof ConsoleView) {
            return viewConsumer.apply((ConsoleView)((ConsoleView)console));
        }
        return null;
    }

    public void clear() {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)ConsoleView::clear));
    }

    public void scrollTo(int offset) {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.scrollTo(offset)));
    }

    public void attachToProcess(ProcessHandler processHandler2) {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.attachToProcess(processHandler2)));
    }

    public void setOutputPaused(boolean value) {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.setOutputPaused(value)));
    }

    public boolean isOutputPaused() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::isOutputPaused);
        return result2 != null && result2 != false;
    }

    public boolean hasDeferredOutput() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::hasDeferredOutput);
        return result2 != null && result2 != false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            BuildView.$$$reportNull$$$0(3);
        }
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> {
            if (runnable2 == null) {
                BuildView.$$$reportNull$$$0(12);
            }
            view.performWhenNoDeferredOutput(runnable2);
        }));
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            BuildView.$$$reportNull$$$0(4);
        }
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> {
            if (helpId == null) {
                BuildView.$$$reportNull$$$0(11);
            }
            view.setHelpId(helpId);
        }));
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            BuildView.$$$reportNull$$$0(5);
        }
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> {
            if (filter == null) {
                BuildView.$$$reportNull$$$0(10);
            }
            view.addMessageFilter(filter);
        }));
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            BuildView.$$$reportNull$$$0(6);
        }
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> {
            if (hyperlinkText == null) {
                BuildView.$$$reportNull$$$0(9);
            }
            view.printHyperlink(hyperlinkText, info);
        }));
    }

    public int getContentSize() {
        Integer result2 = this.getConsoleViewValue(ConsoleView::getContentSize);
        return result2 == null ? 0 : result2;
    }

    public boolean canPause() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::canPause);
        return result2 != null && result2 != false;
    }

    @Override
    @NotNull
    public AnAction[] createConsoleActions() {
        DefaultActionGroup rerunActionGroup = new DefaultActionGroup();
        StopProcessAction stopAction = null;
        StartBuildEvent startBuildEvent = this.myStartBuildEventRef.get();
        if (startBuildEvent != null && startBuildEvent.getProcessHandler() != null) {
            stopAction = new StopProcessAction("Stop", "Stop", (ProcessHandler)startBuildEvent.getProcessHandler());
            AnAction generalStopAction = ActionManager.getInstance().getAction("Stop");
            if (generalStopAction != null) {
                stopAction.copyFrom(generalStopAction);
                stopAction.registerCustomShortcutSet(generalStopAction.getShortcutSet(), this);
            }
        }
        DefaultActionGroup consoleActionGroup = new DefaultActionGroup(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.update(e);
                String eventViewName = BuildTreeConsoleView.class.getName();
                e.getPresentation().setVisible(!BuildView.this.isViewEnabled(eventViewName));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/build/BuildView$1", "update"));
            }
        };
        ExecutionConsole consoleView = this.getConsoleView();
        if (consoleView instanceof ConsoleView) {
            AnAction[] consoleActions;
            for (AnAction anAction : consoleActions = ((ConsoleView)consoleView).createConsoleActions()) {
                if (anAction instanceof StopAction) {
                    if (stopAction != null) continue;
                    stopAction = anAction;
                    continue;
                }
                if (anAction instanceof FakeRerunAction || anAction instanceof PinActiveTabAction || anAction instanceof CloseAction) continue;
                consoleActionGroup.add(anAction);
            }
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        if (startBuildEvent != null) {
            for (AnAction anAction : startBuildEvent.getRestartActions()) {
                rerunActionGroup.add(anAction);
            }
        }
        if (stopAction != null) {
            rerunActionGroup.add((AnAction)stopAction);
        }
        actionGroup.add((AnAction)rerunActionGroup);
        if (this.myViewManager.isBuildContentView()) {
            actionGroup.addAll(this.getSwitchActions());
            actionGroup.addSeparator();
        }
        AnAction[] anActionArray = new AnAction[]{actionGroup, consoleActionGroup};
        if (anActionArray == null) {
            BuildView.$$$reportNull$$$0(7);
        }
        return anActionArray;
    }

    public void allowHeavyFilters() {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)ConsoleView::allowHeavyFilters));
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            BuildView.$$$reportNull$$$0(8);
        }
        if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
            return this.getConsoleView();
        }
        Object data = super.getData(dataId);
        if (data != null) {
            return data;
        }
        StartBuildEvent startBuildEvent = this.myStartBuildEventRef.get();
        if (startBuildEvent != null && LangDataKeys.RUN_PROFILE.is(dataId)) {
            ExecutionEnvironment environment = startBuildEvent.getExecutionEnvironment();
            return environment == null ? null : environment.getRunProfile();
        }
        if (startBuildEvent != null && LangDataKeys.EXECUTION_ENVIRONMENT.is(dataId)) {
            return startBuildEvent.getExecutionEnvironment();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/BuildView";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/BuildView";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onEvent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$printHyperlink$9";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addMessageFilter$8";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setHelpId$7";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performWhenNoDeferredOutput$6";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$print$2";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onEvent$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

