/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSimplifyBooleanIntention
extends PsiElementBaseIntentionAction {
    public static final String NAME = "Simplify boolean expression";
    private static final Map<IElementType, PhpLogicalOperator> logicalInvert = new THashMap();
    private static final Map<IElementType, String> compareInvert = new THashMap();

    @NotNull
    public String getFamilyName() {
        if (NAME == null) {
            PhpSimplifyBooleanIntention.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @NotNull
    public String getText() {
        if (NAME == null) {
            PhpSimplifyBooleanIntention.$$$reportNull$$$0(1);
        }
        return NAME;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        PsiElement negativeExpression;
        if (project == null) {
            PhpSimplifyBooleanIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PhpSimplifyBooleanIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpSimplifyBooleanIntention.$$$reportNull$$$0(4);
        }
        return (negativeExpression = PhpSimplifyBooleanIntention.getNegativeExpression(element)) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpSimplifyBooleanIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            PhpSimplifyBooleanIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            PhpSimplifyBooleanIntention.$$$reportNull$$$0(7);
        }
        PsiElement expression = PhpSimplifyBooleanIntention.getNegativeExpression(element);
        assert (expression instanceof ParenthesizedExpression);
        PhpPsiElement argument = ((ParenthesizedExpression)expression).getArgument();
        if (expression.getParent() != null && argument instanceof PhpExpression) {
            String result = PhpSimplifyBooleanIntention.invertExpression((PhpExpression)argument, 0);
            PhpExpression resultElement = PhpPsiElementFactory.createPhpPsiFromText(project, PhpExpression.class, result);
            PhpCodeEditUtil.replace(expression.getParent(), resultElement);
        }
    }

    public static String invert(@Nullable PsiElement element, int parentPriority) {
        if (element instanceof PhpExpression) {
            return PhpSimplifyBooleanIntention.invertExpression((PhpExpression)element, parentPriority);
        }
        return PhpSimplifyBooleanIntention.safeGetText(element);
    }

    @NotNull
    public static String invertExpression(@NotNull PhpExpression expression, int parentPriority) {
        if (expression == null) {
            PhpSimplifyBooleanIntention.$$$reportNull$$$0(8);
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            PsiElement operation = unaryExpression.getOperation();
            if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opNOT)) {
                String string = PhpSimplifyBooleanIntention.safeGetText((PsiElement)unaryExpression.getValue());
                if (string == null) {
                    PhpSimplifyBooleanIntention.$$$reportNull$$$0(9);
                }
                return string;
            }
        } else if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            IElementType type = binaryExpression.getOperationType();
            if (logicalInvert.containsKey(type)) {
                PhpLogicalOperator operator = logicalInvert.get(type);
                int priority = operator.getPriority();
                StringBuilder builder = new StringBuilder();
                builder.append(PhpSimplifyBooleanIntention.invert(binaryExpression.getLeftOperand(), priority));
                builder.append(" ");
                builder.append(operator.getText());
                builder.append(" ");
                builder.append(PhpSimplifyBooleanIntention.invert(binaryExpression.getRightOperand(), priority));
                String string = parentPriority > priority ? "(" + builder.toString() + ")" : builder.toString();
                if (string == null) {
                    PhpSimplifyBooleanIntention.$$$reportNull$$$0(10);
                }
                return string;
            }
            if (compareInvert.containsKey(type)) {
                StringBuilder builder = new StringBuilder(PhpSimplifyBooleanIntention.safeGetText(binaryExpression.getLeftOperand()));
                builder.append(compareInvert.get(type));
                builder.append(PhpSimplifyBooleanIntention.safeGetText(binaryExpression.getRightOperand()));
                String string = builder.toString();
                if (string == null) {
                    PhpSimplifyBooleanIntention.$$$reportNull$$$0(11);
                }
                return string;
            }
        } else {
            if (expression instanceof ParenthesizedExpression) {
                String string = PhpSimplifyBooleanIntention.invert((PsiElement)((ParenthesizedExpression)expression).getArgument(), 2);
                if (string == null) {
                    PhpSimplifyBooleanIntention.$$$reportNull$$$0(12);
                }
                return string;
            }
            if (expression instanceof ConstantReference) {
                ConstantReference constantReference = (ConstantReference)expression;
                if (PhpLangUtil.isFalse(constantReference)) {
                    if ("true" == null) {
                        PhpSimplifyBooleanIntention.$$$reportNull$$$0(13);
                    }
                    return "true";
                }
                if (PhpLangUtil.isTrue(constantReference)) {
                    if ("false" == null) {
                        PhpSimplifyBooleanIntention.$$$reportNull$$$0(14);
                    }
                    return "false";
                }
            }
        }
        String string = PhpSimplifyBooleanIntention.negate((PsiElement)expression);
        if (string == null) {
            PhpSimplifyBooleanIntention.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String negate(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpSimplifyBooleanIntention.$$$reportNull$$$0(16);
        }
        StringBuilder builder = new StringBuilder("!");
        if (!(expression instanceof PhpReference) && !(expression instanceof ParenthesizedExpression)) {
            builder.append("(");
            builder.append(expression.getText());
            builder.append(")");
        } else {
            builder.append(expression.getText());
        }
        String string = builder.toString();
        if (string == null) {
            PhpSimplifyBooleanIntention.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static String safeGetText(@Nullable PsiElement expression) {
        return expression == null ? "" : expression.getText();
    }

    @Nullable
    public static PsiElement getNegativeExpression(@NotNull PsiElement element) {
        if (element == null) {
            PhpSimplifyBooleanIntention.$$$reportNull$$$0(18);
        }
        return PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)element1 -> {
            PsiElement operation;
            if (element1.getParent() instanceof UnaryExpression && PhpPsiUtil.isOfType(operation = ((UnaryExpression)element1.getParent()).getOperation(), PhpTokenTypes.opNOT)) {
                return element1 instanceof ParenthesizedExpression;
            }
            return false;
        }));
    }

    static {
        logicalInvert.put(PhpTokenTypes.opAND, new PhpLogicalOperator(0, "||"));
        logicalInvert.put(PhpTokenTypes.opOR, new PhpLogicalOperator(1, "&&"));
        logicalInvert.put(PhpTokenTypes.opLIT_AND, new PhpLogicalOperator(0, "or"));
        logicalInvert.put(PhpTokenTypes.opLIT_OR, new PhpLogicalOperator(1, "and"));
        logicalInvert.put(PhpTokenTypes.opBIT_AND, new PhpLogicalOperator(0, "|"));
        logicalInvert.put(PhpTokenTypes.opBIT_OR, new PhpLogicalOperator(1, "&"));
        compareInvert.put(PhpTokenTypes.opEQUAL, "!=");
        compareInvert.put(PhpTokenTypes.opNOT_EQUAL, "==");
        compareInvert.put(PhpTokenTypes.opIDENTICAL, "!==");
        compareInvert.put(PhpTokenTypes.opNOT_IDENTICAL, "===");
        compareInvert.put(PhpTokenTypes.opGREATER, "<=");
        compareInvert.put(PhpTokenTypes.opGREATER_OR_EQUAL, "<");
        compareInvert.put(PhpTokenTypes.opLESS, ">=");
        compareInvert.put(PhpTokenTypes.opLESS_OR_EQUAL, ">");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpSimplifyBooleanIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpSimplifyBooleanIntention";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "invertExpression";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "negate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invertExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "negate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNegativeExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpLogicalOperator {
        private final String myText;
        private final int myPriority;

        private PhpLogicalOperator(int priority, @NotNull String text) {
            if (text == null) {
                PhpLogicalOperator.$$$reportNull$$$0(0);
            }
            this.myPriority = priority;
            this.myText = text;
        }

        private String getText() {
            return this.myText;
        }

        private int getPriority() {
            return this.myPriority;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/php/lang/intentions/PhpSimplifyBooleanIntention$PhpLogicalOperator", "<init>"));
        }
    }
}

