/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnreachableStatementInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnreachableStatementInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFile(PhpFile PhpFile2) {
                PhpUnreachableStatementInspection.analyzeScope((PhpScopeHolder)PhpFile2, holder);
            }

            public void visitPhpFunction(Function function) {
                PhpUnreachableStatementInspection.analyzeScope((PhpScopeHolder)function, holder);
            }

            public void visitPhpMethod(Method method) {
                PhpUnreachableStatementInspection.analyzeScope((PhpScopeHolder)method, holder);
            }

            public void visitPhpNamespace(PhpNamespace namespace) {
                PhpUnreachableStatementInspection.analyzeScope((PhpScopeHolder)namespace, holder);
            }
        };
        if (phpElementVisitor == null) {
            PhpUnreachableStatementInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static void analyzeScope(final @NotNull PhpScopeHolder scopeHolder, final @NotNull ProblemsHolder holder) {
        if (scopeHolder == null) {
            PhpUnreachableStatementInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PhpUnreachableStatementInspection.$$$reportNull$$$0(3);
        }
        PhpControlFlowUtil.processFlow(scopeHolder.getControlFlow(), new PhpInstructionProcessor(){

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                final Ref reachableRef = new Ref((Object)false);
                if (instruction.getPredecessors().size() != 0) {
                    PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                        public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                            reachableRef.set((Object)true);
                            return false;
                        }

                        public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                            reachableRef.set((Object)true);
                            return false;
                        }

                        public boolean processCatchConditionInstruction(PhpCatchConditionInstruction instruction) {
                            if (instruction.getResult()) {
                                reachableRef.set((Object)true);
                                return false;
                            }
                            return super.processCatchConditionInstruction(instruction);
                        }
                    });
                }
                if (!((Boolean)reachableRef.get()).booleanValue()) {
                    Statement unreachableStatement = instruction.getStatement();
                    if (!PhpUnreachableStatementInspection.isEmpty(unreachableStatement) && !PhpUnreachableStatementInspection.isSkippedStatement(unreachableStatement)) {
                        holder.registerProblem((PsiElement)unreachableStatement, PhpBundle.message("inspection.unreachable.statement.problem", new Object[0]), new LocalQuickFix[0]);
                    } else {
                        PhpStatementInstruction nextStatementInstruction = PhpUnreachableStatementInspection.getNextStatementInstruction(instruction);
                        if (nextStatementInstruction != null && !PhpUnreachableStatementInspection.isEmpty(nextStatementInstruction.getStatement()) && !PhpControlFlowUtil.isPredecessor((PhpInstruction)nextStatementInstruction, (PhpInstruction)scopeHolder.getControlFlow().getEntryPoint())) {
                            Statement statement = nextStatementInstruction.getStatement();
                            holder.registerProblem((PsiElement)statement, PhpBundle.message("inspection.unreachable.statement.problem", new Object[0]), new LocalQuickFix[0]);
                        }
                    }
                }
                return true;
            }
        });
    }

    private static boolean isSkippedStatement(@NotNull Statement statement) {
        if (statement == null) {
            PhpUnreachableStatementInspection.$$$reportNull$$$0(4);
        }
        return statement instanceof PhpBreak || statement instanceof PhpContinue;
    }

    private static boolean isEmpty(@NotNull Statement statement) {
        TextRange range;
        if (statement == null) {
            PhpUnreachableStatementInspection.$$$reportNull$$$0(5);
        }
        return (range = statement.getTextRange()).getStartOffset() >= range.getEndOffset();
    }

    @Nullable
    private static PhpStatementInstruction getNextStatementInstruction(@NotNull PhpStatementInstruction statementInstruction) {
        if (statementInstruction == null) {
            PhpUnreachableStatementInspection.$$$reportNull$$$0(6);
        }
        final Ref statementInstructionRef = new Ref();
        PhpControlFlowUtil.processSuccessors((PhpInstruction)statementInstruction, false, new PhpInstructionProcessor(){

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                Statement statement = instruction.getStatement();
                if (PhpUnreachableStatementInspection.isSkippedStatement(statement)) {
                    statementInstructionRef.set((Object)PhpUnreachableStatementInspection.getNextStatementInstruction(instruction));
                } else {
                    statementInstructionRef.set((Object)instruction);
                }
                return false;
            }
        });
        return (PhpStatementInstruction)statementInstructionRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnreachableStatementInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnreachableStatementInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSkippedStatement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNextStatementInstruction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

