/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpDeploymentAwareUtil;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.validation.PhpLocalWebServerValidator;
import com.jetbrains.php.debug.validation.PhpWebServerValidationCache;
import com.jetbrains.php.debug.validation.PhpWebServerValidator;
import com.jetbrains.php.debug.validation.deploymentAware.PhpRemoteWebServerValidationForm;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.ui.PhpInfoLabelPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpWebServerValidationForm
extends JPanel {
    private static final String DEFAULT_HOST = "http://127.0.0.1/";
    private static final PhpInfoLabelPanel LOCAL_INITIAL_LABEL;
    private static final PhpInfoLabelPanel REMOTE_INITIAL_LABEL;
    private JPanel myMainPanel;
    private JRadioButton myLocalWebServerRadio;
    private JRadioButton myRemoteWebServerRadio;
    private TextFieldWithHistoryWithBrowseButton myPathToValidationScriptDir;
    private JTextField myValidationScriptUrl;
    private JPanel myWarningContainer;
    private JLabel myWebPathLabel;
    private JLabel myDeploymentLabel;
    private JLabel myPathToScriptLabel;
    private JPanel myWebServerPanel;
    private JPanel myWarningPanel;
    @Nullable
    private PhpRemoteWebServerValidationForm myRemoteWebServerForm;
    private ActionListener myRadioButtonListener;
    private final Project myProject;
    private final List<PhpInfoLabelPanel> myWarningLabels;
    private boolean myDisposed;

    public PhpWebServerValidationForm(@NotNull Project project, @NotNull Disposable parent) {
        if (project == null) {
            PhpWebServerValidationForm.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            PhpWebServerValidationForm.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myRemoteWebServerForm = null;
        this.$$$setupUI$$$();
        this.myWarningLabels = new ArrayList<PhpInfoLabelPanel>();
        this.myDisposed = false;
        this.myProject = project;
        this.add((Component)this.myMainPanel, "Center");
        this.createWarningPanel();
        this.myRadioButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpWebServerValidationForm.this.radioSelected();
            }
        };
        this.myLocalWebServerRadio.addActionListener(this.myRadioButtonListener);
        this.myRemoteWebServerRadio.addActionListener(this.myRadioButtonListener);
        String title = PhpBundle.message("php.web.server.validation.chose.path.to.script", new Object[0]);
        String description = PhpBundle.message("php.web.server.validation.chose.path.to.script.description", new Object[0]);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        final TextFieldWithHistory textFieldComponent = (TextFieldWithHistory)this.myPathToValidationScriptDir.getChildComponent();
        ComponentWithBrowseButton.BrowseFolderActionListener<TextFieldWithHistory> browseListener = new ComponentWithBrowseButton.BrowseFolderActionListener<TextFieldWithHistory>(title, description, (ComponentWithBrowseButton)this.myPathToValidationScriptDir, project, descriptor, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
                textFieldComponent.addCurrentTextToHistory();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/php/debug/validation/PhpWebServerValidationForm$2", "onFileChosen"));
            }
        };
        this.myPathToValidationScriptDir.addActionListener((ActionListener)browseListener);
        FileChooserFactory.getInstance().installFileCompletion(textFieldComponent.getTextEditor(), descriptor, true, (Disposable)project);
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null) {
            textFieldComponent.setText(FileUtil.toSystemDependentName((String)baseDir.getPath()));
        }
        textFieldComponent.addCurrentTextToHistory();
        Disposer.register((Disposable)parent, (Disposable)this.myPathToValidationScriptDir);
        if (!PhpDeploymentAwareUtil.isDeploymentPluginEnabled()) {
            this.myRemoteWebServerRadio.setVisible(false);
        } else {
            this.myRemoteWebServerForm = new PhpRemoteWebServerValidationForm(this.myProject, this.myWebServerPanel, this.myDeploymentLabel);
        }
        this.myPathToScriptLabel.setLabelFor((Component)this.myPathToValidationScriptDir);
        this.myWebPathLabel.setLabelFor(this.myValidationScriptUrl);
        this.myValidationScriptUrl.setText(DEFAULT_HOST);
        this.myLocalWebServerRadio.setSelected(true);
        this.reset();
        this.radioSelected();
    }

    public void setLocalUrl(@NotNull String url) {
        if (url == null) {
            PhpWebServerValidationForm.$$$reportNull$$$0(2);
        }
        this.myValidationScriptUrl.setText(url);
        this.myLocalWebServerRadio.setSelected(true);
        this.radioSelected();
    }

    private void createUIComponents() {
    }

    private void radioSelected() {
        boolean local = this.myLocalWebServerRadio.isSelected();
        this.myWebPathLabel.setVisible(local);
        this.myValidationScriptUrl.setVisible(local);
        boolean remote = this.myRemoteWebServerForm != null && this.myRemoteWebServerRadio.isSelected();
        this.myDeploymentLabel.setVisible(remote);
        if (this.myRemoteWebServerForm != null) {
            this.myRemoteWebServerForm.setVisible(remote);
        }
        if (this.myWarningLabels.size() == 1 && (this.myWarningLabels.get(0) == LOCAL_INITIAL_LABEL && remote || this.myWarningLabels.get(0) == REMOTE_INITIAL_LABEL && local)) {
            this.resetWarnings();
        }
    }

    protected void createWarningPanel() {
        this.myWarningPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0));
        IdeaTitledBorder titledBorder = IdeBorderFactory.createTitledBorder((String)"Information", (boolean)false);
        JBEmptyBorder emptyBorder = JBUI.Borders.empty((int)0, (int)5, (int)5, (int)5);
        CompoundBorder border = BorderFactory.createCompoundBorder((Border)titledBorder, (Border)emptyBorder);
        this.myWarningPanel.setBorder(border);
        if (this.myRemoteWebServerForm == null || !this.myRemoteWebServerForm.isValid()) {
            this.resetWarnings();
        }
        this.myWarningContainer.add((Component)this.myWarningPanel, "Center");
        this.myWarningContainer.setPreferredSize((Dimension)JBUI.size((int)530, (int)170));
    }

    protected void doValidateAction() {
        this.apply();
        VirtualFile directory = PhpRunUtil.findDirectory(((TextFieldWithHistory)this.myPathToValidationScriptDir.getChildComponent()).getText());
        if (directory == null) {
            this.myWarningLabels.clear();
            PhpInfoValidationMessage message = PhpInfoValidationMessage.failed(PhpBundle.message("php.web.server.validation.invalid.path.to.script", new Object[0]), null);
            this.myWarningLabels.add(PhpInfoLabelPanel.create(message));
            this.updateWarningPanel();
            return;
        }
        PhpWebServerValidator validator = this.createWebServerValidator();
        try {
            List<PhpInfoValidationMessage> validate = validator.validate(directory, this.myWarningContainer);
            this.myWarningLabels.clear();
            for (PhpInfoValidationMessage message : validate) {
                this.myWarningLabels.add(PhpInfoLabelPanel.create(message));
            }
            this.updateWarningPanel();
        }
        catch (ProcessCanceledException e) {
            this.resetWarnings();
        }
    }

    private PhpWebServerValidator createWebServerValidator() {
        if (this.myLocalWebServerRadio.isSelected() || this.myRemoteWebServerForm == null) {
            return new PhpLocalWebServerValidator(this.myProject, this.myValidationScriptUrl.getText());
        }
        return this.myRemoteWebServerForm.createWebServerValidator(this.myProject, this.myMainPanel);
    }

    private void resetWarnings() {
        this.myWarningLabels.clear();
        this.myWarningLabels.add(this.myLocalWebServerRadio.isSelected() ? LOCAL_INITIAL_LABEL : REMOTE_INITIAL_LABEL);
        this.updateWarningPanel();
    }

    private void updateWarningPanel() {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myWarningPanel.removeAll();
            for (PhpInfoLabelPanel label : this.myWarningLabels) {
                this.myWarningPanel.add(label);
            }
            this.myWarningPanel.updateUI();
        });
    }

    protected void disposeUI() {
        this.myDisposed = true;
        this.myLocalWebServerRadio.removeActionListener(this.myRadioButtonListener);
        this.myRemoteWebServerRadio.removeActionListener(this.myRadioButtonListener);
        this.myRadioButtonListener = null;
        if (this.myRemoteWebServerForm != null) {
            this.myRemoteWebServerForm.disposeUI();
        }
    }

    private void apply() {
        PhpWebServerValidationCache.State state = PhpWebServerValidationCache.getInstance(this.myProject).getState();
        if (state != null) {
            state.setType(this.myRemoteWebServerRadio.isSelected() ? PhpWebServerValidationCache.PhpWebServerValidationType.REMOTE : PhpWebServerValidationCache.PhpWebServerValidationType.LOCAL);
            state.setPathToValidationScript(StringUtil.notNullize((String)this.myPathToValidationScriptDir.getText()));
            state.setWebPathToValidationScript(StringUtil.notNullize((String)this.myValidationScriptUrl.getText()));
            if (this.myRemoteWebServerForm != null) {
                this.myRemoteWebServerForm.apply(state);
            }
        }
    }

    private void reset() {
        PhpWebServerValidationCache.State state = PhpWebServerValidationCache.getInstance(this.myProject).getState();
        if (state != null) {
            boolean deploymentEnabled;
            String webPath;
            String pathToScript = state.getPathToValidationScript();
            if (pathToScript != null) {
                ((TextFieldWithHistory)this.myPathToValidationScriptDir.getChildComponent()).setText(pathToScript);
            }
            if ((webPath = state.getWebPathToValidationScript()) != null) {
                this.myValidationScriptUrl.setText(webPath);
            }
            if ((deploymentEnabled = PhpDeploymentAwareUtil.isDeploymentPluginEnabled()) && state.getType() == PhpWebServerValidationCache.PhpWebServerValidationType.REMOTE) {
                assert (this.myRemoteWebServerForm != null);
                this.myRemoteWebServerRadio.setSelected(true);
            } else {
                this.myLocalWebServerRadio.setSelected(true);
            }
            if (deploymentEnabled) {
                this.myRemoteWebServerForm.reset(this.myProject, state);
            }
        }
    }

    static {
        String localDescription = "Validation script will be created locally and the result will be fetched by http request.";
        String local = PhpBundle.message("php.web.server.validation.configure.local", new Object[0]);
        LOCAL_INITIAL_LABEL = PhpInfoLabelPanel.create(PhpInfoValidationMessage.error(local, "Validation script will be created locally and the result will be fetched by http request."));
        String remoteDescription = "Validation script will be created locally and deployed to the remote server.<br>The result of validation will be fetched by http request.<br>Follow this <a href=\"https://confluence.jetbrains.com/display/PhpStorm/Deploying+PHP+applications+with+PhpStorm\">link</a> for more information about deployment.";
        String remote = PhpBundle.message("php.web.server.validation.configure.remote", new Object[0]);
        REMOTE_INITIAL_LABEL = PhpInfoLabelPanel.create(PhpInfoValidationMessage.error(remote, "Validation script will be created locally and deployed to the remote server.<br>The result of validation will be fetched by http request.<br>Follow this <a href=\"https://confluence.jetbrains.com/display/PhpStorm/Deploying+PHP+applications+with+PhpStorm\">link</a> for more information about deployment."));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/validation/PhpWebServerValidationForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setLocalUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        JLabel jLabel3;
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, "North");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLocalWebServerRadio = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/PhpBundle").getString("php.web.server.validation.local.web.server.radio"));
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRemoteWebServerRadio = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/PhpBundle").getString("php.web.server.validation.remote.web.server.radio"));
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPathToValidationScriptDir = textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        jPanel6.add((Component)textFieldWithHistoryWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myPathToScriptLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/PhpBundle").getString("php.web.server.validation.local.path.to.script"));
        jLabel3.setToolTipText(ResourceBundle.getBundle("messages/PhpBundle").getString("php.web.server.validation.local.path.to.script.tooltip"));
        jPanel6.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWebPathLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/PhpBundle").getString("php.web.server.validation.url.to.validation.script"));
        jLabel2.setToolTipText(ResourceBundle.getBundle("messages/PhpBundle").getString("php.web.server.validation.url.to.validation.script.tooltip"));
        jPanel6.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myValidationScriptUrl = jTextField = new JTextField();
        jPanel6.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDeploymentLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/PhpBundle").getString("php.web.server.validation.deployment.server"));
        jLabel.setToolTipText(ResourceBundle.getBundle("messages/PhpBundle").getString("php.web.server.validation.deployment.server.tooltip"));
        jPanel6.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWebServerPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel2, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myWarningContainer = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, "Center");
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

