/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnProgressCanceller;
import org.jetbrains.idea.svn.SvnVcs;

public class CleanupWorker
extends Task.Backgroundable {
    @NotNull
    protected final List<VirtualFile> myRoots;
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final List<Pair<VcsException, VirtualFile>> myExceptions;

    public CleanupWorker(@NotNull SvnVcs vcs, @NotNull List<? extends VirtualFile> roots) {
        if (vcs == null) {
            CleanupWorker.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            CleanupWorker.$$$reportNull$$$0(1);
        }
        this(vcs, roots, null);
    }

    public CleanupWorker(@NotNull SvnVcs vcs, @NotNull List<? extends VirtualFile> roots, @Nullable String title) {
        if (vcs == null) {
            CleanupWorker.$$$reportNull$$$0(2);
        }
        if (roots == null) {
            CleanupWorker.$$$reportNull$$$0(3);
        }
        super(vcs.getProject(), (String)ObjectUtils.notNull((Object)title, (Object)SvnBundle.message("action.Subversion.cleanup.progress.title", new Object[0])));
        this.myExceptions = ContainerUtil.newArrayList();
        this.myVcs = vcs;
        this.myRoots = ContainerUtil.newArrayList(roots);
    }

    public void execute() {
        ApplicationManager.getApplication().saveAll();
        this.fillRoots();
        if (!this.myRoots.isEmpty()) {
            this.queue();
        }
    }

    protected void fillRoots() {
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CleanupWorker.$$$reportNull$$$0(4);
        }
        indicator.setIndeterminate(true);
        for (VirtualFile root : this.myRoots) {
            try {
                File path = VfsUtilCore.virtualToIoFile((VirtualFile)root);
                File pathOrParent = VfsUtilCore.virtualToIoFile((VirtualFile)(root.isDirectory() ? root : root.getParent()));
                indicator.setText(SvnBundle.message("action.Subversion.cleanup.progress.text", path));
                this.myVcs.getFactory(path).createCleanupClient().cleanup(pathOrParent, new SvnProgressCanceller(indicator));
            }
            catch (VcsException e) {
                this.myExceptions.add((Pair<VcsException, VirtualFile>)Pair.create((Object)((Object)e), (Object)root));
            }
        }
    }

    public void onCancel() {
        this.onSuccess();
    }

    public void onSuccess() {
        if (this.myProject.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (!this.myProject.isDisposed()) {
                LocalFileSystem.getInstance().refreshFiles(this.myRoots, false, true, null);
            }
        }));
        VcsFileUtil.markFilesDirty((Project)this.myProject, this.myRoots);
        if (!this.myExceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(this.myExceptions.stream().map(pair -> new VcsException(SvnBundle.message("action.Subversion.cleanup.error.message", FileUtil.toSystemDependentName((String)((VirtualFile)pair.second).getPath()), pair.first == null ? "" : ((VcsException)((Object)((Object)pair.first))).getMessage()))).collect(Collectors.toList()), this.myTitle);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/actions/CleanupWorker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

