/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeWithSignature;
import com.intellij.lang.javascript.ecmascript6.types.TypeScriptOverloadContextualType;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOfJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSignatureChooser {
    private static final Comparator<PsiElement> FUNCTIONS_FIRST = Comparator.comparing(el -> el instanceof TypeScriptCompileTimeType ? 1 : -1).thenComparing(el -> el instanceof TypeScriptModule ? 1 : -1);
    public static final Comparator<ResolveResult> FUNCTIONS_FIRST_RESOLVE_RESULT = (o1, o2) -> FUNCTIONS_FIRST.compare(o1.getElement(), o2.getElement());
    public static final int HAS_REST_ARG = Integer.MAX_VALUE;
    public static final Key<ParameterizedCachedValue<JSFunctionItem, Pair<List<? extends JSFunctionItem>, JSExpression[]>>> RESOLVE_OVERLOAD_KEY = Key.create((String)"ts.resolve.overloads.signature");
    private static final ParameterizedCachedValueProvider<JSFunctionItem, Pair<List<? extends JSFunctionItem>, JSExpression[]>> RESOLVE_OVERLOAD_CACHE = pair -> {
        List functions = (List)pair.first;
        JSExpression[] arguments = (JSExpression[])pair.second;
        ArrayList argTypes = ContainerUtil.newArrayListWithCapacity((int)arguments.length);
        int argumentsLength = arguments.length;
        List availableFunctions = functions.stream().filter(func -> {
            if (func instanceof TypeScriptFunction) {
                JSParameterListElement[] parameters = ((TypeScriptFunction)func).getParameters();
                int min = TypeScriptSignatureChooser.getMinArgumentCount((JSParameterItem[])parameters);
                int max = TypeScriptSignatureChooser.getMaxArgumentCount((JSParameterItem[])parameters);
                return min <= argumentsLength && argumentsLength <= max;
            }
            return true;
        }).collect(Collectors.toList());
        if (availableFunctions.size() <= 1) {
            return CachedValueProvider.Result.create((Object)ContainerUtil.getFirstItem(availableFunctions), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
        for (JSExpression expression : arguments) {
            argTypes.add(TypeScriptGenericTypesEvaluator.getParameterExpressionType(expression, true));
        }
        for (JSFunctionItem function : availableFunctions) {
            ProcessingContext context;
            List actualTypes = argTypes.stream().map(el -> TypeScriptSignatureChooser.mapContextualTypeForOverload(el, (PsiElement)function)).collect(Collectors.toList());
            JSFunctionType functionType = TypeScriptTypeParser.buildFunctionType(function);
            if (!JSTypeUtils.canBeCalledWithArguments((JSType)functionType, actualTypes, false, context = JSTypeComparingContextService.getProcessingContextWithCache((PsiElement)function))) continue;
            return CachedValueProvider.Result.create((Object)function, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
        return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    };

    @NotNull
    public static JSResolveResult checkParameterTypes(@NotNull PsiElement candidate, @Nullable List<JSType> argumentTypes, @NotNull NullableLazyValue<JSType> qualifierType, @Nullable JSTypeSubstitutor genericArguments, boolean isNewExpression) {
        if (candidate == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(0);
        }
        if (qualifierType == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(1);
        }
        if (!(candidate instanceof JSFunction)) {
            JSResolveResult jSResolveResult = new JSResolveResult(candidate);
            if (jSResolveResult == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(2);
            }
            return jSResolveResult;
        }
        if (candidate instanceof TypeScriptFunction && ((TypeScriptFunction)candidate).isOverloadImplementation()) {
            JSResolveResult jSResolveResult = TypeScriptSignatureChooser.getOverloadSignatureForImplementation(candidate, argumentTypes, qualifierType, genericArguments, isNewExpression);
            if (jSResolveResult == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(3);
            }
            return jSResolveResult;
        }
        JSFunction jsFunction = (JSFunction)candidate;
        JSParameterList parameterList = jsFunction.isConstructor() == isNewExpression ? jsFunction.getParameterList() : null;
        JSResolveResult jSResolveResult = new JSResolveResult(candidate, null, TypeScriptSignatureChooser.checkParameterTypes(candidate, argumentTypes, qualifierType, genericArguments, parameterList));
        if (jSResolveResult == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(4);
        }
        return jSResolveResult;
    }

    @NotNull
    public static JSResolveResult getOverloadSignatureForImplementation(@NotNull PsiElement functionCandidate, @Nullable List<JSType> argumentTypes, @NotNull NullableLazyValue<JSType> qualifierType, @Nullable JSTypeSubstitutor substitutor, boolean isNewExpression) {
        if (functionCandidate == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(5);
        }
        if (qualifierType == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(6);
        }
        List overloads = ((TypeScriptFunction)functionCandidate).getOverloadDeclarations();
        String firstError = null;
        TypeScriptFunction firstOverload = null;
        for (TypeScriptFunction overload : overloads) {
            if (overload.isConstructor() != isNewExpression) continue;
            String latestError = TypeScriptSignatureChooser.checkParameterTypes(functionCandidate, argumentTypes, qualifierType, substitutor, overload.getParameterList());
            if (latestError == null) {
                JSResolveResult jSResolveResult = new JSResolveResult((PsiElement)overload);
                if (jSResolveResult == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(7);
                }
                return jSResolveResult;
            }
            if (firstError != null) continue;
            firstError = latestError;
            firstOverload = overload;
        }
        PsiElement resultFunction = functionCandidate;
        if (firstError != null) {
            resultFunction = firstOverload;
        }
        JSResolveResult jSResolveResult = new JSResolveResult(resultFunction, null, firstError);
        if (jSResolveResult == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(8);
        }
        return jSResolveResult;
    }

    public static boolean isOverloadImplementation(@Nullable PsiElement function) {
        return function instanceof TypeScriptFunction && ((TypeScriptFunction)function).isOverloadImplementation();
    }

    @NotNull
    public static List<JSParameterTypeDecorator> getTypeDecoratorsWithAppliedGenerics(@NotNull JSParameterItem[] parameters, @Nullable JSTypeSubstitutor genericArguments) {
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(9);
        }
        ArrayList<JSParameterTypeDecorator> parameterTypes = new ArrayList<JSParameterTypeDecorator>();
        for (JSParameterItem p : parameters) {
            JSType parameterType = p.getType();
            if (parameterType != null) {
                parameterType = JSTypeUtils.applyGenericArguments(parameterType, genericArguments);
            }
            JSParameterTypeDecoratorImpl typeDecorator = new JSParameterTypeDecoratorImpl(parameterType, p.isOptional(), p.isRest(), p.getTypeDecorator().isExplicitlyDeclared());
            parameterTypes.add(typeDecorator);
        }
        ArrayList<JSParameterTypeDecorator> arrayList = parameterTypes;
        if (arrayList == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    public static String checkParameterTypes(@NotNull PsiElement context, @Nullable List<JSType> argumentTypes, @NotNull NullableLazyValue<JSType> qualifierType, @Nullable JSTypeSubstitutor genericArguments, @Nullable JSParameterList parameterList) {
        if (context == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(11);
        }
        if (qualifierType == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(12);
        }
        if (parameterList == null) {
            return null;
        }
        List<JSParameterTypeDecorator> functionParameters = TypeScriptSignatureChooser.getTypeDecoratorsWithAppliedGenerics((JSParameterItem[])parameterList.getParameters(), genericArguments);
        return TypeScriptSignatureChooser.checkParameterTypes(context, ContainerUtil.notNullize(argumentTypes), qualifierType, functionParameters);
    }

    @Nullable
    private static String checkParameterTypes(@NotNull PsiElement contextFunctionOrElement, @NotNull List<JSType> argumentTypes, @Nullable NullableLazyValue<JSType> qualifierLazyType, @NotNull List<JSParameterTypeDecorator> functionParameters) {
        JSType thisType;
        JSType qualifierType;
        if (contextFunctionOrElement == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(13);
        }
        if (argumentTypes == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(14);
        }
        if (functionParameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(15);
        }
        ProcessingContext processingContext = JSTypeComparingContextService.getProcessingContextWithCallEnvironment(contextFunctionOrElement);
        List<JSParameterTypeDecorator> arguments = JSTypeUtils.getParameterTypeDecorators(argumentTypes);
        if (!JSTypeUtils.areArgumentsAssignable(functionParameters, arguments, processingContext, false, false, true)) {
            return "javascript.argument.types.mismatch";
        }
        if (!(contextFunctionOrElement instanceof TypeScriptFunction)) {
            return null;
        }
        TypeScriptFunction tsFunction = (TypeScriptFunction)contextFunctionOrElement;
        JSType jSType = qualifierType = qualifierLazyType != null ? (JSType)qualifierLazyType.getValue() : null;
        if (qualifierType != null && (thisType = tsFunction.getExplicitThisType()) != null && !thisType.isDirectlyAssignableType(qualifierType, processingContext)) {
            return "javascript.argument.types.mismatch";
        }
        List<JSType> types = functionParameters.stream().map(el -> el.getType()).collect(Collectors.toList());
        if (TypeScriptGenericTypesEvaluator.getInstance().hasGenericsCompatibilityErrors(types, argumentTypes, tsFunction)) {
            return "javascript.argument.types.mismatch";
        }
        return null;
    }

    @Nullable
    public static JSFunction getFunctionWithParameters(@NotNull JSCallExpression expression, @NotNull Collection<? extends JSFunction> functions) {
        if (expression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(16);
        }
        if (functions == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(17);
        }
        return TypeScriptSignatureChooser.getFunctionWithParameters(expression, functions, null);
    }

    @Nullable
    public static <T extends JSFunctionItem> T getFunctionWithParameters(@NotNull JSCallExpression expression, @NotNull Collection<T> functions, @Nullable JSTypeSubstitutor substitutor) {
        if (expression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(18);
        }
        if (functions == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(19);
        }
        List<JSType> rawArgumentTypes = TypeScriptGenericTypesEvaluator.getArgumentTypesForSignatureChecking(expression.getArguments(), true);
        for (JSFunctionItem constructor : functions) {
            List<JSParameterTypeDecorator> parameters;
            List<JSType> contextArguments = rawArgumentTypes.stream().map(type -> {
                if (expression == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(88);
                }
                return TypeScriptGenericTypesEvaluator.getExplicitTypeOrAnyIfTypeScript((PsiElement)expression, TypeScriptSignatureChooser.mapContextualTypeForOverload(type, (PsiElement)constructor));
            }).collect(Collectors.toList());
            if (TypeScriptSignatureChooser.checkParameterTypes((PsiElement)expression, contextArguments, null, parameters = TypeScriptSignatureChooser.getTypeDecoratorsWithAppliedGenerics(constructor.getParameters(), substitutor)) != null) continue;
            return (T)constructor;
        }
        return null;
    }

    @NotNull
    public static List<JSFunctionWithSubstitutor> resolveConstructorOrCallSignature(@NotNull PsiElement referenceExpression) {
        PsiElement functionCandidate;
        List<JSFunctionItem> resolveElements;
        if (referenceExpression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(20);
        }
        if (!(referenceExpression instanceof JSReferenceExpression) || !(referenceExpression.getParent() instanceof JSCallExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(21);
            }
            return list;
        }
        JSCallExpression callExpression = (JSCallExpression)referenceExpression.getParent();
        JSReferenceExpression element = (JSReferenceExpression)referenceExpression;
        ResolveResult[] resolveResults = element.multiResolve(false);
        boolean hasAliases = Arrays.stream(resolveResults).anyMatch(r -> r.getElement() instanceof TypeScriptProxyImplicitElementWithBackingItem);
        if (hasAliases) {
            resolveResults = TypeScriptImplicitOverloadedAliasElement.unwrapElements(resolveResults);
        }
        List<PsiElement> elements = JSResolveResult.toElements(resolveResults);
        if (callExpression instanceof JSNewExpression && (resolveElements = TypeScriptSignatureChooser.getConstructorsForResolveElements((JSExpression)referenceExpression, elements)).size() > 0) {
            List<JSFunctionWithSubstitutor> list = resolveElements.stream().map(JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR).collect(Collectors.toList());
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(22);
            }
            return list;
        }
        if (elements.size() == 1 && (functionCandidate = (PsiElement)ContainerUtil.getFirstItem(elements)) != null && (!(functionCandidate instanceof JSFunction) || hasAliases) && DialectDetector.isTypeScript(functionCandidate)) {
            List<JSFunctionWithSubstitutor> list = TypeScriptSignatureChooser.getCallSignatures(functionCandidate, callExpression);
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(23);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    private static List<JSFunctionItem> getConstructorsForResolveElements(@NotNull JSExpression parent, @NotNull Collection<PsiElement> elements) {
        if (parent == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(25);
        }
        if (elements == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(26);
        }
        if (!elements.isEmpty()) {
            List result2 = ContainerUtil.newSmartList();
            for (PsiElement psiElement : elements) {
                ResolveResult[] results;
                List<PsiElement> resolvedElements;
                if (!(psiElement instanceof JSClass) || (resolvedElements = JSResolveResult.toElements(results = JSClassUtils.resolveES6Constructor((JSClass)psiElement, parent))).isEmpty()) continue;
                result2.addAll(resolvedElements);
            }
            if (result2.size() > 0) {
                List list = ContainerUtil.mapNotNull((Collection)result2, el -> el instanceof JSFunctionItem ? (JSFunctionItem)el : null);
                if (list == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(27);
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    private static List<JSFunctionWithSubstitutor> getCallSignatures(@NotNull PsiElement functionCandidate, @NotNull JSCallExpression callExpression) {
        if (functionCandidate == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(29);
        }
        if (callExpression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(30);
        }
        JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.getCallExplicitTypeSubstitutor(functionCandidate, (PsiElement)callExpression, null);
        JSExpression methodExpression = callExpression.getMethodExpression();
        Collection<JSFunctionWithSubstitutor> functionWithSubstitutors = JSStubBasedPsiTreeUtil.calculatePossibleFunctions(functionCandidate, (PsiElement)methodExpression, false);
        List functionItems = functionWithSubstitutors.stream().map(el -> el.myFunctionItem).collect(Collectors.toList());
        Object functionItem = TypeScriptSignatureChooser.getFunctionWithParameters(callExpression, functionItems, substitutor);
        if (functionItem != null) {
            for (JSFunctionWithSubstitutor withSubstitutor : functionWithSubstitutors) {
                if (withSubstitutor.myFunctionItem != functionItem) continue;
                List list = ContainerUtil.createMaybeSingletonList((Object)withSubstitutor);
                if (list == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(31);
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(32);
        }
        return list;
    }

    public static int getMinArgumentCount(@NotNull List<? extends JSParameterTypeDecorator> parameters) {
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(33);
        }
        if (parameters.size() == 0) {
            return 0;
        }
        int minArgumentCount = 0;
        for (JSParameterTypeDecorator jSParameterTypeDecorator : parameters) {
            if (jSParameterTypeDecorator.isOptional() || jSParameterTypeDecorator.isRest()) break;
            ++minArgumentCount;
        }
        return minArgumentCount;
    }

    public static int getMaxArgumentCount(@NotNull List<? extends JSParameterTypeDecorator> parameters) {
        int size;
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(34);
        }
        if ((size = parameters.size()) == 0) {
            return 0;
        }
        JSParameterTypeDecorator lastParameter = (JSParameterTypeDecorator)ContainerUtil.getLastItem(parameters);
        if (lastParameter == null) {
            return size;
        }
        if (lastParameter.isRest()) {
            return Integer.MAX_VALUE;
        }
        return TypeScriptSignatureChooser.getMaxCountWithTuple(size, lastParameter.getTypeWithOptional());
    }

    public static int getMinArgumentCount(@NotNull JSParameterItem[] parameters) {
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(35);
        }
        if (parameters.length == 0) {
            return 0;
        }
        int minArgumentCount = 0;
        for (JSParameterItem element : parameters) {
            if (element.isOptional() || element.isRest()) break;
            ++minArgumentCount;
        }
        return minArgumentCount;
    }

    public static int getMaxArgumentCount(@NotNull JSParameterItem[] parameters) {
        int length;
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(36);
        }
        if ((length = parameters.length) == 0) {
            return 0;
        }
        JSParameterItem lastParameter = (JSParameterItem)ArrayUtil.getLastElement((Object[])parameters);
        if (lastParameter == null) {
            return length;
        }
        if (lastParameter.isRest()) {
            return Integer.MAX_VALUE;
        }
        return TypeScriptSignatureChooser.getMaxCountWithTuple(length, lastParameter.getTypeWithOptional());
    }

    private static int getMaxCountWithTuple(int length, @Nullable JSType type) {
        if (type instanceof JSTupleTypeImpl) {
            int maxLength = ((JSTupleType)type).getMaxLength();
            return maxLength == Integer.MAX_VALUE ? Integer.MAX_VALUE : length + maxLength;
        }
        return length;
    }

    @Nullable
    public static JSRecordType.CallSignature findMatchedSignature(@NotNull List<? extends JSRecordType.CallSignature> signatures, @NotNull JSRecordType.CallSignature signature, boolean partialMatch, boolean ignoreReturnType) {
        if (signatures == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(37);
        }
        if (signature == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(38);
        }
        for (JSRecordType.CallSignature callSignature : signatures) {
            if (!TypeScriptSignatureChooser.compareSignaturesIdentical(callSignature, signature, partialMatch, ignoreReturnType)) continue;
            return callSignature;
        }
        return null;
    }

    @NotNull
    public static List<JSRecordType.CallSignature> findMatchingSignatures(@NotNull List<? extends List<JSRecordType.CallSignature>> table, @NotNull JSRecordType.CallSignature signature, int workingIndex) {
        if (table == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(39);
        }
        if (signature == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(40);
        }
        List result2 = ContainerUtil.newSmartList();
        for (int i = 0; i < table.size(); ++i) {
            JSRecordType.CallSignature matched;
            List<JSRecordType.CallSignature> signatures = table.get(i);
            JSRecordType.CallSignature callSignature = matched = i == workingIndex ? signature : TypeScriptSignatureChooser.findMatchedSignature(signatures, signature, true, true);
            if (matched == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(41);
                }
                return list;
            }
            result2.add(matched);
        }
        List list = result2;
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(42);
        }
        return list;
    }

    private static boolean compareSignaturesIdentical(@NotNull JSRecordType.CallSignature source, @NotNull JSRecordType.CallSignature target, boolean partialMatch, boolean ignoreReturnType) {
        if (source == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(43);
        }
        if (target == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(44);
        }
        if (source.isEquivalentTo((JSRecordType.TypeMember)target, true)) {
            return true;
        }
        if (!TypeScriptSignatureChooser.isMatchingSignature(source, target, partialMatch)) {
            return false;
        }
        List lParameters = source.getParameterTypeDecorators();
        List rParameters = target.getParameterTypeDecorators();
        int rLength = rParameters.size();
        PsiElement element = source.getMemberSource().getSingleElement();
        for (int i = 0; i < lParameters.size(); ++i) {
            JSType rParameterType;
            JSParameterTypeDecorator lDecorator = (JSParameterTypeDecorator)lParameters.get(i);
            JSParameterTypeDecorator rDecorator = rLength > i ? (JSParameterTypeDecorator)rParameters.get(i) : null;
            JSType lParameterType = lDecorator.getType();
            JSType jSType = rParameterType = rDecorator == null ? TypeScriptSignatureChooser.getRestComponentType(rParameters, element) : rDecorator.getType();
            if (TypeScriptTypeRelations.isTypeRelatedTo(lParameterType, rParameterType, null)) continue;
            return false;
        }
        if (!ignoreReturnType) {
            JSType sourceReturnType = source.getReturnType();
            JSType targetReturnType = target.getReturnType();
            return TypeScriptTypeRelations.isTypeRelatedTo(sourceReturnType, targetReturnType, null);
        }
        return true;
    }

    @Nullable
    public static JSType getRestComponentType(@NotNull List<? extends JSParameterTypeDecorator> parameters, PsiElement context) {
        int size;
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(45);
        }
        if ((size = parameters.size()) == 0) {
            return null;
        }
        JSParameterTypeDecorator last = parameters.get(size - 1);
        return last.isRest() && last.getType() != null ? JSTypeUtils.getIndexableComponentType(last.getType()) : JSAnyType.get(context, true);
    }

    public static boolean isMatchingSignature(@NotNull JSRecordType.CallSignature source, @NotNull JSRecordType.CallSignature target, boolean partial) {
        if (source == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(46);
        }
        if (target == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(47);
        }
        List sourceParameters = source.getParameterTypeDecorators();
        int minSource = TypeScriptSignatureChooser.getMinArgumentCount(sourceParameters);
        List targetParameters = target.getParameterTypeDecorators();
        int minTarget = TypeScriptSignatureChooser.getMinArgumentCount(targetParameters);
        boolean sourceHasRestParameter = TypeScriptSignatureChooser.hasRestParameter(sourceParameters);
        boolean targetHasRestParameter = TypeScriptSignatureChooser.hasRestParameter(targetParameters);
        if (sourceParameters.size() == targetParameters.size() && minSource == minTarget && sourceHasRestParameter == targetHasRestParameter) {
            return true;
        }
        if (partial && minSource <= minTarget) {
            if (sourceHasRestParameter && !targetHasRestParameter) {
                return true;
            }
            if (sourceHasRestParameter == targetHasRestParameter) {
                return sourceParameters.size() >= targetParameters.size();
            }
        }
        return false;
    }

    private static boolean hasRestParameter(@NotNull List<JSParameterTypeDecorator> parameters) {
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(48);
        }
        return parameters.size() != 0 && parameters.get(parameters.size() - 1).isRest();
    }

    @Nullable
    public static JSType mapContextualTypeForOverload(@Nullable JSType jsType, @Nullable PsiElement functionCandidate) {
        if (jsType == null) {
            return null;
        }
        return jsType.transformTypeHierarchy(el -> {
            if (el instanceof TypeScriptOverloadContextualType) {
                TypeScriptOverloadContextualType contextualType = (TypeScriptOverloadContextualType)el;
                if (functionCandidate != null) {
                    for (JSTypeWithSignature signature : contextualType.getTypes()) {
                        if (!functionCandidate.getManager().areElementsEquivalent(functionCandidate, (PsiElement)signature.getFunction())) continue;
                        return signature.evaluateGenerics(contextualType.getExpression(), contextualType.getIndex(), true);
                    }
                }
                return contextualType.asCompositeWithAppliedGenerics(true);
            }
            return el;
        });
    }

    @Nullable
    public static JSFunctionItem resolveOverloads(@NotNull JSExpression methodExpression, @NotNull List<? extends JSFunctionItem> functions, @NotNull JSExpression[] arguments) {
        if (methodExpression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(49);
        }
        if (functions == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(50);
        }
        if (arguments == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(51);
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)methodExpression.getProject());
        return (JSFunctionItem)manager.getParameterizedCachedValue((UserDataHolder)methodExpression, RESOLVE_OVERLOAD_KEY, RESOLVE_OVERLOAD_CACHE, false, (Object)Pair.create(functions, (Object)arguments));
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> getFunctionsExcludeNonFunctionsInType(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(52);
            }
            return list;
        }
        JSType jsType = JSTypeUtils.getTypeOfElement(psiElement);
        if (jsType == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(53);
            }
            return list;
        }
        if (!TypeScriptSignatureChooser.typeCanHaveExplicitCallSignatures(jsType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(jsType), false)) {
            List<JSFunctionWithSubstitutor> list = Collections.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(54);
            }
            return list;
        }
        JSRecordType recordType = jsType.asRecordType();
        List members = recordType.getTypeMembers();
        List signatures = recordType.getCallSignatures();
        if (members.size() > 0 && signatures.size() != members.size()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(55);
            }
            return list;
        }
        Collection<JSFunctionWithSubstitutor> collection = JSStubBasedPsiTreeUtil.calculatePossibleFunctions(psiElement, null, true);
        if (collection == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(56);
        }
        return collection;
    }

    @NotNull
    public static List<? extends JSFunctionItem> resolveFunctions(@Nullable PsiElement callExpressionCandidate) {
        if (!(callExpressionCandidate instanceof JSCallExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(57);
            }
            return list;
        }
        JSCallExpression callExpression = (JSCallExpression)callExpressionCandidate;
        if (callExpression.getParent() instanceof ES6Decorator) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(58);
            }
            return list;
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(59);
            }
            return list;
        }
        if (callExpression instanceof JSNewExpression) {
            List<JSFunctionWithSubstitutor> functionWithSubstitutors = TypeScriptSignatureChooser.resolveConstructorOrCallSignature((PsiElement)methodExpression);
            List list = functionWithSubstitutors.size() != 1 ? ContainerUtil.emptyList() : functionWithSubstitutors.stream().map(el -> el.myFunctionItem).collect(Collectors.toList());
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(60);
            }
            return list;
        }
        ResolveResult[] results = ((JSReferenceExpression)methodExpression).multiResolve(false);
        PsiElement resolve = JSResolveResult.resolve(results);
        if (resolve == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(61);
            }
            return list;
        }
        List list = JSStubBasedPsiTreeUtil.calculatePossibleFunctions(resolve, (PsiElement)methodExpression, true).stream().map(el -> el.myFunctionItem).collect(Collectors.toList());
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(62);
        }
        return list;
    }

    @Nullable
    public static JSFunctionItem resolveRelatedFunction(@Nullable PsiElement object, @Nullable PsiElement context) {
        JSFunctionItem resolvedFunction;
        PsiElement callCandidate;
        if (object instanceof JSFunctionItem) {
            return (JSFunctionItem)object;
        }
        if (context == null) {
            return null;
        }
        if (!(context instanceof JSExpression)) {
            context = context.getContext();
        }
        PsiElement psiElement = callCandidate = context != null && !(context instanceof JSCallExpression) ? context.getContext() : null;
        if (!(callCandidate instanceof JSCallExpression)) {
            return null;
        }
        JSCallExpression callExpression = (JSCallExpression)callCandidate;
        List<? extends JSFunctionItem> relatedFunctions = TypeScriptSignatureChooser.resolveFunctions((PsiElement)callExpression);
        if (relatedFunctions.isEmpty()) {
            return null;
        }
        if (relatedFunctions.size() == 1) {
            return relatedFunctions.get(0);
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression != null && (resolvedFunction = TypeScriptSignatureChooser.resolveOverloads(methodExpression, relatedFunctions, callExpression.getArguments())) != null) {
            return resolvedFunction;
        }
        return null;
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctionForVariable(@NotNull JSFieldVariable element, @Nullable PsiElement methodExpression, @Nullable Set<PsiElement> visited, boolean includeRawSignatures) {
        boolean isNew;
        PsiElement typeElement;
        if (element == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(63);
        }
        if ((typeElement = element.getTypeElement()) != null) {
            Collection<JSFunctionWithSubstitutor> collection = TypeScriptSignatureChooser.calculatePossibleFunctionForTypeElement(typeElement, methodExpression, visited, includeRawSignatures);
            if (collection == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(64);
            }
            return collection;
        }
        if (!includeRawSignatures) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(65);
            }
            return list;
        }
        JSType type = element.getType();
        JSType expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type);
        if (!TypeScriptSignatureChooser.typeCanHaveExplicitCallSignatures(expanded, isNew = TypeScriptSignatureChooser.isNewExpression(methodExpression))) {
            List<JSFunctionWithSubstitutor> list = Collections.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(66);
            }
            return list;
        }
        List signatures = expanded.asRecordType().getCallSignatures();
        if (signatures.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(67);
            }
            return list;
        }
        ArrayList results = ContainerUtil.newArrayList();
        for (JSRecordType.CallSignature member : signatures) {
            PsiElement singleElement;
            if (isNew != member.hasNew() || !((singleElement = member.getMemberSource().getSingleElement()) instanceof JSFunctionItem)) continue;
            results.add((JSFunctionItem)singleElement);
        }
        Collection collection = results.stream().map(el -> new JSFunctionWithSubstitutor((JSFunctionItem)el, JSTypeSubstitutor.EMPTY)).collect(Collectors.toList());
        if (collection == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(68);
        }
        return collection;
    }

    @NotNull
    private static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctionForTypeElement(@Nullable PsiElement typeElement, @Nullable PsiElement methodExpression, @Nullable Set<PsiElement> visited, boolean includeRawSignatures) {
        if (typeElement == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(69);
            }
            return list;
        }
        boolean hasNew = TypeScriptSignatureChooser.isNewExpression(methodExpression);
        if (typeElement instanceof TypeScriptSingleType) {
            Collection<JSFunctionWithSubstitutor> collection = TypeScriptSignatureChooser.getSignaturesForSingleType((TypeScriptSingleType)typeElement, hasNew, methodExpression, visited, includeRawSignatures);
            if (collection == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(70);
            }
            return collection;
        }
        if (typeElement instanceof JSFunction) {
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new JSFunctionWithSubstitutor[]{JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)typeElement)});
            if (arrayList == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(71);
            }
            return arrayList;
        }
        if (typeElement instanceof TypeScriptObjectType) {
            List<JSFunctionWithSubstitutor> list = TypeScriptSignatureChooser.getCallSignatures((TypeScriptObjectType)typeElement, hasNew);
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(72);
            }
            return list;
        }
        if (typeElement instanceof TypeScriptTypeofType) {
            String refExpression = ((TypeScriptTypeofType)typeElement).getReferenceText();
            if (StringUtil.isEmpty((String)refExpression)) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(73);
                }
                return list;
            }
            Collection<? extends PsiElement> elements = TypeScriptTypeOfJSTypeImpl.getTypeOfResultElements(typeElement, refExpression);
            if (visited == null) {
                visited = ContainerUtil.newTroveSet();
            }
            if (!visited.add(typeElement)) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(74);
                }
                return list;
            }
            THashSet finalVisited = visited;
            Collection collection = elements.stream().flatMap(arg_0 -> TypeScriptSignatureChooser.lambda$calculatePossibleFunctionForTypeElement$15(methodExpression, (Set)finalVisited, includeRawSignatures, arg_0)).collect(Collectors.toList());
            if (collection == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(75);
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(76);
        }
        return list;
    }

    protected static boolean isNewExpression(@Nullable PsiElement methodExpression) {
        PsiElement callExpressionCandidate = methodExpression instanceof JSCallExpression ? methodExpression : (methodExpression == null ? null : methodExpression.getParent());
        return callExpressionCandidate instanceof JSNewExpression;
    }

    @NotNull
    private static Collection<JSFunctionWithSubstitutor> getSignaturesForSingleType(@NotNull TypeScriptSingleType singleType, boolean isNewExpression, @Nullable PsiElement methodExpression, @Nullable Set<PsiElement> visited, boolean includeRawSignatures) {
        if (singleType == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(77);
        }
        JSTypeDeclaration[] typeArguments = singleType.getTypeArguments();
        List<JSType> genericArguments = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(typeArguments, null);
        String qualifiedTypeName = singleType.getQualifiedTypeName();
        if (qualifiedTypeName == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(78);
            }
            return list;
        }
        JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveTypeName(qualifiedTypeName, (PsiElement)singleType);
        if (!result2.hasElements()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(79);
            }
            return list;
        }
        ArrayList allSignatures = ContainerUtil.newArrayList();
        for (PsiElement psiElement : result2.getElements()) {
            Collection<Object> signatures = ContainerUtil.emptyList();
            if (psiElement instanceof TypeScriptTypeAlias) {
                TypeScriptType aliasedType = ((TypeScriptTypeAlias)psiElement).getTypeDeclaration();
                if (aliasedType != null) {
                    if (visited == null) {
                        visited = ContainerUtil.newTroveSet();
                    }
                    if (!visited.add(singleType)) {
                        List list = ContainerUtil.emptyList();
                        if (list == null) {
                            TypeScriptSignatureChooser.$$$reportNull$$$0(80);
                        }
                        return list;
                    }
                    signatures = TypeScriptSignatureChooser.calculatePossibleFunctionForTypeElement((PsiElement)aliasedType, methodExpression, (Set<PsiElement>)visited, includeRawSignatures);
                } else {
                    signatures = ContainerUtil.emptyList();
                }
            } else if (psiElement instanceof TypeScriptInterface) {
                signatures = TypeScriptSignatureChooser.getCallSignatures((TypeScriptInterface)psiElement, isNewExpression);
            }
            if (!genericArguments.isEmpty() && psiElement instanceof TypeScriptTypeParameterListOwner) {
                JSTypeSubstitutor argumentsSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)psiElement, genericArguments);
                for (JSFunctionWithSubstitutor jSFunctionWithSubstitutor : signatures) {
                    JSTypeSubstitutor substitutor = JSTypeSubstitutor.combineWithApplying((JSTypeSubstitutor)argumentsSubstitutor, (JSTypeSubstitutor)jSFunctionWithSubstitutor.myTypeSubstitutor, JSTypeUtils::applyGenericArguments);
                    allSignatures.add(new JSFunctionWithSubstitutor(jSFunctionWithSubstitutor.myFunctionItem, substitutor));
                }
                continue;
            }
            allSignatures.addAll(signatures);
        }
        ArrayList arrayList = allSignatures;
        if (arrayList == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(81);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> getCallSignatures(@NotNull TypeScriptInterface interfaceToProcess, final boolean isNew) {
        if (interfaceToProcess == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(82);
        }
        final ArrayList result2 = ContainerUtil.newArrayList();
        JSClassUtils.processClassesInHierarchy(interfaceToProcess, true, new TypeScriptUtil.JSClassHierarchyProcessor(){

            @Override
            public boolean process(@NotNull JSClass<?> aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (typeSubstitutor == null) {
                    1.$$$reportNull$$$0(1);
                }
                List interfaceSignatures = TypeScriptSignatureChooser.getCallSignatures(aClass.getMembers(), isNew);
                result2.addAll(ContainerUtil.map((Collection)interfaceSignatures, fun -> {
                    if (typeSubstitutor == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return new JSFunctionWithSubstitutor((JSFunctionItem)fun, typeSubstitutor);
                }));
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeSubstitutor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$process$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList arrayList = result2;
        if (arrayList == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(83);
        }
        return arrayList;
    }

    @NotNull
    private static List<JSFunctionWithSubstitutor> getCallSignatures(@NotNull TypeScriptObjectType type, boolean isNew) {
        if (type == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(84);
        }
        List<JSFunctionWithSubstitutor> list = TypeScriptSignatureChooser.getCallSignatures(Arrays.asList(type.getTypeMembers()), isNew).stream().map(JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR).collect(Collectors.toList());
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(85);
        }
        return list;
    }

    @NotNull
    private static List<JSFunctionItem> getCallSignatures(@NotNull Iterable<? extends JSElement> members, boolean isNew) {
        if (members == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(86);
        }
        List result2 = ContainerUtil.newSmartList();
        for (JSElement jSElement : members) {
            TypeScriptCallSignature callSignature;
            if (!(jSElement instanceof TypeScriptCallSignature) || (callSignature = (TypeScriptCallSignature)jSElement).isConstructor() != isNew) continue;
            result2.add(callSignature);
        }
        List list = result2;
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(87);
        }
        return list;
    }

    @Contract(value="null,_ -> false")
    public static boolean typeCanHaveExplicitCallSignatures(@Nullable JSType type, boolean isNew) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSFunctionType || type instanceof JSPrimitiveFunctionType) {
            return true;
        }
        if (type instanceof JSTypeImpl) {
            JSResolvedTypeInfo resolvedInfo = ((JSTypeImpl)type).resolveType();
            return resolvedInfo.isInterface() && resolvedInfo.getDeclarations().stream().anyMatch(el -> el instanceof TypeScriptInterface && ((TypeScriptInterface)el).hasCallSignature());
        }
        if (type instanceof JSSimpleRecordTypeImpl) {
            return type.getSource().getSourceElement() instanceof TypeScriptObjectType;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            return ((JSUnionOrIntersectionType)type).getTypes().stream().anyMatch(el -> TypeScriptSignatureChooser.typeCanHaveExplicitCallSignatures(el, isNew));
        }
        return isNew || !(type instanceof JSUtilType);
    }

    private static /* synthetic */ Stream lambda$calculatePossibleFunctionForTypeElement$15(@Nullable PsiElement methodExpression, Set finalVisited, boolean includeRawSignatures, PsiElement el) {
        return JSStubBasedPsiTreeUtil.calculatePossibleFunctions(el, methodExpression, finalVisited, includeRawSignatures).stream();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 41: 
            case 42: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 87: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 41: 
            case 42: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 87: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 1: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 41: 
            case 42: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser";
                break;
            }
            case 5: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCandidate";
                break;
            }
            case 9: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFunctionOrElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionParameters";
                break;
            }
            case 16: 
            case 18: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: 
            case 19: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatures";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleType";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceToProcess";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "checkParameterTypes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverloadSignatureForImplementation";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDecoratorsWithAppliedGenerics";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructorOrCallSignature";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorsForResolveElements";
                break;
            }
            case 31: 
            case 32: 
            case 83: 
            case 85: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallSignatures";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatchingSignatures";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionsExcludeNonFunctionsInType";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFunctions";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePossibleFunctionForVariable";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePossibleFunctionForTypeElement";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesForSingleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkParameterTypes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 41: 
            case 42: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 87: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOverloadSignatureForImplementation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDecoratorsWithAppliedGenerics";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionWithParameters";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorOrCallSignature";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorsForResolveElements";
                break;
            }
            case 29: 
            case 30: 
            case 82: 
            case 84: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getCallSignatures";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getMinArgumentCount";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getMaxArgumentCount";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findMatchedSignature";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingSignatures";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "compareSignaturesIdentical";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getRestComponentType";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingSignature";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "hasRestParameter";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "resolveOverloads";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleFunctionForVariable";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getSignaturesForSingleType";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFunctionWithParameters$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 41: 
            case 42: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 87: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

