define("gradereport_grader/feedback_modal",["exports","core/modal","core/notification","core/ajax","core/templates"],(function(_exports,_modal,_notification,_ajax,_templates){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Javascript module for displaying feedback in a modal window
   *
   * @module      gradereport_grader/feedback_modal
   * @copyright   2023 Kevin Percy <kevin.percy@moodle.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_modal=_interopRequireDefault(_modal),_notification=_interopRequireDefault(_notification),_ajax=_interopRequireDefault(_ajax),_templates=_interopRequireDefault(_templates);const Selectors_showFeedback='[data-action="feedback"]',fetchFeedback=(courseid,userid,itemid)=>{const request={methodname:"core_grades_get_feedback",args:{courseid:courseid,userid:userid,itemid:itemid}};return _ajax.default.call([request])[0]},registerEventListeners=()=>{document.addEventListener("click",(e=>{const showFeedbackTrigger=e.target.closest(Selectors_showFeedback);if(showFeedbackTrigger){e.preventDefault();(async(courseid,userid,itemid)=>{let feedbackData;try{feedbackData=await fetchFeedback(courseid,userid,itemid)}catch(e){return Promise.reject(e)}return _modal.default.create({removeOnClose:!0,large:!0,verticallyCentered:!0}).then((modal=>{const body=_templates.default.render("core_grades/feedback_modal",{feedbacktext:feedbackData.feedbacktext,user:{picture:feedbackData.picture,fullname:feedbackData.fullname,additionalfield:feedbackData.additionalfield}});return modal.setBody(body),modal.setTitle(feedbackData.title),modal.show(),modal}))})(showFeedbackTrigger.dataset.courseid,e.target.closest("tr").dataset.uid,e.target.closest("td").dataset.itemid).catch(_notification.default.exception)}}))};_exports.init=()=>{registerEventListeners()}}));

//# sourceMappingURL=feedback_modal.min.js.map