/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.PrintWriter;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KeyValueMapper;

public class PrintForeachAction<K, V>
implements ForeachAction<K, V> {
    private final String label;
    private final PrintWriter printWriter;
    private final KeyValueMapper<? super K, ? super V, String> mapper;

    public PrintForeachAction(PrintWriter printWriter, KeyValueMapper<? super K, ? super V, String> mapper, String label) {
        this.printWriter = printWriter;
        this.mapper = mapper;
        this.label = label;
    }

    @Override
    public void apply(K key, V value) {
        String data = String.format("[%s]: %s", this.label, this.mapper.apply(key, value));
        if (this.printWriter == null) {
            System.out.println(data);
        } else {
            this.printWriter.println(data);
        }
    }

    public void close() {
        if (this.printWriter == null) {
            System.out.flush();
        } else {
            this.printWriter.close();
        }
    }
}

