/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.json;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u0001%\u0011QBS:p]Z\u000bG.^3UKN$(BA\u0002\u0005\u0003\u0011Q7o\u001c8\u000b\u0005\u00151\u0011!B;uS2\u001c(\"A\u0004\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0003\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bE\u0001A\u0011\u0001\n\u0002\rqJg.\u001b;?)\u0005\u0019\u0002C\u0001\u000b\u0001\u001b\u0005\u0011\u0001bB\u0002\u0001\u0005\u0004%\tAF\u000b\u0002/A\u0011\u0001d\b\b\u00033u\u0001\"A\u0007\u0007\u000e\u0003mQ!\u0001\b\u0005\u0002\rq\u0012xn\u001c;?\u0013\tqB\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0005\u0012aa\u0015;sS:<'B\u0001\u0010\r\u0011\u0019\u0019\u0003\u0001)A\u0005/\u0005)!n]8oA!)Q\u0005\u0001C\u0005M\u0005)\u0001/\u0019:tKR\u0011qE\u000b\t\u0003)!J!!\u000b\u0002\u0003\u0013)\u001bxN\u001c,bYV,\u0007\"B\u0016%\u0001\u00049\u0012!A:\t\u000b5\u0002A\u0011\u0002\u0018\u0002\u0011\u0005\u001c8/\u001a:u)>,\"aL\u001e\u0015\u0007A\"e\t\u0006\u00022iA\u00111BM\u0005\u0003g1\u0011A!\u00168ji\"9Q\u0007LA\u0001\u0002\b1\u0014AC3wS\u0012,gnY3%cA\u0019AcN\u001d\n\u0005a\u0012!A\u0003#fG>$WMS:p]B\u0011!h\u000f\u0007\u0001\t\u0015aDF1\u0001>\u0005\u0005!\u0016C\u0001 B!\tYq(\u0003\u0002A\u0019\t9aj\u001c;iS:<\u0007CA\u0006C\u0013\t\u0019EBA\u0002B]fDQ!\u0012\u0017A\u0002e\n\u0001\"\u001a=qK\u000e$X\r\u001a\u0005\u0006\u000f2\u0002\r\u0001S\u0001\nUN|gNV1mk\u0016\u0004BaC%LO%\u0011!\n\u0004\u0002\n\rVt7\r^5p]F\u0002\"\u0001\u0006'\n\u00055\u0013!A\u0003&t_:|%M[3di\")q\n\u0001C\u0005!\u0006i\u0011m]:feR$vNR1jYN,\"!U,\u0015\u0005ICFCA\u0019T\u0011\u001d!f*!AA\u0004U\u000b!\"\u001a<jI\u0016t7-\u001a\u00133!\r!rG\u0016\t\u0003u]#Q\u0001\u0010(C\u0002uBQa\u0012(A\u0002!CQA\u0017\u0001\u0005\u0002m\u000b1\"Y:tKJ$H\u000b\u001b:poV\u0011A\f\u001a\u000b\u0003;B$\"!\r0\t\u000f}K\u0016\u0011!a\u0002A\u0006QQM^5eK:\u001cW\rJ\u001a\u0011\u0007a\t7-\u0003\u0002cC\tAQ*\u00198jM\u0016\u001cH\u000f\u0005\u0002;I\u0012)Q-\u0017b\u0001M\n\tQ)\u0005\u0002?OB\u0011\u0001.\u001c\b\u0003S.t!A\u00076\n\u00035I!\u0001\u001c\u0007\u0002\u000fA\f7m[1hK&\u0011an\u001c\u0002\n)\"\u0014xn^1cY\u0016T!\u0001\u001c\u0007\t\rELF\u00111\u0001s\u0003\u0011\u0011w\u000eZ=\u0011\u0007-\u0019\u0018'\u0003\u0002u\u0019\tAAHY=oC6,g\bC\u0003w\u0001\u0011\u0005q/\u0001\tuKN$\u0018i\u001d&t_:|%M[3diV\t\u0011\u0007\u000b\u0002vsB\u0011!p`\u0007\u0002w*\u0011A0`\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002}\u0006\u0019qN]4\n\u0007\u0005\u00051P\u0001\u0003UKN$\bBBA\u0003\u0001\u0011\u0005q/\u0001\fuKN$\u0018i\u001d&t_:|%M[3di>\u0003H/[8oQ\r\t\u0019!\u001f\u0005\u0007\u0003\u0017\u0001A\u0011A<\u0002\u001fQ,7\u000f^!t\u0015N|g.\u0011:sCfD3!!\u0003z\u0011\u0019\t\t\u0002\u0001C\u0001o\u0006)B/Z:u\u0003NT5o\u001c8BeJ\f\u0017p\u00149uS>t\u0007fAA\bs\"1\u0011q\u0003\u0001\u0005\u0002]\f\u0011\u0003^3ti*\u001bxN\\(cU\u0016\u001cGoR3uQ\r\t)\"\u001f\u0005\u0007\u0003;\u0001A\u0011A<\u0002'Q,7\u000f\u001e&t_:|%M[3di\u0006\u0003\b\u000f\\=)\u0007\u0005m\u0011\u0010\u0003\u0004\u0002$\u0001!\ta^\u0001\u0017i\u0016\u001cHOS:p]>\u0013'.Z2u\u0013R,'/\u0019;pe\"\u001a\u0011\u0011E=\t\r\u0005%\u0002\u0001\"\u0001x\u0003U!Xm\u001d;Kg>t\u0017I\u001d:bs&#XM]1u_JD3!a\nz\u0011\u0019\ty\u0003\u0001C\u0001o\u0006\u0019B/Z:u\u0015N|gNV1mk\u0016,\u0015/^1mg\"\u001a\u0011QF=\t\r\u0005U\u0002\u0001\"\u0001x\u0003U!Xm\u001d;Kg>tg+\u00197vK\"\u000b7\u000f[\"pI\u0016D3!a\rz\u0011\u0019\tY\u0004\u0001C\u0001o\u0006)B/Z:u\u0015N|gNV1mk\u0016$vn\u0015;sS:<\u0007fAA\u001ds\"1\u0011\u0011\t\u0001\u0005\u0002]\f\u0011\u0003^3ti\u0012+7m\u001c3f\u0005>|G.Z1oQ\r\ty$\u001f\u0005\u0007\u0003\u000f\u0002A\u0011A<\u0002!Q,7\u000f\u001e#fG>$Wm\u0015;sS:<\u0007fAA#s\"1\u0011Q\n\u0001\u0005\u0002]\fQ\u0002^3ti\u0012+7m\u001c3f\u0013:$\bfAA&s\"1\u00111\u000b\u0001\u0005\u0002]\fa\u0002^3ti\u0012+7m\u001c3f\u0019>tw\rK\u0002\u0002ReDa!!\u0017\u0001\t\u00039\u0018\u0001\u0005;fgR$UmY8eK\u0012{WO\u00197fQ\r\t9&\u001f\u0005\u0007\u0003?\u0002A\u0011A<\u0002\u001bQ,7\u000f\u001e#fG>$WmU3rQ\r\ti&\u001f\u0005\u0007\u0003K\u0002A\u0011A<\u0002\u001bQ,7\u000f\u001e#fG>$W-T1qQ\r\t\u0019'\u001f\u0005\u0007\u0003W\u0002A\u0011A<\u0002!Q,7\u000f\u001e#fG>$Wm\u00149uS>t\u0007fAA5s\u0002")
public class JsonValueTest {
    private final String json = new StringOps(Predef$.MODULE$.augmentString("\n    |{\n    |  \"boolean\": false,\n    |  \"int\": 1234,\n    |  \"long\": 3000000000,\n    |  \"double\": 16.244355,\n    |  \"string\": \"string\",\n    |  \"number_as_string\": \"123\",\n    |  \"array\": [4.0, 11.1, 44.5],\n    |  \"object\": {\n    |    \"a\": true,\n    |    \"b\": false\n    |  },\n    |  \"null\": null\n    |}\n   ")).stripMargin();

    public String json() {
        return this.json;
    }

    private JsonValue parse(String s) {
        return (JsonValue)Json$.MODULE$.parseFull(s).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error("Failed to parse json: " + s));
    }

    private <T> void assertTo(T expected, Function1<JsonObject, JsonValue> jsonValue, DecodeJson<T> evidence$1) {
        JsonValue parsed = (JsonValue)jsonValue.apply((Object)this.parse(this.json()).asJsonObject());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply(expected), (Object)parsed.toEither(evidence$1));
        Assert.assertEquals(expected, (Object)parsed.to(evidence$1));
    }

    private <T> void assertToFails(Function1<JsonObject, JsonValue> jsonValue, DecodeJson<T> evidence$2) {
        JsonValue parsed = (JsonValue)jsonValue.apply((Object)this.parse(this.json()).asJsonObject());
        Assert.assertTrue((boolean)parsed.toEither(evidence$2).isLeft());
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> parsed.to(evidence$2), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    public <E extends Throwable> void assertThrow(Function0<BoxedUnit> body, Manifest<E> evidence$3) {
        Class klass = Predef$.MODULE$.manifest(evidence$3).runtimeClass();
        Exception$.MODULE$.catchingPromiscuously((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{klass})).opt(body).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            JsonValueTest.$anonfun$assertThrow$1(klass, x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAsJsonObject() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        JsonValue obj = parsed.apply("object");
        Assert.assertEquals((Object)obj, (Object)obj.asJsonObject());
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> parsed.apply("array").asJsonObject(), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    @Test
    public void testAsJsonObjectOption() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assert.assertTrue((boolean)parsed.apply("object").asJsonObjectOption().isDefined());
        Assert.assertEquals((Object)None$.MODULE$, (Object)parsed.apply("array").asJsonObjectOption());
    }

    @Test
    public void testAsJsonArray() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        JsonValue array = parsed.apply("array");
        Assert.assertEquals((Object)array, (Object)array.asJsonArray());
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> parsed.apply("object").asJsonArray(), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    @Test
    public void testAsJsonArrayOption() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assert.assertTrue((boolean)parsed.apply("array").asJsonArrayOption().isDefined());
        Assert.assertEquals((Object)None$.MODULE$, (Object)parsed.apply("object").asJsonArrayOption());
    }

    @Test
    public void testJsonObjectGet() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assert.assertEquals((Object)new Some((Object)this.parse("{\"a\":true,\"b\":false}")), (Object)parsed.get("object"));
        Assert.assertEquals((Object)None$.MODULE$, (Object)parsed.get("aaaaa"));
    }

    @Test
    public void testJsonObjectApply() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assert.assertEquals((Object)this.parse("{\"a\":true,\"b\":false}"), (Object)parsed.apply("object"));
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> parsed.apply("aaaaaaaa"), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    @Test
    public void testJsonObjectIterator() {
        Assert.assertEquals((Object)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.parse("true")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.parse("false"))})), (Object)this.parse(this.json()).asJsonObject().apply("object").asJsonObject().iterator().toVector());
    }

    @Test
    public void testJsonArrayIterator() {
        Assert.assertEquals((Object)((TraversableLike)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"4.0", "11.1", "44.5"}))).map((Function1 & Serializable & scala.Serializable)s -> this.parse((String)s), Vector$.MODULE$.canBuildFrom()), (Object)this.parse(this.json()).asJsonObject().apply("array").asJsonArray().iterator().toVector());
    }

    @Test
    public void testJsonValueEquals() {
        Assert.assertEquals((Object)this.parse(this.json()), (Object)this.parse(this.json()));
        Assert.assertEquals((Object)this.parse("{\"blue\": true, \"red\": false}"), (Object)this.parse("{\"red\": false, \"blue\": true}"));
        Assert.assertNotEquals((Object)this.parse("{\"blue\": true, \"red\": true}"), (Object)this.parse("{\"red\": false, \"blue\": true}"));
        Assert.assertEquals((Object)this.parse("[1, 2, 3]"), (Object)this.parse("[1, 2, 3]"));
        Assert.assertNotEquals((Object)this.parse("[1, 2, 3]"), (Object)this.parse("[2, 1, 3]"));
        Assert.assertEquals((Object)this.parse("1344"), (Object)this.parse("1344"));
        Assert.assertNotEquals((Object)this.parse("1344"), (Object)this.parse("144"));
    }

    @Test
    public void testJsonValueHashCode() {
        Assert.assertEquals((long)new ObjectMapper().readTree(this.json()).hashCode(), (long)this.parse(this.json()).hashCode());
    }

    @Test
    public void testJsonValueToString() {
        String js = "{\"boolean\":false,\"int\":1234,\"array\":[4.0,11.1,44.5],\"object\":{\"a\":true,\"b\":false}}";
        Assert.assertEquals((Object)js, (Object)this.parse(js).toString());
    }

    @Test
    public void testDecodeBoolean() {
        this.assertTo((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$2 -> x$2.apply("boolean"), (DecodeJson)DecodeJson.DecodeBoolean$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$3 -> x$3.apply("int"), (DecodeJson)DecodeJson.DecodeBoolean$.MODULE$);
    }

    @Test
    public void testDecodeString() {
        this.assertTo((Object)"string", (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$4 -> x$4.apply("string"), (DecodeJson)DecodeJson.DecodeString$.MODULE$);
        this.assertTo((Object)"123", (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$5 -> x$5.apply("number_as_string"), (DecodeJson)DecodeJson.DecodeString$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$6 -> x$6.apply("int"), (DecodeJson)DecodeJson.DecodeString$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$7 -> x$7.apply("array"), (DecodeJson)DecodeJson.DecodeString$.MODULE$);
    }

    @Test
    public void testDecodeInt() {
        this.assertTo((Object)BoxesRunTime.boxToInteger((int)1234), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$8 -> x$8.apply("int"), (DecodeJson)DecodeJson.DecodeInt$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$9 -> x$9.apply("long"), (DecodeJson)DecodeJson.DecodeInt$.MODULE$);
    }

    @Test
    public void testDecodeLong() {
        this.assertTo((Object)BoxesRunTime.boxToLong((long)3000000000L), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$10 -> x$10.apply("long"), (DecodeJson)DecodeJson.DecodeLong$.MODULE$);
        this.assertTo((Object)BoxesRunTime.boxToLong((long)1234L), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$11 -> x$11.apply("int"), (DecodeJson)DecodeJson.DecodeLong$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$12 -> x$12.apply("string"), (DecodeJson)DecodeJson.DecodeLong$.MODULE$);
    }

    @Test
    public void testDecodeDouble() {
        this.assertTo((Object)BoxesRunTime.boxToDouble((double)16.244355), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$13 -> x$13.apply("double"), (DecodeJson)DecodeJson.DecodeDouble$.MODULE$);
        this.assertTo((Object)BoxesRunTime.boxToDouble((double)1234.0), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$14 -> x$14.apply("int"), (DecodeJson)DecodeJson.DecodeDouble$.MODULE$);
        this.assertTo((Object)BoxesRunTime.boxToDouble((double)3.0E9), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$15 -> x$15.apply("long"), (DecodeJson)DecodeJson.DecodeDouble$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$16 -> x$16.apply("string"), (DecodeJson)DecodeJson.DecodeDouble$.MODULE$);
    }

    @Test
    public void testDecodeSeq() {
        this.assertTo(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 11.1, 44.5})), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$17 -> x$17.apply("array"), DecodeJson$.MODULE$.decodeSeq((DecodeJson)DecodeJson.DecodeDouble$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$18 -> x$18.apply("string"), DecodeJson$.MODULE$.decodeSeq((DecodeJson)DecodeJson.DecodeDouble$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$19 -> x$19.apply("object"), DecodeJson$.MODULE$.decodeSeq((DecodeJson)DecodeJson.DecodeDouble$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$20 -> x$20.apply("array"), DecodeJson$.MODULE$.decodeSeq((DecodeJson)DecodeJson.DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
    }

    @Test
    public void testDecodeMap() {
        this.assertTo(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToBoolean((boolean)false))})), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$21 -> x$21.apply("object"), DecodeJson$.MODULE$.decodeMap((DecodeJson)DecodeJson.DecodeBoolean$.MODULE$, Map$.MODULE$.canBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$22 -> x$22.apply("object"), DecodeJson$.MODULE$.decodeMap((DecodeJson)DecodeJson.DecodeInt$.MODULE$, Map$.MODULE$.canBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$23 -> x$23.apply("object"), DecodeJson$.MODULE$.decodeMap((DecodeJson)DecodeJson.DecodeString$.MODULE$, Map$.MODULE$.canBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$24 -> x$24.apply("array"), DecodeJson$.MODULE$.decodeMap((DecodeJson)DecodeJson.DecodeDouble$.MODULE$, Map$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDecodeOption() {
        this.assertTo(None$.MODULE$, (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$25 -> x$25.apply("null"), DecodeJson$.MODULE$.decodeOption((DecodeJson)DecodeJson.DecodeInt$.MODULE$));
        this.assertTo(new Some((Object)BoxesRunTime.boxToInteger((int)1234)), (Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$26 -> x$26.apply("int"), DecodeJson$.MODULE$.decodeOption((DecodeJson)DecodeJson.DecodeInt$.MODULE$));
        this.assertToFails((Function1<JsonObject, JsonValue>)(Function1 & Serializable & scala.Serializable)x$27 -> x$27.apply("int"), DecodeJson$.MODULE$.decodeOption((DecodeJson)DecodeJson.DecodeString$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$assertThrow$1(Class klass$1, BoxedUnit x$1) {
        Assert.fail((String)("Expected `" + klass$1 + "` to be thrown, but no exception was thrown"));
    }
}

