/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.jibri;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.jibri.JibriDetector;
import org.jitsi.jicofo.jibri.JibriStats;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;

public class JibriSession {
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    private Jid currentJibriJid;
    private final String displayName;
    private final boolean isSIP;
    private final JibriDetector jibriDetector;
    private final JibriDetectorEventHandler jibriEventHandler = new JibriDetectorEventHandler();
    private JibriIq.Status jibriStatus = JibriIq.Status.UNDEFINED;
    private final Logger logger;
    private final StateListener stateListener;
    @NotNull
    private final AtomicReference<ScheduledFuture<?>> pendingTimeoutTask = new AtomicReference();
    private final long pendingTimeout;
    private final EntityBareJid roomName;
    private final String sipAddress;
    private final String streamID;
    private final String sessionId;
    private final String youTubeBroadcastId;
    private final String applicationData;
    private final int maxNumRetries;
    private int numRetries = 0;
    private final Jid initiator;
    private Jid terminator;

    private static boolean isStartingStatus(JibriIq.Status status) {
        return JibriIq.Status.PENDING.equals((Object)status);
    }

    JibriSession(StateListener stateListener, EntityBareJid roomName, Jid initiator, long pendingTimeout2, int maxNumRetries, JibriDetector jibriDetector, boolean isSIP, String sipAddress, String displayName, String streamID, String youTubeBroadcastId, String sessionId, String applicationData, Logger parentLogger) {
        this.stateListener = stateListener;
        this.roomName = roomName;
        this.initiator = initiator;
        this.pendingTimeout = pendingTimeout2;
        this.maxNumRetries = maxNumRetries;
        this.isSIP = isSIP;
        this.jibriDetector = jibriDetector;
        this.sipAddress = sipAddress;
        this.displayName = displayName;
        this.streamID = streamID;
        this.youTubeBroadcastId = youTubeBroadcastId;
        this.sessionId = sessionId;
        this.applicationData = applicationData;
        jibriDetector.addHandler(this.jibriEventHandler);
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
    }

    private void dispatchSessionStateChanged(JibriIq.Status newStatus, JibriIq.FailureReason failureReason) {
        if (failureReason != null) {
            JibriStats.sessionFailed(this.getJibriType());
        }
        this.stateListener.onSessionStateChanged(this, newStatus, failureReason);
    }

    public Type getJibriType() {
        if (this.isSIP) {
            return Type.SIP_CALL;
        }
        if (StringUtils.isBlank((CharSequence)this.streamID)) {
            return Type.RECORDING;
        }
        return Type.LIVE_STREAMING;
    }

    public boolean isActive() {
        return JibriIq.Status.ON.equals((Object)this.jibriStatus);
    }

    public boolean isPending() {
        return JibriIq.Status.UNDEFINED.equals((Object)this.jibriStatus) || JibriIq.Status.PENDING.equals((Object)this.jibriStatus);
    }

    public synchronized void start() throws StartException {
        try {
            this.startInternal();
        }
        catch (Exception e) {
            JibriStats.sessionFailed(this.getJibriType());
            throw e;
        }
    }

    private void startInternal() throws StartException {
        Jid jibriJid = this.jibriDetector.selectJibri();
        if (jibriJid == null) {
            this.logger.error((Object)"Unable to find an available Jibri, can't start");
            if (this.jibriDetector.isAnyInstanceConnected()) {
                throw new StartException.AllBusy();
            }
            throw new StartException.NotAvailable();
        }
        try {
            this.logger.info((Object)("Starting session with Jibri " + String.valueOf(jibriJid)));
            this.sendJibriStartIq(jibriJid);
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to send start Jibri IQ: " + String.valueOf(e)), (Throwable)e);
            this.jibriDetector.instanceFailed(jibriJid);
            if (!this.maxRetriesExceeded()) {
                this.retryRequestWithAnotherJibri();
            }
            throw new StartException.InternalServerError();
        }
    }

    public synchronized void stop(Jid initiator) {
        if (this.currentJibriJid == null) {
            return;
        }
        this.terminator = initiator;
        JibriIq stopRequest = new JibriIq();
        stopRequest.setType(IQ.Type.set);
        stopRequest.setTo(this.currentJibriJid);
        stopRequest.setAction(JibriIq.Action.STOP);
        stopRequest.setSessionId(this.sessionId);
        this.logger.info((Object)("Trying to stop: " + String.valueOf(stopRequest.toXML())));
        SmackFuture future = this.jibriDetector.getXmppConnection().sendIqRequestAsync((IQ)stopRequest, 60000L);
        future.onSuccess(stanza -> {
            if (stanza instanceof JibriIq) {
                this.processJibriIqFromJibri((JibriIq)stanza);
            } else {
                this.logger.error((Object)("Unexpected response to stop iq: " + String.valueOf(stanza != null ? stanza.toXML() : "null")));
                this.stopError(stopRequest.getTo());
            }
        }).onError(exception -> {
            this.logger.error((Object)("Error from stop request: " + exception.toString()));
            this.stopError(stopRequest.getTo());
        });
    }

    private void stopError(Jid jibriJid) {
        JibriIq error = new JibriIq();
        error.setFrom(jibriJid);
        error.setFailureReason(JibriIq.FailureReason.ERROR);
        error.setStatus(JibriIq.Status.OFF);
        this.processJibriIqFromJibri(error);
    }

    private void cleanupSession() {
        this.logger.info((Object)"Cleaning up current JibriSession");
        this.currentJibriJid = null;
        this.numRetries = 0;
        this.jibriDetector.removeHandler(this.jibriEventHandler);
    }

    public boolean accept(JibriIq packet) {
        return this.currentJibriJid != null && packet.getFrom().equals((CharSequence)this.currentJibriJid);
    }

    private String nickname() {
        return this.isSIP ? "SIP Jibri" : "Jibri";
    }

    IQ processJibriIqRequestFromJibri(JibriIq request) {
        this.processJibriIqFromJibri(request);
        return IQ.createResultIQ((IQ)request);
    }

    private void processJibriIqFromJibri(JibriIq iq) {
        JibriIq.Status status = iq.getStatus();
        if (!JibriIq.Status.UNDEFINED.equals((Object)status)) {
            this.logger.info((Object)("Updating status from JIBRI: " + String.valueOf(iq.toXML()) + " for " + String.valueOf(this.roomName)));
            this.handleJibriStatusUpdate(iq.getFrom(), status, iq.getFailureReason(), iq.getShouldRetry());
        } else {
            this.logger.error((Object)("Received UNDEFINED status from jibri: " + String.valueOf(iq)));
        }
    }

    JibriIq.RecordingMode getRecordingMode() {
        if (this.sipAddress != null) {
            return JibriIq.RecordingMode.UNDEFINED;
        }
        if (this.streamID != null) {
            return JibriIq.RecordingMode.STREAM;
        }
        return JibriIq.RecordingMode.FILE;
    }

    private void sendJibriStartIq(Jid jibriJid) throws SmackException.NotConnectedException, StartException {
        this.currentJibriJid = jibriJid;
        this.logger.info((Object)("Starting Jibri " + String.valueOf(jibriJid) + (this.isSIP ? "for SIP address: " + this.sipAddress : " for stream ID: " + this.streamID) + " in room: " + String.valueOf(this.roomName)));
        JibriIq startIq = new JibriIq();
        startIq.setTo(jibriJid);
        startIq.setType(IQ.Type.set);
        startIq.setAction(JibriIq.Action.START);
        startIq.setSessionId(this.sessionId);
        this.logger.debug((Object)("Passing on jibri application data: " + this.applicationData));
        startIq.setAppData(this.applicationData);
        if (this.streamID != null) {
            startIq.setStreamId(this.streamID);
            startIq.setRecordingMode(JibriIq.RecordingMode.STREAM);
            if (this.youTubeBroadcastId != null) {
                startIq.setYouTubeBroadcastId(this.youTubeBroadcastId);
            }
        } else {
            startIq.setRecordingMode(JibriIq.RecordingMode.FILE);
        }
        startIq.setSipAddress(this.sipAddress);
        startIq.setDisplayName(this.displayName);
        startIq.setRoom(this.roomName);
        this.reschedulePendingTimeout();
        IQ reply = UtilKt.sendIqAndGetResponse((AbstractXMPPConnection)this.jibriDetector.getXmppConnection(), (IQ)startIq);
        if (reply == null) {
            this.logger.error((Object)"Jibri start request timed out, sending a stop command.");
            JibriIq stopRequest = new JibriIq();
            stopRequest.setType(IQ.Type.set);
            stopRequest.setTo(jibriJid);
            stopRequest.setAction(JibriIq.Action.STOP);
            stopRequest.setSessionId(this.sessionId);
            try {
                this.jibriDetector.getXmppConnection().trySendStanza((Stanza)stopRequest);
            }
            catch (SmackException.NotConnectedException e) {
                this.logger.error((Object)"Can't send stop IQ, not connected");
            }
            throw new StartException.UnexpectedResponse();
        }
        if (!(reply instanceof JibriIq)) {
            this.logger.error((Object)("Unexpected response to start request: " + String.valueOf(reply.toXML())));
            throw new StartException.UnexpectedResponse();
        }
        JibriIq jibriIq = (JibriIq)reply;
        if (this.isBusyResponse(jibriIq)) {
            this.logger.info((Object)("Jibri " + String.valueOf(jibriIq.getFrom()) + " was busy"));
            throw new StartException.OneBusy();
        }
        if (!this.isPendingResponse(jibriIq)) {
            this.logger.error((Object)("Unexpected status received in response to the start IQ: " + String.valueOf(jibriIq.toXML())));
            throw new StartException.UnexpectedResponse();
        }
        this.processJibriIqFromJibri(jibriIq);
    }

    private void reschedulePendingTimeout() {
        ScheduledFuture<?> newTask;
        ScheduledFuture<?> oldTask;
        if (this.pendingTimeout > 0L && (oldTask = this.pendingTimeoutTask.getAndSet(newTask = TaskPools.getScheduledPool().schedule(new PendingStatusTimeout(), this.pendingTimeout, TimeUnit.SECONDS))) != null) {
            this.logger.info((Object)("Rescheduling pending timeout task for room: " + String.valueOf(this.roomName)));
            oldTask.cancel(false);
        }
    }

    private void clearPendingTimeout(boolean cancel) {
        ScheduledFuture oldTask = this.pendingTimeoutTask.getAndSet(null);
        if (cancel && oldTask != null) {
            this.logger.info((Object)"Jibri is no longer pending, cancelling pending timeout task");
            oldTask.cancel(false);
        }
    }

    private boolean maxRetriesExceeded() {
        return this.maxNumRetries >= 0 && this.numRetries >= this.maxNumRetries;
    }

    private void retryRequestWithAnotherJibri() throws StartException {
        ++this.numRetries;
        this.start();
    }

    private void handleJibriStatusUpdate(@NotNull Jid jibriJid, JibriIq.Status newStatus, @Nullable JibriIq.FailureReason failureReason, @Nullable Boolean shouldRetryParam) {
        this.jibriStatus = newStatus;
        this.logger.info((Object)("Got Jibri status update: Jibri " + String.valueOf(jibriJid) + " has status " + String.valueOf(newStatus) + " and failure reason " + String.valueOf(failureReason) + ", current Jibri jid is " + String.valueOf(this.currentJibriJid)));
        if (this.currentJibriJid == null) {
            this.logger.info((Object)"Current session has already been cleaned up, ignoring");
            return;
        }
        if (jibriJid.compareTo((Object)this.currentJibriJid) != 0) {
            this.logger.info((Object)("This status update is from " + String.valueOf(jibriJid) + " but the current Jibri is " + String.valueOf(this.currentJibriJid) + ", ignoring"));
            return;
        }
        if (!JibriIq.Status.PENDING.equals((Object)newStatus)) {
            this.clearPendingTimeout(true);
        }
        if (failureReason != null) {
            boolean shouldRetry;
            if (shouldRetryParam == null) {
                this.logger.warn((Object)"failureReason was non-null but shouldRetry wasn't set, will NOT retry");
                shouldRetry = false;
            } else {
                shouldRetry = shouldRetryParam;
            }
            if (shouldRetry && !this.maxRetriesExceeded()) {
                this.logger.info((Object)"Jibri failed, trying to fall back to another Jibri");
                try {
                    this.retryRequestWithAnotherJibri();
                    this.logger.info((Object)"Successfully resumed session with another Jibri");
                }
                catch (StartException exc) {
                    this.logger.warn((Object)("Failed to fall back to another Jibri, this session has now failed: " + String.valueOf(exc)), (Throwable)exc);
                    this.dispatchSessionStateChanged(newStatus, failureReason);
                    this.cleanupSession();
                }
            } else {
                if (!shouldRetry) {
                    this.logger.info((Object)"Jibri failed and signaled that we should not retry the same request");
                } else {
                    this.logger.info((Object)("Jibri failed, but max amount of retries (" + this.maxNumRetries + ") reached, giving up"));
                }
                this.dispatchSessionStateChanged(newStatus, failureReason);
                this.cleanupSession();
            }
        } else if (JibriIq.Status.OFF.equals((Object)newStatus)) {
            this.logger.info((Object)"Jibri session ended cleanly, notifying owner and cleaning up session");
            this.dispatchSessionStateChanged(newStatus, null);
            this.cleanupSession();
        } else if (JibriIq.Status.ON.equals((Object)newStatus)) {
            this.logger.info((Object)"Jibri session started, notifying owner");
            this.dispatchSessionStateChanged(newStatus, null);
        }
    }

    String getSipAddress() {
        return this.sipAddress;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Jid getInitiator() {
        return this.initiator;
    }

    public Jid getTerminator() {
        return this.terminator;
    }

    private boolean isBusyResponse(JibriIq iq) {
        return JibriIq.Status.OFF.equals((Object)iq.getStatus()) && iq.isFailure() && JibriIq.FailureReason.BUSY.equals((Object)iq.getFailureReason());
    }

    private boolean isPendingResponse(JibriIq iq) {
        return JibriIq.Status.PENDING.equals((Object)iq.getStatus());
    }

    private class JibriDetectorEventHandler
    implements JibriDetector.EventHandler {
        private JibriDetectorEventHandler() {
        }

        @Override
        public void instanceOffline(Jid jid) {
            if (jid.equals((CharSequence)JibriSession.this.currentJibriJid)) {
                JibriSession.this.logger.warn((Object)(JibriSession.this.nickname() + " went offline: " + String.valueOf(jid) + " for room: " + String.valueOf(JibriSession.this.roomName)));
                JibriSession.this.handleJibriStatusUpdate(jid, JibriIq.Status.OFF, JibriIq.FailureReason.ERROR, true);
            }
        }
    }

    public static interface StateListener {
        public void onSessionStateChanged(JibriSession var1, JibriIq.Status var2, JibriIq.FailureReason var3);
    }

    public static enum Type {
        SIP_CALL,
        LIVE_STREAMING,
        RECORDING;

    }

    public static abstract class StartException
    extends Exception {
        public StartException(String message) {
            super(message);
        }

        public static class OneBusy
        extends StartException {
            public OneBusy() {
                super("This Jibri instance was busy");
            }
        }

        public static class UnexpectedResponse
        extends StartException {
            public UnexpectedResponse() {
                super("Unexpected response");
            }
        }

        public static class NotAvailable
        extends StartException {
            public NotAvailable() {
                super("No Jibris available");
            }
        }

        public static class InternalServerError
        extends StartException {
            public InternalServerError() {
                super("Internal server error");
            }
        }

        public static class AllBusy
        extends StartException {
            public AllBusy() {
                super("All jibri instances are busy");
            }
        }
    }

    private class PendingStatusTimeout
    implements Runnable {
        private PendingStatusTimeout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JibriSession jibriSession = JibriSession.this;
            synchronized (jibriSession) {
                JibriSession.this.clearPendingTimeout(false);
                if (JibriSession.isStartingStatus(JibriSession.this.jibriStatus)) {
                    JibriSession.this.logger.error((Object)(JibriSession.this.nickname() + " pending timeout! " + String.valueOf(JibriSession.this.roomName)));
                    JibriSession.this.stop(null);
                    JibriSession.this.handleJibriStatusUpdate(JibriSession.this.currentJibriJid, JibriIq.Status.OFF, JibriIq.FailureReason.ERROR, true);
                }
            }
        }
    }
}

